/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.foundation.common.DetectedTextLink;
import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.MultiHyperlinkHandler;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.foundation.rcp.core.text.StyledDocument;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupPart;
import java.net.URI;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PresentationMarkupPart
extends MarkupPart {
    private PresentationDescriptor fDescriptor;
    private IWorkItem fItem;
    private Map<String, String> fHeadDefinitions;
    private LinkDetector fDetector;

    public void initialize(IWorkItem item, PresentationDescriptor descriptor, LinkDetector detector, Map<String, String> headDefinitions) {
        this.fItem = item;
        this.fDescriptor = descriptor;
        this.fDetector = detector;
        this.fHeadDefinitions = headDefinitions;
    }

    public PresentationDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public IWorkItem getItem() {
        return this.fItem;
    }

    protected Map<String, String> getHeadDefinitions() {
        return this.fHeadDefinitions;
    }

    protected LinkDetector getLinkDetector() {
        return this.fDetector;
    }

    protected URI toURI(IItemHandle item) {
        Location itemLocation = Location.itemLocation((IItemHandle)item, (String)this.getTeamRepository().getRepositoryURI());
        URI uri = itemLocation.toAbsoluteUri();
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLString detectLinks(XMLString xml) {
        StyledDocument document = new StyledDocument(xml);
        try {
            LinkDetector linkDetector = this.fDetector;
            synchronized (linkDetector) {
                this.fDetector.setBaseURI(Location.itemLocation((IItemHandle)this.getItem(), (String)this.getTeamRepository().getRepositoryURI()).toAbsoluteUri());
                int line = 0;
                int lines = document.getNumberOfLines();
                while (line < lines) {
                    IRegion lineInfo = document.getLineInformation(line);
                    int offset = lineInfo.getOffset();
                    String text = document.get(offset, lineInfo.getLength());
                    List results = this.fDetector.match(text);
                    for (DetectedTextLink result : results) {
                        List uris = result.createURIs();
                        if (uris.size() == 0) continue;
                        URI uri = uris.size() > 1 ? MultiHyperlinkHandler.createMultiURI((List)uris) : (URI)uris.get(0);
                        int positionOffset = offset + result.getOffset();
                        int positionLength = result.getLength();
                        ReferencePosition position = new ReferencePosition(positionOffset, positionLength, uri, false);
                        document.setReferencePosition(position);
                    }
                    ++line;
                }
            }
        }
        catch (BadLocationException x) {
            WorkItemIDEUIPlugin.getDefault().log(x.getMessage(), x);
        }
        return document.getHTML();
    }

    protected ITeamRepository getTeamRepository() {
        return (ITeamRepository)this.fItem.getOrigin();
    }

    protected IAuditableCommon getAuditableCommon() {
        ITeamRepository repository = this.getTeamRepository();
        return (IAuditableCommon)repository.getClientLibrary(IAuditableCommon.class);
    }

    protected IAuditableClient getAuditableClient() {
        ITeamRepository repository = this.getTeamRepository();
        return (IAuditableClient)repository.getClientLibrary(IAuditableClient.class);
    }

    protected IWorkItemCommon getWorkItemCommon() {
        ITeamRepository repository = this.getTeamRepository();
        return (IWorkItemCommon)repository.getClientLibrary(IWorkItemCommon.class);
    }

    protected IWorkItemClient getWorkItemClient() {
        ITeamRepository repository = this.getTeamRepository();
        return (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
    }

    protected void handleException(MarkupBuilder builder, TeamRepositoryException ex) throws TeamRepositoryException {
        if (ex instanceof ItemNotFoundException) {
            builder.plain(NOT_FOUND);
        } else if (ex instanceof PermissionDeniedException) {
            builder.plain(NO_PERMISSION);
        } else {
            throw ex;
        }
    }
}

