/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.SectionDescriptor;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupLayout;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverviewMarkupLayout
extends MarkupLayout {
    private static final String DETAILS_SLOT = "details";
    private static final String DESCRIPTION_SLOT = "description";
    private static final String DISCUSSION_SLOT = "discussion";
    private static final String QUICKINFO_SLOT = "quickInfo";
    private static final String LINKSSUMMARY_SLOT = "linksSummary";

    @Override
    public void layout(TabDescriptor descriptor, Map<String, String> headDefinitions, StringBuilder buffer, IProgressMonitor monitor) throws TeamRepositoryException {
        List<AbstractPresentationDescriptor> sections = this.getPresentationMap().get(descriptor.getElementId());
        Map<String, List<SectionDescriptor>> mapSlotToSections = this.groupBySlot(sections);
        if (mapSlotToSections.containsKey(DETAILS_SLOT)) {
            this.layoutDetails(headDefinitions, buffer, monitor, mapSlotToSections);
        }
        if (mapSlotToSections.containsKey(DESCRIPTION_SLOT)) {
            this.layoutDescription(headDefinitions, buffer, monitor, mapSlotToSections);
        }
        if (mapSlotToSections.containsKey(DISCUSSION_SLOT)) {
            this.layoutDiscussion(headDefinitions, buffer, monitor, mapSlotToSections);
        }
        if (mapSlotToSections.containsKey(QUICKINFO_SLOT)) {
            this.layoutQuickInfo(headDefinitions, buffer, monitor, mapSlotToSections);
        }
        if (mapSlotToSections.containsKey(LINKSSUMMARY_SLOT)) {
            this.layoutLinksSummary(headDefinitions, buffer, monitor, mapSlotToSections);
        }
    }

    private void layoutDetails(Map<String, String> headDefinitions, StringBuilder buffer, IProgressMonitor monitor, Map<String, List<SectionDescriptor>> mapSlotToSections) throws TeamRepositoryException {
        List<SectionDescriptor> detailsSections = mapSlotToSections.get(DETAILS_SLOT);
        this.layoutInColumns(2, headDefinitions, buffer, detailsSections, this.getInfo() == null || !this.getInfo().isFocusTooltip, true, monitor);
    }

    private void layoutDescription(Map<String, String> headDefinitions, StringBuilder buffer, IProgressMonitor monitor, Map<String, List<SectionDescriptor>> mapSlotToSections) throws TeamRepositoryException {
        List<SectionDescriptor> descriptionSections = mapSlotToSections.get(DESCRIPTION_SLOT);
        this.layoutInColumns(1, headDefinitions, buffer, descriptionSections, true, true, monitor);
    }

    private void layoutDiscussion(Map<String, String> headDefinitions, StringBuilder buffer, IProgressMonitor monitor, Map<String, List<SectionDescriptor>> mapSlotToSections) throws TeamRepositoryException {
        List<SectionDescriptor> discussionSections = mapSlotToSections.get(DISCUSSION_SLOT);
        this.layoutInColumns(1, headDefinitions, buffer, discussionSections, false, true, monitor);
    }

    private void layoutQuickInfo(Map<String, String> headDefinitions, StringBuilder buffer, IProgressMonitor monitor, Map<String, List<SectionDescriptor>> mapSlotToSections) throws TeamRepositoryException {
        List<SectionDescriptor> quickInfoSections = mapSlotToSections.get(QUICKINFO_SLOT);
        this.layoutInColumns(1, headDefinitions, buffer, quickInfoSections, true, true, monitor);
    }

    private void layoutLinksSummary(Map<String, String> headDefinitions, StringBuilder buffer, IProgressMonitor monitor, Map<String, List<SectionDescriptor>> mapSlotToSections) throws TeamRepositoryException {
        List<SectionDescriptor> linksSummarySections = mapSlotToSections.get(LINKSSUMMARY_SLOT);
        this.layoutInColumns(1, headDefinitions, buffer, linksSummarySections, true, true, monitor);
    }
}

