/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.icu.util.StringTokenizer;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.AttributeMarkupPart;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListAttributeMarkupPart
extends AttributeMarkupPart {
    @Override
    public void fillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.internalFillPartContent(builder, monitor);
        }
        catch (TeamRepositoryException e) {
            this.handleException(builder, e);
        }
    }

    private void internalFillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        IEnumeration enumeration;
        String enumTypeId;
        Map properties = this.getDescriptor().getProperties();
        if (properties != null && (enumTypeId = (String)properties.get("enumeration")) != null && enumTypeId.length() > 0 && (enumeration = ((WorkItemClient)this.getWorkItemClient()).internalResolveEnumeration(this.getItem().getProjectArea(), enumTypeId, monitor)) != null) {
            List enumerationLiterals = enumeration.getEnumerationLiterals();
            Object value = this.getNonNullAttributeValue(monitor);
            if (enumerationLiterals != null && value instanceof String) {
                List<String> selectedValues = this.splitValues((String)value);
                for (ILiteral literal : enumerationLiterals) {
                    if (!selectedValues.contains(literal.getIdentifier2().getStringIdentifier())) continue;
                    this.fillLiteral(builder, literal);
                    builder.xml("<br />");
                }
            } else if (value != null) {
                builder.plain(value.toString());
            }
        }
    }

    private List<String> splitValues(String str) {
        StringTokenizer st = new StringTokenizer(str, ",");
        if (st.countTokens() == 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> tokens = new ArrayList<String>(st.countTokens());
        int i = 0;
        while (st.hasMoreTokens()) {
            tokens.add(st.nextToken());
            ++i;
        }
        return tokens;
    }
}

