/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.Duration;
import com.ibm.team.workitem.common.model.DurationFormat;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.AttributeMarkupPart;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import org.eclipse.core.runtime.IProgressMonitor;

public class DurationAttributeMarkupPart
extends AttributeMarkupPart {
    private final DurationFormat fFormat = DurationFormat.getInstance();

    public void fillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        Object value = this.getNonNullAttributeValue(monitor);
        if (value instanceof Long) {
            Long lValue = (Long)value;
            this.fillDuration(builder, lValue);
        } else if (value != null) {
            builder.plain(value.toString());
        }
    }

    protected void fillDuration(MarkupBuilder builder, Long value) {
        Duration duration = new Duration(value.longValue());
        if (duration.isSpecified()) {
            this.fFormat.setUpperBoundOutputUnit(DurationFormat.Units.Hours);
            builder.plain(this.fFormat.format(duration));
        }
    }
}

