/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.foundation.common.internal.util.XMLBuilder;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.ILineBasedSubstitutionScanner;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.LineBasedSubstitutionScannerRegistry;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.PresentationMarkupPart;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

public class DiscussionPresentationMarkupPart
extends PresentationMarkupPart {
    private static final String CSS_KEY = "com.ibm.team.workitem.ide.ui.internal.preview.dynamic.presentations.DiscussionPresentationHoverPart";
    private static final int MAX_COMMENT_LENGTH = 500;
    private static final int MAX_COMMENT_LENGTH_IN_HOVER_TOOLTIP = 200;
    private final DateFormat fDateFormatter = DateFormat.getDateInstance((int)2);
    private final DateFormat fTimeFormatter = DateFormat.getTimeInstance((int)3);

    public void fillPartName(MarkupBuilder builder, IProgressMonitor monitor) {
        builder.plain(Messages.DiscussionPresentationMarkupPart_DISCUSSION);
    }

    public void fillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        IAuditableClient auditableClient = this.getAuditableClient();
        IComment[] comments = this.getItem().getComments().getContents();
        int commentsLimit = comments.length;
        if (commentsLimit > comments.length) {
            commentsLimit = comments.length;
        }
        int workItemId = this.getItem().getId();
        int expandId = 0;
        ArrayList<String> contentOfClippedItems = new ArrayList<String>();
        int i = 0;
        while (i < commentsLimit) {
            IComment comment = comments[i];
            String content = this.format(this.detectLinks(comment.getHTMLContent()).getXMLText());
            int maxCommentLength = 500;
            boolean trimmed = content.length() > maxCommentLength;
            String id = "workItem" + workItemId + ".comment" + expandId;
            String strId = trimmed ? "id='" + id + "'" : "";
            IContributor commenter = this.ensureResolved(auditableClient, comment.getCreator(), monitor);
            builder.xml("<tr><td class='commentTitle'><i>");
            this.appendUserName(builder, commenter);
            builder.xml("</i>").plain(" (" + this.formatDate(comment.getCreationDate(), false) + "):").xml("</td></tr>");
            builder.xml("<tr><td " + strId + " class='commentContent'>");
            if (trimmed) {
                builder.xml(MarkupUtil.trim((String)content, (int)200));
                builder.xml("[<a href=\"javascript:expandWorkItemComment" + workItemId + "('" + expandId + NLS.bind((String)"')\">{0}</a>]", (Object)Messages.DiscussionPresentationMarkupPart_MORE_COMMENTS, (Object[])new Object[0]));
                contentOfClippedItems.add(content);
                ++expandId;
            } else {
                builder.xml(content);
            }
            builder.xml("</td></tr>");
            ++i;
        }
        if (contentOfClippedItems.size() > 0) {
            XMLBuilder javascript = new XMLBuilder();
            javascript.xml("<script type=\"text/javascript\">");
            this.appendJavascriptStringArray(javascript, "workItemComments" + workItemId, contentOfClippedItems);
            javascript.xml("function expandWorkItemComment" + workItemId + "(commentIndex) {");
            javascript.xml("  document.getElementById('workItem" + workItemId + ".comment' + commentIndex).innerHTML = workItemComments" + workItemId + "[commentIndex];");
            javascript.xml("}");
            javascript.xml("</script>");
            this.getHeadDefinitions().put("workItemComments" + workItemId, javascript.toString());
        }
        StringBuilder css = new StringBuilder();
        css.append("<style type=\"text/css\">");
        css.append("td.commentTitle {padding-left:5px;padding-top:2px;vertical-align:top;}");
        css.append("td.commentContent {padding-left:15px;padding-bottom:3px;padding-top:0px;vertical-align:top;}");
        css.append("</style>");
        this.getHeadDefinitions().put(CSS_KEY, css.toString());
    }

    private IContributor ensureResolved(IAuditableClient auditableClient, IContributorHandle handle, IProgressMonitor monitor) throws TeamRepositoryException {
        if (handle == null) {
            return null;
        }
        return (IContributor)auditableClient.resolveAuditable((IAuditableHandle)handle, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
    }

    private String formatDate(Date date, boolean onlyDate) {
        if (date != null) {
            return onlyDate ? this.fDateFormatter.format(date) : NLS.bind((String)Messages.DiscussionPresentationMarkupPart_DATE_TIME_PRESENTATION, (Object)this.fDateFormatter.format(date), (Object[])new Object[]{this.fTimeFormatter.format(date)});
        }
        return UNASSIGNED;
    }

    private void appendUserName(MarkupBuilder xml, IContributor c) {
        String name = c == null ? UNASSIGNED : (c.isArchived() ? NLS.bind((String)Messages.DiscussionPresentationMarkupPart_ARCHIVED_COUNT, (Object)c.getName(), (Object[])new Object[0]) : c.getName());
        URI uri = this.toURI((IItemHandle)c);
        xml.link(uri.toString(), name);
    }

    private String format(String text) {
        try {
            StringBuilder buffer = new StringBuilder();
            String[] lines = text.split("\\n");
            int i = 0;
            while (i < lines.length) {
                ReferencePosition refPos = this.scanLine(lines[i]);
                if (refPos != null) {
                    char[] chars = lines[i].toCharArray();
                    int refOffset = refPos.getOffset();
                    int refLength = refPos.getLength();
                    buffer.append(chars, 0, refOffset);
                    this.appendLink(buffer, new String(chars, refOffset, refLength), refPos.getReference().toString());
                    buffer.append(chars, refOffset + refLength, lines[i].length() - refOffset - refLength);
                } else {
                    buffer.append(lines[i]);
                }
                if (i < lines.length - 1) {
                    buffer.append("<br/>");
                }
                ++i;
            }
            return buffer.toString();
        }
        catch (Exception e) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.DiscussionPresentationMarkupPart_ERROR_CREATE_HTML_LINKS, e);
            return text;
        }
    }

    private ReferencePosition scanLine(String line) {
        List<ILineBasedSubstitutionScanner> scanners = LineBasedSubstitutionScannerRegistry.getDefault().getScanners();
        Iterator<ILineBasedSubstitutionScanner> iterator = scanners.iterator();
        while (iterator.hasNext()) {
            int j = 0;
            ILineBasedSubstitutionScanner scanner = iterator.next();
            ReferencePosition[] positions = scanner.scan(line);
            if (j >= positions.length) continue;
            return positions[j];
        }
        return null;
    }

    private void appendLink(StringBuilder buffer, String title, String href) {
        buffer.append("<a href='" + href + "'>");
        buffer.append(title);
        buffer.append("</a>");
    }

    private void appendJavascriptStringArray(XMLBuilder buffer, String varName, ArrayList strings) {
        buffer.xml("var " + varName + " =new Array(");
        int i = 0;
        while (i < strings.size()) {
            String content = (String)strings.get(i);
            if (i > 0) {
                buffer.xml(",");
            }
            buffer.xml("\"");
            this.escapeJavascriptString(buffer, content);
            buffer.xml("\"");
            ++i;
        }
        buffer.xml(");");
    }

    private void escapeJavascriptString(XMLBuilder buffer, String string) {
        int i = 0;
        while (i < string.length()) {
            char c = string.charAt(i);
            if (c == '\'' || c == '\"') {
                buffer.xml("\\");
                buffer.xml(String.valueOf(c));
            } else if (c == '\n') {
                buffer.xml("\\n");
            } else {
                buffer.xml(String.valueOf(c));
            }
            ++i;
        }
    }
}

