/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.foundation.common.LinkDetector;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IAttributeHandle;
import com.ibm.team.workitem.common.model.IEnumeration;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.PresentationMarkupPart;
import java.io.IOException;
import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AttributeMarkupPart
extends PresentationMarkupPart {
    private IAttribute fAttribute;

    @Override
    public void fillPartName(MarkupBuilder builder, IProgressMonitor monitor) {
        builder.plain(this.getAttribute().getDisplayName());
    }

    public void initialize(IWorkItem item, IAttribute attribute, PresentationDescriptor descriptor, LinkDetector detector, Map<String, String> headDefinitions) {
        super.initialize(item, descriptor, detector, headDefinitions);
        this.fAttribute = attribute;
    }

    public IAttribute getAttribute() {
        return this.fAttribute;
    }

    protected Object getNonNullAttributeValue(IProgressMonitor monitor) throws TeamRepositoryException {
        return this.getNonNullAttributeValue(this.getAttribute(), monitor);
    }

    protected Object getNonNullAttributeValue(IAttribute attribute, IProgressMonitor monitor) throws TeamRepositoryException {
        Object value = this.getItem().getValue(attribute);
        if (value != null) {
            return value;
        }
        IAuditableCommon common = this.getAuditableCommon();
        Object nullValue = attribute.getNullValue(common, monitor);
        if (nullValue != null) {
            return nullValue;
        }
        return this.getDefaultAttributeValue();
    }

    protected Object getDefaultAttributeValue() {
        return UNASSIGNED;
    }

    protected void fillLiteral(MarkupBuilder builder, Identifier value, IProgressMonitor monitor) throws TeamRepositoryException {
        ILiteral literal;
        IEnumeration resolvedEnum = this.getWorkItemCommon().resolveEnumeration((IAttributeHandle)this.getAttribute(), monitor);
        if (resolvedEnum != null && (literal = resolvedEnum.findEnumerationLiteral(value)) != null) {
            this.fillLiteral(builder, literal);
        }
    }

    protected void fillLiteral(MarkupBuilder builder, ILiteral literal) throws TeamRepositoryException {
        if (literal.getIconURL() != null) {
            try {
                URL iconURL = JazzResources.createImageURL((URL)literal.getIconURL());
                builder.image(iconURL.toString(), literal.getName());
                builder.imageLabel(literal.getName());
            }
            catch (IOException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.EnumerationAttributeMarkupPart_ERROR_SAVING_TMP_IMG, e);
            }
        } else {
            builder.plain(literal.getName());
        }
    }
}

