/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview.presentations;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemReferences;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.FileHelper;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.PresentationMarkupPart;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.SWT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttachmentsPresentationMarkupPart
extends PresentationMarkupPart {
    private static final boolean INLINE_IMAGES = false;
    private static final boolean IS_WINDOWS = "win32".equals(SWT.getPlatform());
    private static final String CSS_KEY = "com.ibm.team.workitem.ide.ui.internal.preview.presentations.AttachmentsPresentationHoverPart";

    @Override
    public void fillPartName(MarkupBuilder builder, IProgressMonitor monitor) {
        builder.plain(Messages.AttachmentsPresentationMarkupPart_ATTACHMENTS);
    }

    @Override
    public void fillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        try {
            this.internalFillPartContent(builder, monitor);
        }
        catch (TeamRepositoryException e) {
            this.handleException(builder, e);
        }
    }

    private void internalFillPartContent(MarkupBuilder builder, IProgressMonitor monitor) throws TeamRepositoryException {
        IWorkItemReferences references = this.getWorkItemClient().resolveWorkItemReferences((IWorkItemHandle)this.getItem(), monitor);
        List attachmentRefs = references.getReferences(WorkItemEndPoints.ATTACHMENT);
        if (attachmentRefs.isEmpty()) {
            return;
        }
        List<IAttachment> attachments = this.resolveAll(attachmentRefs, monitor);
        ArrayList images = new ArrayList();
        ArrayList<IAttachment> others = new ArrayList<IAttachment>();
        Comparator<IAttachment> sorter = new Comparator<IAttachment>(){

            @Override
            public int compare(IAttachment o1, IAttachment o2) {
                return o1.getId() < o2.getId() ? -1 : (o1.getId() == o2.getId() ? 0 : 1);
            }
        };
        for (IAttachment attachment : attachments) {
            attachment.getName().toLowerCase();
            others.add(attachment);
        }
        Collections.sort(images, sorter);
        Collections.sort(others, sorter);
        if (!images.isEmpty()) {
            builder.xml("<tr>");
            builder.xml("<td class=\"attachmentKindLabel\">").plain(Messages.AttachmentsPresentationMarkupPart_IMAGE_ATTACHMENTS).xml("</td>");
            builder.xml("<td>");
            builder.xml("<div style=\"width: 100%;\">");
        }
        for (IAttachment attachment : images) {
            URI uri = this.toURI((IItemHandle)attachment);
            try {
                File file = FileHelper.createTemporaryFile(attachment, null);
                String alt = NLS.bind((String)Messages.AttachmentsPresentationMarkupPart_ATTACHMENT_ID_NAME, (Object)attachment.getId(), (Object[])new Object[]{attachment.getName()});
                String photoVal = "<a href=\"" + uri + "\"><img alt=\"" + alt + "\" class=\"attachment\" src=\"file://" + file.getCanonicalPath() + "\"></a>";
                builder.xml(photoVal);
            }
            catch (IOException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.AttachmentsPresentationMarkupPart_ERROR_SAVING_TMP_FILE, e);
            }
            catch (ItemNotFoundException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.AttachmentsPresentationMarkupPart_ERROR_SAVING_TMP_FILE, e);
            }
            catch (PermissionDeniedException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.AttachmentsPresentationMarkupPart_ERROR_SAVING_TMP_FILE, e);
            }
        }
        if (!images.isEmpty()) {
            builder.xml("</div>");
            builder.xml("</td>");
            builder.xml("</tr>");
        }
        int attachmentsCounter = 0;
        if (!others.isEmpty()) {
            builder.xml("<tr>");
            builder.xml("<td style=\"padding-left: 5px;\">");
        }
        String str = "";
        for (IAttachment attachment : others) {
            URI uri = this.toURI((IItemHandle)attachment);
            MarkupBuilder otherAttachmentBuilder = new MarkupBuilder();
            otherAttachmentBuilder.link(uri.toString(), NLS.bind((String)Messages.AttachmentsPresentationMarkupPart_ID_NAME, (Object)attachment.getName(), (Object[])new Object[]{attachment.getId()}));
            str = NLS.bind((String)Messages.AttachmentsPresentationMarkupPart_OTHER_ATTACHMENT_ENUMERATION, (Object)str, (Object[])new Object[]{otherAttachmentBuilder});
            ++attachmentsCounter;
        }
        if (attachmentsCounter > 0) {
            str = str.substring(2);
        }
        builder.xml(str);
        if (!others.isEmpty()) {
            builder.xml("</td>");
            builder.xml("</tr>");
        }
        if (!attachmentRefs.isEmpty()) {
            StringBuilder css = new StringBuilder();
            css.append("<style type=\"text/css\">");
            css.append("img.attachment {border: 1px solid gray; width: 200px; vertical-align: top; margin-bottom: 5px; margin-right: 5px;");
            if (IS_WINDOWS) {
                css.append("-ms-interpolation-mode:bicubic;");
            }
            css.append("}");
            css.append("td.attachmentKindLabel { padding-left:5px; padding-right:10px; font-weight:normal; vertical-align:top; }");
            css.append("</style>");
            this.getHeadDefinitions().put(CSS_KEY, css.toString());
        }
    }

    private List<IAttachment> resolveAll(List<IReference> attachmentRefs, IProgressMonitor monitor) throws TeamRepositoryException {
        ArrayList<IAttachment> attachments = new ArrayList<IAttachment>(attachmentRefs.size());
        for (IReference attachmentRef : attachmentRefs) {
            IItemHandle referencedItem;
            if (!attachmentRef.isItemReference() || !((referencedItem = ((IItemReference)attachmentRef).getReferencedItem()) instanceof IAttachmentHandle)) continue;
            try {
                IAttachment attachment = (IAttachment)this.getAuditableClient().resolveAuditable((IAuditableHandle)((IAttachmentHandle)referencedItem), IAttachment.FULL_PROFILE, monitor);
                attachments.add(attachment);
            }
            catch (TeamRepositoryException e) {
                if (e instanceof ItemNotFoundException || e instanceof PermissionDeniedException) continue;
                throw e;
            }
        }
        return attachments;
    }
}

