/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview;

import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.internal.TeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.Location;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.transport.client.ITeamRestServiceClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.util.RemoteImages;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupBuilder;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupPart;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupPresentationsManager;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.PresentationMarkupPart;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;

public class RestWorkItemHTMLGenerator {
    private static final String HOVER_ROA_QUERY = "_mediaType=text/html&_selector=hover&bodyOnly=true";
    private static final String HOVER_ROA_QUERY_FOR_PRINTING = "_mediaType=text/html&_selector=hover&_context=print";
    private static final String GENERAL_CSS = "GENERAL_WORKITEM_CSS";
    private static final String PROTOCOL_START = "http";
    private static final String ANY_URL_CHAR = "[\\w-%=\\./?#&:@+~!$;,]*";
    private static final String IMAGE_CONTENT_SERVICE = "com.ibm.team.workitem.common.internal.model.IImageContentService";
    private static final Pattern IMAGE_PATTERN = Pattern.compile("http[\\w-%=\\./?#&:@+~!$;,]*com.ibm.team.workitem.common.internal.model.IImageContentService[\\w-%=\\./?#&:@+~!$;,]*");
    private static final Pattern CLIENT_PRESENTATION_OVERRIDE_PATTERN = Pattern.compile("<!-- clientMarkupPresentationOverride:([\\w\\.]+) -->");
    private boolean fForPrinting;

    public RestWorkItemHTMLGenerator() {
        this(false);
    }

    public RestWorkItemHTMLGenerator(boolean forPrinting) {
        this.fForPrinting = forPrinting;
    }

    public void generate(IWorkItem item, HashMap headDefinitions, StringBuffer buffer, IDomainAdapter.Info info, IProgressMonitor monitor) {
        this.fillGeneralCSS(headDefinitions);
        TeamRepository repository = (TeamRepository)item.getOrigin();
        IWorkItemClient wiClient = (IWorkItemClient)repository.getClientLibrary(IWorkItemClient.class);
        ITeamRestServiceClient restClient = repository.getItemRestService();
        Location restLocation = Location.namedLocation((IItem)item, (String)repository.getRepositoryURI(), (String)(this.fForPrinting ? HOVER_ROA_QUERY_FOR_PRINTING : HOVER_ROA_QUERY), null);
        final ITeamRestServiceClient.IRestClientConnection connection = restClient.getConnection(restLocation);
        try {
            ITeamRestServiceClient.IRestClientConnection.Response response = (ITeamRestServiceClient.IRestClientConnection.Response)repository.callCancelableService((IClientLibraryContext.IServiceRunnable)new IClientLibraryContext.IServiceRunnable<ITeamRestServiceClient.IRestClientConnection.Response>(){

                public ITeamRestServiceClient.IRestClientConnection.Response run(IProgressMonitor progressMonitor) throws TeamRepositoryException {
                    try {
                        progressMonitor.beginTask("", -1);
                        ITeamRestServiceClient.IRestClientConnection.Response response = connection.doGet();
                        return response;
                    }
                    finally {
                        progressMonitor.done();
                    }
                }
            }, monitor);
            InputStream responseStream = response.getResponseStream();
            this.fill(item, headDefinitions, responseStream, buffer, wiClient, monitor);
        }
        catch (TeamRepositoryException e) {
            WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
        }
        catch (IOException e) {
            WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
        }
    }

    private void fill(IWorkItem item, Map headDefinitions, InputStream inS, StringBuffer buffer, IWorkItemClient wiClient, IProgressMonitor monitor) throws IOException {
        StringBuilder builder = new StringBuilder();
        InputStreamReader reader = new InputStreamReader(inS, "UTF-8");
        char[] buf = new char[1024];
        int readBytes = 0;
        while ((readBytes = reader.read(buf)) != -1) {
            builder.append(new String(buf, 0, readBytes));
        }
        StringBuffer clientHtmlBuffer = new StringBuffer();
        Matcher matcher = CLIENT_PRESENTATION_OVERRIDE_PATTERN.matcher(builder);
        while (matcher.find()) {
            String clientOverrideId = matcher.group(1);
            MarkupPart part = MarkupPresentationsManager.getInstance().getPart(clientOverrideId);
            if (part == null || !(part instanceof PresentationMarkupPart)) continue;
            try {
                PresentationMarkupPart presentationPart = (PresentationMarkupPart)part;
                presentationPart.initialize(item, null, null, headDefinitions);
                MarkupBuilder content = new MarkupBuilder();
                presentationPart.fillPartContent(content, monitor);
                String clientReplacement = content.toString();
                if (clientReplacement.length() <= 0) continue;
                matcher.appendReplacement(clientHtmlBuffer, clientReplacement);
            }
            catch (TeamRepositoryException e) {
                WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
            }
        }
        matcher.appendTail(clientHtmlBuffer);
        StringBuffer localHtmlBuffer = new StringBuffer();
        matcher = IMAGE_PATTERN.matcher(clientHtmlBuffer);
        while (matcher.find()) {
            String localResource;
            String imageLink = matcher.group(0);
            if (imageLink == null || (localResource = this.toLocalResource(imageLink, wiClient, monitor)) == null) continue;
            matcher.appendReplacement(localHtmlBuffer, localResource);
        }
        matcher.appendTail(localHtmlBuffer);
        buffer.append(localHtmlBuffer);
    }

    private String toLocalResource(String remoteImageLinkStr, IWorkItemClient wiClient, IProgressMonitor monitor) {
        try {
            URI remoteImageLink = new URI(remoteImageLinkStr);
            URL localImageLink = RemoteImages.resolveImageContent((IWorkItemClient)wiClient, (URI)remoteImageLink, (IProgressMonitor)monitor);
            if (localImageLink != null) {
                return localImageLink.toString();
            }
        }
        catch (URISyntaxException e) {
            WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
        }
        catch (TeamRepositoryException e) {
            WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
        }
        catch (MalformedURLException e) {
            WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
        }
        return null;
    }

    private void fillGeneralCSS(Map map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        StringBuilder css = new StringBuilder();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; margin: 0; }\n");
        css.append(".{ ").append(MarkupUtil.getGlobalFont()).append(" }\n");
        css.append("table { ").append(MarkupUtil.getFont()).append(" }\n");
        css.append("table.section { margin: 4px; }\n");
        css.append("th { text-align: left; }\n");
        css.append("a:link { color: #0000FF; text-decoration: none; }");
        css.append("a:hover { color: #000080; text-decoration: underline; }");
        css.append("a:visited { color: #0000FF; text-decoration: none; }\n");
        css.append("a.yellow:link { color: rgb(128,128,0); text-decoration: none; }");
        css.append("a.yellow:hover { color: rgb(128,128,0); text-decoration: underline; }");
        css.append("a.yellow:visited { color: rgb(128,128,0); text-decoration: none; }");
        css.append("td.sectionTitle { padding-top:0; font-weight:bold; padding-right:10px; vertical-align:top; }");
        css.append("td.sectionContent { padding-left:1px; padding-right:10px; vertical-align:top;}");
        css.append("td.sectionContentNoWrap { white-space:nowrap; padding-left:1px; padding-right:10px; vertical-align:top;}");
        css.append("div.description {line-height: 120%;}");
        css.append("span.imageLabel {padding-left:3px; vertical-align:top;}");
        css.append("td.approvalTitle {padding-top:5px; font-weight:bold; padding-right:10px; vertical-align:top; }");
        css.append("td.approvalColumn {padding-top:5px; vertical-align:top; }");
        css.append("td.approvalImage {padding-left:0px; vertical-align:top;}");
        css.append("td.approvalContent {vertical-align:top;}");
        css.append("td.approverName {vertical-align:top; padding-left: 20px;}");
        css.append("td.attachmentKindLabel { padding-left:5px; padding-right:10px; font-weight:normal; vertical-align:top; }");
        css.append("td.commentTitle {padding-left:1px; padding-top:2px; vertical-align:top;}");
        css.append("td.commentContent {line-height: 120%; padding-left:1px; padding-bottom:3px; padding-top:0px; vertical-align:top;}");
        css.append("td.linkName {white-space:nowrap; padding-left:5px; padding-bottom:0px; vertical-align:top;}");
        css.append("td.linkContent {padding-left:15px; padding-bottom:3px; vertical-align:top;}");
        css.append("td.quickEntry {white-space:nowrap; padding-left:1px; padding-right: 10px; padding-bottom:3px; vertical-align:top;}");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }
}

