/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview;

import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.presentations.AbstractPresentationDescriptor;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentation;
import com.ibm.team.workitem.common.internal.presentations.TabDescriptor;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.preview.Messages;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupLayout;
import com.ibm.team.workitem.ide.ui.internal.preview.presentations.MarkupPresentationsManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;

public class PresentationsAwareWorkItemHTMLGenerator {
    private static final String GENERAL_CSS = "GENERAL_WORKITEM_CSS";

    public void generate(IWorkItem item, HashMap headDefinitions, StringBuffer buffer, IDomainAdapter.Info info, IProgressMonitor monitor) {
        this.fillGeneralCSS(headDefinitions);
        ITeamRepository repository = (ITeamRepository)item.getOrigin();
        WorkItemCommon wiCommon = (WorkItemCommon)repository.getClientLibrary(IWorkItemCommon.class);
        try {
            EditorPresentation editorPresentation = wiCommon.getEditorPresentation(item, monitor);
            Map map = editorPresentation.getPresentationsMap();
            ArrayList<TabDescriptor> tabs = new ArrayList<TabDescriptor>((Collection)map.get(editorPresentation.getEditorLayout()));
            TabDescriptor headerTab = null;
            for (AbstractPresentationDescriptor abstractPresentationDescriptor : tabs) {
                if (!(abstractPresentationDescriptor instanceof TabDescriptor) || !"internalHeader".equals(editorPresentation.getTabLayouts().get(abstractPresentationDescriptor.getElementId()))) continue;
                headerTab = (TabDescriptor)abstractPresentationDescriptor;
                break;
            }
            if (headerTab != null) {
                int n = tabs.indexOf(headerTab);
                if (n != 0) {
                    tabs.remove(n);
                    tabs.add(0, headerTab);
                }
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                MarkupLayout headerLayout = MarkupPresentationsManager.getInstance().getLayout("builtInHeaderLayout");
                headerLayout.init(item, info, map);
                headerLayout.layout(null, headDefinitions, stringBuilder, monitor);
                buffer.append((CharSequence)stringBuilder);
            }
            Iterator iterator = tabs.iterator();
            while (iterator.hasNext()) {
                StringBuilder tabBuffer = new StringBuilder();
                TabDescriptor tab = (TabDescriptor)iterator.next();
                String layoutId = (String)editorPresentation.getTabLayouts().get(tab.getElementId());
                MarkupLayout tabLayout = MarkupPresentationsManager.getInstance().getLayout(layoutId);
                if (tabLayout != null) {
                    tabLayout.init(item, info, map);
                    tabLayout.layout(tab, headDefinitions, tabBuffer, monitor);
                }
                buffer.append((CharSequence)tabBuffer);
            }
        }
        catch (PermissionDeniedException permissionDeniedException) {
            buffer.append(Messages.PresentationsAwareWorkItemHTMLGenerator_PERMISSION_DENIED);
        }
        catch (TeamRepositoryException e) {
            WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
        }
    }

    private void fillGeneralCSS(Map map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        StringBuilder css = new StringBuilder();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; margin: 0; }\n");
        css.append(".{ ").append(MarkupUtil.getGlobalFont()).append(" }\n");
        css.append("table { ").append(MarkupUtil.getFont()).append(" }\n");
        css.append("th { text-align: left; }\n");
        css.append("a:link { text-decoration: none; }");
        css.append("a:visited { color:#0000FF; text-decoration: none; }\n");
        css.append("a:hover { text-decoration: underline; }");
        css.append("td.sectionTitle { padding-top:5px; font-weight:bold; padding-right:10px; vertical-align:top; }");
        css.append("td.sectionContent { padding-left:5px; padding-right:7px; vertical-align:top;}");
        css.append("td.sectionContentNoWrap { white-space:nowrap; padding-left:5px; padding-right:7px; vertical-align:top;}");
        css.append("td.sectionColumn {padding-right:15px; vertical-align:top;}");
        css.append("span.imageLabel {padding-left:3px;vertical-align:top;}");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }
}

