/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContent;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.FileHelper;
import com.ibm.team.workitem.ide.ui.internal.preview.Messages;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.swt.SWT;

public class AttachmentHTMLGenerator
extends HTMLGenerator {
    private static final boolean IS_WINDOWS = "win32".equals(SWT.getPlatform());
    private static final String GENERAL_CSS = "GENERAL_ATTACHMENT_CSS";
    private static final String ATTACHMENT_JS = "ATTACHMENT_JS";
    private IAttachmentHandle fAttachmentHandle;

    public AttachmentHTMLGenerator(IAttachmentHandle attachment) {
        this.fAttachmentHandle = attachment;
    }

    protected void createControl(HTMLGenerator.Composite composite) {
        try {
            ITeamRepository teamRepository = (ITeamRepository)this.fAttachmentHandle.getOrigin();
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            IAttachment attachment = this.fAttachmentHandle instanceof IAttachment && ((IAttachment)this.fAttachmentHandle).isComplete() ? (IAttachment)this.fAttachmentHandle : (IAttachment)auditableClient.resolveAuditable((IAuditableHandle)this.fAttachmentHandle, IAttachment.FULL_PROFILE, null);
            String name = attachment.getName().toLowerCase();
            if (name.endsWith(".png") || name.endsWith(".gif") || name.endsWith(".jpg") || name.endsWith(".jpeg")) {
                try {
                    this.creatorLine(composite, auditableClient, teamRepository, attachment);
                    new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                    File file = FileHelper.createTemporaryFile(attachment, null);
                    if (this.getInfo().isHoverTooltip) {
                        String cssStyle = IS_WINDOWS ? "style=\"-ms-interpolation-mode:bicubic;\"" : "";
                        String photoVal = "<img " + cssStyle + " src=\"file://" + file.getCanonicalPath() + "\" id=\"photoId\" onload=\"scale_load('photoId')\">";
                        new HTMLGenerator.Markup((HTMLGenerator)this, composite, photoVal);
                    } else {
                        String cssStyle = "style=\"border: 1px solid rgb(216,216,216);\"";
                        String photoVal = "<img " + cssStyle + " src=\"file://" + file.getCanonicalPath() + "\">";
                        new HTMLGenerator.Markup((HTMLGenerator)this, composite, photoVal);
                    }
                }
                catch (IOException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.AttachmentHTMLGenerator_ERROR_SAVING_ATTACHMENT, e);
                    new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.AttachmentHTMLGenerator_ERROR_SAVING_ATTACHMENT_TO_TEMP);
                }
                return;
            }
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.AttachmentHTMLGenerator_NAME).setCSSClass("dimmed");
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Utils.escapeToHTML((String)attachment.getName()));
            new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)"   ({0}: {1})", (Object)Messages.AttachmentHTMLGenerator_ID, (Object[])new Object[]{attachment.getId()})).setCSSClass("dimmed");
            IContent content = attachment.getContent();
            if (content != null) {
                new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
                new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.AttachmentHTMLGenerator_SIZE).setCSSClass("dimmed");
                new HTMLGenerator.Label((HTMLGenerator)this, composite, AttachmentHTMLGenerator.smartFormatSize(content.getEstimatedConvertedLength()));
                new HTMLGenerator.Label((HTMLGenerator)this, composite, NLS.bind((String)"   {0}: ", (Object)Messages.AttachmentHTMLGenerator_TYPE, (Object[])new Object[0])).setCSSClass("dimmed");
                new HTMLGenerator.Label((HTMLGenerator)this, composite, content.getContentType());
            }
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            this.creatorLine(composite, auditableClient, teamRepository, attachment);
            new HTMLGenerator.LineBreak((HTMLGenerator)this, composite);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.AttachmentHTMLGenerator_DESCRIPTION).setCSSClass("dimmed");
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Utils.escapeToHTML((String)attachment.getDescription()));
        }
        catch (PermissionDeniedException permissionDeniedException) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.AttachmentHTMLGenerator_PERMISSION_DENIED);
        }
        catch (TeamRepositoryException e) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.AttachmentHTMLGenerator_EXCEPTION_RETRIEVING_ATTACHMENT, e);
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.AttachmentHTMLGenerator_ERROR_RETRIEVING_ATTACHMENT);
        }
    }

    private void creatorLine(HTMLGenerator.Composite composite, IAuditableClient auditableClient, ITeamRepository teamRepository, IAttachment attachment) throws TeamRepositoryException {
        Timestamp date;
        IContributor creator = null;
        if (attachment.getCreator() != null) {
            creator = (IContributor)auditableClient.resolveAuditable((IAuditableHandle)attachment.getCreator(), ItemProfile.CONTRIBUTOR_DEFAULT, null);
        }
        if (creator != null) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.AttachmentHTMLGenerator_CREATED_BY).setCSSClass("dimmed");
            HTMLGenerator.Composite c = composite;
            if (this.getInfo().isFocusTooltip) {
                c = new HTMLGenerator.Link((HTMLGenerator)this, composite, URIService.createAuditableURI((ITeamRepository)teamRepository, (IItemHandle)creator).toString());
            }
            new HTMLGenerator.Label((HTMLGenerator)this, c, Utils.escapeToHTML((String)creator.getName()));
        }
        if ((date = attachment.getCreationDate()) != null && ((Date)date).getTime() != 0L) {
            new HTMLGenerator.Label((HTMLGenerator)this, composite, Messages.AttachmentHTMLGenerator_ON).setCSSClass("dimmed");
            new HTMLGenerator.Label((HTMLGenerator)this, composite, DateFormat.getDateTimeInstance((int)2, (int)3).format((Date)date));
        }
    }

    public static String smartFormatSize(long size) {
        if (size % 0x100000L < size && size / 0x100000L > 10L) {
            return String.valueOf(size / 0x100000L) + Messages.AttachmentHTMLGenerator_MEGABYTE;
        }
        if (size % 1024L < size) {
            return String.valueOf(size / 1024L) + Messages.AttachmentHTMLGenerator_KILOBYTE;
        }
        return Long.toString(size);
    }

    protected void generateHead(HashMap map) {
        if (this.getInfo().isHoverTooltip) {
            StringBuilder js = new StringBuilder();
            js.append("\t\t<script type=\"text/javascript\">\n\t\t\n\t\t\tvar img= document.getElementById('photoId');\n\t\t\tvar img_width= 0;\n\t\t\tvar img_height= 0;\n\t\t\t\n\t\t\twindow.onresize= function() {\n\t\t\t\tadjustRatio(img);\n\t\t\t}\n\t\t\t\n\t\t\tdocument.onload= function() {\n\t\t\t\tadjustRatio(img);\n\t\t\t}\n\t\t\t\n\t\t\tfunction scale_load(id) {\n\t\t\t\timg= document.getElementById(id);\n\t\t\t\timg_width= img.width;\n\t\t\t\timg_height= img.height;\n\t\t\t\tadjustRatio(img);\n\t\t\t}\n\t\t\t\n\t\t\tfunction adjustRatio(img) {\n\t\t\t\tvar w;\n\t\t\t\tvar h;\n\t\t\t\tif (navigator.appName == 'Microsoft Internet Explorer') {\n\t\t\t\t\tw= document.body.clientWidth;\n\t\t\t\t\th= document.body.clientHeight;\n\t\t\t\t} else {\n\t\t\t\t\tw= window.innerWidth;\n\t\t\t\t\th= window.innerHeight;\n\t\t\t\t}\n\t\t\t\t\n\t\t\t\tvar f= Math.min(1.0, Math.min(w/img_width, h/img_height));\n\t\t\t\t\n\t\t\t\timg.width= img_width*f;\n\t\t\t\timg.height= img_height*f;\n\t\t\t}\n\t\t\n\t\t</script>");
            map.put(ATTACHMENT_JS, js.toString());
        }
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        StringBuffer css = new StringBuffer();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; ").append(MarkupUtil.getFont()).append(" }");
        css.append("span.photo { float: left; }");
        css.append(".dimmed { color: #666666}\n");
        if (this.getInfo().isHoverTooltip) {
            css.append("a:link { text-decoration: none; color: black; } ");
        } else {
            css.append("a:link { color: #0000FF; text-decoration: none; }");
        }
        if (this.getInfo().isHoverTooltip) {
            css.append("a:visited { color: black; text-decoration: none; } ");
        } else {
            css.append("a:visited { color: #0000FF; text-decoration: none; }\n");
        }
        css.append("a:hover { color: #000080; text-decoration: underline; }");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }
}

