/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preview;

import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.preview.AttachmentHTMLGenerator;
import com.ibm.team.workitem.ide.ui.internal.preview.Messages;
import com.ibm.team.workitem.rcp.ui.internal.preview.ResolveDomainAdapter;
import java.util.HashMap;

public class AttachmentDomainAdapter
extends ResolveDomainAdapter {
    public String generateContentAsText(Object input) {
        try {
            input = this.resolve(input, IAttachment.SMALL_PROFILE);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return this.permissionDenied();
        }
        if (input instanceof IAttachment) {
            return ((IAttachment)input).getDescription();
        }
        return "";
    }

    public void generateContentAsHTML(HashMap head, StringBuffer body, Object input, IDomainAdapter.Info info) {
        if (input instanceof IAttachmentHandle) {
            new AttachmentHTMLGenerator((IAttachmentHandle)input).generate(head, body, info);
        }
    }

    public String generateTitle(Object input) {
        try {
            input = this.resolve(input, IAttachment.SMALL_PROFILE);
        }
        catch (PermissionDeniedException permissionDeniedException) {
            return this.permissionDenied();
        }
        if (input instanceof IAttachment) {
            return ((IAttachment)input).getName();
        }
        return "";
    }

    private Object resolve(Object input, ItemProfile itemProfile) throws PermissionDeniedException {
        if (input instanceof IAttachmentHandle) {
            IAttachmentHandle ah = (IAttachmentHandle)input;
            try {
                ITeamRepository teamRepository = (ITeamRepository)ah.getOrigin();
                if (teamRepository != null) {
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    input = auditableClient.resolveAuditable((IAuditableHandle)ah, itemProfile, null);
                }
            }
            catch (PermissionDeniedException x) {
                throw x;
            }
            catch (TeamRepositoryException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.AttachmentDomainAdapter_EXCEPTION_RESOLVING_ATTACHMENT, x);
            }
        }
        return input;
    }

    public String generateJobInfo(Object input, IDomainAdapter.Info info) {
        IAttachment attachment;
        if (info.isHoverTooltip) {
            return null;
        }
        if (input instanceof IAttachment && (attachment = (IAttachment)input).isPropertySet(IAttachment.ID_PROPERTY) && attachment.isPropertySet(IAttachment.NAME_PROPERTY)) {
            return NLS.bind((String)Messages.AttachmentDomainAdapter_RESOLVING_ATTACHMENT_ID_NAME, (Object)attachment.getId(), (Object[])new Object[]{attachment.getName()});
        }
        return Messages.AttachmentDomainAdapter_RESOLVING_ATTACHMENT;
    }
}

