/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.preference;

import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.FileHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.DefaultHyperlinkHandler;
import com.ibm.team.workitem.ide.ui.internal.preference.Messages;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.layout.ITrimManager;
import org.eclipse.ui.internal.layout.IWindowTrim;

public final class WorkItemPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String PAGE_ID = "com.ibm.team.workitem.ide.ui.workitemPage";
    private Button fActiveWorkItemButton;
    private Button fAttachmentButton;
    private Button fAutoCommentButton;
    private Spinner fCategorySize;
    private Spinner fTargetSize;
    private Control fControl;
    private Button fQuickSearchButton;
    private Button fReuseEditorButton;
    private Button fExternalOpenButton;

    protected Control createContents(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(16384, 128, false, false));
        c.setLayout((Layout)new GridLayout());
        Composite spinnerContainer = new Composite(c, 0);
        spinnerContainer.setLayoutData((Object)new GridData(16384, 128, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        spinnerContainer.setLayout((Layout)layout);
        this.categorySelectionHistorySize(spinnerContainer);
        this.targetSelectionHistorySize(spinnerContainer);
        this.activeWorkitemTrim(c);
        this.quickSearchTrim(c);
        this.attachmentDialogWarning(c);
        this.externalOpenDialogWarning(c);
        this.autoSubscribeOnComment(c);
        this.reuseWorkItemEditor(c);
        this.applyDialogFont(c);
        this.fControl = c;
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.workitem.ide.ui.work_item_preference_page");
        return c;
    }

    private void categorySelectionHistorySize(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(Messages.WorkItemPreferencePage_RECENTLY_USED_CATEGORIES);
        this.fCategorySize = new Spinner(parent, 2048);
        this.fCategorySize.setValues(WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getInt("com.ibm.team.workitem.ide.ui.CategorySelectionHistory.size"), 0, 80, 0, 1, 5);
    }

    private void targetSelectionHistorySize(Composite parent) {
        Label l = new Label(parent, 0);
        l.setText(Messages.WorkItemPreferencePage_RECENTLY_USED_ITERATIONS);
        this.fTargetSize = new Spinner(parent, 2048);
        this.fTargetSize.setValues(WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getInt("com.ibm.team.workitem.ide.ui.IntervalSelectionHistory.size"), 0, 80, 0, 1, 5);
    }

    private void autoSubscribeOnComment(Composite parent) {
        this.fAutoCommentButton = new Button(parent, 32);
        this.fAutoCommentButton.setText(Messages.WorkItemPreferencePage_AUTO_SUBSCRIBE);
        this.fAutoCommentButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fAutoCommentButton.setSelection(WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getBoolean("com.ibm.team.workitem.ide.ui.editor.autosubscribe"));
    }

    private void attachmentDialogWarning(Composite parent) {
        this.fAttachmentButton = new Button(parent, 32);
        this.fAttachmentButton.setText(Messages.WorkItemPreferencePage_ATTACHMENT_WARNING);
        this.fAttachmentButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fAttachmentButton.setSelection(WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getBoolean(FileHelper.SHOW_ATTACHMENT_WARNING_DIALOG));
    }

    private void externalOpenDialogWarning(Composite parent) {
        this.fExternalOpenButton = new Button(parent, 32);
        this.fExternalOpenButton.setText(Messages.WorkItemPreferencePage_SHOW_OPEN_EXTERNAL_WARNING_DIALOG);
        this.fExternalOpenButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fExternalOpenButton.setSelection(WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getBoolean(DefaultHyperlinkHandler.SHOW_EXTERNAL_OPEN_WARNING_DIALOG));
    }

    private void activeWorkitemTrim(Composite parent) {
        this.fActiveWorkItemButton = new Button(parent, 32);
        this.fActiveWorkItemButton.setText(Messages.WorkItemPreferencePage_CURRENT_WORK_TRIM);
        this.fActiveWorkItemButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fActiveWorkItemButton.setSelection(this.isActiveWorkItemTrimVisible());
    }

    private void quickSearchTrim(Composite parent) {
        this.fQuickSearchButton = new Button(parent, 32);
        this.fQuickSearchButton.setText(Messages.WorkItemPreferencePage_SHOW_QUICK_SEARCH_TRIM);
        this.fQuickSearchButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fQuickSearchButton.setSelection(WorkItemRCPUIPlugin.getDefault().getQuickSearchTrimVisibilityPreference());
    }

    private void reuseWorkItemEditor(Composite parent) {
        this.fReuseEditorButton = new Button(parent, 32);
        this.fReuseEditorButton.setText(Messages.WorkItemPreferencePage_REUSE_WORKITEM_EDITOR);
        this.fReuseEditorButton.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fReuseEditorButton.setSelection(WorkItemRCPUIPlugin.getDefault().getReuseWorkItemEditorPref());
    }

    protected void performDefaults() {
        if (this.fAutoCommentButton != null && !this.fAutoCommentButton.isDisposed()) {
            this.fAutoCommentButton.setSelection(WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getDefaultBoolean("com.ibm.team.workitem.ide.ui.editor.autosubscribe"));
        }
        if (this.fAttachmentButton != null && !this.fAttachmentButton.isDisposed()) {
            this.fAttachmentButton.setSelection(WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getDefaultBoolean(FileHelper.SHOW_ATTACHMENT_WARNING_DIALOG));
        }
        if (this.fExternalOpenButton != null && !this.fExternalOpenButton.isDisposed()) {
            this.fExternalOpenButton.setSelection(WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getDefaultBoolean(DefaultHyperlinkHandler.SHOW_EXTERNAL_OPEN_WARNING_DIALOG));
        }
        if (this.fCategorySize != null && !this.fCategorySize.isDisposed()) {
            this.fCategorySize.setSelection(WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getDefaultInt("com.ibm.team.workitem.ide.ui.CategorySelectionHistory.size"));
        }
        if (this.fTargetSize != null && !this.fTargetSize.isDisposed()) {
            this.fTargetSize.setSelection(WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getDefaultInt("com.ibm.team.workitem.ide.ui.IntervalSelectionHistory.size"));
        }
        if (this.fActiveWorkItemButton != null && !this.fActiveWorkItemButton.isDisposed()) {
            this.updateActiveWorkItemTrim(true);
        }
        if (this.fQuickSearchButton != null && !this.fQuickSearchButton.isDisposed()) {
            this.fQuickSearchButton.setSelection(true);
        }
        if (this.fReuseEditorButton != null && !this.fReuseEditorButton.isDisposed()) {
            this.fReuseEditorButton.setSelection(true);
        }
        super.performDefaults();
    }

    public boolean performOk() {
        if (this.fAutoCommentButton != null && !this.fAutoCommentButton.isDisposed()) {
            WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue("com.ibm.team.workitem.ide.ui.editor.autosubscribe", this.fAutoCommentButton.getSelection());
        }
        if (this.fAttachmentButton != null && !this.fAttachmentButton.isDisposed()) {
            WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue(FileHelper.SHOW_ATTACHMENT_WARNING_DIALOG, this.fAttachmentButton.getSelection());
        }
        if (this.fExternalOpenButton != null && !this.fExternalOpenButton.isDisposed()) {
            WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue(DefaultHyperlinkHandler.SHOW_EXTERNAL_OPEN_WARNING_DIALOG, this.fExternalOpenButton.getSelection());
        }
        if (this.fCategorySize != null && !this.fCategorySize.isDisposed()) {
            WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue("com.ibm.team.workitem.ide.ui.CategorySelectionHistory.size", this.fCategorySize.getSelection());
        }
        if (this.fTargetSize != null && !this.fTargetSize.isDisposed()) {
            WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue("com.ibm.team.workitem.ide.ui.IntervalSelectionHistory.size", this.fTargetSize.getSelection());
        }
        if (this.fActiveWorkItemButton != null && !this.fActiveWorkItemButton.isDisposed()) {
            this.updateActiveWorkItemTrim(this.fActiveWorkItemButton.getSelection());
        }
        if (this.fQuickSearchButton != null && !this.fQuickSearchButton.isDisposed()) {
            WorkItemRCPUIPlugin.getDefault().setQuickSearchTrimVisibilityPreference(this.fQuickSearchButton.getSelection());
            WorkItemRCPUIPlugin.getDefault().updateQuickSearchTrimVisibility();
        }
        if (this.fReuseEditorButton != null && !this.fReuseEditorButton.isDisposed()) {
            WorkItemRCPUIPlugin.getDefault().setReuseWorkItemEditorPref(this.fReuseEditorButton.getSelection());
        }
        return true;
    }

    private void updateActiveWorkItemTrim(boolean selection) {
        IWorkbenchWindow[] windows;
        IPreferenceStore store = WorkItemRCPUIPlugin.getDefault().getPreferenceStore();
        store.setDefault("com.ibm.team.workitem.active.trim", true);
        store.setValue("com.ibm.team.workitem.active.trim", selection);
        IWorkbenchWindow[] iWorkbenchWindowArray = windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = windows.length;
        int n2 = 0;
        while (n2 < n) {
            IWindowTrim trim;
            WorkbenchWindow extended;
            ITrimManager manager;
            IWorkbenchWindow window = iWorkbenchWindowArray[n2];
            if (window instanceof WorkbenchWindow && (manager = (extended = (WorkbenchWindow)window).getTrimManager()) != null && (trim = manager.getTrim("com.ibm.team.workitem.rcp.ui.WorkitemActivationGroup")) != null) {
                manager.setTrimVisible(trim, selection);
                trim.getControl().getParent().layout(true);
            }
            ++n2;
        }
    }

    private boolean isActiveWorkItemTrimVisible() {
        Control control;
        IWindowTrim trim;
        WorkbenchWindow extended;
        ITrimManager manager;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window instanceof WorkbenchWindow && (manager = (extended = (WorkbenchWindow)window).getTrimManager()) != null && (trim = manager.getTrim("com.ibm.team.workitem.rcp.ui.WorkitemActivationGroup")) != null && (control = trim.getControl()) != null) {
            return control.isVisible();
        }
        return false;
    }

    public Point computeSize() {
        return this.doComputeSize();
    }

    protected Point doComputeSize() {
        if (this.fControl != null && !this.fControl.isDisposed()) {
            Point size = this.fControl.computeSize(-1, -1);
            this.setSize(size);
        }
        return super.doComputeSize();
    }

    public void init(IWorkbench workbench) {
    }
}

