/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.mailconfig;

import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.internal.mailconfig.MailConfigurationDefaults;
import com.ibm.team.workitem.common.internal.mailconfig.WorkItemChange;
import com.ibm.team.workitem.common.internal.mailconfig.WorkItemNotificationFilter;
import com.ibm.team.workitem.common.internal.mailconfig.WorkItemRelationship;
import com.ibm.team.workitem.ide.ui.internal.mailconfig.Messages;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MailConfigWorkItemChangesMatrix
extends Composite {
    private Map<WorkItemNotificationFilter, Button> fMapFilterToButton = new HashMap<WorkItemNotificationFilter, Button>();
    private Map<WorkItemNotificationFilter, Boolean> fMapFilterToValue = new HashMap<WorkItemNotificationFilter, Boolean>();
    private LocalResourceManager fResources;

    public MailConfigWorkItemChangesMatrix(Composite parent, int style) {
        super(parent, style);
        this.fResources = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.createControl();
    }

    private void createControl() {
        WorkItemRelationship[] relationships = WorkItemRelationship.values();
        WorkItemChange[] changes = WorkItemChange.values();
        GridLayout layout = new GridLayout(relationships.length + 1, false);
        layout.horizontalSpacing = 20;
        layout.verticalSpacing = 10;
        this.internalSetLayout((Layout)layout);
        int row = 0;
        while (row < changes.length + 1) {
            int col = 0;
            while (col < relationships.length + 1) {
                if (row == 0 && col < relationships.length) {
                    WorkItemRelationship rel = relationships[col];
                    Composite linkContainer = new Composite((Composite)this, 0);
                    linkContainer.setLayout((Layout)new GridLayout(2, false));
                    ((GridLayout)linkContainer.getLayout()).marginWidth = 0;
                    ((GridLayout)linkContainer.getLayout()).marginHeight = 0;
                    GridData data = new GridData(0x1000000, 1, true, false);
                    linkContainer.setLayoutData((Object)data);
                    Label imgLabel = new Label(linkContainer, 0);
                    imgLabel.setImage(this.fResources.createImage(FeedUIPlugin.getSubjectRelationShipImageDescriptor((String)rel.getId())));
                    Label label = new Label(linkContainer, 0);
                    label.setText(rel.getName());
                    data = new GridData(0x1000000, 1, true, false);
                    label.setLayoutData((Object)data);
                } else if (row != 0 && col == relationships.length) {
                    WorkItemChange change = changes[row - 1];
                    Label label = new Label((Composite)this, 0);
                    label.setText(change.getName());
                } else if (row == 0) {
                    new Label((Composite)this, 0);
                } else {
                    final WorkItemNotificationFilter filter = WorkItemNotificationFilter.createFrom((WorkItemRelationship)relationships[col], (WorkItemChange)changes[row - 1]);
                    boolean defaultEnabled = this.getDefault(filter);
                    final Button check = new Button((Composite)this, 32);
                    final String accName = NLS.bind((String)Messages.MailConfigWorkItemChangesMatrix_RELATION_CHANGE_TOOLTIP, (Object)filter.getRelationship().getName(), (Object[])new Object[]{filter.getChange().getName()});
                    check.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                        public void getName(AccessibleEvent e) {
                            e.result = accName;
                        }
                    });
                    check.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
                    check.setSelection(defaultEnabled);
                    check.setToolTipText(accName);
                    this.fMapFilterToValue.put(filter, defaultEnabled);
                    check.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            MailConfigWorkItemChangesMatrix.this.notifyListeners(13, new Event());
                            MailConfigWorkItemChangesMatrix.this.fMapFilterToValue.put(filter, check.getSelection());
                        }
                    });
                    this.fMapFilterToButton.put(filter, check);
                }
                ++col;
            }
            ++row;
        }
        Composite buttonContainer = new Composite((Composite)this, 0);
        buttonContainer.setLayout((Layout)new GridLayout(3, false));
        buttonContainer.setLayoutData((Object)new GridData(4, 1, true, false, relationships.length + 1, 1));
        Button selectAll = new Button(buttonContainer, 8);
        selectAll.setText(Messages.MailConfigWorkItemChangesMatrix_SELECT_ALL);
        selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MailConfigWorkItemChangesMatrix.this.setSelection(true);
            }
        });
        Button deselectAll = new Button(buttonContainer, 8);
        deselectAll.setText(Messages.MailConfigWorkItemChangesMatrix_DESELECT_ALL);
        deselectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MailConfigWorkItemChangesMatrix.this.setSelection(false);
            }
        });
        Button restoreDefaults = new Button(buttonContainer, 8);
        restoreDefaults.setText(Messages.MailConfigWorkItemChangesMatrix_RESTORE_DEFAULTS);
        restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MailConfigWorkItemChangesMatrix.this.restoreDefaults();
            }
        });
        GC gc = new GC((Drawable)this);
        FontMetrics metrics = gc.getFontMetrics();
        this.setButtonLayoutData(selectAll, metrics);
        this.setButtonLayoutData(deselectAll, metrics);
        this.setButtonLayoutData(restoreDefaults, metrics);
        gc.dispose();
    }

    private boolean getDefault(WorkItemNotificationFilter filter) {
        List relations = (List)MailConfigurationDefaults.FILTERS.get(filter.getChange());
        if (relations != null) {
            return relations.contains(filter.getRelationship());
        }
        return false;
    }

    private void restoreDefaults() {
        this.fMapFilterToValue.clear();
        Set entries = MailConfigurationDefaults.FILTERS.entrySet();
        for (Map.Entry entry : entries) {
            List relations = (List)entry.getValue();
            for (WorkItemRelationship relation : relations) {
                this.fMapFilterToValue.put(WorkItemNotificationFilter.createFrom((WorkItemRelationship)relation, (WorkItemChange)((WorkItemChange)entry.getKey())), true);
            }
        }
        this.updateButtons();
        this.notifyListeners(13, new Event());
    }

    private void setButtonLayoutData(Button button, FontMetrics metrics) {
        GridData data = new GridData(256);
        int widthHint = Dialog.convertHorizontalDLUsToPixels((FontMetrics)metrics, (int)61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
    }

    private void setSelection(boolean selected) {
        boolean changed = false;
        Set<Map.Entry<WorkItemNotificationFilter, Button>> entries = this.fMapFilterToButton.entrySet();
        for (Map.Entry<WorkItemNotificationFilter, Button> entry : entries) {
            if (selected == entry.getValue().getSelection()) continue;
            entry.getValue().setSelection(selected);
            this.fMapFilterToValue.put(entry.getKey(), selected);
            changed = true;
        }
        if (changed) {
            this.notifyListeners(13, new Event());
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.setEnabled(this, enabled);
    }

    private void setEnabled(Composite c, boolean enabled) {
        Control[] children;
        Control[] controlArray = children = c.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.setEnabled(enabled);
            if (control instanceof Composite) {
                this.setEnabled((Composite)control, enabled);
            }
            ++n2;
        }
    }

    public void setLayout(Layout layout) {
    }

    private void internalSetLayout(Layout layout) {
        super.setLayout(layout);
    }

    void loadFrom(IMemento memento) {
        IMemento root = memento.getChild("filter");
        if (root != null) {
            WorkItemRelationship[] relationships = WorkItemRelationship.values();
            WorkItemChange[] changes = WorkItemChange.values();
            WorkItemRelationship[] workItemRelationshipArray = relationships;
            int n = relationships.length;
            int n2 = 0;
            while (n2 < n) {
                WorkItemRelationship relationship = workItemRelationshipArray[n2];
                IMemento relMemento = root.getChild(relationship.name());
                WorkItemChange[] workItemChangeArray = changes;
                int n3 = changes.length;
                int n4 = 0;
                while (n4 < n3) {
                    WorkItemChange change = workItemChangeArray[n4];
                    WorkItemNotificationFilter filter = WorkItemNotificationFilter.createFrom((WorkItemRelationship)relationship, (WorkItemChange)change);
                    IMemento changeMemento = relMemento != null ? relMemento.getChild(change.name()) : null;
                    this.fMapFilterToValue.put(filter, changeMemento != null);
                    ++n4;
                }
                ++n2;
            }
            FoundationUIJob job = new FoundationUIJob(""){

                public IStatus runProtectedInUI(IProgressMonitor monitor) {
                    MailConfigWorkItemChangesMatrix.this.updateButtons();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        }
    }

    void saveTo(IMemento memento) {
        IMemento root = memento.createChild("filter");
        HashMap<WorkItemRelationship, IMemento> mapRelationshipToMemento = new HashMap<WorkItemRelationship, IMemento>();
        Set<Map.Entry<WorkItemNotificationFilter, Boolean>> entries = this.fMapFilterToValue.entrySet();
        for (Map.Entry<WorkItemNotificationFilter, Boolean> entry : entries) {
            if (entry.getValue() == null || !entry.getValue().booleanValue()) continue;
            WorkItemRelationship relationship = entry.getKey().getRelationship();
            WorkItemChange change = entry.getKey().getChange();
            IMemento relMemento = (IMemento)mapRelationshipToMemento.get(relationship);
            if (relMemento == null) {
                relMemento = root.createChild(relationship.name());
                mapRelationshipToMemento.put(relationship, relMemento);
            }
            relMemento.createChild(change.name());
        }
    }

    private void updateButtons() {
        Set<Map.Entry<WorkItemNotificationFilter, Button>> entries = this.fMapFilterToButton.entrySet();
        for (Map.Entry<WorkItemNotificationFilter, Button> entry : entries) {
            Boolean enabled = this.fMapFilterToValue.get(entry.getKey());
            Button button = entry.getValue();
            if (button == null || button.isDisposed()) continue;
            button.setSelection(enabled != null && enabled != false);
        }
    }
}

