/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.mailconfig;

import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.util.IMemento;
import com.ibm.team.foundation.common.util.XMLMemento;
import com.ibm.team.repository.common.IContributorDetails;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.ui.editor.TeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.HelpContextIds;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.mailconfig.AbstractMailConfigFormPart;
import com.ibm.team.workitem.ide.ui.internal.mailconfig.MailConfigApprovalsFormPart;
import com.ibm.team.workitem.ide.ui.internal.mailconfig.MailConfigEditorInput;
import com.ibm.team.workitem.ide.ui.internal.mailconfig.MailConfigFormatFormPart;
import com.ibm.team.workitem.ide.ui.internal.mailconfig.MailConfigMessagesAtMeFormPart;
import com.ibm.team.workitem.ide.ui.internal.mailconfig.MailConfigWorkItemsFormPart;
import com.ibm.team.workitem.ide.ui.internal.mailconfig.Messages;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.SectionPart;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.ColumnLayout;

public class MailConfigFormPage
extends TeamFormPage {
    private static final String ID = "com.ibm.team.workitem.ide.ui.internal.mailconfig.MailConfigFormPage";
    private static final String NAME = Messages.MailConfigFormPage_EDITOR_TAB_NAME;
    private boolean fDirty;
    private List<AbstractMailConfigFormPart> fMailConfigParts = new ArrayList<AbstractMailConfigFormPart>();
    private MailConfigEditorInput fInput;

    public MailConfigFormPage(FormEditor editor) {
        super(editor, ID, NAME);
    }

    protected void setInput(IEditorInput input) {
        if (input == null || !(input instanceof MailConfigEditorInput)) {
            return;
        }
        super.setInput(input);
        this.fInput = (MailConfigEditorInput)input;
    }

    protected void createFormContent(IManagedForm form) {
        Assert.isNotNull((Object)form);
        ColumnLayout layout = new ColumnLayout();
        layout.maxNumColumns = 2;
        form.getForm().getBody().setLayout((Layout)layout);
        MailConfigWorkItemsFormPart mailConfigWorkItemsFormPart = new MailConfigWorkItemsFormPart(this);
        this.fMailConfigParts.add(mailConfigWorkItemsFormPart);
        TeamFormSectionPart workItemsConfigSection = new TeamFormSectionPart(form, 256, Messages.MailConfigFormPage_WORKITEMS, new TeamFormPart[]{mailConfigWorkItemsFormPart});
        this.addPart((SectionPart)workItemsConfigSection);
        workItemsConfigSection.setFormInput((Object)this.getEditorInput());
        MailConfigMessagesAtMeFormPart mailConfigMessagesAtMeFormPart = new MailConfigMessagesAtMeFormPart(this);
        this.fMailConfigParts.add(mailConfigMessagesAtMeFormPart);
        TeamFormSectionPart messagesAtMeConfigSection = new TeamFormSectionPart(form, 256, Messages.MailConfigFormPage_MESSAGES_AT_ME, new TeamFormPart[]{mailConfigMessagesAtMeFormPart});
        this.addPart((SectionPart)messagesAtMeConfigSection);
        messagesAtMeConfigSection.setFormInput((Object)this.getEditorInput());
        MailConfigApprovalsFormPart mailConfigApprovalsFormPart = new MailConfigApprovalsFormPart(this);
        this.fMailConfigParts.add(mailConfigApprovalsFormPart);
        TeamFormSectionPart approvalsConfigSection = new TeamFormSectionPart(form, 256, Messages.MailConfigFormPage_APPROVALS, new TeamFormPart[]{mailConfigApprovalsFormPart});
        this.addPart((SectionPart)approvalsConfigSection);
        approvalsConfigSection.setFormInput((Object)this.getEditorInput());
        MailConfigFormatFormPart mailConfigFormatFormPart = new MailConfigFormatFormPart(this);
        this.fMailConfigParts.add(mailConfigFormatFormPart);
        TeamFormSectionPart formatConfigSection = new TeamFormSectionPart(form, 256, Messages.MailConfigFormPage_FORMAT, new TeamFormPart[]{mailConfigFormatFormPart});
        this.addPart((SectionPart)formatConfigSection);
        formatConfigSection.setFormInput((Object)this.getEditorInput());
        this.loadConfiguration();
        HelpContextIds.hookHelpListener((Control)form.getForm(), "com.ibm.team.workitem.ide.ui.mail_configuration_editor_page");
    }

    private synchronized void loadConfiguration() {
        FoundationJob job = new FoundationJob(Messages.MailConfigFormPage_FETCHING_CONFIG){

            protected IStatus runProtected(IProgressMonitor monitor) {
                monitor.beginTask(Messages.MailConfigFormPage_FETCHING_CONFIG_DOTDOTDOT, -1);
                try {
                    IContributorDetails contributorDetails = MailConfigFormPage.this.fInput.loadContributorDetails(monitor);
                    if (contributorDetails != null) {
                        IMemento globalConfig;
                        XMLMemento configMemento = null;
                        String configurationValue = contributorDetails.getLargeStringExtension("com.ibm.team.workitem.mail.Configuration");
                        if (configurationValue != null && configurationValue.length() > 0 && (configMemento = XMLMemento.createReadRoot((Reader)new StringReader(configurationValue))) != null && (globalConfig = configMemento.getChild("global")) != null) {
                            for (AbstractMailConfigFormPart part : MailConfigFormPage.this.fMailConfigParts) {
                                IMemento domainMemento = globalConfig.getChild(part.getDomain());
                                if (domainMemento == null) continue;
                                part.loadFrom(domainMemento);
                            }
                        }
                    }
                }
                catch (TeamRepositoryException e) {
                    WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
                }
                catch (CoreException e) {
                    WorkItemIDEUIPlugin.getDefault().log(e.getStatus());
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(10);
        job.schedule();
    }

    public synchronized void doSave(IProgressMonitor monitor) {
        final boolean[] result = new boolean[1];
        this.runLongOperation(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                XMLMemento memento = XMLMemento.createWriteRoot((String)"mailconfiguration");
                memento.putString("version", "0.6");
                IMemento globalConfig = memento.createChild("global");
                for (AbstractMailConfigFormPart part : MailConfigFormPage.this.fMailConfigParts) {
                    IMemento domainMemento = globalConfig.createChild(part.getDomain());
                    part.saveTo(domainMemento);
                }
                try {
                    StringWriter writer = new StringWriter();
                    memento.save((Writer)writer);
                    IContributorDetails contributorDetails = (IContributorDetails)MailConfigFormPage.this.fInput.loadContributorDetails(monitor).getWorkingCopy();
                    contributorDetails.setLargeStringExtension("com.ibm.team.workitem.mail.Configuration", writer.toString());
                    MailConfigFormPage.this.fInput.saveContributorDetails(monitor, contributorDetails);
                    result[0] = true;
                }
                catch (IOException e) {
                    WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
                }
                catch (TeamRepositoryException e) {
                    WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
                }
            }
        });
        if (result[0]) {
            this.setDirty(false);
        } else {
            monitor.setCanceled(true);
        }
    }

    private void runLongOperation(IRunnableWithProgress runnable) {
        Assert.isNotNull((Object)runnable);
        try {
            this.getSite().getWorkbenchWindow().run(true, true, runnable);
        }
        catch (InvocationTargetException exception) {
            if (exception.getTargetException() instanceof RuntimeException) {
                throw (RuntimeException)exception.getTargetException();
            }
            if (exception.getTargetException() instanceof Error) {
                throw (Error)exception.getTargetException();
            }
            throw new UndeclaredThrowableException(exception.getTargetException() != null ? exception.getTargetException() : exception);
        }
        catch (InterruptedException exception) {
            throw new OperationCanceledException(exception.getMessage());
        }
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    void setDirty(boolean dirty) {
        boolean changed = this.fDirty ^ dirty;
        this.fDirty = dirty;
        if (changed) {
            this.firePropertyChange(257);
        }
    }
}

