/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.history;

import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemSelectionHistory {
    protected LinkedList<IItemHandle> fHistory = new LinkedList();
    private boolean fIsResolving = false;

    ItemSelectionHistory() {
    }

    public abstract void resolveHistory(IWorkItem var1, IProgressMonitor var2) throws TeamRepositoryException;

    protected abstract boolean isNullItem(IItem var1);

    protected abstract void setSize(int var1);

    protected abstract int getSize();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(IItem p) {
        if (p == null || this.isNullItem(p)) {
            return;
        }
        LinkedList<IItemHandle> linkedList = this.fHistory;
        synchronized (linkedList) {
            if (this.historyContains((IItemHandle)p)) {
                this.fHistory.remove(p);
            }
            while (this.getCurrentSize() >= this.getMaxSize()) {
                this.fHistory.removeLast();
            }
            this.fHistory.addFirst((IItemHandle)p);
        }
    }

    public int getMaxSize() {
        return this.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IItem[] getHistory() {
        LinkedList<IItem> result = new LinkedList<IItem>();
        LinkedList<IItemHandle> linkedList = this.fHistory;
        synchronized (linkedList) {
            for (IItemHandle element : this.fHistory) {
                if (!(element instanceof IItem)) continue;
                if (result.size() >= this.getMaxSize()) break;
                result.addLast((IItem)element);
            }
        }
        return result.toArray(new IItem[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<IItemHandle> getRawValues() {
        LinkedList<IItemHandle> result = new LinkedList<IItemHandle>();
        LinkedList<IItemHandle> linkedList = this.fHistory;
        synchronized (linkedList) {
            for (IItemHandle element : this.fHistory) {
                if (result.size() >= this.getMaxSize()) break;
                result.addLast(element);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasUnresolvedEntries() {
        LinkedList<IItemHandle> linkedList = this.fHistory;
        synchronized (linkedList) {
            IItemHandle element;
            Iterator it = this.fHistory.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while ((element = (IItemHandle)it.next()) instanceof IItem);
            return true;
        }
    }

    public boolean isResolving() {
        return this.fIsResolving;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addLast(IItemHandle p) {
        if (p == null || p instanceof IItem && this.isNullItem((IItem)p)) {
            return;
        }
        LinkedList<IItemHandle> linkedList = this.fHistory;
        synchronized (linkedList) {
            if (!this.historyContains(p)) {
                this.fHistory.addLast(p);
            }
        }
    }

    protected int getCurrentSize() {
        return this.fHistory.size();
    }

    protected void setResolving(boolean resolving) {
        this.fIsResolving = resolving;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean historyContains(IItemHandle p) {
        LinkedList<IItemHandle> linkedList = this.fHistory;
        synchronized (linkedList) {
            IItemHandle h;
            Iterator it = this.fHistory.iterator();
            do {
                if (it.hasNext()) continue;
                return false;
            } while (!(h = (IItemHandle)it.next()).sameItemId(p));
            return true;
        }
    }
}

