/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.history;

import com.ibm.team.process.common.IDevelopmentLine;
import com.ibm.team.process.common.IDevelopmentLineHandle;
import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IIterationHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.common.IAuditableCommon;
import com.ibm.team.workitem.common.internal.WorkItemCommon;
import com.ibm.team.workitem.common.internal.util.IterationsHelper;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.history.ItemSelectionHistory;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;

public class IntervalSelectionHistory
extends ItemSelectionHistory {
    public static final String INTERVAL_SELECTION_HISTORY_SIZE = "com.ibm.team.workitem.ide.ui.IntervalSelectionHistory.size";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveHistory(IWorkItem workItem, IProgressMonitor monitor) throws TeamRepositoryException {
        LinkedList element22;
        ArrayList copy;
        ITeamRepository teamRepository = (ITeamRepository)workItem.getOrigin();
        this.setResolving(true);
        LinkedList linkedList = this.fHistory;
        synchronized (linkedList) {
            copy = new ArrayList(this.fHistory);
        }
        HashMap<UUID, IIteration> intervals = new HashMap<UUID, IIteration>();
        for (LinkedList element22 : copy) {
            if (!(element22 instanceof IIterationHandle) || element22 instanceof IIteration) continue;
            try {
                IIteration interval = (IIteration)teamRepository.itemManager().fetchCompleteItem((IItemHandle)element22, 0, monitor);
                intervals.put(interval.getItemId(), interval);
            }
            catch (ItemNotFoundException itemNotFoundException) {}
        }
        element22 = this.fHistory;
        synchronized (element22) {
            int i = 0;
            while (i < this.fHistory.size()) {
                IItemHandle element3 = (IItemHandle)this.fHistory.get(i);
                if (!(element3 instanceof IIteration) || ((IIteration)element3).isArchived() || !((IIteration)element3).hasDeliverable()) {
                    this.fHistory.remove(i);
                    IIteration interval = (IIteration)intervals.get(element3.getItemId());
                    if (interval != null) {
                        if (this.historyContains((IItemHandle)interval)) {
                            --i;
                        } else {
                            this.fHistory.add(i, interval);
                        }
                    }
                }
                ++i;
            }
        }
        if (this.getCurrentSize() < this.getMaxSize()) {
            Object[] values;
            IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            IDevelopmentLine devLine = ((WorkItemCommon)workItemClient).findDevelopmentLine(workItem.getProjectArea(), monitor);
            if (devLine != null) {
                LinkedList linkedList2;
                ArrayList<IIteration> valueSet = new ArrayList<IIteration>();
                values = new ArrayList();
                values.addAll(IterationsHelper.findIterations((IAuditableCommon)auditableClient, (IDevelopmentLineHandle)devLine, (ItemProfile)ItemProfile.createFullProfile((IItemType)IIteration.ITEM_TYPE), (boolean)false, (IProgressMonitor)monitor));
                for (Object e : values) {
                    if (!(e instanceof IIteration)) continue;
                    valueSet.add((IIteration)e);
                }
                for (IIteration iIteration : valueSet) {
                    if (iIteration.getEndDate() == null || !iIteration.getEndDate().after(new Date())) continue;
                    linkedList2 = this.fHistory;
                    synchronized (linkedList2) {
                        if (this.getCurrentSize() >= this.getMaxSize()) {
                            break;
                        }
                        this.addLast((IItemHandle)iIteration);
                    }
                }
                if (this.getCurrentSize() < this.getMaxSize()) {
                    for (IIteration iIteration : valueSet) {
                        if (iIteration.getEndDate() != null) continue;
                        linkedList2 = this.fHistory;
                        synchronized (linkedList2) {
                            if (this.getCurrentSize() >= this.getMaxSize()) {
                                break;
                            }
                            this.addLast((IItemHandle)iIteration);
                        }
                    }
                }
            }
            if (this.getCurrentSize() < this.getMaxSize()) {
                IAttribute attribute = workItemClient.findAttribute(workItem.getProjectArea(), IWorkItem.TARGET_PROPERTY, monitor);
                values = attribute.getValueSet((IAuditableCommon)auditableClient, workItem, monitor);
                ArrayList<IIteration> arrayList = new ArrayList<IIteration>();
                Object[] objectArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    Object value = objectArray[n2];
                    if (value instanceof IIteration) {
                        arrayList.add((IIteration)value);
                    }
                    ++n2;
                }
                for (IIteration inter : arrayList) {
                    if (inter.getEndDate() == null || !inter.getEndDate().after(new Date())) continue;
                    LinkedList linkedList3 = this.fHistory;
                    synchronized (linkedList3) {
                        if (this.getCurrentSize() >= this.getMaxSize()) {
                            break;
                        }
                        this.addLast((IItemHandle)inter);
                    }
                }
                if (this.getCurrentSize() < this.getMaxSize()) {
                    for (IIteration inter : arrayList) {
                        if (inter.getEndDate() != null) continue;
                        LinkedList linkedList4 = this.fHistory;
                        synchronized (linkedList4) {
                            if (this.getCurrentSize() >= this.getMaxSize()) {
                                break;
                            }
                            this.addLast((IItemHandle)inter);
                        }
                    }
                }
            }
        }
        this.setResolving(false);
    }

    protected boolean isNullItem(IItem item) {
        return item == null;
    }

    protected int getSize() {
        return WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getInt(INTERVAL_SELECTION_HISTORY_SIZE);
    }

    protected void setSize(int size) {
        WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue(INTERVAL_SELECTION_HISTORY_SIZE, size);
    }
}

