/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.history;

import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.ItemHandle;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.history.CategorySelectionHistory;
import com.ibm.team.workitem.ide.ui.internal.models.CategoryHistory;
import com.ibm.team.workitem.ide.ui.internal.models.CategoryHistoryEntry;
import com.ibm.team.workitem.ide.ui.internal.models.ModelsFactory;
import com.ibm.team.workitem.ide.ui.internal.models.WorkItemIDEUIModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CategorySelectionHistoryManager {
    private static HashMap<String, Map<UUID, CategorySelectionHistory>> fgRepositoryToHashMap = new HashMap();
    private static boolean initialized = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CategorySelectionHistory getHistory(IProjectAreaHandle projectArea) {
        HashMap<String, Map<UUID, CategorySelectionHistory>> hashMap = fgRepositoryToHashMap;
        synchronized (hashMap) {
            CategorySelectionHistory history;
            if (!initialized) {
                CategorySelectionHistoryManager.readCompleteHistory();
                initialized = true;
            }
            if (projectArea == null) {
                return new CategorySelectionHistory();
            }
            String repository = ((ITeamRepository)projectArea.getOrigin()).getRepositoryURI();
            Map<UUID, CategorySelectionHistory> projectToHistory = fgRepositoryToHashMap.get(repository);
            if (projectToHistory == null) {
                projectToHistory = new HashMap<UUID, CategorySelectionHistory>();
                history = new CategorySelectionHistory();
                projectToHistory.put(projectArea.getItemId(), history);
                fgRepositoryToHashMap.put(repository, projectToHistory);
            } else {
                history = projectToHistory.get(projectArea.getItemId());
                if (history == null) {
                    history = new CategorySelectionHistory();
                    projectToHistory.put(projectArea.getItemId(), history);
                }
            }
            CategorySelectionHistoryManager.patchHistory(history, (ITeamRepository)projectArea.getOrigin());
            return history;
        }
    }

    private static void patchHistory(CategorySelectionHistory history, ITeamRepository repository) {
        for (IItemHandle handle : history.fHistory) {
            if (handle.getOrigin() != null) continue;
            ((ItemHandle)handle).setOrigin((Object)repository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeHistories() throws IOException {
        HashMap<String, Map<UUID, CategorySelectionHistory>> hashMap = fgRepositoryToHashMap;
        synchronized (hashMap) {
            WorkItemIDEUIModel wim;
            CategoryHistory hist;
            if (!initialized) {
                CategorySelectionHistoryManager.readCompleteHistory();
                initialized = true;
            }
            if ((hist = (wim = WorkItemIDEUIPlugin.getDefault().getModel()).getCategoryHistory()) == null) {
                ModelsFactory factory = ModelsFactory.eINSTANCE;
                hist = factory.createCategoryHistory();
                wim.setCategoryHistory(hist);
            }
            List internalContents = hist.getInternalContents();
            internalContents.clear();
            for (Map.Entry<String, Map<UUID, CategorySelectionHistory>> repo : fgRepositoryToHashMap.entrySet()) {
                for (Map.Entry<UUID, CategorySelectionHistory> history : repo.getValue().entrySet()) {
                    List<IItemHandle> handles;
                    if (history.getValue().hasUnresolvedEntries()) {
                        handles = history.getValue().getRawValues();
                    } else {
                        IItem[] categories = history.getValue().getHistory();
                        handles = new ArrayList<IItemHandle>();
                        IItem[] iItemArray = categories;
                        int n = categories.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IItem cat = iItemArray[n2];
                            handles.add((IItemHandle)((ICategoryHandle)cat.getItemHandle()));
                            ++n2;
                        }
                    }
                    for (IItemHandle handle : handles) {
                        if (!(handle instanceof ICategoryHandle)) continue;
                        ModelsFactory factory = ModelsFactory.eINSTANCE;
                        CategoryHistoryEntry entry = null;
                        entry = factory.createCategoryHistoryEntry();
                        entry.setRepository(repo.getKey());
                        entry.setProjectArea((IProjectAreaHandle)IProjectArea.ITEM_TYPE.createItemHandle(history.getKey(), null));
                        entry.setCategory((ICategoryHandle)handle);
                        internalContents.add(entry);
                    }
                }
            }
        }
    }

    private static void readCompleteHistory() {
        WorkItemIDEUIModel wim = WorkItemIDEUIPlugin.getDefault().getModel();
        CategoryHistory hist = wim.getCategoryHistory();
        if (hist == null) {
            ModelsFactory factory = ModelsFactory.eINSTANCE;
            hist = factory.createCategoryHistory();
            wim.setCategoryHistory(hist);
            return;
        }
        for (Object element : hist.getInternalContents()) {
            CategorySelectionHistory history;
            CategoryHistoryEntry entry = (CategoryHistoryEntry)element;
            String repo = entry.getRepository();
            IProjectAreaHandle project = entry.getProjectArea();
            ICategoryHandle category = entry.getCategory();
            if (repo == null || project == null || category == null) continue;
            Map<UUID, CategorySelectionHistory> projectMap = fgRepositoryToHashMap.get(repo);
            if (projectMap == null) {
                projectMap = new HashMap<UUID, CategorySelectionHistory>();
                fgRepositoryToHashMap.put(repo, projectMap);
            }
            if ((history = projectMap.get(project.getItemId())) == null) {
                history = new CategorySelectionHistory();
                projectMap.put(project.getItemId(), history);
            }
            history.addLast((IItemHandle)((ICategoryHandle)category.getItemType().createItemHandle(category.getItemId(), null)));
        }
    }
}

