/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.templates;

import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;

public class WorkItemTemplateManager {
    private static final String TEMPLATES_KEY = "com.ibm.team.workitem.custom_templates";
    private static WorkItemTemplateManager fInstance;
    private ContributionTemplateStore fTemplateStore;
    private ContextTypeRegistry fContextTypeRegistry;

    public static WorkItemTemplateManager getDefault() {
        if (fInstance == null) {
            fInstance = new WorkItemTemplateManager();
        }
        return fInstance;
    }

    public synchronized TemplateStore getTemplateStore() {
        if (this.fTemplateStore == null) {
            IPreferenceStore store = WorkItemIDEUIPlugin.getDefault().getPreferenceStore();
            this.fTemplateStore = new ContributionTemplateStore(this.getTemplateContextRegistry(), store, TEMPLATES_KEY);
            try {
                this.fTemplateStore.load();
            }
            catch (IOException e) {
                WorkItemIDEUIPlugin.getDefault().log(e.getLocalizedMessage(), e);
            }
            this.fTemplateStore.startListeningForPreferenceChanges();
        }
        return this.fTemplateStore;
    }

    public synchronized ContextTypeRegistry getTemplateContextRegistry() {
        if (this.fContextTypeRegistry == null) {
            ContributionContextTypeRegistry registry = new ContributionContextTypeRegistry();
            registry.addContextType("context_type_all");
            registry.addContextType("context_type_workitem_editor");
            registry.addContextType("context_type_wiki_editor");
            this.fContextTypeRegistry = registry;
        }
        return this.fContextTypeRegistry;
    }

    public TemplateContextType getContextType(String contextTypeId) {
        return this.getTemplateContextRegistry().getContextType(contextTypeId);
    }

    public Template[] getTemplates(String contextTypeId) {
        return this.getTemplateStore().getTemplates(contextTypeId);
    }
}

