/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.quickinformation;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkflowUtilities;
import com.ibm.team.workitem.common.internal.presentations.QuickInformationConfigurationManager;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.links.LinkContentProvider;
import com.ibm.team.workitem.ide.ui.internal.editor.part.LinksPart;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.ItemizedQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.Messages;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemQuickInformationEntry
extends ItemizedQuickInformationEntry<IWorkItem> {
    private LinkContentProvider fLinkContentProvider = new LinkContentProvider(true);
    private IEndPointDescriptor fEndPoint;
    private IHyperlinkListener fURILinks;
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private ResolveItemsJob fResolverJob;
    private boolean fShowState = false;
    private HashMap<UUID, IWorkItem> fWorkItems = new HashMap();
    HashMap<UUID, IReference> fRefs = new HashMap();
    private final Object fWIIdLock = new Object();

    @Override
    public void adaptElementLink(Hyperlink link, IWorkItem element) {
        this.adaptItemHyperlink(link, element, this.fRefs.get(element.getItemId()));
        new ItemizedQuickInformationEntry.ItemDragSupport((Control)link, (IItemHandle)element);
    }

    @Override
    public void adaptLDotsLink(Hyperlink link) {
        this.getQuickInformationPart().getLinkGroup().add(link);
        IHyperlinkListener hyperlinkListener = this.getQuickInformationPart().getPartActivator(this.getConfigurationEntry().getProperty("linkTarget"));
        if (hyperlinkListener != null) {
            link.addHyperlinkListener(hyperlinkListener);
        }
        new WorkItemToolTipSupport((Control)link, this.getTitle(), this.getNumberOfItems(), this.getElements()){

            protected WorkItemWorkingCopy getWorkingCopy() {
                return WorkItemQuickInformationEntry.this.getWorkingCopy();
            }
        };
    }

    @Override
    public void init() {
        this.fURILinks = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getHref() instanceof URI) {
                    Hyperlinks.openHyperlink((URI)((URI)e.getHref()));
                }
            }
        };
        this.fLinkContentProvider.inputChanged(null, null, this.getWorkingCopy());
        this.assignDescriptor();
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().addListener((IWorkItemListener)this.fWorkItemListener, "references");
        }
        if (this.canShow()) {
            this.updateWorkItems();
        }
    }

    private void assignDescriptor() {
        List descriptors = this.getWorkingCopy().getReferences().getTypes();
        String combinedId = this.getConfigurationEntry().getProperty("endpointId");
        this.fEndPoint = QuickInformationConfigurationManager.findEndpointDescriptor((List)descriptors, (String)combinedId);
    }

    @Override
    public boolean canShow() {
        return this.fEndPoint != null && this.fLinkContentProvider.getChildren(this.fEndPoint).length > 0;
    }

    @Override
    public void shown(boolean reflow) {
        if (reflow) {
            this.fShowState = true;
        }
    }

    @Override
    public void adaptTitleLink(Hyperlink titleLink, Label imageLabel) {
        this.getQuickInformationPart().getLinkGroup().add(titleLink);
        IHyperlinkListener hyperlinkListener = this.getQuickInformationPart().getPartActivator(this.getConfigurationEntry().getProperty("linkTarget"));
        if (hyperlinkListener != null) {
            titleLink.addHyperlinkListener(hyperlinkListener);
        }
        new WorkItemToolTipSupport((Control)titleLink, this.getTitle(), this.getNumberOfItems(), this.getElements()){

            protected WorkItemWorkingCopy getWorkingCopy() {
                return WorkItemQuickInformationEntry.this.getWorkingCopy();
            }
        };
        new WorkItemToolTipSupport((Control)imageLabel, this.getTitle(), this.getNumberOfItems(), this.getElements()){

            protected WorkItemWorkingCopy getWorkingCopy() {
                return WorkItemQuickInformationEntry.this.getWorkingCopy();
            }
        };
        this.createItemContextMenu((Control)titleLink, this.fEndPoint);
        this.createItemContextMenu((Control)imageLabel, this.fEndPoint);
        this.addItemDropTarget((Control)titleLink, this.fEndPoint);
        this.addItemDropTarget((Control)imageLabel, this.fEndPoint);
    }

    @Override
    public void dispose() {
        if (this.fResolverJob != null) {
            this.fResolverJob.cancel();
        }
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().removeListener((IWorkItemListener)this.fWorkItemListener, "references");
        }
        if (this.fLinkContentProvider != null) {
            this.fLinkContentProvider.dispose();
            this.fLinkContentProvider = null;
        }
    }

    @Override
    public List<IWorkItem> getElements() {
        ArrayList<IWorkItem> workitems = new ArrayList<IWorkItem>();
        Object[] objectArray = this.fLinkContentProvider.getChildren(this.fEndPoint);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkItem wi;
            IItemReference iref;
            IReference ref;
            Object o = objectArray[n2];
            if (o instanceof IReference && (ref = (IReference)o).isItemReference() && (iref = (IItemReference)ref).getReferencedItem() instanceof IWorkItemHandle && (wi = this.fWorkItems.get(iref.getReferencedItem().getItemId())) != null) {
                workitems.add(wi);
                this.fRefs.put(wi.getItemId(), (IReference)iref);
            }
            ++n2;
        }
        Collections.sort(workitems, new WorkitemComparator());
        return workitems;
    }

    @Override
    public Image getImage() {
        return this.getQuickInformationPart().getLinkLableProvider().getColumnImage(this.fEndPoint, 0);
    }

    @Override
    public String getShortIdentifier(IWorkItem element) {
        return String.valueOf(element.getId());
    }

    @Override
    public String getTitle() {
        if (this.getConfigurationEntry().getTitle() != null) {
            return this.getConfigurationEntry().getTitle();
        }
        return this.fEndPoint.getDisplayName();
    }

    @Override
    public boolean showNumberOfItems() {
        return this.fEndPoint.isMultiValued();
    }

    @Override
    public int getNumberOfItems() {
        if (this.fEndPoint != null) {
            return this.fLinkContentProvider.getChildren(this.fEndPoint).length;
        }
        return super.getNumberOfItems();
    }

    private void updateWorkItems() {
        if (this.fResolverJob == null) {
            this.fResolverJob = new ResolveItemsJob(Messages.WorkItemQuickInformationEntry_RESOLVING_LINKS);
        }
        this.fResolverJob.schedule();
    }

    private void adaptItemHyperlink(Hyperlink link, final IWorkItem item, final IReference ref) {
        if (WorkItemQuickInformationEntry.isStateClosed(item)) {
            this.getQuickInformationPart().getClosedGroup().add(link);
        } else {
            this.getQuickInformationPart().getLinkGroup().add(link);
        }
        final URI uri = URIService.createAuditableURI((ITeamRepository)this.getWorkingCopy().getTeamRepository(), (IItemHandle)item);
        link.setHref((Object)uri);
        link.addHyperlinkListener(this.fURILinks);
        new TooltipSupport((Control)link, true, true){

            protected Object mapElement(int x, int y) {
                return item;
            }

            protected void openRequested(Object element) {
                Hyperlinks.openHyperlink((URI)uri);
            }
        };
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return item == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)item);
            }
        };
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LinkHelper.addSelectionActions(WorkItemQuickInformationEntry.this.getQuickInformationPart().getSite().getWorkbenchPage(), manager, new LinkHelper.InputSelectionProvider(WorkItemQuickInformationEntry.this.getWorkingCopy(), (ISelection)new StructuredSelection((Object)ref)));
            }
        });
        this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu((Control)link);
        link.setMenu(menu);
    }

    private boolean checkEndPoint(IEndPointDescriptor endPoint) {
        if (!WorkItemLinkTypes.isUserWritable((IEndPointDescriptor)endPoint)) {
            return false;
        }
        return endPoint.getReferencedItemType() == IWorkItem.ITEM_TYPE;
    }

    private void createItemContextMenu(Control control, final IEndPointDescriptor endPoint) {
        if (!this.checkEndPoint(endPoint)) {
            return;
        }
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LinkHelper.addSelectionActions(WorkItemQuickInformationEntry.this.getQuickInformationPart().getSite().getWorkbenchPage(), manager, new LinkHelper.InputSelectionProvider(WorkItemQuickInformationEntry.this.getWorkingCopy(), (ISelection)new StructuredSelection((Object)endPoint)));
            }
        });
        this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void addItemDropTarget(final Control control, final IEndPointDescriptor endPoint) {
        DropTarget target = new DropTarget(control, 7);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new LinksPart.LinkDropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                super.dragEnter(event);
                if (control instanceof Hyperlink && event.detail != 0) {
                    ((Hyperlink)control).setUnderlined(true);
                }
            }

            public void dragLeave(DropTargetEvent event) {
                super.dragLeave(event);
                if (control instanceof Hyperlink) {
                    ((Hyperlink)control).setUnderlined(false);
                }
            }

            protected IEndPointDescriptor getEndPoint(DropTargetEvent event) {
                return endPoint;
            }

            protected WorkItemWorkingCopy getWorkingCopy() {
                return WorkItemQuickInformationEntry.this.getWorkingCopy();
            }
        });
    }

    private static boolean isStateClosed(IWorkItem workitem) {
        IWorkflowInfo workflowInfo = WorkflowUtilities.findCachedWorkflowInfo((IWorkItem)workitem);
        if (workflowInfo != null) {
            return workflowInfo.getStateGroup(workitem.getState2()) == 2;
        }
        return false;
    }

    private void triggerUpdate() {
        boolean show = this.canShow();
        if (show != this.fShowState) {
            this.getQuickInformationPart().updateItems(true);
            this.fShowState = show;
        } else {
            this.getQuickInformationPart().updateItems(false);
        }
    }

    private class ResolveItemsJob
    extends UIUpdaterJob {
        public ResolveItemsJob(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInBackground(IProgressMonitor monitor) {
            if (WorkItemQuickInformationEntry.this.fLinkContentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            ArrayList<IWorkItemHandle> wiToResolve = new ArrayList<IWorkItemHandle>();
            Object[] objectArray = WorkItemQuickInformationEntry.this.fLinkContentProvider.getChildren(WorkItemQuickInformationEntry.this.fEndPoint);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IItemReference iref;
                Object o = objectArray[n2];
                if (o instanceof IReference && ((IReference)o).isItemReference() && (iref = (IItemReference)o).getReferencedItem() instanceof IWorkItemHandle) {
                    wiToResolve.add((IWorkItemHandle)iref.getReferencedItem());
                }
                ++n2;
            }
            List wiResolved = null;
            if (WorkItemQuickInformationEntry.this.getWorkingCopy() != null) {
                IAuditableClient auditableClient = (IAuditableClient)((ITeamRepository)WorkItemQuickInformationEntry.this.getWorkingCopy().getWorkItem().getOrigin()).getClientLibrary(IAuditableClient.class);
                try {
                    wiResolved = auditableClient.resolveAuditables(wiToResolve, IWorkItem.DEFAULT_PROFILE, monitor);
                }
                catch (TeamRepositoryException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.WorkItemQuickInformationEntry_ERROR_RESOLVING_WORKITEMS, e);
                }
            }
            Object object = WorkItemQuickInformationEntry.this.fWIIdLock;
            synchronized (object) {
                WorkItemQuickInformationEntry.this.fWorkItems = new HashMap();
                if (wiResolved != null) {
                    for (IWorkItem wi : wiResolved) {
                        if (wi == null) continue;
                        WorkItemQuickInformationEntry.this.fWorkItems.put(wi.getItemId(), wi);
                    }
                }
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (WorkItemQuickInformationEntry.this.fLinkContentProvider == null) {
                return Status.CANCEL_STATUS;
            }
            WorkItemQuickInformationEntry.this.triggerUpdate();
            return Status.OK_STATUS;
        }
    }

    private class WorkItemListener
    implements IWorkItemListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)WorkItemQuickInformationEntry.this.getWorkingCopy().getWorkItem())) {
                return;
            }
            if (event.affects("references")) {
                IEndPointDescriptor desc;
                if (WorkItemQuickInformationEntry.this.fEndPoint == null) {
                    WorkItemQuickInformationEntry.this.assignDescriptor();
                }
                if (WorkItemQuickInformationEntry.this.fEndPoint == null) {
                    return;
                }
                IAdaptable details = event.getAttributeChangeDetails("references");
                if (details == null) {
                    return;
                }
                ReferencesChangeDetails change = (ReferencesChangeDetails)details.getAdapter(ReferencesChangeDetails.class);
                if (change == null) {
                    return;
                }
                for (IReference ref : change.getAdded()) {
                    desc = WorkItemLinkTypes.getEndPointDescriptor((IReference)ref);
                    if (!desc.equals(WorkItemQuickInformationEntry.this.fEndPoint)) continue;
                    WorkItemQuickInformationEntry.this.updateWorkItems();
                    return;
                }
                for (IReference ref : change.getRemoved()) {
                    desc = WorkItemLinkTypes.getEndPointDescriptor((IReference)ref);
                    if (!desc.equals(WorkItemQuickInformationEntry.this.fEndPoint)) continue;
                    WorkItemQuickInformationEntry.this.triggerUpdate();
                    return;
                }
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class WorkItemToolTipSupport
    extends TooltipSupport {
        private List<IWorkItem> fReferences;
        private String fTitle;
        private int fCount;
        private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

        protected abstract WorkItemWorkingCopy getWorkingCopy();

        public WorkItemToolTipSupport(Control control, String title, int count, List<IWorkItem> references) {
            super(control, true, false);
            control.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    if (WorkItemToolTipSupport.this.fStandardLabelProvider != null) {
                        WorkItemToolTipSupport.this.fStandardLabelProvider.dispose();
                        WorkItemToolTipSupport.this.fStandardLabelProvider = null;
                    }
                }
            });
            this.fTitle = title;
            this.fCount = count;
            this.fReferences = references;
        }

        protected Object mapElement(int x, int y) {
            return this.fReferences;
        }

        private String[] splitId(String label) {
            String id = "";
            String name = label;
            int c = label.indexOf(58);
            if (c > 0) {
                id = label.substring(0, c);
                name = label.substring(c);
            }
            return new String[]{id, name};
        }

        protected String getMarkup(Object element, boolean isFocus) {
            StringBuffer result = new StringBuffer();
            result.append("<ul>");
            int closed = 0;
            for (IWorkItem r : this.fReferences) {
                String strikeStart = "";
                String strikeEnd = "";
                String fontStart = "";
                String fontEnd = "";
                if (WorkItemQuickInformationEntry.isStateClosed(r)) {
                    strikeStart = "<strike>";
                    strikeEnd = "</strike>";
                    fontStart = "<font color='darkgray'>";
                    fontEnd = "</font>";
                    ++closed;
                }
                String[] text = this.splitId(this.fStandardLabelProvider.getText((Object)r));
                text[1] = XMLString.createFromPlainText((String)text[1]).getXMLText();
                if (isFocus && this.getWorkingCopy() != null) {
                    String uri = URIService.createAuditableURI((ITeamRepository)((ITeamRepository)this.getWorkingCopy().getWorkItem().getOrigin()), (Object)r).toString();
                    result.append("<li><a href='" + uri + "'>" + fontStart + strikeStart + text[0] + strikeEnd + text[1] + fontEnd + "</a></li>");
                    continue;
                }
                result.append("<li>" + fontStart + strikeStart + text[0] + strikeEnd + text[1] + fontEnd + "</li>");
            }
            result.append("</ul>");
            StringBuffer title = new StringBuffer();
            String openClosed = ": " + this.fCount;
            if (closed == this.fCount && this.fCount != 0) {
                openClosed = String.valueOf(openClosed) + Messages.WorkItemQuickInformationEntry_ALL_COMPLETE;
            } else if (closed > 0) {
                openClosed = String.valueOf(openClosed) + NLS.bind((String)Messages.WorkItemQuickInformationEntry_SOME_COMPLETE, (Object)closed, (Object[])new Object[0]);
            }
            String unsaved = "";
            if (this.fReferences.size() != this.fCount) {
                unsaved = Messages.WorkItemQuickInformationEntry_SOME_CANNOT_BE_DISPLAYED;
            }
            title.append("<b>" + XMLString.createFromPlainText((String)this.fTitle).getXMLText() + openClosed + "</b>" + unsaved + "<br />");
            return String.valueOf(title.toString()) + result.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class WorkitemComparator
    implements Comparator<IWorkItem> {
        private WorkitemComparator() {
        }

        @Override
        public int compare(IWorkItem e1, IWorkItem e2) {
            return e1.getId() - e2.getId();
        }
    }
}

