/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.quickinformation;

import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.AbstractQuickInformationEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Hyperlink;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ItemizedQuickInformationEntry<T>
extends AbstractQuickInformationEntry<T> {
    public abstract List<T> getElements();

    public abstract String getShortIdentifier(T var1);

    public abstract void adaptElementLink(Hyperlink var1, T var2);

    public abstract void adaptLDotsLink(Hyperlink var1);

    public abstract String getTitle();

    public abstract Image getImage();

    public abstract void adaptTitleLink(Hyperlink var1, Label var2);

    public int getNumberOfItems() {
        List<T> elements = this.getElements();
        return elements != null ? elements.size() : 0;
    }

    public boolean showNumberOfItems() {
        return true;
    }

    public boolean showFirstNElements() {
        return true;
    }

    @Override
    public void createContent(Composite parent) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getQuickInformationPart().getSite().getToolkit();
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        Label label = toolkit.createLabel(parent, null);
        label.setImage(this.getImage());
        label.setBackground(null);
        int availableSpace = parent.getBounds().width - 12;
        availableSpace = availableSpace - label.computeSize((int)-1, (int)-1).x - 5;
        Composite links = toolkit.createComposite(parent);
        links.setBackground(null);
        RowLayout rl = new RowLayout();
        rl.marginLeft = 0;
        rl.marginRight = 0;
        rl.marginTop = 0;
        rl.marginBottom = 0;
        rl.spacing = 0;
        links.setLayout((Layout)rl);
        ArrayList<T> elements = new ArrayList<T>(this.getElements());
        String nOfItems = "";
        if (this.showNumberOfItems()) {
            nOfItems = " (" + this.getNumberOfItems() + ")";
        }
        Hyperlink link = toolkit.createCustomHyperlink(links, String.valueOf(this.getTitle()) + nOfItems + ":", 0);
        this.adaptTitleLink(link, label);
        Hyperlink lDots = null;
        boolean first = true;
        availableSpace -= link.computeSize((int)-1, (int)-1).x;
        int displayableArtifacts = 0;
        int index = 0;
        if (!this.showFirstNElements()) {
            int aSpace = availableSpace;
            Collections.reverse(elements);
            for (Object element : elements) {
                String linkText = this.getShortIdentifier(element);
                if (linkText == null || linkText.length() == 0 || (aSpace = aSpace - gc.stringExtent((String)linkText).x - 2 - gc.stringExtent((String)", ").x) - gc.stringExtent((String)linkText).x - gc.stringExtent((String)" ").x - gc.stringExtent((String)"...").x - gc.stringExtent((String)", ").x - 2 >= 0) continue;
                index = elements.size() - elements.indexOf(element) - 1;
                break;
            }
            Collections.reverse(elements);
            if (index > 0) {
                Label l = toolkit.createLabel(links, " ");
                l.setBackground(null);
                lDots = toolkit.createCustomHyperlink(links, "...", 0);
                this.adaptLDotsLink(lDots);
            }
        }
        for (Object element : elements) {
            Label l;
            String linkText;
            if (!this.showFirstNElements() && elements.indexOf(element) < index || (linkText = this.getShortIdentifier(element)) == null || linkText.length() == 0) continue;
            if (availableSpace - gc.stringExtent((String)linkText).x - gc.stringExtent((String)" ").x - gc.stringExtent((String)"...").x - gc.stringExtent((String)", ").x - 2 < 0) {
                if (!this.showFirstNElements()) break;
                l = toolkit.createLabel(links, " ");
                l.setBackground(null);
                lDots = toolkit.createCustomHyperlink(links, "...", 0);
                this.adaptLDotsLink(lDots);
                break;
            }
            ++displayableArtifacts;
            if (first) {
                first = false;
                l = toolkit.createLabel(links, " ");
                l.setBackground(null);
                availableSpace -= l.computeSize((int)-1, (int)-1).x;
            } else {
                l = toolkit.createLabel(links, ", ");
                l.setBackground(null);
                availableSpace -= l.computeSize((int)-1, (int)-1).x;
            }
            Hyperlink elementLink = toolkit.createCustomHyperlink(links, linkText, 0);
            this.adaptElementLink(elementLink, element);
            this.getQuickInformationPart().addInvalidDropTarget((Control)elementLink);
            availableSpace -= elementLink.computeSize((int)-1, (int)-1).x;
        }
        gc.dispose();
        if (displayableArtifacts == 0 && link.getText().lastIndexOf(58) > 0) {
            link.setText(link.getText().substring(0, link.getText().lastIndexOf(58)));
        }
    }

    protected static class ItemDragSupport
    extends DragSupport {
        private final IItemHandle fItem;

        public ItemDragSupport(Control control, IItemHandle item) {
            super(control);
            this.fItem = item;
        }

        protected boolean validateSelection(ISelection selection) {
            if (super.validateSelection(selection)) {
                IStructuredSelection structured = (IStructuredSelection)selection;
                Object[] objectArray = structured.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    if (!(element instanceof IItemHandle)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            return false;
        }

        public ISelection getSelection() {
            return new StructuredSelection((Object)this.fItem);
        }
    }
}

