/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.quickinformation;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.ApprovalsTab;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.part.ApprovalsPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.SubscriberUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.AbstractQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.Messages;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApprovalQuickInformationEntry
extends AbstractQuickInformationEntry<IApprovals> {
    private HashMap<UUID, IContributor> fApprovers = new HashMap();
    private ApprovalsJob fApprovalsJob;
    private final Object fALock = new Object();
    private int fSize = -1;
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private boolean fDisposed = false;

    @Override
    public void init() {
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.APPROVALS_PROPERTY);
            this.getQuickInformationPart().getUIListener().addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY);
        }
        if (this.canShow()) {
            this.updateApprovals();
        }
    }

    @Override
    public boolean canShow() {
        return this.getWorkingCopy().getWorkItem().getApprovals() != null && this.getWorkingCopy().getWorkItem().getApprovals().getDescriptors().size() > 0;
    }

    @Override
    public void shown(boolean reflow) {
        if (reflow) {
            this.fSize = this.getWorkingCopy().getWorkItem().getApprovals().getDescriptors().size();
        }
    }

    @Override
    public void createContent(Composite parent) {
        GC gc = new GC((Drawable)parent);
        gc.setFont(parent.getFont());
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getQuickInformationPart().getSite().getToolkit();
        IApprovals app = this.getWorkingCopy().getWorkItem().getApprovals();
        for (IApprovalDescriptor desc : app.getDescriptors()) {
            Label label = toolkit.createLabel(parent, null);
            label.setImage(this.getQuickInformationPart().getResourceManager().createImage(ImageDescriptor.createFromURL((URL)WorkItemApprovals.getType((String)desc.getTypeIdentifier()).getIconURL())));
            label.setBackground(null);
            Composite links = toolkit.createComposite(parent);
            links.setBackground(null);
            RowLayout rl = new RowLayout();
            rl.marginLeft = 0;
            rl.marginTop = 0;
            rl.marginBottom = 0;
            rl.spacing = 0;
            links.setLayout((Layout)rl);
            Hyperlink link = toolkit.createCustomHyperlink(links, String.valueOf(desc.getName()) + ":", 0);
            new ApprovalToolTipSupport((Control)link, desc);
            new ApprovalToolTipSupport((Control)label, desc);
            this.createApprovalContextMenui((Control)link, desc);
            this.createApprovalContextMenui((Control)label, desc);
            this.addApprovalDropTarget((Control)link, desc);
            this.addApprovalDropTarget((Control)label, desc);
            this.getQuickInformationPart().getLinkGroup().add(link);
            IHyperlinkListener hyperlinkListener = this.getQuickInformationPart().getPartActivator(this.getConfigurationEntry().getProperty("linkTarget"));
            if (hyperlinkListener != null) {
                link.addHyperlinkListener(hyperlinkListener);
            }
            int relevant = 0;
            IApprovalState cum = app.getCumulativeState(desc);
            IApprovalDescriptor currentUser = null;
            for (IApproval a : app.getContents(desc)) {
                if (a.getApprover().sameItemId((IItemHandle)this.getWorkingCopy().getTeamRepository().loggedInContributor())) {
                    currentUser = a;
                }
                if (!a.getStateIdentifier().equals(cum.getIdentifier())) continue;
                ++relevant;
            }
            final IApprovalDescriptor selection = currentUser != null ? currentUser : desc;
            Label l = toolkit.createLabel(links, " ");
            l.setBackground(null);
            Hyperlink descriptor = toolkit.createCustomHyperlink(links, NLS.bind((String)Messages.ApprovalQuickInformationEntry_CUMULATIVE_STATE_NUMBERS, (Object)cum.getDisplayName(), (Object[])new Object[]{relevant, app.getContents(desc).size()}), 0);
            this.getQuickInformationPart().getLinkGroup().add(descriptor);
            descriptor.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    IEditorPart part = ApprovalQuickInformationEntry.this.getQuickInformationPart().getSite().getWorkbenchPage().getActiveEditor();
                    if (part instanceof WorkItemEditor) {
                        WorkItemEditor editor = (WorkItemEditor)part;
                        ApprovalsTab approvals = null;
                        for (Object page : editor.getPages()) {
                            if (!(page instanceof ApprovalsTab)) continue;
                            approvals = (ApprovalsTab)((Object)page);
                            break;
                        }
                        if (approvals != null) {
                            editor.setActivePage(approvals.getId());
                            approvals.setApprovalSelection(selection);
                        }
                    }
                }
            });
            new ApprovalToolTipSupport((Control)descriptor, desc);
            this.createSetApprovalValueContextMenu((Control)descriptor, desc);
            this.getQuickInformationPart().addInvalidDropTarget((Control)descriptor);
            int availableSpace = parent.getBounds().width - 12 - 2 - label.computeSize((int)-1, (int)-1).x - 5 - l.computeSize((int)-1, (int)-1).x - descriptor.computeSize((int)-1, (int)-1).x - 1;
            int currentLinkLength = gc.stringExtent((String)link.getText()).x;
            String text = link.getText();
            if (currentLinkLength <= availableSpace || text.length() <= 1) continue;
            text = String.valueOf(text.substring(0, text.length() - 1)) + "...:";
            while (text.length() > 5 && gc.stringExtent((String)text).x > availableSpace) {
                text = String.valueOf(text.substring(0, text.length() - 5)) + "...:";
            }
            link.setText(text);
        }
        gc.dispose();
    }

    private void updateApprovals() {
        if (this.fApprovalsJob == null) {
            this.fApprovalsJob = new ApprovalsJob(Messages.ApprovalQuickInformationEntry_RESOLVING_SUBSCRIBERS);
        }
        this.fApprovalsJob.schedule();
    }

    private void createSetApprovalValueContextMenu(Control control, final IApprovalDescriptor desc) {
        IApproval approval = null;
        for (IApproval app : this.getWorkingCopy().getWorkItem().getApprovals().getContents(desc)) {
            if (!app.getApprover().sameItemId((IItemHandle)this.getWorkingCopy().getTeamRepository().loggedInContributor())) continue;
            approval = app;
            break;
        }
        if (approval == null) {
            return;
        }
        final IApproval fapp = approval;
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (final IApprovalState state : WorkItemApprovals.getStates()) {
                    if (!state.getIdentifier().equals(WorkItemApprovals.PENDING_STATE.getIdentifier())) {
                        if (fapp.getStateIdentifier().equals(state.getIdentifier())) continue;
                        manager.add((IAction)new Action(String.valueOf(Messages.ApprovalQuickInformationEntry_SET) + state.getDisplayName()){

                            public void run() {
                                fapp.setStateIdentifier(state.getIdentifier());
                            }
                        });
                        continue;
                    }
                    if (fapp.getStateIdentifier().equals(state.getIdentifier())) continue;
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new Action(String.valueOf(Messages.ApprovalQuickInformationEntry_RESET) + WorkItemApprovals.getType((String)desc.getTypeIdentifier()).getDisplayName()){

                        public void run() {
                            fapp.setStateIdentifier(state.getIdentifier());
                        }
                    });
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void createApprovalContextMenui(Control control, final IApprovalDescriptor desc) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        Action editApprovalAction = new Action(Messages.ApprovalQuickInformationEntry_EDIT_APPROVAL){

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromURL((URL)WorkItemApprovals.getType((String)desc.getTypeIdentifier()).getIconURL());
            }

            public void run() {
                ArrayList descriptors = new ArrayList(ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals().getDescriptors());
                descriptors.remove(desc);
                ApprovalsPart.NewApprovalDescriptorDialog dialog = new ApprovalsPart.NewApprovalDescriptorDialog(Display.getCurrent().getActiveShell(), null, true);
                dialog.setType(WorkItemApprovals.getType((String)desc.getTypeIdentifier()));
                dialog.setName(desc.getName());
                dialog.setDueDate(desc.getDueDate());
                if (dialog.open() != 0) {
                    return;
                }
                desc.setTypeIdentifier(dialog.getType().getIdentifier());
                desc.setName(dialog.getName());
                desc.setDueDate(dialog.getDueDate());
                if (dialog.isAddApprover()) {
                    ArrayList<IContributorHandle> approvers = new ArrayList<IContributorHandle>();
                    List contents = ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals().getContents(desc);
                    for (IApproval approval : contents) {
                        approvers.add(approval.getApprover());
                    }
                    TeamContributorSelectionDialog tc = new TeamContributorSelectionDialog(Display.getCurrent().getActiveShell(), ApprovalQuickInformationEntry.this.getWorkingCopy().getTeamRepository(), approvers, true);
                    tc.setTitle(Messages.ApprovalQuickInformationEntry_ADD_APPROVERS);
                    tc.setShellTitle(Messages.ApprovalQuickInformationEntry_ADD_APPROVERS);
                    tc.setMessage(Messages.ApprovalQuickInformationEntry_SELECT_APPROVERS_MESSAGE);
                    if (tc.open() == 0) {
                        IWorkItemClient workItemClient = (IWorkItemClient)ApprovalQuickInformationEntry.this.getWorkingCopy().getTeamRepository().getClientLibrary(IWorkItemClient.class);
                        try {
                            workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem());
                            IContributorHandle[] iContributorHandleArray = tc.getContributorResult();
                            int n = iContributorHandleArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IContributorHandle contributor = iContributorHandleArray[n2];
                                ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals().add(ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals().createApproval(desc, contributor));
                                ++n2;
                            }
                        }
                        finally {
                            workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem());
                        }
                    }
                }
            }
        };
        Action addApprovalAction = new Action(Messages.ApprovalQuickInformationEntry_ADD){

            public ImageDescriptor getImageDescriptor() {
                return ImagePool.USER;
            }

            public void run() {
                ArrayList<IContributorHandle> filtered = new ArrayList<IContributorHandle>();
                for (IApproval app : ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals().getContents(desc)) {
                    filtered.add(app.getApprover());
                }
                TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(Display.getCurrent().getActiveShell(), ApprovalQuickInformationEntry.this.getWorkingCopy().getTeamRepository(), filtered, true);
                dialog.setTitle(Messages.ApprovalQuickInformationEntry_ADD_APPROVERS);
                dialog.setShellTitle(Messages.ApprovalQuickInformationEntry_ADD_APPROVERS);
                dialog.setMessage(Messages.ApprovalQuickInformationEntry_SELECT_APPROVERS_MESSAGE);
                if (dialog.open() == 0) {
                    IWorkItemClient workItemClient = (IWorkItemClient)ApprovalQuickInformationEntry.this.getWorkingCopy().getTeamRepository().getClientLibrary(IWorkItemClient.class);
                    try {
                        workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem());
                        IContributorHandle[] iContributorHandleArray = dialog.getContributorResult();
                        int n = iContributorHandleArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContributorHandle contributor = iContributorHandleArray[n2];
                            ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals().add(ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals().createApproval(desc, contributor));
                            ++n2;
                        }
                    }
                    finally {
                        workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem());
                    }
                }
            }
        };
        Action removeApprovalDescriptorAction = new Action(Messages.ApprovalQuickInformationEntry_REMOVE_APPROVAL){

            public ImageDescriptor getImageDescriptor() {
                return ImagePool.REMOVE;
            }

            public void run() {
                ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals().remove(desc);
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)addApprovalAction, (IAction)editApprovalAction, (IAction)removeApprovalDescriptorAction){
            private final /* synthetic */ IAction val$addApprovalAction;
            private final /* synthetic */ IAction val$editApprovalAction;
            private final /* synthetic */ IAction val$removeApprovalDescriptorAction;
            {
                this.val$addApprovalAction = iAction;
                this.val$editApprovalAction = iAction2;
                this.val$removeApprovalDescriptorAction = iAction3;
            }

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(this.val$addApprovalAction);
                manager.add(this.val$editApprovalAction);
                manager.add(this.val$removeApprovalDescriptorAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getQuickInformationPart().getSite().registerContextMenu(this.getQuickInformationPart().getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void addApprovalDropTarget(final Control control, final IApprovalDescriptor desc) {
        DropTarget target = new DropTarget(control, 5);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new SubscriberUtil.SubscriberDropListener(){

            @Override
            public void dragEnter(DropTargetEvent event) {
                super.dragEnter(event);
                if (control instanceof Hyperlink && event.detail != 0) {
                    ((Hyperlink)control).setUnderlined(true);
                }
            }

            @Override
            public void drop(DropTargetEvent event) {
                ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
                if (selection instanceof IStructuredSelection) {
                    IApprovals approvals = ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals();
                    ArrayList<IApproval> existing = new ArrayList<IApproval>(approvals.getContents(desc));
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    ArrayList<IItemHandle> itemList = new ArrayList<IItemHandle>();
                    for (Object e : ss.toList()) {
                        if ((e = LinkHelper.convertURIReferenceToItemHandle(e, this.getWorkingCopy().getTeamRepository())) instanceof IItemHandle) {
                            itemList.add((IItemHandle)e);
                            continue;
                        }
                        if (!(e instanceof IReference) || !((IReference)e).isItemReference()) continue;
                        itemList.add(((IItemReference)e).getReferencedItem());
                    }
                    for (IItemHandle handle : itemList) {
                        if (handle instanceof IContributorHandle) {
                            this.addApprover((IContributorHandle)handle, existing, approvals);
                            continue;
                        }
                        if (!(handle instanceof ITeamArea)) continue;
                        IContributorHandle[] iContributorHandleArray = ((ITeamArea)handle).getMembers();
                        int n = iContributorHandleArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IContributorHandle subs = iContributorHandleArray[n2];
                            this.addApprover(subs, existing, approvals);
                            ++n2;
                        }
                    }
                }
            }

            private void addApprover(IContributorHandle approver, List<IApproval> existing, IApprovals approvals) {
                boolean found = false;
                for (IApproval approval : existing) {
                    if (!approval.getApprover().sameItemId((IItemHandle)approver)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    IApproval approval;
                    approval = approvals.createApproval(desc, approver);
                    approvals.add(approval);
                    existing.add(approval);
                }
            }

            public void dragLeave(DropTargetEvent event) {
                super.dragLeave(event);
                if (control instanceof Hyperlink) {
                    ((Hyperlink)control).setUnderlined(false);
                }
            }

            @Override
            protected WorkItemWorkingCopy getWorkingCopy() {
                return ApprovalQuickInformationEntry.this.getWorkingCopy();
            }
        });
    }

    @Override
    public void dispose() {
        this.fDisposed = true;
        if (this.fApprovalsJob != null) {
            this.fApprovalsJob.cancel();
        }
        if (this.getQuickInformationPart().getUIListener() != null) {
            this.getQuickInformationPart().getUIListener().removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.APPROVALS_PROPERTY);
            this.getQuickInformationPart().getUIListener().removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY);
        }
    }

    private void triggerUpdate() {
        int size = -1;
        if (this.getWorkingCopy().getWorkItem().getApprovals() != null) {
            size = this.getWorkingCopy().getWorkItem().getApprovals().getDescriptors().size();
        }
        if (this.fSize != size) {
            this.getQuickInformationPart().updateItems(true);
            this.fSize = size;
        } else {
            this.getQuickInformationPart().updateItems(false);
        }
    }

    private boolean updateNeeded() {
        for (IApproval a : this.getWorkingCopy().getWorkItem().getApprovals().getContents()) {
            if (this.fApprovers.containsKey(a.getApprover().getItemId())) continue;
            return true;
        }
        return false;
    }

    private class ApprovalToolTipSupport
    extends TooltipSupport {
        private IApprovalDescriptor fDesc;

        public ApprovalToolTipSupport(Control control, IApprovalDescriptor descriptor) {
            super(control, true, true);
            this.fDesc = descriptor;
        }

        protected Object mapElement(int x, int y) {
            return this.fDesc;
        }

        protected void openRequested(Object element) {
            IHyperlinkListener hyperlinkListener = ApprovalQuickInformationEntry.this.getQuickInformationPart().getPartActivator(ApprovalQuickInformationEntry.this.getConfigurationEntry().getProperty("linkTarget"));
            hyperlinkListener.linkActivated(null);
        }

        protected String getMarkup(Object element, boolean isFocus) {
            StringBuffer result = new StringBuffer();
            IApprovals app = ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals();
            HashMap stateToApprovers = new HashMap();
            IApproval currentUser = null;
            for (IApproval a : app.getContents(this.fDesc)) {
                if (stateToApprovers.get(WorkItemApprovals.getState((String)a.getStateIdentifier())) == null) {
                    stateToApprovers.put(WorkItemApprovals.getState((String)a.getStateIdentifier()), new ArrayList());
                }
                ((List)stateToApprovers.get(WorkItemApprovals.getState((String)a.getStateIdentifier()))).add(a.getApprover());
                if (!a.getApprover().sameItemId((IItemHandle)ApprovalQuickInformationEntry.this.getWorkingCopy().getTeamRepository().loggedInContributor())) continue;
                currentUser = a;
            }
            String stateName = WorkItemApprovals.getState((String)this.fDesc.getCumulativeStateIdentifier()).getDisplayName();
            result.append(NLS.bind((String)"<b>{0}</b><br >{1}<b>{2}</b>", (Object)XMLString.createFromPlainText((String)this.fDesc.getName()).getXMLText(), (Object[])new Object[]{XMLString.createFromPlainText((String)Messages.ApprovalQuickInformationEntry_CUMULATIVE_STATE).getXMLText(), XMLString.createFromPlainText((String)stateName).getXMLText()}));
            if (currentUser != null) {
                result.append(NLS.bind((String)"<br >{0}<b>{1}</b>", (Object)XMLString.createFromPlainText((String)Messages.ApprovalQuickInformationEntry_YOUR_STATE).getXMLText(), (Object[])new Object[]{XMLString.createFromPlainText((String)WorkItemApprovals.getState((String)currentUser.getStateIdentifier()).getDisplayName()).getXMLText()}));
            }
            if (isFocus && ApprovalQuickInformationEntry.this.getWorkingCopy() != null) {
                result.append("<ul>");
                for (IApprovalState state : WorkItemApprovals.getStates()) {
                    if (stateToApprovers.get(state) == null) {
                        stateToApprovers.put(state, new ArrayList());
                    }
                    result.append(NLS.bind((String)"{0}: {1}", (Object)XMLString.createFromPlainText((String)state.getDisplayName()).getXMLText(), (Object[])new Object[]{((List)stateToApprovers.get(state)).size()}));
                    result.append("<ul>");
                    for (IContributorHandle handle : (List)stateToApprovers.get(state)) {
                        String name = Messages.ApprovalQuickInformationEntry_ERROR_RETRIEVING_NAME;
                        if (ApprovalQuickInformationEntry.this.fApprovers.get(handle.getItemId()) == null) continue;
                        String uri = URIService.createAuditableURI((ITeamRepository)((ITeamRepository)ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getOrigin()), (IItemHandle)((IItemHandle)ApprovalQuickInformationEntry.this.fApprovers.get(handle.getItemId()))).toString();
                        name = ((IContributor)ApprovalQuickInformationEntry.this.fApprovers.get(handle.getItemId())).getName();
                        if (((IContributor)ApprovalQuickInformationEntry.this.fApprovers.get(handle.getItemId())).isArchived()) {
                            name = String.valueOf(name) + Messages.ApprovalQuickInformationEntry_ARCHIVED;
                        }
                        name = XMLString.createFromPlainText((String)name).getXMLText();
                        result.append("<li><a href='" + uri + "'>" + name + "</a></li>");
                    }
                    result.append("</ul>");
                    result.append("<br />");
                }
                result.append("</ul>");
            } else {
                result.append("<ul>");
                for (IApprovalState state : WorkItemApprovals.getStates()) {
                    if (stateToApprovers.get(state) == null) {
                        stateToApprovers.put(state, new ArrayList());
                    }
                    result.append(NLS.bind((String)"<li>{0} {1}</li>", (Object)((List)stateToApprovers.get(state)).size(), (Object[])new Object[]{XMLString.createFromPlainText((String)state.getDisplayName()).getXMLText()}));
                }
                result.append("</ul>");
            }
            return result.toString();
        }
    }

    private class ApprovalsJob
    extends UIUpdaterJob {
        public ApprovalsJob(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInBackground(IProgressMonitor monitor) {
            if (ApprovalQuickInformationEntry.this.getWorkingCopy() != null) {
                IAuditableClient auditableClient = (IAuditableClient)((ITeamRepository)ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getOrigin()).getClientLibrary(IAuditableClient.class);
                try {
                    ArrayList<IContributorHandle> toResolve = new ArrayList<IContributorHandle>();
                    for (IApproval a : ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem().getApprovals().getContents()) {
                        toResolve.add(a.getApprover());
                    }
                    List resolved = auditableClient.resolveAuditables(toResolve, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                    Object object = ApprovalQuickInformationEntry.this.fALock;
                    synchronized (object) {
                        ApprovalQuickInformationEntry.this.fApprovers = new HashMap();
                        for (IContributor contrib : resolved) {
                            if (contrib == null) continue;
                            ApprovalQuickInformationEntry.this.fApprovers.put(contrib.getItemId(), contrib);
                        }
                    }
                }
                catch (TeamRepositoryException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.ApprovalQuickInformationEntry_ERROR_RESOLVING_SUBSCRIBERS, e);
                }
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (ApprovalQuickInformationEntry.this.fDisposed) {
                return Status.CANCEL_STATUS;
            }
            ApprovalQuickInformationEntry.this.triggerUpdate();
            return Status.OK_STATUS;
        }
    }

    private class WorkItemListener
    implements IWorkItemListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)ApprovalQuickInformationEntry.this.getWorkingCopy().getWorkItem())) {
                return;
            }
            if (event.affects(IWorkItem.APPROVALS_PROPERTY)) {
                if (ApprovalQuickInformationEntry.this.updateNeeded()) {
                    ApprovalQuickInformationEntry.this.updateApprovals();
                } else {
                    ApprovalQuickInformationEntry.this.triggerUpdate();
                }
            }
            if (event.affects(IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY)) {
                ApprovalQuickInformationEntry.this.triggerUpdate();
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

