/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler;

import com.ibm.team.workitem.client.WorkItemEvent;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.EditorPresentationHandler;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationContext;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandler;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerRegistry;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationUpdaterContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class PresentationHandlerManager {
    private List<PresentationUpdaterContext> fPresentationContexts = Collections.synchronizedList(new ArrayList());
    private PresentationHandlerRegistry fRegistry;

    public PresentationHandlerManager(IPresentationContext context) {
        this.fRegistry = PresentationHandlerRegistry.createInstance(context);
    }

    private void processEvent(PresentationUpdaterContext updater, WorkItemEvent event) {
        ArrayList<PresentationHandler> handlers = new ArrayList<PresentationHandler>();
        Map properties = updater.getPresentationDescriptor().getProperties();
        if (properties != null) {
            for (String key : properties.keySet()) {
                PresentationHandler handler = this.fRegistry.getHandler(event.getKind(), key);
                if (handler == null) continue;
                handlers.add(handler);
            }
        }
        for (PresentationHandler handler : handlers) {
            handler.handle(updater, event);
        }
    }

    public void presentationEvent(WorkItemEvent event) {
        for (EditorPresentationHandler editorHandler : this.fRegistry.getEditorHandlers(event.getKind())) {
            editorHandler.handle(this.fPresentationContexts, event);
        }
        for (PresentationUpdaterContext context : this.fPresentationContexts) {
            this.processEvent(context, event);
        }
    }

    public void addPresentationUpdater(IPresentationUpdater updater, PresentationDescriptor desc) {
        PresentationUpdaterContext context = new PresentationUpdaterContext(updater, desc);
        this.fPresentationContexts.add(context);
        WorkItemEvent init = new WorkItemEvent(){

            public WorkItemEvent.EventKind getKind() {
                return WorkItemEvent.EventKind.INITIALIZATION;
            }
        };
        for (EditorPresentationHandler editorHandler : this.fRegistry.getEditorHandlers(WorkItemEvent.EventKind.INITIALIZATION)) {
            editorHandler.handle(Collections.singletonList(context), init);
        }
        this.processEvent(context, init);
    }

    public void removePresentationUpdater(IPresentationUpdater updater) {
        PresentationUpdaterContext c = null;
        for (PresentationUpdaterContext context : this.fPresentationContexts) {
            if (!context.equalsUpdater(updater)) continue;
            c = context;
            break;
        }
        if (c != null) {
            this.fPresentationContexts.remove(c);
        }
    }
}

