/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.jface.calendar.DatePicker;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormConfiguration;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.internal.util.Daystamp;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TimestampAttributePart
extends AttributePart {
    private static final String NONE = Messages.TimestampAttributePart_NONE;
    private WorkItemWorkingCopy fWorkingCopy;
    private RequiredPropertyLabel fAttributeName;
    private DecoratedFormsText fAttributeContent;
    private Text fReadOnlyContent;
    private DateFormat fDateTimeFormat = DateFormat.getDateTimeInstance((int)2, (int)3);
    private DateFormat fDateFormat = DateFormat.getDateInstance((int)2);
    private Daystamp fDaystamp = new Daystamp(2);
    private IAttribute fContributorAttribute;
    private StandardControlLabelProvider fROLabeledHyperlink;
    private Label fNoContributorLabel;
    private Composite fContainer;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (TimestampAttributePart.this.fAttributeName != null && !TimestampAttributePart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(TimestampAttributePart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(TimestampAttributePart.this.fAttributeName.getLayoutControl());
            }
            if (TimestampAttributePart.this.fContainer != null && !TimestampAttributePart.this.fContainer.isDisposed()) {
                TeamFormUtil.setVisible((Control)TimestampAttributePart.this.fContainer, visible);
                changedControls.add(TimestampAttributePart.this.fContainer);
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        public void setRequired(boolean required) {
            if (TimestampAttributePart.this.fAttributeName != null && !TimestampAttributePart.this.fAttributeName.isDisposed()) {
                TimestampAttributePart.this.fAttributeName.setRequired(required);
            }
        }

        public void setStatus(IStatus status) {
            if (TimestampAttributePart.this.fAttributeContent != null && !TimestampAttributePart.this.fAttributeContent.getLayoutControl().isDisposed()) {
                TimestampAttributePart.this.fAttributeContent.setStatus(status);
            }
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            if (TimestampAttributePart.this.fContainer != null && !TimestampAttributePart.this.fContainer.isDisposed()) {
                TimestampAttributePart.this.handleDateChanged();
            }
        }
    };
    private IPresentationUpdater fContributorUpdater = new AbstractPresentationUpdater(){

        public void attributeChanged(WorkItemChangeEvent event) {
            TimestampAttributePart.this.setContributor();
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        this.fContainer = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
        if (this.isReadOnly()) {
            TeamFormLayouts.setLayoutData((Control)this.fContainer, (ITeamFormData)ITeamFormData.SINGLE_LINE_READONLY_TEXT);
            Util.addWidthHint((Control)this.fContainer);
            formLayout.add((Control)this.fContainer, "content");
            this.fContainer.setLayout((Layout)new GridLayout(2, false));
            ((GridLayout)this.fContainer.getLayout()).marginWidth = 0;
            ((GridLayout)this.fContainer.getLayout()).marginHeight = 0;
            Composite content = toolkit.createComposite(this.fContainer, 0, this.getBackgroundStyle());
            GridLayout layout = new GridLayout(4, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 0;
            content.setLayout((Layout)layout);
            content.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
            this.fReadOnlyContent = toolkit.createReadOnlyText(content, "", 0, this.getBackgroundStyle());
            this.initAccessible((Control)this.fReadOnlyContent);
            GridData data = this.showContributor() ? new GridData(16384, 4, false, false, 1, 1) : new GridData(4, 4, true, false, 4, 1);
            this.fReadOnlyContent.setLayoutData((Object)data);
            if (this.showContributor()) {
                Label l = toolkit.createLabel(content, Messages.TimestampAttributePart_DATE_CONTRIBUTOR_SEPARATOR, 0, this.getBackgroundStyle());
                l.setLayoutData((Object)new GridData(16384, 1024, false, false));
                this.fROLabeledHyperlink = toolkit.createDecoratedHyperlink((TeamFormPart)this, content, null, this.getBackgroundStyle());
                this.fROLabeledHyperlink.setLabelProvider((IViewerLabelProvider)new StandardLabelProvider((ILabelProvider)new LabelProvider(), (IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
                data = new GridData(16384, 4, false, false);
                data.horizontalIndent = 3;
                data.widthHint = 0;
                this.fROLabeledHyperlink.getControl().setLayoutData((Object)data);
                this.fNoContributorLabel = toolkit.createLabel(content, Messages.TimestampAttributePart_NONE, 0, this.getBackgroundStyle());
                data = new GridData(16384, 0x1000000, false, false);
                data.horizontalIndent = 1;
                this.fNoContributorLabel.setLayoutData((Object)data);
            }
        } else {
            ITeamFormLayout innerLayout = TeamFormLayouts.createLayout((Composite)this.fContainer, (ITeamFormConfiguration)ITeamFormConfiguration.EMPTY_CONFIGURATION);
            this.fAttributeContent = new DecoratedFormsText(this.fContainer, this.getSite(), 0, 0, this.getBackgroundStyle());
            this.initAccessible((Control)this.fAttributeContent.getText());
            ITeamFormData layoutData = TeamFormLayouts.getLayoutData((Control)this.fAttributeContent.getLayoutControl()).maxVertOffset(ITeamFormData.BUTTON);
            TeamFormLayouts.setLayoutData((Control)this.fContainer, (ITeamFormData)layoutData);
            Util.addNarrowWidthHint((Control)this.fContainer);
            formLayout.add((Control)this.fContainer, "content");
            innerLayout.add(this.fAttributeContent.getLayoutControl(), "text");
            this.fAttributeContent.getText().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    TimestampAttributePart.this.handleDateTextChanged();
                }
            });
            this.fAttributeContent.getText().addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    try {
                        TimestampAttributePart.this.writeDate();
                    }
                    catch (ParseException parseException) {
                        TimestampAttributePart.this.fAttributeContent.getText().setText(NONE);
                    }
                    TimestampAttributePart.this.handleDateTextChanged();
                }
            });
            LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fAttributeContent.getText());
            final ToolBar toolBar = new ToolBar(this.fContainer, 0x800000);
            this.initAccessible((Control)toolBar, Messages.TimestampAttributePart_PICK_DATE);
            innerLayout.add((Control)toolBar, "button", ITeamFormData.BUTTON);
            toolkit.adapt((Composite)toolBar, this.getBackgroundStyle());
            final ToolItem calendarButton = new ToolItem(toolBar, 8);
            calendarButton.setToolTipText(Messages.TimestampAttributePart_PICK_DATE);
            Image image = JazzResources.getImageWithDefault((ResourceManager)resourceManager, (ImageDescriptor)ImagePool.DATE);
            calendarButton.setImage(image);
            calendarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    calendarButton.setEnabled(false);
                    Rectangle rect = calendarButton.getBounds();
                    Point pt = new Point(rect.x, rect.y + rect.height);
                    pt = toolBar.toDisplay(pt);
                    Shell shell = TimestampAttributePart.this.getSite().getWorkbenchPage().getWorkbenchWindow().getShell();
                    DatePicker picker = new DatePicker(shell, 2);
                    Point loc = new Point(pt.x, pt.y);
                    if (shell != null) {
                        int sizeY;
                        int sizeX;
                        Rectangle sB = shell.getBounds();
                        Rectangle dB = shell.getMonitor().getBounds();
                        int maxX = Math.min(sB.x + sB.width, dB.x + dB.width) - 3;
                        int maxY = Math.min(sB.y + sB.height, dB.y + dB.height) - 3;
                        int n = sizeX = "gtk".equals(SWT.getPlatform()) ? 312 : 200;
                        int n2 = "gtk".equals(SWT.getPlatform()) ? 230 : (sizeY = "carbon".equals(SWT.getPlatform()) ? 150 : 200);
                        if (pt.x > maxX - sizeX) {
                            loc.x = maxX - sizeX;
                        }
                        if (pt.y > maxY - sizeY) {
                            loc.y = maxY - sizeY;
                            loc.x = loc.x + 32 > maxX - sizeX ? pt.x - sizeX : (loc.x += 32);
                        }
                    }
                    picker.setLocation(loc.x, loc.y);
                    try {
                        picker.setDate(TimestampAttributePart.this.fDateFormat.parse(TimestampAttributePart.this.fAttributeContent.getText().getText()));
                    }
                    catch (ParseException parseException) {}
                    picker.open();
                    Date date = picker.getDateObject();
                    if (date != null) {
                        TimestampAttributePart.this.fAttributeContent.getText().setText(TimestampAttributePart.this.fDateFormat.format(date));
                        TimestampAttributePart.this.fAttributeContent.getText().setFocus();
                        try {
                            TimestampAttributePart.this.writeDate();
                        }
                        catch (ParseException parseException) {
                            TimestampAttributePart.this.fAttributeContent.getText().setText(NONE);
                        }
                        TimestampAttributePart.this.handleDateTextChanged();
                    }
                    calendarButton.setEnabled(true);
                }
            });
        }
    }

    private void layoutDateAndContributor() {
        if (!this.showContributor()) {
            return;
        }
        this.fReadOnlyContent.getParent().layout();
    }

    private void handleDateTextChanged() {
        if (this.fWorkingCopy != null && !this.fWorkingCopy.isDirty()) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            this.fDaystamp.setStoredTimestamp((Timestamp)workItem.getValue(this.getAttribute()));
            String string = this.fDaystamp.getText();
            if (!this.fAttributeContent.getText().getText().equals(string)) {
                ((WorkItemWorkingCopyImpl)this.fWorkingCopy).setDirty(true);
            }
        }
        if (!this.isReadOnly() && this.fAttributeContent != null && !this.fAttributeContent.getText().isDisposed()) {
            Daystamp stamp = new Daystamp(2);
            String string = this.fAttributeContent.getText().getText().trim();
            stamp.setText(string);
            if (stamp.getTimestamp() == null && !NONE.equals(string) && !"".equals(string)) {
                this.fAttributeContent.setStatus((IStatus)new Status(2, "com.ibm.team.workitem.ide.ui", Messages.LongAttributePart_VALUE_NOT_VALID));
            } else {
                this.fAttributeContent.setStatus(Status.OK_STATUS);
            }
        }
    }

    private void handleDateChanged() {
        if (this.fWorkingCopy == null) {
            return;
        }
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
        if (this.isReadOnly()) {
            String string = this.getReadOnlyDateString((Timestamp)workItem.getValue(this.getAttribute()));
            if (!this.fReadOnlyContent.getText().equals(string)) {
                this.fReadOnlyContent.setText(string);
                if (this.showContributor()) {
                    this.fReadOnlyContent.setToolTipText(this.getFullDateTime((Timestamp)workItem.getValue(this.getAttribute())));
                    this.layoutDateAndContributor();
                }
            }
        } else {
            this.fDaystamp.setStoredTimestamp((Timestamp)workItem.getValue(this.getAttribute()));
            String string = this.fDaystamp.getText();
            if (!this.fAttributeContent.getText().getText().equals(string)) {
                this.fAttributeContent.getText().setText(string);
            }
        }
    }

    private String getFullDateTime(Date date) {
        if (date == null) {
            return NONE;
        }
        return this.fDateTimeFormat.format(date);
    }

    private String getReadOnlyDateString(Date date) {
        if (date == null) {
            return NONE;
        }
        if (this.showContributor()) {
            return this.fDateFormat.format(date);
        }
        return this.fDateTimeFormat.format(date);
    }

    private void writeDate() throws ParseException {
        this.fDaystamp.setText(this.fAttributeContent.getText().getText().trim());
        Timestamp value = this.fDaystamp.getTimestamp();
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
        if (this.fWorkingCopy != null && !this.equal(workItem.getValue(this.getAttribute()), value)) {
            this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), (Object)value);
        }
    }

    private boolean equal(Object left, Object right) {
        if (left == right) {
            return true;
        }
        if (left == null) {
            return false;
        }
        return left.equals(right);
    }

    private IAttribute getContributorAttribute() {
        WorkItemWorkingCopy copy = this.fWorkingCopy;
        if (copy == null || this.fContributorAttribute != null && copy.getWorkItem().getProjectArea().sameItemId((IItemHandle)this.fContributorAttribute.getProjectArea())) {
            return this.fContributorAttribute;
        }
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)copy.getAdapter(IWorkItemUIWorkingCopy.class);
        if (this.getDescriptor().getProperties() == null || this.getDescriptor().getProperties().get("contributorAttributeId") == null) {
            return null;
        }
        this.fContributorAttribute = uiCopy.getResolvedWorkItem().findAttribute(WorkItemAttributes.getPropertyIdentifier((String)((String)this.getDescriptor().getProperties().get("contributorAttributeId"))));
        return this.fContributorAttribute;
    }

    private boolean showContributor() {
        String contributor;
        return this.getDescriptor() != null && this.getDescriptor().getProperties() != null && (contributor = (String)this.getDescriptor().getProperties().get("contributorAttributeId")) != null;
    }

    private void setContributor() {
        Object value = null;
        if (this.fWorkingCopy != null && this.getContributorAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getContributorAttribute())) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            value = workItem.getValue(this.getContributorAttribute());
        }
        Control linkControl = this.fROLabeledHyperlink.getControl();
        GridData linkData = (GridData)linkControl.getLayoutData();
        GridData labelData = (GridData)this.fNoContributorLabel.getLayoutData();
        if (value != null) {
            linkData.widthHint = -1;
            labelData.widthHint = 0;
        } else {
            linkData.widthHint = 0;
            labelData.widthHint = -1;
        }
        this.fROLabeledHyperlink.setElement(value);
        this.layoutDateAndContributor();
    }

    public void setFocus() {
        if (!this.isReadOnly() && this.fAttributeContent != null && !this.fAttributeContent.getText().isDisposed()) {
            this.fAttributeContent.getText().setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
            }
            if (this.isReadOnly() && this.showContributor()) {
                this.setContributor();
            }
            this.handleDateChanged();
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
            if (this.showContributor() && this.getContributorAttribute() != null) {
                mgr.addPresentationUpdater(this.fContributorUpdater, new PresentationDescriptor(null, null, null, WorkItemAttributes.getPropertyIdentifier((String)this.getContributorAttribute().getIdentifier()), new HashMap()));
            }
        }
    }

    private void removeListeners() {
        if (this.getSite() != null) {
            PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
            if (mgr != null) {
                mgr.removePresentationUpdater(this.fPresentationUpdater);
            }
            if (this.showContributor()) {
                mgr.removePresentationUpdater(this.fContributorUpdater);
            }
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }
}

