/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.common.ITeamAreaHandle;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.ProjectAreaPicker;
import com.ibm.team.workitem.rcp.ui.internal.wizards.CopyToProjectAreaWizard;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class TeamAreaAttributePart
extends PresentationPart {
    private WorkItemWorkingCopy fWorkingCopy;
    private StandardControlLabelProvider fLabeledProjectHyperlink;
    private Composite fContainer;
    private StandardControlLabelProvider fLabeledTeamHyperlink;
    private UIUpdaterJob fTeamAreaUpdater = new TeamAreaUpdaterJob();
    private InternalItemListener fItemListener = new InternalItemListener();
    private Label fLabel;
    private Label fSeparator;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        @Override
        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (TeamAreaAttributePart.this.fLabel != null && !TeamAreaAttributePart.this.fLabel.isDisposed()) {
                TeamFormUtil.setVisible((Control)TeamAreaAttributePart.this.fLabel, visible);
                changedControls.add(TeamAreaAttributePart.this.fLabel);
            }
            if (TeamAreaAttributePart.this.fContainer != null && !TeamAreaAttributePart.this.fContainer.isDisposed()) {
                TeamFormUtil.setVisible((Control)TeamAreaAttributePart.this.fContainer, visible);
                changedControls.add(TeamAreaAttributePart.this.fContainer);
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            if (TeamAreaAttributePart.this.fTeamAreaUpdater != null && TeamAreaAttributePart.this.fContainer != null && !TeamAreaAttributePart.this.fContainer.isDisposed()) {
                TeamAreaAttributePart.this.fTeamAreaUpdater.schedule();
            }
            if (dependencies.contains(IWorkItem.PROJECT_AREA_PROPERTY)) {
                TeamAreaAttributePart.this.updateProjectArea();
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        this.fLabel = toolkit.createLabel(parent, NLS.bind((String)ATTRNAME_COLON, (Object)Messages.TeamAreaAttributePart_PROJECT_AREA, (Object[])new Object[0]), 0, this.getBackgroundStyle());
        formLayout.add((Control)this.fLabel, "label");
        this.fContainer = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
        TeamFormLayouts.setLayoutData((Control)this.fContainer, (ITeamFormData)ITeamFormData.HYPERLINK.maxOffset(ITeamFormData.LABEL).maxVertOffset(ITeamFormData.BUTTON));
        Util.addWidthHint((Control)this.fContainer);
        formLayout.add((Control)this.fContainer, "content");
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.fContainer.setLayout((Layout)layout);
        Composite links = toolkit.createComposite(this.fContainer, 0, this.getBackgroundStyle());
        links.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        layout = new GridLayout(3, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        links.setLayout((Layout)layout);
        this.fLabeledTeamHyperlink = toolkit.createDecoratedHyperlink((TeamFormPart)this, links, null, this.getBackgroundStyle());
        this.fLabeledTeamHyperlink.setForegroundAware(false);
        StandardLabelProvider labelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        labelProvider.setDecoratorsDisabled(true);
        this.fLabeledTeamHyperlink.setLabelProvider((IViewerLabelProvider)labelProvider);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.exclude = true;
        this.fLabeledTeamHyperlink.getControl().setLayoutData((Object)data);
        this.fLabeledTeamHyperlink.getControl().setVisible(false);
        this.fSeparator = toolkit.createLabel(links, Messages.TeamAreaAttributePart_TEAM_PROJECT_SEPARATOR, 0, this.getBackgroundStyle());
        data = new GridData(16384, 0x1000000, false, false);
        data.exclude = true;
        this.fSeparator.setVisible(false);
        this.fSeparator.setLayoutData((Object)data);
        this.fSeparator.setForeground(toolkit.getColors().getForeground());
        this.fLabeledProjectHyperlink = toolkit.createDecoratedHyperlink((TeamFormPart)this, links, null, this.getBackgroundStyle());
        this.fLabeledProjectHyperlink.getControl().setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.fLabeledProjectHyperlink.setLabelProvider((IViewerLabelProvider)new ProjectAreaPicker.ProjectAreaLabelProvider(Collections.EMPTY_LIST));
        this.fLabeledProjectHyperlink.setForegroundAware(false);
        ToolBar toolBar = new ToolBar(this.fContainer, 0x800000);
        this.initAccessible((Control)toolBar, Messages.TeamAreaAttributePart_MOVE_COPY_TO_PA);
        toolkit.adapt((Composite)toolBar, this.getBackgroundStyle());
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ToolItem movePA = new ToolItem(toolBar, 8);
        movePA.setToolTipText(Messages.TeamAreaAttributePart_MOVE_COPY_TO_PA);
        movePA.setImage(JazzResources.getImageWithDefault((ResourceManager)new LocalResourceManager(JFaceResources.getResources(), (Control)toolBar), (ImageDescriptor)ImagePool.MOVE_COPY));
        movePA.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (TeamAreaAttributePart.this.fWorkingCopy != null) {
                    CopyToProjectAreaWizard.CopyToProjectAreaAction action = new CopyToProjectAreaWizard.CopyToProjectAreaAction();
                    action.selectionChanged(null, (ISelection)new StructuredSelection((Object)TeamAreaAttributePart.this.fWorkingCopy.getWorkItem()));
                    action.run(null);
                }
            }
        });
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            this.updateProjectArea();
            this.fTeamAreaUpdater.schedule();
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, Util.addDependencies(this.getDescriptor(), IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.CATEGORY_PROPERTY, IWorkItem.TARGET_PROPERTY));
        }
        IItemManager itemManager = this.fWorkingCopy.getTeamRepository().itemManager();
        itemManager.addItemChangeListener(ICategory.ITEM_TYPE, (ISharedItemChangeListener)this.fItemListener);
    }

    private void removeListeners() {
        if (this.fWorkingCopy != null) {
            PresentationHandlerManager mgr;
            if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
                mgr.removePresentationUpdater(this.fPresentationUpdater);
            }
            IItemManager itemManager = this.fWorkingCopy.getTeamRepository().itemManager();
            itemManager.removeItemChangeListener(ICategory.ITEM_TYPE, (ISharedItemChangeListener)this.fItemListener);
        }
    }

    private void updateProjectArea() {
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        IProjectArea projectArea = (IProjectArea)uiCopy.getResolvedWorkItem().getValue(IWorkItem.PROJECT_AREA_PROPERTY);
        this.fLabeledProjectHyperlink.setElement((Object)projectArea);
        this.fContainer.layout(true, true);
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    private class InternalItemListener
    implements ISharedItemChangeListener {
        private InternalItemListener() {
        }

        public void itemsChanged(List events) {
            for (ISharedItemChangeEvent event : events) {
                if (!(event.getSharedItem() instanceof ICategory)) continue;
                TeamAreaAttributePart.this.fTeamAreaUpdater.schedule(80L);
            }
        }
    }

    private class TeamAreaUpdaterJob
    extends UIUpdaterJob {
        private ITeamArea fTeamArea;

        public TeamAreaUpdaterJob() {
            super(Messages.TeamAreaAttributePart_FIND_TEAM_AREA);
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            try {
                this.fTeamArea = null;
                WorkItemWorkingCopy workingCopy = TeamAreaAttributePart.this.fWorkingCopy;
                if (workingCopy == null) {
                    return Status.CANCEL_STATUS;
                }
                ITeamRepository teamRepository = workingCopy.getTeamRepository();
                IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                IProcessAreaHandle processArea = workItemClient.findProcessArea((IWorkItemHandle)workingCopy.getWorkItem(), monitor);
                if (processArea instanceof ITeamAreaHandle) {
                    this.fTeamArea = (ITeamArea)auditableClient.resolveAuditable((IAuditableHandle)processArea, ItemProfile.TEAM_AREA_DEFAULT, monitor);
                }
                return Status.OK_STATUS;
            }
            catch (TeamRepositoryException x) {
                return new Status(4, "com.ibm.team.workitem.ide.ui", 4, Messages.TeamAreaAttributePart_EXCEPTION_RETRIEVING_TEAM_AREA, (Throwable)x);
            }
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (TeamAreaAttributePart.this.fWorkingCopy == null) {
                return Status.CANCEL_STATUS;
            }
            if (TeamAreaAttributePart.this.fLabeledTeamHyperlink.getElement() == this.fTeamArea) {
                return Status.OK_STATUS;
            }
            TeamAreaAttributePart.this.fLabeledTeamHyperlink.getControl().setVisible(this.fTeamArea != null);
            ((GridData)((TeamAreaAttributePart)TeamAreaAttributePart.this).fLabeledTeamHyperlink.getControl().getLayoutData()).exclude = this.fTeamArea == null;
            TeamAreaAttributePart.this.fSeparator.setVisible(this.fTeamArea != null);
            ((GridData)((TeamAreaAttributePart)TeamAreaAttributePart.this).fSeparator.getLayoutData()).exclude = this.fTeamArea == null;
            TeamAreaAttributePart.this.fLabeledTeamHyperlink.setElement((Object)this.fTeamArea);
            if (this.fTeamArea == null) {
                TeamAreaAttributePart.this.fLabel.setText(NLS.bind((String)ATTRNAME_COLON, (Object)Messages.TeamAreaAttributePart_PROJECT_AREA, (Object[])new Object[0]));
                TeamAreaAttributePart.this.fLabel.getParent().layout(new Control[]{TeamAreaAttributePart.this.fLabel});
            } else {
                TeamAreaAttributePart.this.fLabel.setText(NLS.bind((String)ATTRNAME_COLON, (Object)Messages.TeamAreaAttributePart_TEAM_AREA, (Object[])new Object[0]));
                TeamAreaAttributePart.this.fLabel.getParent().layout(new Control[]{TeamAreaAttributePart.this.fLabel});
            }
            TeamAreaAttributePart.this.fContainer.layout(true, true);
            return Status.OK_STATUS;
        }
    }
}

