/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.ISubscriptions;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class SubscriberUtil {

    public static class AddSubscriberAction
    extends Action {
        private WorkItemWorkingCopy fWorkingCopy;

        public AddSubscriberAction(WorkItemWorkingCopy workingCopy, String text) {
            super(text, ImagePool.SUBSCRIPTION);
            this.fWorkingCopy = workingCopy;
        }

        public void run() {
            IWorkItem workItem = this.fWorkingCopy.getWorkItem();
            ITeamRepository teamRepository = (ITeamRepository)workItem.getOrigin();
            ItemHandleAwareHashSet filtered = new ItemHandleAwareHashSet(Arrays.asList(workItem.getSubscriptions().getContents()));
            TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(Display.getCurrent().getActiveShell(), teamRepository, filtered.toList(), true);
            dialog.setTitle(Messages.SubscribersPart_ADD_SUBSCRIBERS);
            dialog.setShellTitle(Messages.SubscribersPart_ADD_SUBSCRIBERS);
            dialog.setMessage(Messages.SubscriberUtil_SELECT_SUBSCRIBERS_MESSAGE);
            if (dialog.open() == 0) {
                Object[] results = dialog.getResult();
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                try {
                    workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                    Object[] objectArray = results;
                    int n = results.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object contributor = objectArray[n2];
                        workItem.getSubscriptions().add((IContributorHandle)contributor);
                        ++n2;
                    }
                }
                finally {
                    workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)workItem);
                }
            }
        }
    }

    public static abstract class SubscriberDropListener
    extends DropTargetAdapter {
        protected abstract WorkItemWorkingCopy getWorkingCopy();

        public void dragEnter(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dropAccept(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void drop(DropTargetEvent event) {
            ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                ArrayList<IItemHandle> itemList = new ArrayList<IItemHandle>();
                if (sel != null) {
                    for (Object e : sel.toList()) {
                        if ((e = LinkHelper.convertURIReferenceToItemHandle(e, this.getWorkingCopy().getTeamRepository())) instanceof IItemHandle) {
                            itemList.add((IItemHandle)e);
                            continue;
                        }
                        if (!(e instanceof IReference) || !((IReference)e).isItemReference()) continue;
                        itemList.add(((IItemReference)e).getReferencedItem());
                    }
                }
                ISubscriptions subscriptions = this.getWorkingCopy().getWorkItem().getSubscriptions();
                for (IItemHandle handle : itemList) {
                    if (handle instanceof IContributorHandle) {
                        subscriptions.add((IContributorHandle)handle);
                        continue;
                    }
                    if (!(handle instanceof ITeamArea)) continue;
                    IContributorHandle[] iContributorHandleArray = ((ITeamArea)handle).getMembers();
                    int n = iContributorHandleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributorHandle subs = iContributorHandleArray[n2];
                        subscriptions.add(subs);
                        ++n2;
                    }
                }
            }
        }

        private void validateDrop(DropTargetEvent event) {
            event.detail = 0;
            if (!LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                return;
            }
            ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                for (Object e : structuredSelection.toList()) {
                    if ((e instanceof IContributorHandle || e instanceof ITeamArea) && ((IItemHandle)e).getOrigin() == this.getWorkingCopy().getTeamRepository() || e instanceof IReference && ((IReference)e).isItemReference() && (((IItemReference)e).getReferencedItem() instanceof IContributorHandle || ((IItemReference)e).getReferencedItem() instanceof ITeamArea) && ((IItemReference)e).getReferencedItem().getOrigin() == this.getWorkingCopy().getTeamRepository()) continue;
                    event.detail = 0;
                    return;
                }
                if ((event.operations & 4) != 0) {
                    event.detail = 4;
                } else if ((event.operations & 1) != 0) {
                    event.detail = 1;
                }
            }
        }
    }
}

