/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RequiredPropertyLabel {
    private static final RGB INDICATOR_COLOR = new RGB(232, 120, 32);
    private Composite fContainer;
    private Label fLabel;
    private Control fIndicator;

    public RequiredPropertyLabel(Composite parent, WorkItemEditorToolkit toolkit, int backgroundStyle) {
        this.fContainer = toolkit.createComposite(parent, 0, backgroundStyle);
        TeamFormLayouts.setLayoutData((Control)this.fContainer, (ITeamFormData)ITeamFormData.LABEL);
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 0;
        this.fContainer.setLayout((Layout)layout);
        this.fLabel = toolkit.createLabel(this.fContainer, "", 0, backgroundStyle);
        this.fLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fIndicator = RequiredPropertyLabel.createIndicator(this.fContainer, toolkit, backgroundStyle);
        this.fIndicator.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fIndicator.setVisible(false);
    }

    public Control getLayoutControl() {
        return this.fContainer;
    }

    public boolean isDisposed() {
        return this.fLabel.isDisposed();
    }

    public void setText(String string) {
        this.fLabel.setText(string);
    }

    public void layout() {
        this.fContainer.getParent().layout(new Control[]{this.fLabel, this.fIndicator});
    }

    public void setRequired(boolean required) {
        this.fIndicator.setVisible(required);
    }

    public void setBackground(Color color) {
        this.fContainer.setBackground(color);
        this.fLabel.setBackground(color);
        this.fIndicator.setBackground(color);
    }

    public static Control createIndicator(Composite container, WorkItemEditorToolkit toolkit, int backgroundStyle) {
        Label indicator = toolkit.createLabel(container, "*", 0, backgroundStyle);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)indicator);
        indicator.setForeground(resourceManager.createColor(INDICATOR_COLOR));
        indicator.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        return indicator;
    }
}

