/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.common.internal.presentations.QuickInformationConfigurationManager;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.LinkLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.part.ApprovalsPart;
import com.ibm.team.workitem.ide.ui.internal.editor.part.AttachmentsPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.SubscriberUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.AbstractQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.CollectorQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.quickinformation.QuickInformationManager;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.SharedScrolledComposite;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class QuickInformationPart
extends PresentationPart {
    private static final String SUMMARY_TOOLTIP = Messages.QuickInformationPart_USE_CONTEXT_MENU;
    private WorkItemWorkingCopy fWorkingCopy;
    private WorkItemEditorToolkit fToolkit;
    private HyperlinkGroup fLinkGroup;
    private HyperlinkGroup fClosedLinkGroup;
    private HyperlinkGroup fPresentGroup;
    private Composite fListComposite;
    private Map<String, IHyperlinkListener> fPartActivators = new HashMap<String, IHyperlinkListener>();
    private LinkLabelProvider fLinkLabelProvider = new LinkLabelProvider();
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private UIWorkItemListener fUIListener;
    private List<AbstractQuickInformationEntry> fEntries = new ArrayList<AbstractQuickInformationEntry>();
    private int fLastWidth = 0;
    private UIJob fUpdaterJob = new UIJob(Messages.QuickInformationPart_REFRESH_QI){

        public IStatus runInUIThread(IProgressMonitor monitor) {
            QuickInformationPart.this.updateItems(false);
            return Status.OK_STATUS;
        }
    };

    public void createContent(Composite parent) {
        this.fToolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        this.fLinkGroup = new HyperlinkGroup(this.fToolkit.getColors().getDisplay());
        this.fLinkGroup.setBackground(null);
        this.fLinkGroup.setHyperlinkUnderlineMode(2);
        this.fClosedLinkGroup = new HyperlinkGroup(this.fToolkit.getColors().getDisplay());
        this.fClosedLinkGroup.setBackground(null);
        this.fClosedLinkGroup.setHyperlinkUnderlineMode(2);
        this.fClosedLinkGroup.setForeground(WorkItemIDEUIPlugin.getDefault().getDarkShadow());
        this.fClosedLinkGroup.setActiveForeground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
        this.fPresentGroup = new HyperlinkGroup(this.fToolkit.getColors().getDisplay());
        this.fPresentGroup.setBackground(null);
        this.fPresentGroup.setHyperlinkUnderlineMode(2);
        this.fPresentGroup.setForeground(JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)CollaborationUI.getForegroundColor((CollaborationPresenceStatus)CollaborationPresenceStatus.STATUS_AVAILABLE, (boolean)true)));
        this.fPresentGroup.setActiveForeground(JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)CollaborationUI.getHighlightColor((CollaborationPresenceStatus)CollaborationPresenceStatus.STATUS_AVAILABLE)));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 3;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.fListComposite = this.fToolkit.createComposite(parent);
        GridData gd = new GridData(1808);
        GC gc = new GC((Drawable)this.fListComposite);
        FontMetrics metrics = gc.getFontMetrics();
        int widthHint = 33 * metrics.getAverageCharWidth();
        gc.dispose();
        gd.widthHint = widthHint;
        this.fListComposite.setLayoutData((Object)gd);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginTop = 3;
        layout.marginBottom = 3;
        layout.marginWidth = 6;
        layout.verticalSpacing = 3;
        this.fListComposite.setLayout((Layout)layout);
        this.fListComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle clArea = QuickInformationPart.this.fListComposite.getClientArea();
                GC gc = e.gc;
                gc.setAntialias(1);
                gc.setForeground(QuickInformationPart.this.fToolkit.getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
                gc.drawRoundRectangle(0, 0, clArea.width - 1, clArea.height - 1, 6, 6);
                gc.setForeground(QuickInformationPart.this.fListComposite.getDisplay().getSystemColor(1));
                gc.drawPoint(2, 2);
                gc.drawPoint(1, 2);
                gc.drawPoint(1, 3);
                gc.drawPoint(2, 1);
                gc.drawPoint(3, 1);
                gc.drawPoint(clArea.width - 3, 2);
                gc.drawPoint(clArea.width - 2, 2);
                gc.drawPoint(clArea.width - 2, 3);
                gc.drawPoint(clArea.width - 3, 1);
                gc.drawPoint(clArea.width - 4, 1);
                gc.drawPoint(2, clArea.height - 3);
                gc.drawPoint(1, clArea.height - 3);
                gc.drawPoint(1, clArea.height - 4);
                gc.drawPoint(2, clArea.height - 2);
                gc.drawPoint(3, clArea.height - 2);
                gc.drawPoint(clArea.width - 3, clArea.height - 3);
                gc.drawPoint(clArea.width - 2, clArea.height - 3);
                gc.drawPoint(clArea.width - 2, clArea.height - 4);
                gc.drawPoint(clArea.width - 3, clArea.height - 2);
                gc.drawPoint(clArea.width - 4, clArea.height - 2);
                gc.setAntialias(0);
            }
        });
        final Color start = this.fToolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        final Color end = this.fToolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        this.fListComposite.setBackgroundMode(1);
        this.fListComposite.setBackground(start);
        QuickInformationPart.setBackgroundImage(this.fListComposite, start, end);
        this.fUpdaterJob.setSystem(true);
        this.fListComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                QuickInformationPart.setBackgroundImage(QuickInformationPart.this.fListComposite, start, end);
                if (((QuickInformationPart)QuickInformationPart.this).fListComposite.getClientArea().width != QuickInformationPart.this.fLastWidth) {
                    QuickInformationPart.this.fUpdaterJob.cancel();
                    QuickInformationPart.this.fUpdaterJob.schedule(500L);
                }
            }
        });
        this.fListComposite.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                Image backgroundImage = QuickInformationPart.this.fListComposite.getBackgroundImage();
                if (backgroundImage != null && !backgroundImage.isDisposed()) {
                    backgroundImage.dispose();
                }
            }
        });
        this.addUndefinedEndPointDropTarget((Control)this.fListComposite);
        Label summaryLabel = this.fToolkit.createLabel(this.fListComposite, Messages.QuickInformationPart_QUICK_INFORMATION);
        summaryLabel.setLayoutData((Object)new GridData(16384, 1, false, false, 2, 1));
        summaryLabel.setBackground(null);
        summaryLabel.setForeground(this.fToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        summaryLabel.setFont((Font)this.fResourceManager.get((DeviceResourceDescriptor)JFaceResources.getFontDescriptor((String)"").withStyle(1)));
        this.createContextMenu((Control)summaryLabel);
        summaryLabel.setToolTipText(SUMMARY_TOOLTIP);
    }

    private static void setBackgroundImage(Composite control, Color start, Color end) {
        Rectangle rect = control.getClientArea();
        if (!rect.isEmpty()) {
            int height = Math.max(3, rect.height);
            int width = Math.max(4, rect.width);
            Image newImage = new Image((Device)control.getDisplay(), width, height);
            GC gc = new GC((Drawable)newImage);
            gc.setForeground(start);
            gc.setBackground(end);
            gc.fillGradientRectangle(rect.x + 2, rect.y + 2, width - 4, height - 3, true);
            gc.dispose();
            Image oldImage = control.getBackgroundImage();
            control.setBackgroundImage(newImage);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
        }
    }

    public ResourceManager getResourceManager() {
        return this.fResourceManager;
    }

    public LinkLabelProvider getLinkLableProvider() {
        return this.fLinkLabelProvider;
    }

    public UIWorkItemListener getUIListener() {
        return this.fUIListener;
    }

    public HyperlinkGroup getLinkGroup() {
        return this.fLinkGroup;
    }

    public HyperlinkGroup getPresentGroup() {
        return this.fPresentGroup;
    }

    public HyperlinkGroup getClosedGroup() {
        return this.fClosedLinkGroup;
    }

    public void updateItems(boolean reflow) {
        if (this.fListComposite.isDisposed() || this.fWorkingCopy == null) {
            return;
        }
        Control[] kids = this.fListComposite.getChildren();
        int i = 1;
        while (i < kids.length) {
            kids[i].dispose();
            ++i;
        }
        this.createContextMenu((Control)this.fListComposite);
        for (AbstractQuickInformationEntry entry : this.fEntries) {
            if (!entry.canShow()) continue;
            entry.createContent(this.fListComposite);
            entry.shown(reflow);
        }
        if (this.fListComposite.getChildren().length == 1) {
            Label l = new Label(this.fListComposite, 0x1000000);
            l.setText(Messages.QuickInformationPart_NO_INFORMATION);
            l.setForeground(l.getDisplay().getSystemColor(16));
            l.setBackground(null);
            this.createContextMenu((Control)l);
            l.setToolTipText(SUMMARY_TOOLTIP);
            GridData data = new GridData(0x1000000, 0x1000000, true, true, 2, 1);
            l.setLayoutData((Object)data);
        }
        this.fLinkGroup.setBackground(null);
        this.fClosedLinkGroup.setBackground(null);
        this.fPresentGroup.setBackground(null);
        this.refreshLayout(reflow);
        this.fLastWidth = this.fListComposite.getBounds().width;
    }

    private void refreshLayout(boolean reflow) {
        SharedScrolledComposite form;
        if (reflow && (form = this.getScrolledComposite()) != null) {
            form.reflow(true);
            form.layout(true, true);
            return;
        }
        this.fListComposite.layout(true, true);
    }

    private SharedScrolledComposite getScrolledComposite() {
        Composite parent = this.fListComposite.getParent();
        while (parent != null) {
            if (parent instanceof SharedScrolledComposite) {
                return (SharedScrolledComposite)parent;
            }
            parent = parent.getParent();
        }
        return null;
    }

    private static IStructuredSelection getStructuredSelection() {
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    private void createContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        Action addApprovalAction = new Action(Messages.QuickInformationPart_ADD_APPROVAL){

            public ImageDescriptor getImageDescriptor() {
                return ImageDescriptor.createFromURL((URL)WorkItemApprovals.APPROVAL_TYPE.getIconURL());
            }

            public void run() {
                ApprovalsPart.NewApprovalDescriptorDialog dialog = new ApprovalsPart.NewApprovalDescriptorDialog(Display.getCurrent().getActiveShell(), Messages.QuickInformationPart_APPROVAL, false);
                if (dialog.open() != 0) {
                    return;
                }
                IApprovalDescriptor descriptor = QuickInformationPart.this.fWorkingCopy.getWorkItem().getApprovals().createDescriptor(dialog.getType().getIdentifier(), dialog.getName());
                descriptor.setDueDate(dialog.getDueDate());
                QuickInformationPart.this.fWorkingCopy.getWorkItem().getApprovals().add(descriptor);
                if (dialog.isAddApprover()) {
                    ITeamRepository teamRepository = (ITeamRepository)QuickInformationPart.this.fWorkingCopy.getWorkItem().getOrigin();
                    ArrayList<IContributorHandle> approvers = new ArrayList<IContributorHandle>();
                    List contents = QuickInformationPart.this.fWorkingCopy.getWorkItem().getApprovals().getContents(descriptor);
                    for (IApproval approval : contents) {
                        approvers.add(approval.getApprover());
                    }
                    TeamContributorSelectionDialog tc = new TeamContributorSelectionDialog(Display.getCurrent().getActiveShell(), teamRepository, approvers, true);
                    tc.setTitle(Messages.QuickInformationPart_ADD_APPROVERS);
                    tc.setShellTitle(Messages.QuickInformationPart_ADD_APPROVERS);
                    tc.setMessage(Messages.QuickInformationPart_SELECT_APPROVERS_MESSAGE);
                    if (tc.open() == 0) {
                        IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                        try {
                            workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)QuickInformationPart.this.fWorkingCopy.getWorkItem());
                            IContributorHandle[] iContributorHandleArray = tc.getContributorResult();
                            int n = iContributorHandleArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IContributorHandle contributor = iContributorHandleArray[n2];
                                QuickInformationPart.this.fWorkingCopy.getWorkItem().getApprovals().add(QuickInformationPart.this.fWorkingCopy.getWorkItem().getApprovals().createApproval(descriptor, contributor));
                                ++n2;
                            }
                        }
                        finally {
                            workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)QuickInformationPart.this.fWorkingCopy.getWorkItem());
                        }
                    }
                }
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)addApprovalAction){
            private final /* synthetic */ IAction val$addApprovalAction;
            {
                this.val$addApprovalAction = iAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                LinkHelper.addEmptySelectionActions(QuickInformationPart.this.getSite().getWorkbenchPage(), manager, QuickInformationPart.this.fWorkingCopy);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new AttachmentsPart.AddFileAction(QuickInformationPart.this.fWorkingCopy));
                manager.add((IAction)new AttachmentsPart.AddScreenshotAction(QuickInformationPart.this.fWorkingCopy));
                manager.add((IContributionItem)new Separator());
                manager.add(this.val$addApprovalAction);
                manager.add((IContributionItem)new Separator());
                if (QuickInformationPart.this.fWorkingCopy.getWorkItem().getSubscriptions().contains((IContributorHandle)QuickInformationPart.this.fWorkingCopy.getTeamRepository().loggedInContributor())) {
                    manager.add((IAction)new Action(Messages.QuickInformationPart_UNSUBSCRIBE_ME, ImagePool.REMOVE_SELF){

                        public void run() {
                            QuickInformationPart.this.fWorkingCopy.getWorkItem().getSubscriptions().remove((IContributorHandle)QuickInformationPart.this.fWorkingCopy.getTeamRepository().loggedInContributor());
                        }
                    });
                } else {
                    manager.add((IAction)new Action(Messages.QuickInformationPart_SUBSCRIBE_ME, ImagePool.ADD_SELF){

                        public void run() {
                            QuickInformationPart.this.fWorkingCopy.getWorkItem().getSubscriptions().add((IContributorHandle)QuickInformationPart.this.fWorkingCopy.getTeamRepository().loggedInContributor());
                        }
                    });
                }
                manager.add((IAction)new SubscriberUtil.AddSubscriberAction(QuickInformationPart.this.fWorkingCopy, Messages.QuickInformationPart_ADD_SUBSCRIBER));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(this.getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void addUndefinedEndPointDropTarget(final Control control) {
        DropTarget target = new DropTarget(control, 7);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void dropAccept(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void drop(DropTargetEvent event) {
                this.performDrop(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void dragLeave(DropTargetEvent event) {
            }

            private void validateDrop(DropTargetEvent event) {
                if (LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    IStructuredSelection selection = QuickInformationPart.getStructuredSelection();
                    if (selection != null) {
                        Object element = selection.getFirstElement();
                        if ((element = LinkHelper.convertURIReferenceToItemHandle(element, QuickInformationPart.this.fWorkingCopy.getTeamRepository())) instanceof IItemHandle && ((IItemHandle)element).getOrigin() != QuickInformationPart.this.fWorkingCopy.getTeamRepository()) {
                            event.detail = 0;
                            return;
                        }
                        if (element instanceof IFile || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(IResource.class) instanceof IFile) {
                            if (selection.size() != 1) {
                                event.detail = 0;
                                return;
                            }
                            if ((event.operations & 4) != 0) {
                                event.detail = 4;
                            } else if ((event.operations & 1) != 0) {
                                event.detail = 1;
                            }
                            return;
                        }
                        if (element instanceof IWorkItemHandle || element instanceof IAttachmentHandle || element instanceof IReference && ((IReference)element).isItemReference() && (((IItemReference)element).getReferencedItem() instanceof IWorkItemHandle || ((IItemReference)element).getReferencedItem() instanceof IAttachmentHandle)) {
                            if (element instanceof IWorkItemHandle && selection.toList().size() == 1 && ((IWorkItemHandle)element).sameItemId((IItemHandle)QuickInformationPart.this.fWorkingCopy.getWorkItem())) {
                                event.detail = 0;
                                return;
                            }
                            IItemType type = element instanceof IWorkItemHandle || element instanceof IAttachmentHandle ? ((IItemHandle)element).getItemType() : ((IItemReference)element).getReferencedItem().getItemType();
                            for (Object e : selection.toList()) {
                                if ((e = LinkHelper.convertURIReferenceToItemHandle(e, QuickInformationPart.this.fWorkingCopy.getTeamRepository())) instanceof IItemHandle && ((IItemHandle)element).getOrigin() == QuickInformationPart.this.fWorkingCopy.getTeamRepository()) {
                                    if (((IItemHandle)e).getItemType().equals(type)) continue;
                                    event.detail = 0;
                                    return;
                                }
                                if (e instanceof IReference && ((IReference)e).isItemReference() && ((IItemReference)e).getReferencedItem().getOrigin() == QuickInformationPart.this.fWorkingCopy.getTeamRepository()) {
                                    if (((IItemReference)e).getReferencedItem().getItemType().equals(type)) continue;
                                    event.detail = 0;
                                    return;
                                }
                                event.detail = 0;
                                return;
                            }
                            event.detail = 4;
                            return;
                        }
                        if (element instanceof IContributorHandle || element instanceof ITeamArea || element instanceof IReference && ((IReference)element).isItemReference() && (((IItemReference)element).getReferencedItem() instanceof IContributorHandle || ((IItemReference)element).getReferencedItem() instanceof ITeamArea)) {
                            for (Object e : selection.toList()) {
                                if ((e instanceof IContributorHandle || e instanceof ITeamArea) && ((IItemHandle)e).getOrigin() == QuickInformationPart.this.fWorkingCopy.getTeamRepository() || e instanceof IReference && ((IReference)e).isItemReference() && (((IItemReference)e).getReferencedItem() instanceof IContributorHandle || ((IItemReference)e).getReferencedItem() instanceof ITeamArea) && ((IItemReference)e).getReferencedItem().getOrigin() == QuickInformationPart.this.fWorkingCopy.getTeamRepository()) continue;
                                event.detail = 0;
                                return;
                            }
                            event.detail = 4;
                            return;
                        }
                        if (element instanceof IItemHandle) {
                            for (Object e : selection.toList()) {
                                if (e instanceof IItemHandle) continue;
                                event.detail = 0;
                                return;
                            }
                            event.detail = 4;
                            return;
                        }
                    }
                } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    if ((event.operations & 4) != 0) {
                        event.detail = 4;
                    } else if ((event.operations & 1) != 0) {
                        event.detail = 1;
                    }
                    return;
                }
                event.detail = 0;
            }

            private void performDrop(DropTargetEvent event) {
                MenuManager menuMgr = new MenuManager("#PopupMenu");
                menuMgr.setRemoveAllWhenShown(true);
                Object element = null;
                String[] fileNames = null;
                ArrayList<IItemHandle> itemList = new ArrayList<IItemHandle>();
                if (LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    IStructuredSelection selection = QuickInformationPart.getStructuredSelection();
                    if (selection != null) {
                        element = selection.getFirstElement();
                        element = LinkHelper.convertURIReferenceToItemHandle(element, QuickInformationPart.this.fWorkingCopy.getTeamRepository());
                        for (Object e : selection.toList()) {
                            if ((e = LinkHelper.convertURIReferenceToItemHandle(e, QuickInformationPart.this.fWorkingCopy.getTeamRepository())) instanceof IItemHandle && !((IItemHandle)e).sameItemId((IItemHandle)QuickInformationPart.this.fWorkingCopy.getWorkItem())) {
                                itemList.add((IItemHandle)e);
                                continue;
                            }
                            if (!(e instanceof IReference) || !((IReference)e).isItemReference() || ((IItemReference)e).getReferencedItem().sameItemId((IItemHandle)QuickInformationPart.this.fWorkingCopy.getWorkItem())) continue;
                            itemList.add(((IItemReference)e).getReferencedItem());
                        }
                    }
                } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    fileNames = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType);
                }
                final ArrayList<IItemHandle> finalList = itemList;
                final Object finalElement = element;
                final String[] finalFileNames = fileNames;
                menuMgr.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        if (!finalList.isEmpty() && finalList.get(0) instanceof IAttachmentHandle) {
                            LinkHelper.AddLinkToEndPointAction addLinkAction = new LinkHelper.AddLinkToEndPointAction(QuickInformationPart.this.fWorkingCopy, WorkItemEndPoints.ATTACHMENT, Messages.QuickInformationPart_ADD_ATTACHMENT, finalList);
                            if (addLinkAction.isEnabled()) {
                                manager.add((IAction)addLinkAction);
                            }
                        } else if (finalElement instanceof IFile || finalElement instanceof IAdaptable && ((IAdaptable)finalElement).getAdapter(IResource.class) instanceof IFile) {
                            LinkHelper.AddLinkToEndPointAction addLinkAction = new LinkHelper.AddLinkToEndPointAction(QuickInformationPart.this.fWorkingCopy, WorkItemEndPoints.ATTACHMENT, Messages.QuickInformationPart_ADD_ATTACHMENT, finalElement);
                            if (addLinkAction.isEnabled()) {
                                manager.add((IAction)addLinkAction);
                            }
                        } else if (finalFileNames != null && finalFileNames.length > 0) {
                            manager.add((IAction)new Action(Messages.QuickInformationPart_ADD_ATTACHMENT, ImagePool.WORKITEM_ATTACHMENT){

                                public void run() {
                                    String[] stringArray = finalFileNames;
                                    int n = finalFileNames.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String fileName = stringArray[n2];
                                        AttachmentsPart.addFileSystemLink(QuickInformationPart.this.fWorkingCopy, fileName);
                                        ++n2;
                                    }
                                }
                            });
                        } else if (!finalList.isEmpty() && (finalList.get(0) instanceof ITeamArea || finalList.get(0) instanceof IContributorHandle)) {
                            manager.add((IAction)new Action(Messages.QuickInformationPart_ADD_AS_SUBSCRIBER, ImagePool.SUBSCRIPTION){

                                public void run() {
                                    for (IItemHandle handle : finalList) {
                                        if (handle instanceof IContributorHandle) {
                                            QuickInformationPart.this.fWorkingCopy.getWorkItem().getSubscriptions().add((IContributorHandle)handle);
                                            continue;
                                        }
                                        if (!(handle instanceof ITeamArea)) continue;
                                        IContributorHandle[] iContributorHandleArray = ((ITeamArea)handle).getMembers();
                                        int n = iContributorHandleArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IContributorHandle subs = iContributorHandleArray[n2];
                                            QuickInformationPart.this.fWorkingCopy.getWorkItem().getSubscriptions().add(subs);
                                            ++n2;
                                        }
                                    }
                                }
                            });
                        }
                        manager.add((IContributionItem)new Separator());
                        LinkHelper.addDropActions(manager, QuickInformationPart.this.fWorkingCopy, finalList);
                    }
                });
                Menu menu = menuMgr.createContextMenu(control);
                Util.showAndDisposeOnHide(menu);
            }
        });
    }

    public void addInvalidDropTarget(Control control) {
        DropTarget target = new DropTarget(control, 5);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.setNone(event);
            }

            private void setNone(DropTargetEvent event) {
                event.detail = 0;
            }

            public void dragLeave(DropTargetEvent event) {
                this.setNone(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.setNone(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.setNone(event);
            }

            public void drop(DropTargetEvent event) {
                this.setNone(event);
            }

            public void dropAccept(DropTargetEvent event) {
                this.setNone(event);
            }
        });
    }

    public boolean stretchVertically() {
        return true;
    }

    private void addQuickInformationEntries() {
        UIUpdaterJob addJob = new UIUpdaterJob(Messages.QuickInformationPart_RETRIEVING_QUICK_INFO){
            private List<QuickInformationConfigurationManager.QuickInformationConfigurationEntry> fUnitializedEntries;

            public IStatus runInBackground(IProgressMonitor monitor) {
                if (QuickInformationPart.this.fWorkingCopy == null) {
                    return Status.CANCEL_STATUS;
                }
                WorkItemClient workItemClient = (WorkItemClient)QuickInformationPart.this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                QuickInformationConfigurationManager manager = workItemClient.getQuickInformationConfigurationManager();
                try {
                    this.fUnitializedEntries = manager.getQuickInformationEntries(QuickInformationPart.this.fWorkingCopy.getWorkItem().getProjectArea(), (String)QuickInformationPart.this.getDescriptor().getProperties().get("quickinformationConfiguration"), monitor);
                }
                catch (TeamRepositoryException x) {
                    return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.QuickInformationPart_EXCEPTION_RESOLVING_QUICK_INFO, (Throwable)x);
                }
                return Status.OK_STATUS;
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.fUnitializedEntries == null || monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                if (QuickInformationPart.this.fWorkingCopy == null) {
                    return Status.OK_STATUS;
                }
                QuickInformationPart.this.fEntries.clear();
                for (QuickInformationConfigurationManager.QuickInformationConfigurationEntry entry : this.fUnitializedEntries) {
                    AbstractQuickInformationEntry e;
                    if (entry.getKind().equals("Hidden") || (e = QuickInformationManager.getPresentation(entry.getKind())) == null) continue;
                    if (e instanceof CollectorQuickInformationEntry) {
                        ((CollectorQuickInformationEntry)e).setAllEntries(this.fUnitializedEntries);
                    }
                    e.initialize(QuickInformationPart.this, QuickInformationPart.this.fWorkingCopy, entry);
                    QuickInformationPart.this.fEntries.add(e);
                }
                QuickInformationPart.this.updateItems(true);
                return Status.OK_STATUS;
            }
        };
        addJob.schedule();
    }

    public void setInput(Object input) {
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.fUIListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class);
            for (AbstractQuickInformationEntry entry : this.fEntries) {
                entry.dispose();
            }
            this.fEntries.clear();
            this.updateItems(true);
            this.addQuickInformationEntries();
        } else {
            for (AbstractQuickInformationEntry entry : this.fEntries) {
                entry.dispose();
            }
            this.fEntries.clear();
            this.fWorkingCopy = null;
            this.fUIListener = null;
        }
    }

    public IHyperlinkListener getPartActivator(final String partId) {
        if (partId == null) {
            return null;
        }
        if (this.fPartActivators.get(partId) == null) {
            this.fPartActivators.put(partId, (IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    QuickInformationPart.this.activatePart(partId);
                }
            });
        }
        return this.fPartActivators.get(partId);
    }

    private void activatePart(String partId) {
        IEditorPart editorPart = this.getSite().getWorkbenchPage().getActiveEditor();
        if (editorPart instanceof WorkItemEditor) {
            WorkItemEditor editor = (WorkItemEditor)editorPart;
            editor.activatePart(partId);
        }
    }

    public void dispose() {
        for (AbstractQuickInformationEntry entry : this.fEntries) {
            entry.dispose();
        }
        if (this.fLinkLabelProvider != null) {
            this.fLinkLabelProvider.dispose();
            this.fLinkLabelProvider = null;
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        this.fUIListener = null;
        this.fWorkingCopy = null;
        super.dispose();
    }
}

