/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.common.internal.presentations.EditorPresentation;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;

public abstract class PresentationPart
extends TeamFormPart {
    protected static String ATTRNAME_COLON = Messages.PresentationPart_ATTRIBUTENAME_COLON;
    private PresentationDescriptor fDescriptor;
    private boolean fHeader = false;
    private boolean fVisible = true;

    public void initialize(PresentationDescriptor descriptor) {
        this.setId(descriptor.getElementId());
        this.fDescriptor = descriptor;
    }

    public void setIsHeader(boolean header) {
        this.fHeader = header;
    }

    public PresentationDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public int getBackgroundStyle() {
        if (this.fHeader) {
            return 1;
        }
        return -1;
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public void setVisible(boolean visible) {
        this.fVisible = visible;
    }

    protected boolean isVisible() {
        return this.fVisible;
    }

    public String getDescription() {
        return this.fDescriptor != null ? this.fDescriptor.getLabel() : null;
    }

    protected void initAccessible(Control control) {
        this.initAccessible(control, null);
    }

    protected void initAccessible(final Control control, final String name) {
        if (control != null && !control.isDisposed()) {
            control.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    String label;
                    String string = label = name != null ? name : PresentationPart.this.getLabel();
                    if (label != null) {
                        if (control instanceof Tree || control instanceof Table) {
                            if (e.childID == -1) {
                                e.result = label;
                            } else {
                                Widget widget = control.getDisplay().findWidget((Widget)control, e.childID);
                                if (widget != null && widget instanceof Item) {
                                    e.result = NLS.bind((String)Messages.PresentationPart_LABEL_VALUE, (Object)label, (Object[])new Object[]{((Item)widget).getText()});
                                }
                            }
                        } else {
                            e.result = label;
                        }
                    }
                }
            });
        }
    }

    protected boolean isLabelVisible() {
        if (this.fDescriptor == null || this.fDescriptor.getProperties() == null || this.fDescriptor.getProperties().get("labelVisible") == null) {
            EditorPresentation presentation;
            return this.getSite() == null || (presentation = (EditorPresentation)this.getSite().getAdapter(EditorPresentation.class)) == null || this.fDescriptor == null || Util.getPresentationChildren(this.fDescriptor.getParentSectionId(), presentation.getPresentationsMap()).size() != 1;
        }
        return Boolean.parseBoolean((String)this.fDescriptor.getProperties().get("labelVisible"));
    }

    public String getLabel() {
        return this.fDescriptor != null ? this.fDescriptor.getLabel() : null;
    }

    public String getValueSetProviderId() {
        String id;
        if (this.fDescriptor != null && this.fDescriptor.getProperties() != null && (id = (String)this.fDescriptor.getProperties().get("valueSetProvider")) != null && !"".equals(id.trim())) {
            return id;
        }
        return null;
    }
}

