/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;

public class LongAttributePart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private RequiredPropertyLabel fAttributeName;
    private DecoratedText fAttributeContent;
    private Text fText;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (LongAttributePart.this.fAttributeName != null && !LongAttributePart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(LongAttributePart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(LongAttributePart.this.fAttributeName.getLayoutControl());
            }
            if (LongAttributePart.this.fAttributeContent != null && !LongAttributePart.this.fAttributeContent.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(LongAttributePart.this.fAttributeContent.getLayoutControl(), visible);
                changedControls.add(LongAttributePart.this.fAttributeContent.getLayoutControl());
            } else if (LongAttributePart.this.fText != null && !LongAttributePart.this.fText.isDisposed()) {
                TeamFormUtil.setVisible((Control)LongAttributePart.this.fText, visible);
                changedControls.add(LongAttributePart.this.fText);
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        public void setRequired(boolean required) {
            if (LongAttributePart.this.fAttributeName != null && !LongAttributePart.this.fAttributeName.isDisposed()) {
                LongAttributePart.this.fAttributeName.setRequired(required);
            }
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            if (LongAttributePart.this.fText != null && !LongAttributePart.this.fText.isDisposed() && !LongAttributePart.this.fText.getText().equals(LongAttributePart.this.getNonNullValue())) {
                LongAttributePart.this.fText.setText(LongAttributePart.this.getNonNullValue());
            }
        }

        public void setStatus(IStatus status) {
            if (LongAttributePart.this.fAttributeContent != null && !LongAttributePart.this.fAttributeContent.getLayoutControl().isDisposed()) {
                LongAttributePart.this.fAttributeContent.setStatus(status);
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        if (this.isReadOnly()) {
            this.fText = toolkit.createReadOnlyText(parent, "", 0, this.getBackgroundStyle());
            this.initAccessible((Control)this.fText);
            TeamFormLayouts.setLayoutData((Control)this.fText, (ITeamFormData)ITeamFormData.SINGLE_LINE_READONLY_TEXT);
            Util.addWidthHint((Control)this.fText);
            formLayout.add((Control)this.fText, "content");
        } else {
            this.fAttributeContent = new DecoratedFormsText(parent, this.getSite(), 0, 0, this.getBackgroundStyle());
            this.initAccessible((Control)this.fAttributeContent.getText());
            Util.addWidthHint(this.fAttributeContent.getLayoutControl());
            formLayout.add(this.fAttributeContent.getLayoutControl(), "content");
            this.fText = this.fAttributeContent.getText();
            this.fText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    if (LongAttributePart.this.fWorkingCopy != null && !LongAttributePart.this.fWorkingCopy.isDirty() && !LongAttributePart.this.fText.getText().equals(LongAttributePart.this.getNonNullValue())) {
                        ((WorkItemWorkingCopyImpl)LongAttributePart.this.fWorkingCopy).setDirty(true);
                    }
                    try {
                        LongAttributePart.this.readLong();
                        LongAttributePart.this.fAttributeContent.setStatus(Status.OK_STATUS);
                    }
                    catch (NumberFormatException numberFormatException) {
                        LongAttributePart.this.fAttributeContent.setStatus((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", Messages.LongAttributePart_VALUE_NOT_VALID));
                    }
                }
            });
            this.fText.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    if (!LongAttributePart.this.fText.getText().equals(LongAttributePart.this.getNonNullValue())) {
                        LongAttributePart.this.writeValue();
                    }
                }
            });
        }
    }

    private Long readLong() throws NumberFormatException {
        if (this.fText.getText().trim().equals("")) {
            return new Long(0L);
        }
        return Long.parseLong(this.fText.getText().trim());
    }

    private void writeValue() {
        if (this.fWorkingCopy != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            try {
                Long l = this.readLong();
                this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), (Object)l);
            }
            catch (NumberFormatException numberFormatException) {
                this.fAttributeContent.setStatus((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", Messages.LongAttributePart_VALUE_NOT_VALID));
            }
        }
    }

    private String getNonNullValue() {
        WorkItemUIWorkingCopy uiCopy;
        ResolvedWorkItem workItem;
        Long l;
        String value = null;
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute()) && (l = (Long)(workItem = (uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class)).getResolvedWorkItem()).getValue(this.getAttribute())) != null) {
            value = l.toString();
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void setFocus() {
        if (this.fText != null && !this.fText.isDisposed()) {
            this.fText.setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
            }
            if (this.fText != null && !this.fText.isDisposed()) {
                this.fText.setText(this.getNonNullValue());
            }
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }
}

