/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.process.common.IProcessArea;
import com.ibm.team.process.internal.ide.ui.ImagePool;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedHyperlink;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.IItemPicker;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.ItemPickerRegistry;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import java.util.ArrayList;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class ItemAttributePart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private DecoratedHyperlink fLink;
    private RequiredPropertyLabel fAttributeName;
    private Action fClear;
    private ToolBarManager fToolbarManager;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (ItemAttributePart.this.fAttributeName != null && !ItemAttributePart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(ItemAttributePart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(ItemAttributePart.this.fAttributeName.getLayoutControl());
            }
            if (ItemAttributePart.this.isReadOnly()) {
                TeamFormUtil.setVisible(ItemAttributePart.this.fLink.getLayoutControl(), visible);
                changedControls.add(ItemAttributePart.this.fLink.getLayoutControl());
            } else if (ItemAttributePart.this.fLink != null && !ItemAttributePart.this.fLink.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible((Control)ItemAttributePart.this.fLink.getLayoutControl().getParent(), visible);
                changedControls.add(ItemAttributePart.this.fLink.getLayoutControl().getParent());
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        public void setRequired(boolean required) {
            if (ItemAttributePart.this.fAttributeName != null && !ItemAttributePart.this.fAttributeName.isDisposed()) {
                ItemAttributePart.this.fAttributeName.setRequired(required);
            }
        }

        public void setStatus(IStatus status) {
            if (ItemAttributePart.this.fLink != null) {
                ItemAttributePart.this.fLink.setStatus(status);
            }
        }

        public void attributeChanged(WorkItemChangeEvent event) {
            ItemAttributePart.this.readItem();
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        Composite container = parent;
        if (!this.isReadOnly()) {
            container = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 3;
            container.setLayout((Layout)layout);
        }
        this.fLink = new DecoratedHyperlink(container, 0, 1);
        toolkit.adapt(this.fLink.getHyperlink().getControl(), true, true);
        Util.addWidthHint(this.fLink.getLayoutControl());
        if (this.isReadOnly()) {
            formLayout.add(this.fLink.getLayoutControl(), "content");
        } else {
            ITeamFormData layoutData = TeamFormLayouts.getLayoutData((Control)this.fLink.getLayoutControl()).maxVertOffset(ITeamFormData.BUTTON).maxOffset(ITeamFormData.BUTTON);
            TeamFormLayouts.setLayoutData((Control)container, (ITeamFormData)layoutData);
            this.fLink.getLayoutControl().setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
            formLayout.add((Control)container, "content");
        }
        String aType = this.getAttribute().getAttributeType();
        if ("teamArea".equals(aType) || "projectArea".equals(aType) || "processArea".equals(aType)) {
            this.fLink.getHyperlink().setTextAware(false);
        }
        this.fLink.getHyperlink().setImageAware(false);
        this.fLink.getHyperlink().setForegroundAware(false);
        DragSource drag = new DragSource(this.fLink.getLayoutControl(), 4);
        DragSourceAdapter dragSourceAdapter = new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                if (ItemAttributePart.this.fLink.getValue() == null || ItemAttributePart.this.fLink.getValue() instanceof IWorkItem && ((IWorkItem)ItemAttributePart.this.fLink.getValue()).isNewItem()) {
                    event.doit = false;
                } else {
                    LocalSelectionTransfer.getInstance().setSelection((ISelection)new StructuredSelection(ItemAttributePart.this.fLink.getValue()));
                }
            }

            public void dragSetData(DragSourceEvent event) {
                if (LocalSelectionTransfer.getInstance().isSupportedType(event.dataType)) {
                    event.data = LocalSelectionTransfer.getInstance().getSelection();
                }
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getInstance().setSelection(null);
            }
        };
        drag.addDragListener((DragSourceListener)dragSourceAdapter);
        if (!this.isReadOnly()) {
            Action choose = new Action(Messages.ItemAttributePart_CHOOSE){

                public void run() {
                    ItemAttributePart.this.choose();
                }
            };
            this.fClear = new Action(Messages.ItemAttributePart_CLEAR){

                public void run() {
                    ItemAttributePart.this.fWorkingCopy.getWorkItem().setValue(ItemAttributePart.this.getAttribute(), null);
                }
            };
            final Menu menu = new Menu((Control)parent);
            new ActionContributionItem((IAction)choose).fill(menu, -1);
            new ActionContributionItem((IAction)this.fClear).fill(menu, -1);
            this.fToolbarManager = new ToolBarManager(0x800000);
            final IMenuCreator creator = new IMenuCreator(){

                public Menu getMenu(Control parent) {
                    return menu;
                }

                public Menu getMenu(Menu parent) {
                    return null;
                }

                public void dispose() {
                    menu.dispose();
                }
            };
            Action button = new Action(Messages.ItemAttributePart_CHOOSE, 4){

                public IMenuCreator getMenuCreator() {
                    return creator;
                }

                public void run() {
                    ItemAttributePart.this.choose();
                }

                public ImageDescriptor getImageDescriptor() {
                    String aType = ItemAttributePart.this.getAttribute().getAttributeType();
                    if ("workItem".equals(aType)) {
                        return com.ibm.team.workitem.rcp.ui.internal.ImagePool.WORK_ITEMS;
                    }
                    if ("teamArea".equals(aType)) {
                        return ImagePool.TEAM_AREA_NOT_CUSTOMIZED;
                    }
                    if ("projectArea".equals(aType)) {
                        return ImagePool.PROJECT_AREA;
                    }
                    if ("processArea".equals(aType)) {
                        return ImagePool.TEAM_AREA_NOT_CUSTOMIZED;
                    }
                    return null;
                }
            };
            this.fToolbarManager.add((IAction)button);
            ToolBar toolbar = this.fToolbarManager.createControl(container);
            toolkit.adapt((Composite)toolbar, this.getBackgroundStyle());
            toolbar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        }
    }

    private void choose() {
        IItemPicker picker = ItemPickerRegistry.getItemPicker(AttributeTypes.getItemType((String)this.getAttribute().getAttributeType()));
        if (picker != null) {
            Object oldValue = this.fWorkingCopy.getWorkItem().getValue(this.getAttribute());
            IItemHandle value = picker.getItemResult(null, this.getAttribute().getAttributeType(), this.fWorkingCopy.getTeamRepository(), null, null, oldValue != null ? Collections.singletonList(oldValue) : Collections.emptyList(), Collections.emptyList(), true);
            if (picker.getStatus().isOK()) {
                this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), (Object)value);
            }
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
            }
            this.readItem();
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    private void readItem() {
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            Object value = workItem.getValue(this.getAttribute());
            this.fLink.setValue(value);
            String aType = this.getAttribute().getAttributeType();
            if ("teamArea".equals(aType) || "projectArea".equals(aType) || "processArea".equals(aType)) {
                if (value != null) {
                    ((Hyperlink)this.fLink.getHyperlink().getControl()).setText(((IProcessArea)value).getName());
                } else {
                    ((Hyperlink)this.fLink.getHyperlink().getControl()).setText("None");
                }
            }
            this.fLink.getLayoutControl().getParent().layout(new Control[]{this.fLink.getHyperlink().getControl()});
            if (this.fClear != null) {
                this.fClear.setEnabled(value != null);
            }
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        if (this.fToolbarManager != null) {
            this.fToolbarManager.dispose();
        }
        super.dispose();
    }
}

