/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledTextViewerSupport;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.SourceViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPart;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.rcp.core.text.StyledDocument;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.editor.DocumentModel;
import com.ibm.team.workitem.ide.ui.internal.editor.SourceViewerSupport;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.FindDuplicatesAction;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemContextProvider;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class HTMLAttributePart
extends AttributePart {
    private static final int MIN_PREFERRED_VISIBLE_LINES = 5;
    private WorkItemWorkingCopy fWorkingCopy;
    private StyledTextViewerSupport fSourceViewerSupport;
    private RequiredPropertyLabel fAttributeName;
    private Control fRequiredPropertyIndicator;
    private ViewerPart fViewerPart;
    private FindDuplicatesAction fFindDuplicatesAction;
    private Composite fContainer;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (HTMLAttributePart.this.fContainer != null && !HTMLAttributePart.this.fContainer.isDisposed()) {
                TeamFormUtil.setVisible((Control)HTMLAttributePart.this.fContainer, visible);
                changedControls.add(HTMLAttributePart.this.fContainer);
            }
            if (HTMLAttributePart.this.fAttributeName != null && !HTMLAttributePart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(HTMLAttributePart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(HTMLAttributePart.this.fAttributeName.getLayoutControl());
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        public void setRequired(boolean required) {
            if (HTMLAttributePart.this.isLabelVisible()) {
                if (HTMLAttributePart.this.fAttributeName != null && !HTMLAttributePart.this.fAttributeName.isDisposed()) {
                    HTMLAttributePart.this.fAttributeName.setRequired(required);
                }
            } else if (HTMLAttributePart.this.fRequiredPropertyIndicator != null && !HTMLAttributePart.this.fRequiredPropertyIndicator.isDisposed()) {
                HTMLAttributePart.this.fRequiredPropertyIndicator.setVisible(required);
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        ViewerPane viewerPane;
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        } else if (this.isSmallSectionLayout() && this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        Composite[] result = Util.multiLineStyledTextBorder(parent, toolkit, this.getBackgroundStyle());
        this.fContainer = result[0];
        Composite border = result[1];
        Util.addWidthHint((Control)this.fContainer);
        formLayout.add((Control)this.fContainer, this.isSmallSectionLayout() ? "content" : "wideContent");
        this.fSourceViewerSupport = SourceViewerSupport.createStyledTextViewerSupport();
        this.fSourceViewerSupport.setMargin(new Point(1, 1));
        this.fSourceViewerSupport.setContentAssistContextProvider((ContentAssistContextProvider)new WorkItemContextProvider(){

            protected WorkItemWorkingCopy getWorkItemWorkingCopy() {
                return HTMLAttributePart.this.fWorkingCopy;
            }
        });
        this.fSourceViewerSupport.init(this.getSite());
        this.fSourceViewerSupport.createContent(border);
        SourceViewer sourceViewer = this.fSourceViewerSupport.getSourceViewer();
        Control control = sourceViewer.getControl();
        this.initAccessible(control);
        GridData data = new GridData(4, 4, true, true);
        control.setLayoutData((Object)data);
        this.setMinHints(true);
        toolkit.adapt(control, false, false);
        this.fSourceViewerSupport.getSourceViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (HTMLAttributePart.this.fWorkingCopy == null) {
                    return;
                }
                WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)HTMLAttributePart.this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                DocumentModel documentModel = uiCopy.getDocumentModel(HTMLAttributePart.this.getAttribute());
                if (documentModel.isDirty()) {
                    XMLString newHtml = documentModel.getDocument().getHTML();
                    HTMLAttributePart.this.fWorkingCopy.getWorkItem().setValue(HTMLAttributePart.this.getAttribute(), (Object)newHtml.getXMLText());
                    documentModel.markClean();
                }
            }
        });
        SourceViewerPane sourceViewerPane = (SourceViewerPane)this.getSite().getAdapter(SourceViewerPane.class);
        if (sourceViewerPane != null) {
            sourceViewerPane.addSourceViewer((ISourceViewer)sourceViewer);
        }
        if ((viewerPane = (ViewerPane)this.getSite().getAdapter(ViewerPane.class)) != null) {
            this.fViewerPart = new ViewerPart((Viewer)sourceViewer, this.getAttribute().getIdentifier());
            viewerPane.addViewerPart(this.fViewerPart);
        }
        if (IWorkItem.DESCRIPTION_PROPERTY.equals(this.getAttribute().getIdentifier())) {
            this.createSectionHeader(parent, toolkit);
        }
        if (this.isReadOnly()) {
            sourceViewer.setEditable(false);
        }
    }

    private void createSectionHeader(Composite parent, WorkItemEditorToolkit toolkit) {
        if (this.getSite().getWorkbenchPage() == null) {
            return;
        }
        Section section = this.findSection(parent);
        if (section == null) {
            return;
        }
        Composite container = new Composite((Composite)section, 0){

            public void setBounds(int x, int y, int width, int height) {
                ExpandableComposite parent = (ExpandableComposite)this.getParent();
                super.setBounds(x, y, parent.getSize().x - x - parent.marginWidth - parent.titleBarTextMarginWidth, height);
            }
        };
        container.setBackground(null);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 0;
        container.setLayout((Layout)layout);
        this.fRequiredPropertyIndicator = RequiredPropertyLabel.createIndicator(container, toolkit, this.getBackgroundStyle());
        this.fRequiredPropertyIndicator.setBackground(null);
        this.fRequiredPropertyIndicator.setVisible(false);
        this.fRequiredPropertyIndicator.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Label spacer = new Label(container, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Control toolBar = this.createToolBar(container, (FormToolkit)toolkit);
        toolBar.setBackground(null);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        section.setTextClient((Control)container);
    }

    private Section findSection(Composite parent) {
        Composite current = parent;
        while (current != null && !(current instanceof Section)) {
            current = current.getParent();
        }
        return (Section)current;
    }

    private Control createToolBar(Composite parent, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        this.fFindDuplicatesAction = new FindDuplicatesAction(this.getSite().getWorkbenchPage());
        toolBarManager.add((IAction)this.fFindDuplicatesAction);
        ToolBar toolbar = toolBarManager.createControl(parent);
        toolkit.adapt((Control)toolbar, false, false);
        return toolbar;
    }

    private boolean isSmallSectionLayout() {
        if (this.getDescriptor() == null || this.getDescriptor().getProperties() == null || this.getDescriptor().getProperties().get("small") == null) {
            return false;
        }
        return "true".equals(this.getDescriptor().getProperties().get("small"));
    }

    public void init(ITeamFormPartSite site) {
        super.init(site);
    }

    public boolean stretchVertically() {
        return true;
    }

    public void setFocus() {
        if (this.fSourceViewerSupport != null && this.fSourceViewerSupport.getSourceViewer() != null && !this.fSourceViewerSupport.getSourceViewer().getTextWidget().isDisposed()) {
            this.fSourceViewerSupport.getSourceViewer().getTextWidget().setFocus();
        }
    }

    public void setInput(Object input) {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            PresentationHandlerManager mgr2;
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            if (this.getSite() != null && (mgr2 = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
                mgr2.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
            }
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            DocumentModel model = uiCopy.getDocumentModel(this.getAttribute());
            this.fSourceViewerSupport.getSourceViewer().setDocument((IDocument)model.getDocument(), model.getAnnotationModel());
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
            }
            this.fSourceViewerSupport.updateBaseURI();
        } else {
            this.fWorkingCopy = null;
            this.fSourceViewerSupport.getSourceViewer().setDocument((IDocument)new StyledDocument(), null);
        }
        if (this.fFindDuplicatesAction != null) {
            this.fFindDuplicatesAction.setInput(this.fWorkingCopy);
        }
    }

    public Control setMinHints(boolean set) {
        StyledText text = this.fSourceViewerSupport.getSourceViewer().getTextWidget();
        Object data = text.getLayoutData();
        if (data instanceof GridData) {
            GridData gridData = (GridData)data;
            if (set) {
                gridData.heightHint = text.getLineHeight() * (this.isSmallSectionLayout() ? 5 : 1);
                gridData.minimumHeight = 0;
            } else {
                gridData.heightHint = -1;
                gridData.minimumHeight = 5 * text.getLineHeight();
            }
        }
        return text;
    }

    public void dispose() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
        if (this.fSourceViewerSupport != null) {
            SourceViewerPane sourceViewerPane = (SourceViewerPane)this.getSite().getAdapter(SourceViewerPane.class);
            if (sourceViewerPane != null) {
                sourceViewerPane.removeSourceViewer((ISourceViewer)this.fSourceViewerSupport.getSourceViewer());
            }
            this.fSourceViewerSupport.dispose();
            this.fSourceViewerSupport = null;
        }
        if (this.fViewerPart != null) {
            ViewerPane viewerPane = (ViewerPane)this.getSite().getAdapter(ViewerPane.class);
            if (viewerPane != null) {
                viewerPane.removeViewerPart(this.fViewerPart);
            }
            this.fViewerPart = null;
        }
        if (this.fFindDuplicatesAction != null) {
            this.fFindDuplicatesAction.dispose();
            this.fFindDuplicatesAction = null;
        }
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }
}

