/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.process.common.IProcessAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.WorkItemWorkingCopyImpl;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.ConfigurationItem;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ILiteral;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.IWorkItemType;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedComboUpdaterJob;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class EnumerationAttributePart
extends AttributePart {
    private IWorkingCopyListener fWorkItemListener = new IWorkingCopyListener(){

        public void workingCopyEvent(WorkingCopyEvent event) {
            if (EnumerationAttributePart.this.fUpdater != null && event.hasType("saved")) {
                EnumerationAttributePart.this.fUpdater.scheduleDefered();
            }
        }
    };
    private WorkItemWorkingCopy fWorkingCopy;
    private DecoratedCombo fCombo;
    private DecoratedComboUpdaterJob fUpdater;
    private RequiredPropertyLabel fAttributeName;
    private boolean fTeamAreaUnchanged = true;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        @Override
        public void setVisible(boolean visible) {
            ArrayList<Control> changedControls = new ArrayList<Control>();
            if (EnumerationAttributePart.this.fAttributeName != null && !EnumerationAttributePart.this.fAttributeName.isDisposed()) {
                TeamFormUtil.setVisible(EnumerationAttributePart.this.fAttributeName.getLayoutControl(), visible);
                changedControls.add(EnumerationAttributePart.this.fAttributeName.getLayoutControl());
            }
            if (EnumerationAttributePart.this.fReadOnlyText != null && !EnumerationAttributePart.this.fReadOnlyText.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(EnumerationAttributePart.this.fReadOnlyText.getLayoutControl(), visible);
                changedControls.add(EnumerationAttributePart.this.fReadOnlyText.getLayoutControl());
            }
            if (EnumerationAttributePart.this.fCombo != null && !EnumerationAttributePart.this.fCombo.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(EnumerationAttributePart.this.fCombo.getLayoutControl(), visible);
                changedControls.add(EnumerationAttributePart.this.fCombo.getLayoutControl());
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        @Override
        public void setRequired(boolean required) {
            if (EnumerationAttributePart.this.fAttributeName != null && !EnumerationAttributePart.this.fAttributeName.isDisposed()) {
                EnumerationAttributePart.this.fAttributeName.setRequired(required);
            }
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            if (EnumerationAttributePart.this.fUpdater != null && EnumerationAttributePart.this.fCombo != null && !EnumerationAttributePart.this.fCombo.getCombo().isDisposed()) {
                EnumerationAttributePart.this.fUpdater.scheduleDefered();
            }
        }

        @Override
        public void setStatus(IStatus status) {
            if (EnumerationAttributePart.this.fCombo == null || EnumerationAttributePart.this.fCombo.getLayoutControl().isDisposed()) {
                return;
            }
            if (status.getSeverity() != 4 && WorkItemAttributes.TYPE.equals((Object)EnumerationAttributePart.this.getDescriptor().getAttributeId())) {
                EnumerationAttributePart.this.updateWarningDecoration();
            } else {
                EnumerationAttributePart.this.fCombo.setStatus(status);
            }
        }

        @Override
        public void attributeChanged(WorkItemChangeEvent event) {
            EnumerationAttributePart.this.readValue();
        }
    };
    private DecoratedFormsText fReadOnlyText;
    private LabelProvider fLabelProvider;

    private void updateWarningDecoration() {
        if (!WorkItemAttributes.TYPE.equals((Object)this.getDescriptor().getAttributeId())) {
            return;
        }
        if (this.typeUnchanged() && this.fTeamAreaUnchanged) {
            this.fCombo.setStatus(Status.OK_STATUS);
            return;
        }
        List<Object> elements = Arrays.asList(this.fCombo.getValueSet());
        Object candidate = this.fCombo.getValue();
        if (!elements.contains(DecoratedComboUpdaterJob.RETRIEVEENTRY) && !elements.contains(candidate) && this.getWarnMessage() != null) {
            this.fCombo.setStatus((IStatus)new Status(2, "com.ibm.team.workitem.ide.ui", this.getWarnMessage()));
        } else {
            this.fCombo.setStatus(Status.OK_STATUS);
        }
    }

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fAttributeName = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fAttributeName.getLayoutControl(), "label");
        }
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)parent);
        this.fLabelProvider = new LabelProvider((ResourceManager)resourceManager){
            private final /* synthetic */ ResourceManager val$resourceManager;
            {
                this.val$resourceManager = resourceManager;
            }

            public String getText(Object element) {
                if (element instanceof ConfigurationItem) {
                    return ((ConfigurationItem)element).getDisplayName();
                }
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof Identifier) {
                    return ((Identifier)element).getStringIdentifier();
                }
                return "";
            }

            public Image getImage(Object element) {
                ImageDescriptor desc = ImagePool.EMPTY;
                if (element instanceof ConfigurationItem && ((ConfigurationItem)element).getIconURL() != null) {
                    desc = WorkItemUI.getImageDescriptor((URL)((ConfigurationItem)element).getIconURL());
                }
                return JazzResources.getImageWithDefault((ResourceManager)this.val$resourceManager, (ImageDescriptor)desc);
            }
        };
        if (this.isReadOnly()) {
            this.fReadOnlyText = new DecoratedFormsText(parent, this.getSite(), 8, 1, this.getBackgroundStyle());
            this.initAccessible((Control)this.fReadOnlyText.getText());
            Util.addWidthHint(this.fReadOnlyText.getLayoutControl());
            formLayout.add(this.fReadOnlyText.getLayoutControl(), "content");
            this.fReadOnlyText.setLabelProvider((ILabelProvider)this.fLabelProvider);
        } else {
            this.fCombo = new DecoratedCombo(parent, 8, 1);
            this.initAccessible((Control)this.fCombo.getCombo());
            toolkit.adapt((DecoratedControl)this.fCombo, true, false, this.getBackgroundStyle());
            Util.addWidthHint(this.fCombo.getLayoutControl());
            formLayout.add(this.fCombo.getLayoutControl(), "content");
            this.fCombo.setLabelProvider((ILabelProvider)this.fLabelProvider);
            this.fCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (EnumerationAttributePart.this.fWorkingCopy != null) {
                        EnumerationAttributePart.this.writeValue();
                    }
                }
            });
            String providerId = this.getValueSetProviderId();
            if (providerId == null) {
                providerId = "com.ibm.team.workitem.common.enumerationValueSetProvider";
            }
            this.fUpdater = new DecoratedComboUpdaterJob(NLS.bind((String)Messages.EnumerationAttributePart_ATTRIBUTE_UPDATE, (Object)this.getAttribute().getDisplayName(), (Object[])new Object[0]), this.fCombo, this.getAttribute().getIdentifier(), providerId){

                public IStatus runInBackground(IProgressMonitor monitor) {
                    EnumerationAttributePart.this.fTeamAreaUnchanged = true;
                    WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy();
                    if (workingCopy != null) {
                        try {
                            EnumerationAttributePart.this.fTeamAreaUnchanged = this.teamAreaUnchanged(monitor);
                        }
                        catch (TeamRepositoryException x) {
                            WorkItemIDEUIPlugin.getDefault().log(Messages.EnumerationAttributePart_EXCEPTION_DETERMINING_TEAM_AREA, x);
                        }
                    }
                    return super.runInBackground(monitor);
                }

                private boolean teamAreaUnchanged(IProgressMonitor monitor) throws TeamRepositoryException {
                    IProcessAreaHandle oldProcessArea;
                    WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.getWorkingCopy();
                    if (workingCopy == null) {
                        return true;
                    }
                    if (workingCopy.getBaseState() == null) {
                        return false;
                    }
                    ITeamRepository teamRepository = workingCopy.getTeamRepository();
                    IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    IProcessAreaHandle newProcessArea = workItemClient.findProcessArea((IWorkItemHandle)workingCopy.getWorkItem(), monitor);
                    return newProcessArea == (oldProcessArea = workItemClient.findProcessArea((IWorkItemHandle)workingCopy.getBaseState(), monitor)) || newProcessArea != null && newProcessArea.sameItemId((IItemHandle)oldProcessArea);
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (EnumerationAttributePart.this.fCombo.getCombo().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    if (this.fValueSet.length == 0) {
                        EnumerationAttributePart.this.fCombo.getCombo().setEnabled(false);
                    } else {
                        EnumerationAttributePart.this.fCombo.getCombo().setEnabled(true);
                    }
                    IStatus status = super.runInUI(monitor);
                    if (status.getSeverity() != 4 && status.getSeverity() != 8) {
                        EnumerationAttributePart.this.updateWarningDecoration();
                    }
                    return status;
                }

                protected WorkItemWorkingCopy getWorkingCopy() {
                    return EnumerationAttributePart.this.fWorkingCopy;
                }
            };
        }
    }

    private Object getIdentifier(Object value) {
        if (value instanceof ILiteral) {
            value = ((ILiteral)value).getIdentifier2();
        }
        if (value instanceof Identifier && IWorkItemType.class.isAssignableFrom(((Identifier)value).getType())) {
            value = ((Identifier)value).getStringIdentifier();
        }
        return value;
    }

    private void writeValue() {
        if (this.fWorkingCopy != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            Object val = this.getIdentifier(this.fCombo.getValue());
            if (DecoratedComboUpdaterJob.RETRIEVEENTRY.equals(val)) {
                this.readValue();
                return;
            }
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            Object currentValue = this.getIdentifier(workItem.getValue(this.getAttribute()));
            if (val == null && currentValue != null || val != null && !val.equals(currentValue)) {
                this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), val);
            }
        }
    }

    private void readValue() {
        Object value = null;
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            try {
                IWorkItemType v;
                WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
                ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
                value = workItem.getValue(this.getAttribute());
                ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                if (this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY) && (v = workItemClient.findWorkItemType(this.fWorkingCopy.getWorkItem().getProjectArea(), (String)value, null)) != null) {
                    value = v;
                }
            }
            catch (TeamRepositoryException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.EnumerationAttributePart_EXCEPTION_RETRIEVING_VALUE, e);
            }
        }
        if (this.fCombo != null) {
            this.fCombo.setValue(value);
            this.updateWarningDecoration();
        } else if (this.fReadOnlyText != null) {
            this.fReadOnlyText.setValue(value);
        }
    }

    public void setFocus() {
        if (this.fCombo != null && !this.fCombo.getCombo().isDisposed()) {
            this.fCombo.getCombo().setFocus();
        } else if (this.fReadOnlyText != null && !this.fReadOnlyText.getLayoutControl().isDisposed()) {
            this.fReadOnlyText.getText().setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.layout();
            }
            if (this.fCombo != null && !this.fCombo.getCombo().isDisposed()) {
                this.fUpdater.scheduleJob();
                this.readValue();
            } else if (this.fReadOnlyText != null && !this.fReadOnlyText.getLayoutControl().isDisposed()) {
                this.readValue();
            }
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr;
        UIWorkItemWorkingCopyListener uiWorkingCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class);
        if (uiWorkingCopyListener != null) {
            uiWorkingCopyListener.addListener(this.fWorkItemListener);
        }
        if ((mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            PresentationDescriptor desc = this.getDescriptor();
            if (this.getAttribute().getIdentifier().equals(IWorkItem.TYPE_PROPERTY)) {
                desc = Util.addDependencies(desc, IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.PROJECT_AREA_PROPERTY, IWorkItem.TARGET_PROPERTY);
            }
            mgr.addPresentationUpdater(this.fPresentationUpdater, desc);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    private void removeListeners() {
        if (this.getSite() != null) {
            PresentationHandlerManager mgr;
            UIWorkItemWorkingCopyListener uiWorkingCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class);
            if (uiWorkingCopyListener != null) {
                uiWorkingCopyListener.removeListener(this.fWorkItemListener);
            }
            if ((mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
                mgr.removePresentationUpdater(this.fPresentationUpdater);
            }
        }
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }

    private boolean typeUnchanged() {
        String oldType;
        WorkItemWorkingCopyImpl workingCopy = (WorkItemWorkingCopyImpl)this.fWorkingCopy;
        if (workingCopy == null) {
            return true;
        }
        if (workingCopy.getBaseState() == null) {
            return false;
        }
        String newType = workingCopy.getWorkItem().getWorkItemType();
        return newType == (oldType = workingCopy.getBaseState().getWorkItemType()) || newType != null && newType.equals(oldType);
    }

    private String getWarnMessage() {
        WorkItemWorkingCopy workingCopy = this.fWorkingCopy;
        if (workingCopy != null && workingCopy.getWorkItem().isNewItem()) {
            return Messages.EnumerationAttributePart_NO_PERMISSION_CREATE_TYPE;
        }
        if (!this.typeUnchanged()) {
            return Messages.EnumerationAttributePart_NO_PERMISSION_CHANGE_TYPE;
        }
        return Messages.EnumerationAttributePart_NO_PERMISSION_REASSIGNING;
    }
}

