/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormConfiguration;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.DeliverableWorkingCopy;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.DecoratedHistoryCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class DeliverableAttributePart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private StandardControlLabelProvider fLabeledHyperlink;
    private RequiredPropertyLabel fHyperlinkRequired;
    private DecoratedHistoryCombo fDeliverableCombo;
    private List<Control> fVisibleControls = new ArrayList<Control>();
    private Label fAttributeName;
    private StandardControlLabelProvider fROLabeledHyperlink;
    private Label fNoContributorLabel;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        @Override
        public void setVisible(boolean visible) {
            ArrayList<Control> changedControls = new ArrayList<Control>();
            for (Control c : DeliverableAttributePart.this.fVisibleControls) {
                if (c.isDisposed()) continue;
                TeamFormUtil.setVisible(c, visible);
                changedControls.add(c);
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        @Override
        public void setRequired(boolean required) {
            if (DeliverableAttributePart.this.fHyperlinkRequired != null && !DeliverableAttributePart.this.fHyperlinkRequired.isDisposed()) {
                DeliverableAttributePart.this.fHyperlinkRequired.setRequired(required);
            }
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            if (DeliverableAttributePart.this.fDeliverableCombo != null && !DeliverableAttributePart.this.fDeliverableCombo.getLayoutControl().isDisposed()) {
                DeliverableAttributePart.this.fDeliverableCombo.scheduleJob();
            }
        }

        @Override
        public void attributeChanged(WorkItemChangeEvent event) {
            DeliverableAttributePart.this.readDeliverable();
        }

        @Override
        public void setStatus(IStatus status) {
            if (DeliverableAttributePart.this.fDeliverableCombo != null && !DeliverableAttributePart.this.fDeliverableCombo.getLayoutControl().isDisposed()) {
                DeliverableAttributePart.this.fDeliverableCombo.setStatus(status);
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof IDeliverable) {
                    return ((IDeliverable)element).getName();
                }
                return IWorkItem.UNASSIGNED_FOUND_IN_NAME;
            }
        };
        if (this.isReadOnly()) {
            this.fAttributeName = toolkit.createLabel(parent, "", 0, this.getBackgroundStyle());
            this.fVisibleControls.add((Control)this.fAttributeName);
            formLayout.add((Control)this.fAttributeName, "label");
            Composite rOContainer = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
            this.fVisibleControls.add((Control)rOContainer);
            TeamFormLayouts.setLayoutData((Control)rOContainer, (ITeamFormData)ITeamFormData.HYPERLINK.maxOffset(ITeamFormData.LABEL).maxVertOffset(ITeamFormData.LABEL));
            Util.addWidthHint((Control)rOContainer);
            formLayout.add((Control)rOContainer, "content");
            ITeamFormLayout innerLayout = TeamFormLayouts.createLayout((Composite)rOContainer, (ITeamFormConfiguration)ITeamFormConfiguration.EMPTY_CONFIGURATION);
            this.fROLabeledHyperlink = toolkit.createDecoratedHyperlink((TeamFormPart)this, rOContainer, null, this.getBackgroundStyle());
            this.fROLabeledHyperlink.setLabelProvider((IViewerLabelProvider)new StandardLabelProvider((ILabelProvider)labelProvider, (IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
            this.fROLabeledHyperlink.setForegroundAware(false);
            TeamFormLayouts.setLayoutData((Control)this.fROLabeledHyperlink.getControl(), (ITeamFormData)ITeamFormData.HYPERLINK);
            innerLayout.add(this.fROLabeledHyperlink.getControl(), "release", ITeamFormData.HYPERLINK.setIgnore(true));
            this.fNoContributorLabel = toolkit.createLabel(rOContainer, Messages.DeliverableAttributePart_NONE_DELIVERABLE, 0, this.getBackgroundStyle());
            this.fNoContributorLabel.setForeground(toolkit.getColors().getForeground());
            TeamFormLayouts.setLayoutData((Control)this.fNoContributorLabel, (ITeamFormData)ITeamFormData.LABEL);
            innerLayout.add((Control)this.fNoContributorLabel, "release");
        } else {
            Composite container = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
            this.fVisibleControls.add((Control)container);
            formLayout.add((Control)container, "label", ITeamFormData.HYPERLINK);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.horizontalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            container.setLayout((Layout)gl);
            this.fLabeledHyperlink = toolkit.createDecoratedHyperlink((TeamFormPart)this, container, null, this.getBackgroundStyle());
            this.fLabeledHyperlink.setTextAware(false);
            this.fLabeledHyperlink.setForegroundAware(false);
            Hyperlink link = (Hyperlink)this.fLabeledHyperlink.getControl();
            link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.fHyperlinkRequired = new RequiredPropertyLabel(container, toolkit, this.getBackgroundStyle());
            this.fHyperlinkRequired.setText(NLS.bind((String)ATTRNAME_COLON, (Object)"", (Object[])new Object[0]));
            GridData gd = new GridData(4, 0x1000000, true, false, 1, 1);
            this.fHyperlinkRequired.getLayoutControl().setLayoutData((Object)gd);
            this.fDeliverableCombo = new DecoratedHistoryCombo(parent, 8, 0, this.getAttribute(), this.getValueSetProviderId());
            this.initAccessible((Control)this.fDeliverableCombo.getCombo());
            this.fVisibleControls.add(this.fDeliverableCombo.getLayoutControl());
            toolkit.adapt((DecoratedControl)this.fDeliverableCombo, true, false, this.getBackgroundStyle());
            Util.addWidthHint(this.fDeliverableCombo.getLayoutControl());
            formLayout.add(this.fDeliverableCombo.getLayoutControl(), "content");
            this.fDeliverableCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (DeliverableAttributePart.this.fWorkingCopy != null) {
                        DeliverableAttributePart.this.writeDeliverable();
                    }
                }
            });
            this.fDeliverableCombo.setElementComparer((IElementComparer)new ItemComparer());
            this.fDeliverableCombo.setSorter(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof String && o2 instanceof String) {
                        return Collator.getInstance().compare((String)o1, (String)o2);
                    }
                    if (o1 == null) {
                        return -1;
                    }
                    if (o2 == null) {
                        return 1;
                    }
                    if (!(o1 instanceof IDeliverable)) {
                        return 1;
                    }
                    if (!(o2 instanceof IDeliverable)) {
                        return -1;
                    }
                    IDeliverable d1 = (IDeliverable)o1;
                    IDeliverable d2 = (IDeliverable)o2;
                    return DeliverableWorkingCopy.compare((IDeliverable)d1, (IDeliverable)d2);
                }
            });
            this.fDeliverableCombo.setLabelProvider((ILabelProvider)labelProvider);
        }
    }

    private void writeDeliverable() {
        Object value = this.fDeliverableCombo.getValue();
        if (DecoratedHistoryCombo.RETRIEVEENTRY.equals(value)) {
            this.readDeliverable();
            return;
        }
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
        if (!this.equalItems((IItemHandle)value, (IItemHandle)workItem.getValue(this.getAttribute()))) {
            this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), value);
        }
    }

    private void readDeliverable() {
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            Object value = workItem.getValue(this.getAttribute());
            if (this.fDeliverableCombo != null && !this.fDeliverableCombo.getLayoutControl().isDisposed()) {
                this.fDeliverableCombo.setValue(value);
                this.fLabeledHyperlink.setElement(value);
            }
            if (this.fROLabeledHyperlink != null && !this.fROLabeledHyperlink.getControl().isDisposed()) {
                boolean showLink = value != null;
                Control linkControl = this.fROLabeledHyperlink.getControl();
                this.show(linkControl, showLink);
                this.show((Control)this.fNoContributorLabel, !showLink);
                this.fROLabeledHyperlink.setElement(value);
                linkControl.getParent().getParent().layout(true, true);
            }
        }
    }

    private void show(Control control, boolean show) {
        ITeamFormData layoutData = TeamFormLayouts.getLayoutData((Control)control);
        TeamFormLayouts.setLayoutData((Control)control, (ITeamFormData)layoutData.setIgnore(!show));
        control.setVisible(show);
    }

    private boolean equalItems(IItemHandle first, IItemHandle second) {
        if (first == second) {
            return true;
        }
        return first != null && first.sameItemId(second);
    }

    public void setFocus() {
        if (this.fDeliverableCombo != null && !this.fDeliverableCombo.getCombo().isDisposed()) {
            this.fDeliverableCombo.getCombo().setFocus();
        }
        if (this.fROLabeledHyperlink != null && !this.fROLabeledHyperlink.getControl().isDisposed()) {
            this.fROLabeledHyperlink.getControl().setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            this.initializeDeliverable();
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void initializeDeliverable() {
        if (this.fDeliverableCombo != null && !this.fDeliverableCombo.getLayoutControl().isDisposed()) {
            this.fDeliverableCombo.setWorkItem(this.fWorkingCopy.getWorkItem());
            this.fDeliverableCombo.scheduleJob();
        }
        if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
            this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
            this.fAttributeName.getParent().layout(new Control[]{this.fAttributeName});
        }
        this.readDeliverable();
        if (this.fLabeledHyperlink != null && !this.fLabeledHyperlink.getControl().isDisposed()) {
            ((Hyperlink)this.fLabeledHyperlink.getControl()).setText(this.getLabel());
            this.fLabeledHyperlink.getControl().getParent().getParent().layout(new Control[]{this.fLabeledHyperlink.getControl()});
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }
}

