/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.StandardControlLabelProvider;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormConfiguration;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedComboUpdaterJob;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IViewerLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ContributorAttributePart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private Label fAttributeName;
    private StandardControlLabelProvider fROLabeledHyperlink;
    private Label fNoContributorLabel;
    private MoreAwareDecoratedCombo fCombo;
    private DecoratedComboUpdaterJob fUpdater;
    private StandardControlLabelProvider fLabeledHyperlink;
    private RequiredPropertyLabel fHyperlinkRequired;
    private StandardControlLabelProvider fLabeledCombo;
    private List<Control> fVisibleControls = new ArrayList<Control>();
    private Object[] fAllValues;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        @Override
        public void setVisible(boolean visible) {
            ArrayList<Control> changedControls = new ArrayList<Control>();
            for (Control c : ContributorAttributePart.this.fVisibleControls) {
                if (c.isDisposed()) continue;
                TeamFormUtil.setVisible(c, visible);
                changedControls.add(c);
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        @Override
        public void setRequired(boolean required) {
            if (ContributorAttributePart.this.fHyperlinkRequired != null && !ContributorAttributePart.this.fHyperlinkRequired.isDisposed()) {
                ContributorAttributePart.this.fHyperlinkRequired.setRequired(required);
            }
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            if (ContributorAttributePart.this.isReadOnly()) {
                ContributorAttributePart.this.setContributor();
            } else if (ContributorAttributePart.this.fCombo != null && !ContributorAttributePart.this.fCombo.getCombo().isDisposed()) {
                ContributorAttributePart.this.fUpdater.scheduleDefered();
            }
        }

        @Override
        public void attributeChanged(WorkItemChangeEvent event) {
            if (ContributorAttributePart.this.isReadOnly()) {
                ContributorAttributePart.this.setContributor();
            } else {
                ContributorAttributePart.this.readValue();
            }
        }

        @Override
        public void setStatus(IStatus status) {
            if (ContributorAttributePart.this.fCombo != null) {
                if (status.isOK()) {
                    ContributorAttributePart.this.updateWarningDecoration();
                } else {
                    ContributorAttributePart.this.fCombo.setStatus(status);
                }
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isReadOnly()) {
            this.fAttributeName = toolkit.createLabel(parent, "", 0, this.getBackgroundStyle());
            this.fVisibleControls.add((Control)this.fAttributeName);
            formLayout.add((Control)this.fAttributeName, "label");
            Composite rOContainer = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
            this.fVisibleControls.add((Control)rOContainer);
            TeamFormLayouts.setLayoutData((Control)rOContainer, (ITeamFormData)ITeamFormData.HYPERLINK.maxOffset(ITeamFormData.LABEL));
            Util.addWidthHint((Control)rOContainer);
            formLayout.add((Control)rOContainer, "content");
            ITeamFormLayout innerLayout = TeamFormLayouts.createLayout((Composite)rOContainer, (ITeamFormConfiguration)ITeamFormConfiguration.EMPTY_CONFIGURATION);
            this.fROLabeledHyperlink = toolkit.createDecoratedHyperlink((TeamFormPart)this, rOContainer, null, this.getBackgroundStyle());
            this.fROLabeledHyperlink.setLabelProvider((IViewerLabelProvider)new StandardLabelProvider((ILabelProvider)new LabelProvider(), (IElementRemovedNotifier)new ElementRemovedNotifierImpl()));
            innerLayout.add(this.fROLabeledHyperlink.getControl(), "contributor", ITeamFormData.HYPERLINK.setIgnore(true));
            this.fNoContributorLabel = toolkit.createLabel(rOContainer, Messages.ContributorAttributePart_NONE, 0, this.getBackgroundStyle());
            this.fNoContributorLabel.setForeground(toolkit.getColors().getForeground());
            innerLayout.add((Control)this.fNoContributorLabel, "contributor");
        } else {
            Composite user = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
            this.fVisibleControls.add((Control)user);
            formLayout.add((Control)user, "label", ITeamFormData.HYPERLINK);
            GridLayout gl = new GridLayout();
            gl.numColumns = 2;
            gl.horizontalSpacing = 0;
            gl.marginWidth = 0;
            gl.marginHeight = 0;
            user.setLayout((Layout)gl);
            this.fLabeledHyperlink = toolkit.createDecoratedHyperlink((TeamFormPart)this, user, null, this.getBackgroundStyle());
            this.fLabeledHyperlink.setTextAware(false);
            Hyperlink link = (Hyperlink)this.fLabeledHyperlink.getControl();
            link.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
            this.fHyperlinkRequired = new RequiredPropertyLabel(user, toolkit, this.getBackgroundStyle());
            this.fHyperlinkRequired.setText(Messages.ContributorAttributePart_COLON_AFTER_CONTRIBUTOR_LINK);
            GridData gd = new GridData(4, 0x1000000, true, false, 1, 1);
            this.fHyperlinkRequired.getLayoutControl().setLayoutData((Object)gd);
            this.fCombo = new MoreAwareDecoratedCombo(parent, 12, 0);
            this.initAccessible((Control)this.fCombo.getCombo());
            this.fVisibleControls.add(this.fCombo.getLayoutControl());
            toolkit.adapt((DecoratedControl)this.fCombo, true, false, this.getBackgroundStyle());
            Util.addWidthHint(this.fCombo.getLayoutControl());
            formLayout.add(this.fCombo.getLayoutControl(), "content");
            this.fCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (ContributorAttributePart.this.fWorkingCopy != null) {
                        ContributorAttributePart.this.writeValue();
                    }
                }
            });
            this.fCombo.setElementComparer((IElementComparer)new ItemComparer());
            this.fCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element == null) {
                        return DefaultModel.NULL_CONTRIBUTOR_NAME;
                    }
                    if (element instanceof String) {
                        return (String)element;
                    }
                    return String.valueOf(((IContributor)element).getName()) + (((IContributor)element).isArchived() ? Messages.ContributorAttributePart_ARCHIVED : "");
                }
            });
            this.fCombo.setSorter(new ContributorComparator());
            this.fLabeledCombo = new StandardControlLabelProvider((Control)this.fCombo.getCombo());
            this.fLabeledCombo.setForegroundAware(true);
            this.fUpdater = new DecoratedComboUpdaterJob(NLS.bind((String)Messages.ContributorAttributePart_ATTRIBUTE_UPDATE, (Object)this.getAttribute().getIdentifier(), (Object[])new Object[0]), this.fCombo, this.getAttribute().getIdentifier(), this.getValueSetProviderId()){

                protected WorkItemWorkingCopy getWorkingCopy() {
                    return ContributorAttributePart.this.fWorkingCopy;
                }

                public IStatus runInUI(IProgressMonitor monitor) {
                    if (ContributorAttributePart.this.fCombo.getCombo().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    ContributorAttributePart.this.fCombo.setNullValue(this.fNullValue);
                    ContributorAttributePart.this.fAllValues = this.fValueSet;
                    ContributorAttributePart.this.setComboValues(this.fValueSet);
                    return Status.OK_STATUS;
                }
            };
        }
    }

    private void setContributor() {
        Object value = null;
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            value = workItem.getValue(this.getAttribute());
        }
        boolean showLink = value != null && (!(value instanceof IContributor) || !((IContributor)value).getItemId().equals((Object)DefaultModel.NULL_CONTRIBUTOR_ITEM_ID));
        Control linkControl = this.fROLabeledHyperlink.getControl();
        this.show(linkControl, showLink);
        this.show((Control)this.fNoContributorLabel, !showLink);
        this.fROLabeledHyperlink.setElement(value);
        linkControl.getParent().getParent().layout(true, true);
    }

    private void show(Control control, boolean show) {
        ITeamFormData layoutData = TeamFormLayouts.getLayoutData((Control)control);
        TeamFormLayouts.setLayoutData((Control)control, (ITeamFormData)layoutData.setIgnore(!show));
        control.setVisible(show);
    }

    private void setComboValues(Object[] valueSet) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(valueSet));
        Collections.sort(list, new ContributorComparator());
        Iterator<Object> it = list.iterator();
        while (it.hasNext()) {
            Object cand = it.next();
            if (!(cand instanceof IContributor) || !((IContributor)cand).isArchived()) continue;
            it.remove();
        }
        int size = list.size();
        if (list.size() > 25) {
            size = 25;
        }
        Object[] result = new Object[size + 1];
        int i = 0;
        while (i < size) {
            result[i] = list.get(i);
            ++i;
        }
        result[size] = MoreAwareDecoratedCombo.MOREDIALOGENTRY;
        this.fCombo.setValueSet(result);
        this.updateWarningDecoration();
    }

    private void updateWarningDecoration() {
        List<Object> elements = this.fAllValues == null ? Arrays.asList(this.fCombo.getValueSet()) : Arrays.asList(this.fAllValues);
        Object candidate = this.fCombo.getValue();
        if (!elements.isEmpty() && !elements.contains(candidate) && this.getWarnMessage() != null) {
            this.fCombo.setStatus((IStatus)new Status(2, "com.ibm.team.workitem.ide.ui", this.getWarnMessage()));
        } else {
            this.fCombo.setStatus(Status.OK_STATUS);
        }
    }

    private String getWarnMessage() {
        String message = null;
        if (this.getDescriptor().getProperties() != null) {
            message = (String)this.getDescriptor().getProperties().get("warningMessage");
        }
        return message;
    }

    private void writeValue() {
        if (this.fWorkingCopy != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            Object value = this.fCombo.getValue();
            if (value == null) {
                return;
            }
            if (value instanceof String) {
                if (MoreAwareDecoratedCombo.MOREDIALOGENTRY.equals(value)) {
                    this.createUserDialog();
                } else if (DecoratedComboUpdaterJob.RETRIEVEENTRY.equals(value)) {
                    this.readValue();
                }
                return;
            }
            IContributor contrib = (IContributor)value;
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            Object val = workItem.getValue(this.getAttribute());
            if (!(val instanceof IContributor) || !this.equalItems((IItemHandle)contrib, (IItemHandle)((IContributor)val))) {
                this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), (Object)contrib);
            }
            this.setComboValues(this.fCombo.getValueSet());
        }
    }

    private boolean equalItems(IItemHandle first, IItemHandle second) {
        if (first == second) {
            return true;
        }
        return first != null && first.sameItemId(second);
    }

    private void readValue() {
        Object value = null;
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            value = workItem.getValue(this.getAttribute());
        }
        this.fCombo.setValue(value);
        this.fLabeledCombo.setElement(value);
        this.fLabeledHyperlink.setElement(value);
    }

    private void initializeContributor() {
        this.fUpdater.scheduleJob();
        this.readValue();
        ((Hyperlink)this.fLabeledHyperlink.getControl()).setText(this.getLabel());
        this.fLabeledHyperlink.getControl().getParent().getParent().layout(new Control[]{this.fLabeledHyperlink.getControl()});
    }

    private void createUserDialog() {
        TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(this.fCombo.getCombo().getShell(), this.fWorkingCopy.getTeamRepository(), Collections.EMPTY_LIST, false);
        dialog.setTitle(Messages.ContributorAttributePart_SELECT_USER);
        dialog.setShellTitle(Messages.ContributorAttributePart_SELECT_USER);
        dialog.setMessage(Messages.ContributorAttributePart_SELECT_USER_MESSAGE);
        if (dialog.open() != 0) {
            this.readValue();
            return;
        }
        Object[] results = dialog.getResult();
        if (results.length == 0 || !(results[0] instanceof IContributorHandle)) {
            this.readValue();
            return;
        }
        IContributorHandle owner = (IContributorHandle)results[0];
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
        Object val = workItem.getValue(this.getAttribute());
        if (!(val instanceof IContributor) || !this.equalItems((IItemHandle)owner, (IItemHandle)((IContributor)val))) {
            this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), (Object)owner);
        } else {
            this.fCombo.setValue(val);
        }
        this.setComboValues(this.fCombo.getValueSet());
    }

    public void setFocus() {
        if (!this.isReadOnly() && this.fCombo != null && !this.fCombo.getCombo().isDisposed()) {
            this.fCombo.getCombo().setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fAttributeName != null && !this.fAttributeName.isDisposed()) {
                this.fAttributeName.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fAttributeName.getParent().layout(new Control[]{this.fAttributeName});
                this.setContributor();
            } else if (this.fLabeledHyperlink != null && !this.fLabeledHyperlink.getControl().isDisposed()) {
                this.initializeContributor();
            }
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContributorComparator
    implements Comparator<Object> {
        private ContributorComparator() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            if (!(o1 instanceof IContributor)) {
                return 1;
            }
            if (!(o2 instanceof IContributor)) {
                return -1;
            }
            if (((IContributor)o1).getItemId().equals((Object)DefaultModel.NULL_CONTRIBUTOR_ITEM_ID)) {
                return -1;
            }
            if (((IContributor)o2).getItemId().equals((Object)DefaultModel.NULL_CONTRIBUTOR_ITEM_ID)) {
                return 1;
            }
            String name1 = ((IContributor)o1).getName();
            String name2 = ((IContributor)o2).getName();
            return Collator.getInstance().compare(name1, name2);
        }
    }

    private static class MoreAwareDecoratedCombo
    extends DecoratedCombo {
        public static final String MOREDIALOGENTRY = Messages.ContributorAttributePart_MORE;

        public MoreAwareDecoratedCombo(Composite parent, int style, int options) {
            super(parent, style, options);
        }

        public Object[] getValueSet() {
            Object[] input;
            ArrayList<Object> result = new ArrayList<Object>();
            Object[] objectArray = input = super.getValueSet();
            int n = input.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                if (!MOREDIALOGENTRY.equals(o) && !DecoratedComboUpdaterJob.RETRIEVEENTRY.equals(o)) {
                    result.add(o);
                }
                ++n2;
            }
            return result.toArray();
        }
    }
}

