/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.icu.text.Collator;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormData;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.ui.editor.TeamFormLayouts;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.util.ResolvedWorkItem;
import com.ibm.team.workitem.common.internal.model.DefaultModel;
import com.ibm.team.workitem.common.internal.util.CategoriesHelper;
import com.ibm.team.workitem.common.model.CategoryId;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.ICategoryHandle;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedFormsText;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.DecoratedHistoryCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.AttributePart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.RequiredPropertyLabel;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.TeamFormUtil;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import com.ibm.team.workitem.rcp.ui.internal.viewer.ItemComparer;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.IWorkbenchWindow;

public class CategoryAttributePart
extends AttributePart {
    private WorkItemWorkingCopy fWorkingCopy;
    private DecoratedHistoryCombo fCategoryCombo;
    private IWorkingCopyListener fWorkItemListener = new WorkItemListener();
    private RequiredPropertyLabel fCategory;
    private DecoratedFormsText fReadOnlyText;
    private ToolItem fGuessButton;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        @Override
        public void setVisible(boolean visible) {
            ArrayList<Object> changedControls = new ArrayList<Object>();
            if (CategoryAttributePart.this.fCategory != null && !CategoryAttributePart.this.fCategory.isDisposed()) {
                TeamFormUtil.setVisible(CategoryAttributePart.this.fCategory.getLayoutControl(), visible);
                changedControls.add(CategoryAttributePart.this.fCategory.getLayoutControl());
            }
            if (CategoryAttributePart.this.fCategoryCombo != null && !CategoryAttributePart.this.fCategoryCombo.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible((Control)CategoryAttributePart.this.fCategoryCombo.getLayoutControl().getParent(), visible);
                changedControls.add(CategoryAttributePart.this.fCategoryCombo.getLayoutControl().getParent());
            }
            if (CategoryAttributePart.this.fReadOnlyText != null && !CategoryAttributePart.this.fReadOnlyText.getLayoutControl().isDisposed()) {
                TeamFormUtil.setVisible(CategoryAttributePart.this.fReadOnlyText.getLayoutControl(), visible);
                changedControls.add(CategoryAttributePart.this.fReadOnlyText.getLayoutControl());
            }
            Util.updateFormLayout(changedControls.toArray(new Control[changedControls.size()]));
        }

        @Override
        public void setRequired(boolean required) {
            if (CategoryAttributePart.this.fCategory != null && !CategoryAttributePart.this.fCategory.isDisposed()) {
                CategoryAttributePart.this.fCategory.setRequired(required);
            }
        }

        @Override
        public void setStatus(IStatus status) {
            if (CategoryAttributePart.this.fCategoryCombo != null) {
                CategoryAttributePart.this.fCategoryCombo.setStatus(status);
            }
        }

        @Override
        public void attributeChanged(WorkItemChangeEvent event) {
            CategoryAttributePart.this.readCategory();
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            if (CategoryAttributePart.this.fCategoryCombo != null && !CategoryAttributePart.this.fCategoryCombo.getCombo().isDisposed()) {
                CategoryAttributePart.this.fCategoryCombo.scheduleJob();
            }
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            this.fCategory = new RequiredPropertyLabel(parent, toolkit, this.getBackgroundStyle());
            formLayout.add(this.fCategory.getLayoutControl(), "label");
        }
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object element) {
                if (element == null) {
                    return DefaultModel.NULL_CATEGORY_NAME;
                }
                if (element instanceof String) {
                    return (String)element;
                }
                if (element instanceof CategoryId) {
                    return CategoriesHelper.getHierarchicalName((CategoryId)((CategoryId)element));
                }
                ICategory category = (ICategory)element;
                String name = CategoriesHelper.getHierarchicalName((CategoryId)category.getCategoryId());
                if (name.equals("")) {
                    return category.getName();
                }
                return name;
            }
        };
        if (this.isReadOnly()) {
            this.fReadOnlyText = new DecoratedFormsText(parent, this.getSite(), 8, 4, this.getBackgroundStyle());
            this.initAccessible((Control)this.fReadOnlyText.getText());
            Util.addWidthHint(this.fReadOnlyText.getLayoutControl());
            formLayout.add(this.fReadOnlyText.getLayoutControl(), "content");
            this.fReadOnlyText.setLabelProvider((ILabelProvider)labelProvider);
            new TooltipSupport((Control)this.fReadOnlyText.getText(), true, false){

                protected Object mapElement(int x, int y) {
                    return CategoryAttributePart.this.fReadOnlyText.getValue();
                }
            };
        } else {
            Composite container = toolkit.createComposite(parent, 0, this.getBackgroundStyle());
            GridLayout layout = new GridLayout(2, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.horizontalSpacing = 0;
            container.setLayout((Layout)layout);
            this.fCategoryCombo = new DecoratedHistoryCombo(container, 8, 0, this.getAttribute(), this.getValueSetProviderId()){

                protected Object getDefaultValue(IProgressMonitor monitor) {
                    return this.getCachedDefaultValue();
                }

                public Object getCachedDefaultValue() {
                    if (CategoryAttributePart.this.fWorkingCopy != null) {
                        Object[] objectArray = CategoryAttributePart.this.fCategoryCombo.getFullValueSet();
                        int n = objectArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            WorkItemUIWorkingCopy uiCopy;
                            ResolvedWorkItem workItem;
                            Object o = objectArray[n2];
                            if (o instanceof ICategory && ((ICategory)o).sameItemId((IItemHandle)((ICategory)(workItem = (uiCopy = (WorkItemUIWorkingCopy)CategoryAttributePart.this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class)).getResolvedWorkItem()).getValue(CategoryAttributePart.this.getAttribute())))) {
                                return o;
                            }
                            ++n2;
                        }
                    }
                    return null;
                }
            };
            toolkit.adapt((DecoratedControl)this.fCategoryCombo, true, false, this.getBackgroundStyle());
            Util.addWidthHint(this.fCategoryCombo.getLayoutControl());
            ITeamFormData layoutData = TeamFormLayouts.getLayoutData((Control)this.fCategoryCombo.getLayoutControl()).maxVertOffset(ITeamFormData.BUTTON);
            TeamFormLayouts.setLayoutData((Control)container, (ITeamFormData)layoutData);
            formLayout.add((Control)container, "content");
            this.fCategoryCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            int comboSize = WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getInt("com.ibm.team.workitem.ide.ui.CategorySelectionHistory.size") + 3;
            comboSize = Math.min(comboSize, 30);
            this.fCategoryCombo.getCombo().setVisibleItemCount(comboSize);
            new TooltipSupport((Control)this.fCategoryCombo.getCombo(), true, false){

                protected Object mapElement(int x, int y) {
                    return CategoryAttributePart.this.fCategoryCombo.getValue();
                }
            };
            this.fCategoryCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (CategoryAttributePart.this.fWorkingCopy != null) {
                        CategoryAttributePart.this.writeCategory();
                    }
                }
            });
            this.fCategoryCombo.setElementComparer((IElementComparer)new ItemComparer());
            this.fCategoryCombo.setLabelProvider((ILabelProvider)labelProvider);
            this.fCategoryCombo.setSorter(new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    if (o1 instanceof String && o2 instanceof String) {
                        return Collator.getInstance().compare((String)o1, (String)o2);
                    }
                    if (!(o1 instanceof ICategory)) {
                        return 1;
                    }
                    if (!(o2 instanceof ICategory)) {
                        return -1;
                    }
                    ICategory category1 = (ICategory)o1;
                    ICategory category2 = (ICategory)o2;
                    if (category1.isUnassigned()) {
                        return -1;
                    }
                    if (category2.isUnassigned()) {
                        return 1;
                    }
                    return category1.getCategoryId().compareTo(category2.getCategoryId());
                }
            });
            LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)container);
            ToolBar toolBar = new ToolBar(container, 0x800000);
            toolkit.adapt((Composite)toolBar, this.getBackgroundStyle());
            toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
            this.fGuessButton = new ToolItem(toolBar, 8);
            this.fGuessButton.setToolTipText(Messages.CategoryAttributePart_GUESS_CATEGORY);
            Image image = JazzResources.getImageWithDefault((ResourceManager)resourceManager, (ImageDescriptor)ImagePool.GUESS_CATEGORY);
            this.fGuessButton.setImage(image);
            this.fGuessButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CategoryAttributePart.this.fGuessButton.setEnabled(false);
                    final ICategory[] result = new ICategory[1];
                    try {
                        ((IWorkbenchWindow)CategoryAttributePart.this.getSite().getAdapter(IWorkbenchWindow.class)).run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    IAuditableClient auditableClient = (IAuditableClient)CategoryAttributePart.this.fWorkingCopy.getTeamRepository().getClientLibrary(IAuditableClient.class);
                                    IWorkItemClient workItemClient = (IWorkItemClient)CategoryAttributePart.this.fWorkingCopy.getTeamRepository().getClientLibrary(IWorkItemClient.class);
                                    ICategoryHandle categoryHandle = workItemClient.guessCategory(CategoryAttributePart.this.fWorkingCopy.getWorkItem(), monitor);
                                    result[0] = categoryHandle != null ? (ICategory)auditableClient.resolveAuditable((IAuditableHandle)categoryHandle, ICategory.DEFAULT_PROFILE, monitor) : null;
                                }
                                catch (TeamRepositoryException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException invocationTargetException) {
                    }
                    catch (InterruptedException interruptedException) {}
                    if (result[0] instanceof ICategory) {
                        CategoryAttributePart.this.fCategoryCombo.setValue(result[0]);
                    } else {
                        MessageDialog.openInformation((Shell)CategoryAttributePart.this.fGuessButton.getDisplay().getActiveShell(), (String)Messages.CategoryAttributePart_NO_CATEGORY_FOUND, (String)Messages.CategoryAttributePart_NO_CATEGORY_FOUND_MESSAGE);
                    }
                    CategoryAttributePart.this.fGuessButton.setEnabled(true);
                }
            });
        }
    }

    private void writeCategory() {
        Object value = this.fCategoryCombo.getValue();
        if (value != null && ("DecoratedHistoryCombo.dialog_canceled".equals(value) || DecoratedHistoryCombo.RETRIEVEENTRY.equals(value) || !(value instanceof ICategory))) {
            this.readCategory();
            return;
        }
        ICategory category = (ICategory)value;
        WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
        if (!this.equalItems((IItemHandle)category, (IItemHandle)((ICategory)workItem.getValue(this.getAttribute())))) {
            this.fWorkingCopy.getWorkItem().setValue(this.getAttribute(), (Object)category);
        }
    }

    private boolean equalItems(IItemHandle first, IItemHandle second) {
        if (first == second) {
            return true;
        }
        return first != null && first.sameItemId(second);
    }

    private void readCategory() {
        if (this.fWorkingCopy != null && this.getAttribute() != null && this.fWorkingCopy.getWorkItem().hasAttribute(this.getAttribute())) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            ResolvedWorkItem workItem = uiCopy.getResolvedWorkItem();
            Object value = workItem.getValue(this.getAttribute());
            if (this.fCategoryCombo != null && !this.fCategoryCombo.getLayoutControl().isDisposed()) {
                this.fCategoryCombo.setValue(value);
            }
            if (this.fReadOnlyText != null && !this.fReadOnlyText.getLayoutControl().isDisposed()) {
                this.fReadOnlyText.setValue(value);
            }
        }
    }

    public void setFocus() {
        if (this.fCategoryCombo != null && !this.fCategoryCombo.getCombo().isDisposed()) {
            this.fCategoryCombo.getCombo().setFocus();
        }
        if (this.fReadOnlyText != null && !this.fReadOnlyText.getLayoutControl().isDisposed()) {
            this.fReadOnlyText.getText().setFocus();
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved() && this.getAttribute() != null) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            if (this.fCategoryCombo != null && !this.fCategoryCombo.getLayoutControl().isDisposed()) {
                this.fCategoryCombo.setWorkItem(this.fWorkingCopy.getWorkItem());
                this.fCategoryCombo.scheduleJob();
                if (!this.fWorkingCopy.isDirty() && this.fWorkingCopy.getWorkItem().isNewItem()) {
                    this.fGuessButton.setEnabled(false);
                }
            }
            this.readCategory();
            if (this.fCategory != null && !this.fCategory.isDisposed()) {
                this.fCategory.setText(NLS.bind((String)ATTRNAME_COLON, (Object)this.getLabel(), (Object[])new Object[0]));
                this.fCategory.layout();
            }
        } else {
            this.fWorkingCopy = null;
        }
    }

    private void addListeners() {
        UIWorkItemWorkingCopyListener uiWorkingCopyListener;
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            mgr.addPresentationUpdater(this.fPresentationUpdater, this.getDescriptor());
        }
        if ((uiWorkingCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class)) != null) {
            uiWorkingCopyListener.addListener(this.fWorkItemListener);
        }
    }

    private void removeListeners() {
        if (this.getSite() != null) {
            UIWorkItemWorkingCopyListener uiWorkingCopyListener;
            PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
            if (mgr != null) {
                mgr.removePresentationUpdater(this.fPresentationUpdater);
            }
            if ((uiWorkingCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class)) != null) {
                uiWorkingCopyListener.removeListener(this.fWorkItemListener);
            }
        }
    }

    public void dispose() {
        this.removeListeners();
        this.fWorkingCopy = null;
        super.dispose();
    }

    public IAttribute getAttribute() {
        return this.getAttribute(this.fWorkingCopy);
    }

    private class WorkItemListener
    implements IWorkingCopyListener {
        private WorkItemListener() {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            if (event.hasType("dirtyState") && CategoryAttributePart.this.fGuessButton != null && !CategoryAttributePart.this.fGuessButton.isEnabled()) {
                CategoryAttributePart.this.fGuessButton.setEnabled(true);
            }
        }
    }
}

