/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.presentations;

import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;

public abstract class AttributePart
extends PresentationPart {
    private IAttribute fAttribute;

    public void initialize(IAttribute attribute, PresentationDescriptor descriptor) {
        super.initialize(descriptor);
        this.fAttribute = attribute;
    }

    public IAttribute getAttribute() {
        return this.fAttribute;
    }

    public String getLabel() {
        String label = super.getLabel();
        if (label == null && this.fAttribute != null) {
            label = this.fAttribute.getDisplayName();
        }
        return label;
    }

    protected IAttribute getAttribute(WorkItemWorkingCopy workingCopy) {
        if (workingCopy == null || workingCopy.getWorkItem().getProjectArea().sameItemId((IItemHandle)this.fAttribute.getProjectArea())) {
            return this.fAttribute;
        }
        WorkItemUIWorkingCopy uiWorkingCopy = (WorkItemUIWorkingCopy)workingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
        IAttribute attribute = uiWorkingCopy.getResolvedWorkItem().findAttribute(this.fAttribute.getIdentifier());
        if (attribute == null) {
            return this.fAttribute;
        }
        return attribute;
    }

    protected boolean isReadOnly() {
        String readOnly;
        if (this.getDescriptor() != null && this.getDescriptor().getProperties() != null && (readOnly = (String)this.getDescriptor().getProperties().get("readonly")) != null && "true".equalsIgnoreCase(readOnly)) {
            return true;
        }
        return this.getAttribute().isReadOnly();
    }
}

