/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.team.jface.JazzResources;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormLayout;
import com.ibm.team.workitem.client.IWorkingCopyListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.WorkingCopyEvent;
import com.ibm.team.workitem.client.internal.util.WorkItemEventResolver;
import com.ibm.team.workitem.common.internal.WorkflowUtil;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.IResolution;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.Identifier;
import com.ibm.team.workitem.common.workflow.IWorkflowAction;
import com.ibm.team.workitem.common.workflow.IWorkflowInfo;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedControl;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemWorkingCopyListener;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolutionPart
extends PresentationPart {
    public static final String PART_ID = "com.ibm.team.workitem.ide.ui.editor.part.resolution";
    private WorkItemWorkingCopy fWorkingCopy;
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private DecoratedCombo fCombo;
    private ResolutionValue[] fResolutions;
    private Identifier<IResolution> fCachedResolution;
    private ResourceManager fResourceManager;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        @Override
        public void attributeChanged(WorkItemChangeEvent event) {
            if (event.getAttributeChangeType(IWorkItem.RESOLUTION_PROPERTY) == 1) {
                ResolutionPart.this.readResolution();
            } else {
                ResolutionPart.this.updateResolutionValueSet();
            }
        }

        @Override
        public void dependencyChanged(List<String> dependencies) {
            ResolutionPart.this.updateResolutionValueSet();
        }
    };

    public void createContent(ITeamFormLayout formLayout) {
        WorkItemEditorToolkit toolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        Composite parent = formLayout.getContainer();
        if (this.isLabelVisible()) {
            String label = this.getLabel();
            if (label == null) {
                label = Messages.ResolutionPart_RESOLUTION;
            }
            Label name = toolkit.createLabel(parent, NLS.bind((String)ATTRNAME_COLON, (Object)label, (Object[])new Object[0]), 0, this.getBackgroundStyle());
            formLayout.add((Control)name, "label");
        }
        this.fCombo = new DecoratedCombo(parent, 8, 1);
        this.initAccessible((Control)this.fCombo.getCombo(), Messages.ResolutionPart_RESOLUTION);
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fCombo.getCombo());
        toolkit.adapt((DecoratedControl)this.fCombo, true, false, this.getBackgroundStyle());
        Util.addWidthHint(this.fCombo.getLayoutControl());
        formLayout.add(this.fCombo.getLayoutControl(), "content");
        this.fCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (ResolutionPart.this.fWorkingCopy != null) {
                    ResolutionPart.this.writeResolution();
                }
            }
        });
        this.fCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ResolutionValue) {
                    IWorkflowInfo workflowInfo = ResolutionPart.this.getWorkflowInfo();
                    if (workflowInfo != null) {
                        String name = workflowInfo.getResolutionName(((ResolutionValue)element).getIdentifier());
                        if (name == null) {
                            name = ((ResolutionValue)element).getId();
                        }
                        return name;
                    }
                } else if (element instanceof String) {
                    return (String)element;
                }
                return "";
            }

            public Image getImage(Object element) {
                URL resolutionIconName;
                IWorkflowInfo workflowInfo;
                ImageDescriptor desc = ImagePool.EMPTY_ICON;
                if (element instanceof ResolutionValue && (workflowInfo = ResolutionPart.this.getWorkflowInfo()) != null && (resolutionIconName = workflowInfo.getResolutionIconName(((ResolutionValue)element).getIdentifier())) != null) {
                    ImageDescriptor imageDescriptor = WorkItemUI.getImageDescriptor((URL)resolutionIconName);
                    return JazzResources.getImage((ResourceManager)ResolutionPart.this.fResourceManager, (ImageDescriptor)imageDescriptor, null);
                }
                return JazzResources.getImageWithDefault((ResourceManager)ResolutionPart.this.fResourceManager, (ImageDescriptor)desc);
            }
        });
        this.updateResolutionValueSet();
    }

    public void setInput(Object input) {
        this.removeWorkItemListener();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.fCachedResolution = this.fWorkingCopy.getWorkItem().getResolution2();
            this.addWorkItemListener();
        } else {
            this.fWorkingCopy = null;
        }
        this.updateResolutionValueSet();
    }

    public void dispose() {
        this.removeWorkItemListener();
        this.fWorkingCopy = null;
        super.dispose();
    }

    private void addWorkItemListener() {
        PresentationHandlerManager mgr;
        UIWorkItemWorkingCopyListener uiWorkingCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class);
        if (uiWorkingCopyListener != null) {
            uiWorkingCopyListener.addListener((IWorkingCopyListener)this.fWorkItemListener);
        }
        if ((mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            PresentationDescriptor desc = Util.addDependencies(this.getDescriptor(), WorkItemEventResolver.WORKFLOW_INFO_PROPERTY);
            desc.setAttributeId(WorkItemAttributes.RESOLUTION);
            mgr.addPresentationUpdater(this.fPresentationUpdater, desc);
        }
    }

    private void removeWorkItemListener() {
        if (this.getSite() != null) {
            PresentationHandlerManager mgr;
            UIWorkItemWorkingCopyListener uiWorkingCopyListener = (UIWorkItemWorkingCopyListener)this.getSite().getAdapter(UIWorkItemWorkingCopyListener.class);
            if (uiWorkingCopyListener != null) {
                uiWorkingCopyListener.removeListener((IWorkingCopyListener)this.fWorkItemListener);
            }
            if ((mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
                mgr.removePresentationUpdater(this.fPresentationUpdater);
            }
        }
    }

    private void updateResolutionValueSet() {
        if (this.fWorkingCopy != null) {
            IWorkItem workItem = this.fWorkingCopy.getWorkItem();
            this.createResolutionValueSet(this.getWorkflowInfo(), this.fWorkingCopy.getWorkflowAction(), (Identifier<IResolution>)workItem.getResolution2());
        } else {
            this.fResolutions = new ResolutionValue[0];
            this.fCombo.setValueSet(new Object[0]);
        }
        this.readResolution();
    }

    private void createResolutionValueSet(IWorkflowInfo workflow, String actionId, Identifier<IResolution> resolution) {
        if (workflow == null) {
            return;
        }
        Identifier[] availableResolutionIds = actionId != null ? workflow.getResolutionIds(Identifier.create(IWorkflowAction.class, (String)actionId)) : (resolution != null ? (WorkflowUtil.validState((IWorkflowInfo)workflow, (IWorkItem)this.fWorkingCopy.getWorkItem(), (String)actionId) && workflow.getShowResoution(this.fWorkingCopy.getWorkItem().getState2()) ? new Identifier[]{resolution} : new Identifier[]{}) : new Identifier[]{});
        ArrayList<ResolutionValue> values = new ArrayList<ResolutionValue>();
        if (availableResolutionIds.length > 0) {
            Object[] ids = new String[availableResolutionIds.length];
            int i = 0;
            while (i < availableResolutionIds.length) {
                ids[i] = availableResolutionIds[i].getStringIdentifier();
                ++i;
            }
            Arrays.sort(ids);
            i = 0;
            while (i < ids.length) {
                values.add(new ResolutionValue((Identifier<IResolution>)Identifier.create(IResolution.class, (String)ids[i])));
                ++i;
            }
        }
        this.fResolutions = values.toArray(new ResolutionValue[values.size()]);
        this.fCombo.setValueSet((Object[])this.fResolutions);
        this.fCombo.getLayoutControl().getParent().getParent().layout();
    }

    private void readResolution() {
        boolean initialized;
        IWorkflowInfo workflowInfo = this.getWorkflowInfo();
        boolean bl = initialized = this.fResolutions.length > 1 || this.fResolutions.length == 1 && this.fResolutions[0].getIdentifier() != null;
        if (this.fWorkingCopy != null) {
            this.selectResolution(workflowInfo, initialized ? this.fWorkingCopy.getWorkItem().getResolution2() : null);
            this.setEnabled(initialized && this.fResolutions.length > 1);
        } else {
            this.selectResolution(workflowInfo, null);
            this.setEnabled(false);
        }
    }

    private IWorkflowInfo getWorkflowInfo() {
        if (this.fWorkingCopy != null) {
            WorkItemUIWorkingCopy uiCopy = (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
            return uiCopy.getResolvedWorkItem().getWorkflowInfo();
        }
        return null;
    }

    private void selectResolution(IWorkflowInfo workflowInfo, Identifier<IResolution> resolution) {
        if (!(this.fResolutions.length <= 0 || resolution != null && this.contains(Arrays.asList(this.fResolutions), resolution))) {
            resolution = this.fResolutions[0].getIdentifier();
        }
        ResolutionValue[] resolutionValueArray = this.fResolutions;
        int n = this.fResolutions.length;
        int n2 = 0;
        while (n2 < n) {
            ResolutionValue v = resolutionValueArray[n2];
            Identifier<IResolution> identifier = v.getIdentifier();
            if (identifier != null && identifier.equals(resolution)) {
                this.fCombo.setValue((Object)v);
                if (this.getWorkflowInfo().getResolutionName(v.getIdentifier()) == null) {
                    this.fCombo.getCombo().setToolTipText(v.getId());
                } else {
                    this.fCombo.getCombo().setToolTipText(null);
                }
                return;
            }
            ++n2;
        }
        this.fCombo.setValue((Object)"");
        this.fCombo.getCombo().setToolTipText(null);
    }

    private boolean contains(List<ResolutionValue> list, Identifier<IResolution> resolution) {
        if (resolution == null) {
            return false;
        }
        for (ResolutionValue v : list) {
            if (!resolution.equals(v.getIdentifier())) continue;
            return true;
        }
        return false;
    }

    private void setEnabled(boolean enabled) {
        this.fCombo.getCombo().setEnabled(enabled);
        this.fCombo.getImageControl().setEnabled(enabled);
    }

    private void writeResolution() {
        Identifier oldResolution;
        Identifier<IResolution> resolution;
        Object val = this.fCombo.getValue();
        if (val instanceof ResolutionValue && !(resolution = ((ResolutionValue)val).getIdentifier()).equals((Object)(oldResolution = this.fWorkingCopy.getWorkItem().getResolution2()))) {
            this.fWorkingCopy.getWorkItem().setResolution2(resolution);
            return;
        }
    }

    @Override
    public boolean stretchHorizontally() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolutionValue {
        private Identifier<IResolution> fId;

        public ResolutionValue(Identifier<IResolution> resolution) {
            this.fId = resolution;
        }

        public String getId() {
            return this.fId.getStringIdentifier();
        }

        public Identifier<IResolution> getIdentifier() {
            return this.fId;
        }
    }

    private class WorkItemListener
    implements IWorkingCopyListener {
        private WorkItemListener() {
        }

        public void workingCopyEvent(WorkingCopyEvent event) {
            if ((event.hasType("saved") || event.hasType("reverted")) && ResolutionPart.this.fWorkingCopy != null) {
                ResolutionPart.this.fCachedResolution = ResolutionPart.this.fWorkingCopy.getWorkItem().getResolution2();
            }
            if (event.hasType("workflowAction")) {
                if (ResolutionPart.this.fWorkingCopy != null && ResolutionPart.this.fWorkingCopy.getWorkflowAction() == null && ResolutionPart.this.fWorkingCopy.isDirty()) {
                    ResolutionPart.this.fWorkingCopy.getWorkItem().setResolution2(ResolutionPart.this.fCachedResolution);
                }
                ResolutionPart.this.updateResolutionValueSet();
            }
        }
    }
}

