/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.team.foundation.rcp.core.HistoryBin;
import com.ibm.team.jface.internal.tooltip.MarkupJob;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.model.Auditable;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.ide.ui.internal.editor.HistoryLogDomainAdapter;
import com.ibm.team.workitem.ide.ui.internal.editor.HistoryLogItem;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.HistoryPart;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Control;

public class RemoteChangesTooltipSupport
extends TooltipSupport {
    public RemoteChangesTooltipSupport(Control control) {
        super(control, true, false);
    }

    protected String getMarkup(final Object element, boolean isFocus) {
        final IDomainAdapter.Info info = new IDomainAdapter.Info();
        info.isHoverTooltip = !isFocus;
        info.isFocusTooltip = isFocus;
        String waitMessage = Messages.RemoteChangesTooltipSupport_RESOLVING_CHANGES;
        this.setMarkupJob(new MarkupJob(new MarkupJob.MarkupJobIdentifier(element, info), waitMessage){

            protected String run() {
                IWorkItemHandle workItem = (IWorkItemHandle)element;
                UUID from = null;
                if (workItem.getStateId() != null) {
                    from = workItem.getStateId();
                } else if (workItem instanceof IWorkItem) {
                    from = ((Auditable)workItem).getWorkingCopyPredecessor();
                }
                ArrayList<HistoryLogItem> history = new ArrayList<HistoryLogItem>(Arrays.asList(HistoryPart.getPartialHistory(workItem, from, null)));
                Collections.sort(history, new Comparator<HistoryLogItem>(){

                    @Override
                    public int compare(HistoryLogItem o1, HistoryLogItem o2) {
                        return -o1.getDate().compareTo(o2.getDate());
                    }
                });
                StringBuffer body = new StringBuffer();
                HashMap head = new HashMap();
                HistoryLogDomainAdapter domainAdapter = new HistoryLogDomainAdapter();
                int i = 0;
                while (i < history.size()) {
                    HistoryLogItem item = (HistoryLogItem)history.get(i);
                    body.append("<div style=\"margin-left: 5px; margin-top: 5px;\">\n");
                    FontData def = JFaceResources.getDefaultFont().getFontData()[0];
                    body.append("<span style=\"" + MarkupUtil.getFont((String)def.getName(), (int)def.getHeight(), (int)1) + "\">");
                    body.append(domainAdapter.generateTitle(item));
                    body.append("</span>");
                    StringBuilder dateStr = new StringBuilder("<span class=\"date\">&nbsp;&nbsp;");
                    Date date = item.getDate();
                    if (date != null) {
                        dateStr.append(HistoryBin.getReadableTimeDif((Date)date)).append("</span>");
                    }
                    body.append(dateStr.toString());
                    domainAdapter.generateContentAsHTML(head, body, item, info);
                    body.append("</div>\n");
                    ++i;
                }
                StringBuffer html = new StringBuffer();
                html.append("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">\n");
                if ("win32".equals(SWT.getPlatform())) {
                    html.append("<!-- saved from url=(0014)about:internet -->\n");
                }
                html.append("<html>\n<head>\n");
                html.append("<meta http-equiv=\"content-type\" content=\"text/html; charset=UTF-8\">\n");
                HTMLGenerator.getHeadDefinitions((StringBuffer)html, head);
                html.append("</head>\n<body>\n");
                html.append(body.toString());
                html.append("</body>\n</html>\n");
                return html.toString();
            }
        });
        return waitMessage;
    }
}

