/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.icu.text.Collator;
import com.ibm.team.collaboration.core.session.CollaborationPresenceStatus;
import com.ibm.team.collaboration.ui.CollaborationUI;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.jface.viewerutilities.SelectionProvider;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.common.model.WorkItemEndPoints;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.ApprovalsTab;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.LinksTab;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.links.LinkContentProvider;
import com.ibm.team.workitem.ide.ui.internal.editor.part.AbstractQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.part.ArtifactQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.part.AttachmentsPart;
import com.ibm.team.workitem.ide.ui.internal.editor.part.ItemizedQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.part.ReferenceQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.part.SubscriberQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.part.WorkItemQuickInformationEntry;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.SubscriberUtil;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class LinksSummaryPart
extends PresentationPart {
    private static final String SUMMARY_TOOLTIP = Messages.LinksSummaryPart_USE_CONTEXT_MENU;
    private WorkItemWorkingCopy fWorkingCopy;
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private UIWorkItemListener fUIListener;
    private WorkItemEditorToolkit fToolkit;
    private HyperlinkGroup fLinkGroup;
    private HyperlinkGroup fClosedLinkGroup;
    private HyperlinkGroup fPresentGroup;
    private Composite fListComposite;
    private ApprovalsJob fApprovalsJob;
    private final Object fALock = new Object();
    private HashMap<UUID, IContributor> fApprovers = new HashMap();
    SubscriberQuickInformationEntry fContribEntry;
    private IHyperlinkListener fLinksPageActivator;
    private IHyperlinkListener fApprovalPageActivator;
    private LinkContentProvider fLinkContentProvider = new LinkContentProvider(true);
    private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    private Map<IEndPointDescriptor, ItemizedQuickInformationEntry> fItemizingEntries = new HashMap<IEndPointDescriptor, ItemizedQuickInformationEntry>();

    public void createContent(Composite parent) {
        this.fToolkit = (WorkItemEditorToolkit)this.getSite().getToolkit();
        this.fLinkGroup = new HyperlinkGroup(this.fToolkit.getColors().getDisplay());
        this.fLinkGroup.setBackground(null);
        this.fLinkGroup.setHyperlinkUnderlineMode(2);
        this.fClosedLinkGroup = new HyperlinkGroup(this.fToolkit.getColors().getDisplay());
        this.fClosedLinkGroup.setBackground(null);
        this.fClosedLinkGroup.setHyperlinkUnderlineMode(2);
        this.fClosedLinkGroup.setForeground(WorkItemIDEUIPlugin.getDefault().getDarkShadow());
        this.fClosedLinkGroup.setActiveForeground(WorkItemIDEUIPlugin.getDefault().getMidShadow());
        this.fPresentGroup = new HyperlinkGroup(this.fToolkit.getColors().getDisplay());
        this.fPresentGroup.setBackground(null);
        this.fPresentGroup.setHyperlinkUnderlineMode(2);
        this.fPresentGroup.setForeground(JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)CollaborationUI.getForegroundColor((CollaborationPresenceStatus)CollaborationPresenceStatus.STATUS_AVAILABLE, (boolean)true)));
        this.fPresentGroup.setActiveForeground(JazzResources.getColor((ResourceManager)this.fResourceManager, (RGB)CollaborationUI.getHighlightColor((CollaborationPresenceStatus)CollaborationPresenceStatus.STATUS_AVAILABLE)));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 7;
        layout.verticalSpacing = 0;
        parent.setLayout((Layout)layout);
        this.fLinksPageActivator = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LinksSummaryPart.this.activateLinksPage();
            }
        };
        this.fApprovalPageActivator = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                LinksSummaryPart.this.activateApprovalPage();
            }
        };
        this.fListComposite = this.fToolkit.createComposite(parent);
        GridData gd = new GridData(1808);
        gd.widthHint = 0;
        this.fListComposite.setLayoutData((Object)gd);
        layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginTop = 3;
        layout.marginWidth = 6;
        layout.verticalSpacing = 3;
        this.fListComposite.setLayout((Layout)layout);
        this.fListComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Rectangle clArea = LinksSummaryPart.this.fListComposite.getClientArea();
                GC gc = e.gc;
                gc.setAntialias(1);
                gc.setForeground(LinksSummaryPart.this.fToolkit.getColors().getColor("org.eclipse.ui.forms.TB_BORDER"));
                gc.drawRoundRectangle(0, 0, clArea.width - 1, clArea.height - 1, 6, 6);
                gc.setForeground(LinksSummaryPart.this.fListComposite.getDisplay().getSystemColor(1));
                gc.drawPoint(2, 2);
                gc.drawPoint(1, 2);
                gc.drawPoint(1, 3);
                gc.drawPoint(2, 1);
                gc.drawPoint(3, 1);
                gc.drawPoint(clArea.width - 3, 2);
                gc.drawPoint(clArea.width - 2, 2);
                gc.drawPoint(clArea.width - 2, 3);
                gc.drawPoint(clArea.width - 3, 1);
                gc.drawPoint(clArea.width - 4, 1);
                gc.drawPoint(2, clArea.height - 3);
                gc.drawPoint(1, clArea.height - 3);
                gc.drawPoint(1, clArea.height - 4);
                gc.drawPoint(2, clArea.height - 2);
                gc.drawPoint(3, clArea.height - 2);
                gc.drawPoint(clArea.width - 3, clArea.height - 3);
                gc.drawPoint(clArea.width - 2, clArea.height - 3);
                gc.drawPoint(clArea.width - 2, clArea.height - 4);
                gc.drawPoint(clArea.width - 3, clArea.height - 2);
                gc.drawPoint(clArea.width - 4, clArea.height - 2);
                gc.setAntialias(0);
            }
        });
        final Color start = this.fToolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_START");
        final Color end = this.fToolkit.getColors().getColor("org.eclipse.ui.forms.H_GRADIENT_END");
        this.fListComposite.setBackgroundMode(1);
        this.fListComposite.setBackground(start);
        LinksSummaryPart.setBackgroundImage(this.fListComposite, start, end);
        this.fListComposite.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                LinksSummaryPart.setBackgroundImage(LinksSummaryPart.this.fListComposite, start, end);
            }
        });
        this.fListComposite.addListener(12, new Listener(){

            public void handleEvent(Event event) {
                Image backgroundImage = LinksSummaryPart.this.fListComposite.getBackgroundImage();
                if (backgroundImage != null && !backgroundImage.isDisposed()) {
                    backgroundImage.dispose();
                }
            }
        });
        this.addUndefinedEndPointDropTarget((Control)this.fListComposite);
        Hyperlink summaryLabel = this.fToolkit.createCustomHyperlink(this.fListComposite, Messages.LinksSummaryPart_QUICK_INFORMATION, 0);
        summaryLabel.setUnderlined(false);
        summaryLabel.addHyperlinkListener(this.fLinksPageActivator);
        summaryLabel.setLayoutData((Object)new GridData(16384, 1, false, false, 2, 1));
        summaryLabel.setBackground(null);
        summaryLabel.setForeground(this.fToolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        summaryLabel.setFont((Font)this.fResourceManager.get((DeviceResourceDescriptor)JFaceResources.getFontDescriptor((String)"").withStyle(1)));
        this.createContextMenu((Control)summaryLabel);
        summaryLabel.setToolTipText(SUMMARY_TOOLTIP);
        this.fContribEntry = new SubscriberQuickInformationEntry(this);
    }

    private static void setBackgroundImage(Composite control, Color start, Color end) {
        Rectangle rect = control.getClientArea();
        if (!rect.isEmpty()) {
            int height = Math.max(3, rect.height);
            int width = Math.max(4, rect.width);
            Image newImage = new Image((Device)control.getDisplay(), width, height);
            GC gc = new GC((Drawable)newImage);
            gc.setForeground(start);
            gc.setBackground(end);
            gc.fillGradientRectangle(rect.x + 2, rect.y + 2, width - 4, height - 3, true);
            gc.dispose();
            Image oldImage = control.getBackgroundImage();
            control.setBackgroundImage(newImage);
            if (oldImage != null && !oldImage.isDisposed()) {
                oldImage.dispose();
            }
        }
    }

    public HyperlinkGroup getLinkGroup() {
        return this.fLinkGroup;
    }

    public HyperlinkGroup getPresentGroup() {
        return this.fPresentGroup;
    }

    public HyperlinkGroup getClosedGroup() {
        return this.fClosedLinkGroup;
    }

    void updateItems() {
        if (this.fListComposite.isDisposed() || this.fWorkingCopy == null) {
            return;
        }
        Control[] kids = this.fListComposite.getChildren();
        int i = 1;
        while (i < kids.length) {
            kids[i].dispose();
            ++i;
        }
        GC gc = new GC((Drawable)this.fListComposite);
        gc.setFont(this.fListComposite.getFont());
        this.createContextMenu((Control)this.fListComposite);
        if (this.fContribEntry != null) {
            this.fContribEntry.createContent(this.fListComposite);
        }
        ArrayList<ItemizedQuickInformationEntry> entries = new ArrayList<ItemizedQuickInformationEntry>(this.fItemizingEntries.values());
        Collections.sort(entries, new Comparator<AbstractQuickInformationEntry>(){

            @Override
            public int compare(AbstractQuickInformationEntry o1, AbstractQuickInformationEntry o2) {
                if (o1 instanceof ArtifactQuickInformationEntry) {
                    return -1;
                }
                if (o2 instanceof ArtifactQuickInformationEntry) {
                    return 1;
                }
                if (o1 instanceof WorkItemQuickInformationEntry && o2 instanceof ReferenceQuickInformationEntry) {
                    return -1;
                }
                if (o1 instanceof ReferenceQuickInformationEntry && o2 instanceof WorkItemQuickInformationEntry) {
                    return 1;
                }
                if (o1 instanceof ItemizedQuickInformationEntry && !(o2 instanceof ItemizedQuickInformationEntry)) {
                    return -1;
                }
                if (!(o1 instanceof ItemizedQuickInformationEntry) && o2 instanceof ItemizedQuickInformationEntry) {
                    return 1;
                }
                return Collator.getInstance().compare(o1.getTitle(), o2.getTitle());
            }
        });
        for (AbstractQuickInformationEntry abstractQuickInformationEntry : entries) {
            abstractQuickInformationEntry.createContent(this.fListComposite);
        }
        IApprovals iApprovals = this.fWorkingCopy.getWorkItem().getApprovals();
        for (IApprovalDescriptor desc : iApprovals.getDescriptors()) {
            Label label = this.fToolkit.createLabel(this.fListComposite, null);
            label.setImage(this.fResourceManager.createImage(ImageDescriptor.createFromURL((URL)WorkItemApprovals.getType((String)desc.getTypeIdentifier()).getIconURL())));
            label.setBackground(null);
            Composite links = this.fToolkit.createComposite(this.fListComposite);
            links.setBackground(null);
            RowLayout rl = new RowLayout();
            rl.marginLeft = 0;
            rl.marginTop = 0;
            rl.marginBottom = 0;
            rl.spacing = 0;
            links.setLayout((Layout)rl);
            Hyperlink link = this.fToolkit.createCustomHyperlink(links, String.valueOf(desc.getName()) + ":", 0);
            new ApprovalToolTipSupport((Control)link, desc);
            new ApprovalToolTipSupport((Control)label, desc);
            this.createApprovalContextMenui((Control)link, desc);
            this.createApprovalContextMenui((Control)label, desc);
            this.addApprovalDropTarget((Control)link, desc);
            this.addApprovalDropTarget((Control)label, desc);
            this.fLinkGroup.add(link);
            link.addHyperlinkListener(this.fApprovalPageActivator);
            int relevant = 0;
            IApprovalState cum = iApprovals.getCumulativeState(desc);
            IApprovalDescriptor currentUser = null;
            for (IApproval a : iApprovals.getContents(desc)) {
                if (a.getApprover().sameItemId((IItemHandle)this.fWorkingCopy.getTeamRepository().loggedInContributor())) {
                    currentUser = a;
                }
                if (!a.getStateIdentifier().equals(cum.getIdentifier())) continue;
                ++relevant;
            }
            final IApprovalDescriptor selection = currentUser != null ? currentUser : desc;
            Label l = this.fToolkit.createLabel(links, " ");
            l.setBackground(null);
            Hyperlink descriptor = this.fToolkit.createCustomHyperlink(links, NLS.bind((String)Messages.LinksSummaryPart_DESCRIPTOR_HYPERLINK, (Object)cum.getDisplayName(), (Object[])new Object[]{relevant, iApprovals.getContents(desc).size()}), 0);
            this.fLinkGroup.add(descriptor);
            descriptor.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    IEditorPart part = LinksSummaryPart.this.getSite().getWorkbenchPage().getActiveEditor();
                    if (part instanceof WorkItemEditor) {
                        WorkItemEditor editor = (WorkItemEditor)part;
                        ApprovalsTab approvals = null;
                        for (Object page : editor.getPages()) {
                            if (!(page instanceof ApprovalsTab)) continue;
                            approvals = (ApprovalsTab)((Object)page);
                            break;
                        }
                        if (approvals != null) {
                            editor.setActivePage(approvals.getId());
                            approvals.setApprovalSelection(selection);
                        }
                    }
                }
            });
            new ApprovalToolTipSupport((Control)descriptor, desc);
            this.createSetApprovalValueContextMenu((Control)descriptor, desc);
            this.addInvalidDropTarget((Control)descriptor);
            int availableSpace = this.fListComposite.getBounds().width - 12 - 2 - label.computeSize((int)-1, (int)-1).x - 5 - l.computeSize((int)-1, (int)-1).x - descriptor.computeSize((int)-1, (int)-1).x - 1;
            int currentLinkLength = gc.stringExtent((String)link.getText()).x;
            String text = link.getText();
            if (currentLinkLength <= availableSpace || text.length() <= 1) continue;
            text = String.valueOf(text.substring(0, text.length() - 1)) + "...:";
            while (text.length() > 5 && gc.stringExtent((String)text).x > availableSpace) {
                text = String.valueOf(text.substring(0, text.length() - 5)) + "...:";
            }
            link.setText(text);
        }
        gc.dispose();
        if (this.fListComposite.getChildren().length == 1) {
            Label l = new Label(this.fListComposite, 0x1000000);
            l.setText(Messages.LinksSummaryPart_NO_INFORMATION);
            l.setForeground(l.getDisplay().getSystemColor(16));
            l.setBackground(null);
            this.createContextMenu((Control)l);
            l.setToolTipText(SUMMARY_TOOLTIP);
            l.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true, 2, 1));
            l = new Label(this.fListComposite, 0);
            l.setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false, 2, 1));
        }
        this.fListComposite.layout(true, true);
        this.fLinkGroup.setBackground(null);
        this.fClosedLinkGroup.setBackground(null);
        this.fPresentGroup.setBackground(null);
    }

    private static IStructuredSelection getStructuredSelection() {
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    private void createSetApprovalValueContextMenu(Control control, final IApprovalDescriptor desc) {
        IApproval approval = null;
        for (IApproval app : this.fWorkingCopy.getWorkItem().getApprovals().getContents(desc)) {
            if (!app.getApprover().sameItemId((IItemHandle)this.fWorkingCopy.getTeamRepository().loggedInContributor())) continue;
            approval = app;
            break;
        }
        if (approval == null) {
            return;
        }
        final IApproval fapp = approval;
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                for (final IApprovalState state : WorkItemApprovals.getStates()) {
                    if (!state.getIdentifier().equals(WorkItemApprovals.PENDING_STATE.getIdentifier())) {
                        if (fapp.getStateIdentifier().equals(state.getIdentifier())) continue;
                        manager.add((IAction)new Action(NLS.bind((String)Messages.LinksSummaryPart_SET, (Object)state.getDisplayName(), (Object[])new Object[0])){

                            public void run() {
                                fapp.setStateIdentifier(state.getIdentifier());
                            }
                        });
                        continue;
                    }
                    if (fapp.getStateIdentifier().equals(state.getIdentifier())) continue;
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new Action(NLS.bind((String)Messages.LinksSummaryPart_RESET, (Object)WorkItemApprovals.getType((String)desc.getTypeIdentifier()).getDisplayName(), (Object[])new Object[0])){

                        public void run() {
                            fapp.setStateIdentifier(state.getIdentifier());
                        }
                    });
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(this.getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void createApprovalContextMenui(Control control, final IApprovalDescriptor desc) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        Action addApprovalAction = new Action(Messages.LinksSummaryPart_ADD){

            public void run() {
                ArrayList<IContributorHandle> filtered = new ArrayList<IContributorHandle>();
                for (IApproval app : LinksSummaryPart.this.fWorkingCopy.getWorkItem().getApprovals().getContents(desc)) {
                    filtered.add(app.getApprover());
                }
                TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(Display.getCurrent().getActiveShell(), LinksSummaryPart.this.fWorkingCopy.getTeamRepository(), filtered, true);
                dialog.setTitle(Messages.LinksSummaryPart_ADD_APPROVERS);
                if (dialog.open() == 0) {
                    IContributorHandle[] iContributorHandleArray = dialog.getContributorResult();
                    int n = iContributorHandleArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributorHandle contributor = iContributorHandleArray[n2];
                        LinksSummaryPart.this.fWorkingCopy.getWorkItem().getApprovals().add(LinksSummaryPart.this.fWorkingCopy.getWorkItem().getApprovals().createApproval(desc, contributor));
                        if (!LinksSummaryPart.this.fWorkingCopy.getWorkItem().getCreator().sameItemId((IItemHandle)contributor) && !LinksSummaryPart.this.fWorkingCopy.getWorkItem().getSubscriptions().contains(contributor)) {
                            LinksSummaryPart.this.fWorkingCopy.getWorkItem().getSubscriptions().add(contributor);
                        }
                        ++n2;
                    }
                }
            }
        };
        menuMgr.addMenuListener(new IMenuListener((IAction)addApprovalAction){
            private final /* synthetic */ IAction val$addApprovalAction;
            {
                this.val$addApprovalAction = iAction;
            }

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(this.val$addApprovalAction);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(this.getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void createContextMenu(Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        SelectionProvider selectionProvider = new SelectionProvider(){

            public ISelection getSelection() {
                return StructuredSelection.EMPTY;
            }
        };
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LinkHelper.addEmptySelectionActions(LinksSummaryPart.this.getSite().getWorkbenchPage(), manager, LinksSummaryPart.this.fWorkingCopy);
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new AttachmentsPart.AddFileAction(LinksSummaryPart.this.fWorkingCopy));
                manager.add((IAction)new AttachmentsPart.AddScreenshotAction(LinksSummaryPart.this.fWorkingCopy));
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)new SubscriberUtil.AddSubscriberAction(LinksSummaryPart.this.fWorkingCopy, Messages.LinksSummaryPart_ADD_SUBSCRIBER));
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(this.getId(), menuMgr, (ISelectionProvider)selectionProvider);
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    private void addUndefinedEndPointDropTarget(final Control control) {
        DropTarget target = new DropTarget(control, 7);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance(), FileTransfer.getInstance()});
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void dropAccept(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void drop(DropTargetEvent event) {
                this.performDrop(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.validateDrop(event);
            }

            public void dragLeave(DropTargetEvent event) {
            }

            private void validateDrop(DropTargetEvent event) {
                if (LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    IStructuredSelection selection = LinksSummaryPart.getStructuredSelection();
                    if (selection != null) {
                        Object element = selection.getFirstElement();
                        if ((element = LinkHelper.convertURIReferenceToItemHandle(element, LinksSummaryPart.this.fWorkingCopy.getTeamRepository())) instanceof IItemHandle && ((IItemHandle)element).getOrigin() != LinksSummaryPart.this.fWorkingCopy.getTeamRepository()) {
                            event.detail = 0;
                            return;
                        }
                        if (element instanceof IFile || element instanceof IAdaptable && ((IAdaptable)element).getAdapter(IResource.class) instanceof IFile) {
                            if (selection.size() != 1) {
                                event.detail = 0;
                                return;
                            }
                            if ((event.operations & 4) != 0) {
                                event.detail = 4;
                            } else if ((event.operations & 1) != 0) {
                                event.detail = 1;
                            }
                            return;
                        }
                        if (element instanceof IWorkItemHandle || element instanceof IAttachmentHandle || element instanceof IReference && ((IReference)element).isItemReference() && (((IItemReference)element).getReferencedItem() instanceof IWorkItemHandle || ((IItemReference)element).getReferencedItem() instanceof IAttachmentHandle)) {
                            if (element instanceof IWorkItemHandle && selection.toList().size() == 1 && ((IWorkItemHandle)element).sameItemId((IItemHandle)LinksSummaryPart.this.fWorkingCopy.getWorkItem())) {
                                event.detail = 0;
                                return;
                            }
                            IItemType type = element instanceof IWorkItemHandle || element instanceof IAttachmentHandle ? ((IItemHandle)element).getItemType() : ((IItemReference)element).getReferencedItem().getItemType();
                            for (Object e : selection.toList()) {
                                if ((e = LinkHelper.convertURIReferenceToItemHandle(e, LinksSummaryPart.this.fWorkingCopy.getTeamRepository())) instanceof IItemHandle && ((IItemHandle)element).getOrigin() == LinksSummaryPart.this.fWorkingCopy.getTeamRepository()) {
                                    if (((IItemHandle)e).getItemType().equals(type)) continue;
                                    event.detail = 0;
                                    return;
                                }
                                if (e instanceof IReference && ((IReference)e).isItemReference() && ((IItemReference)e).getReferencedItem().getOrigin() == LinksSummaryPart.this.fWorkingCopy.getTeamRepository()) {
                                    if (((IItemReference)e).getReferencedItem().getItemType().equals(type)) continue;
                                    event.detail = 0;
                                    return;
                                }
                                event.detail = 0;
                                return;
                            }
                            event.detail = 4;
                            return;
                        }
                        if (element instanceof IContributorHandle || element instanceof ITeamArea || element instanceof IReference && ((IReference)element).isItemReference() && (((IItemReference)element).getReferencedItem() instanceof IContributorHandle || ((IItemReference)element).getReferencedItem() instanceof ITeamArea)) {
                            for (Object e : selection.toList()) {
                                if ((e instanceof IContributorHandle || e instanceof ITeamArea) && ((IItemHandle)e).getOrigin() == LinksSummaryPart.this.fWorkingCopy.getTeamRepository() || e instanceof IReference && ((IReference)e).isItemReference() && (((IItemReference)e).getReferencedItem() instanceof IContributorHandle || ((IItemReference)e).getReferencedItem() instanceof ITeamArea) && ((IItemReference)e).getReferencedItem().getOrigin() == LinksSummaryPart.this.fWorkingCopy.getTeamRepository()) continue;
                                event.detail = 0;
                                return;
                            }
                            event.detail = 4;
                            return;
                        }
                    }
                } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    if ((event.operations & 4) != 0) {
                        event.detail = 4;
                    } else if ((event.operations & 1) != 0) {
                        event.detail = 1;
                    }
                    return;
                }
                event.detail = 0;
            }

            private void performDrop(DropTargetEvent event) {
                MenuManager menuMgr = new MenuManager("#PopupMenu");
                menuMgr.setRemoveAllWhenShown(true);
                Object element = null;
                String[] fileNames = null;
                ArrayList<IItemHandle> itemList = new ArrayList<IItemHandle>();
                if (LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    IStructuredSelection selection = LinksSummaryPart.getStructuredSelection();
                    if (selection != null) {
                        element = selection.getFirstElement();
                        element = LinkHelper.convertURIReferenceToItemHandle(element, LinksSummaryPart.this.fWorkingCopy.getTeamRepository());
                        for (Object e : selection.toList()) {
                            if ((e = LinkHelper.convertURIReferenceToItemHandle(e, LinksSummaryPart.this.fWorkingCopy.getTeamRepository())) instanceof IItemHandle && !((IItemHandle)e).sameItemId((IItemHandle)LinksSummaryPart.this.fWorkingCopy.getWorkItem())) {
                                itemList.add((IItemHandle)e);
                                continue;
                            }
                            if (!(e instanceof IReference) || !((IReference)e).isItemReference() || ((IItemReference)e).getReferencedItem().sameItemId((IItemHandle)LinksSummaryPart.this.fWorkingCopy.getWorkItem())) continue;
                            itemList.add(((IItemReference)e).getReferencedItem());
                        }
                    }
                } else if (FileTransfer.getInstance().isSupportedType(event.currentDataType)) {
                    fileNames = (String[])FileTransfer.getInstance().nativeToJava(event.currentDataType);
                }
                final ArrayList<IItemHandle> finalList = itemList;
                final Object finalElement = element;
                final String[] finalFileNames = fileNames;
                menuMgr.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        if (!finalList.isEmpty() && finalList.get(0) instanceof IAttachmentHandle) {
                            LinkHelper.AddLinkToEndPointAction addLinkAction = new LinkHelper.AddLinkToEndPointAction(LinksSummaryPart.this.fWorkingCopy, WorkItemEndPoints.ATTACHMENT, Messages.LinksSummaryPart_ADD_ATTACHMENT, finalList);
                            if (addLinkAction.isEnabled()) {
                                manager.add((IAction)addLinkAction);
                            }
                        } else if (finalElement instanceof IFile || finalElement instanceof IAdaptable && ((IAdaptable)finalElement).getAdapter(IResource.class) instanceof IFile) {
                            LinkHelper.AddLinkToEndPointAction addLinkAction = new LinkHelper.AddLinkToEndPointAction(LinksSummaryPart.this.fWorkingCopy, WorkItemEndPoints.ATTACHMENT, Messages.LinksSummaryPart_ADD_ATTACHMENT, finalElement);
                            if (addLinkAction.isEnabled()) {
                                manager.add((IAction)addLinkAction);
                            }
                        } else if (finalFileNames != null && finalFileNames.length > 0) {
                            manager.add((IAction)new Action(Messages.LinksSummaryPart_ADD_ATTACHMENT){

                                public void run() {
                                    String[] stringArray = finalFileNames;
                                    int n = finalFileNames.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String fileName = stringArray[n2];
                                        AttachmentsPart.addFileSystemLink(LinksSummaryPart.this.fWorkingCopy, fileName);
                                        ++n2;
                                    }
                                }
                            });
                        } else if (!finalList.isEmpty() && (finalList.get(0) instanceof ITeamArea || finalList.get(0) instanceof IContributorHandle)) {
                            manager.add((IAction)new Action(Messages.LinksSummaryPart_ADD_SUSBRIBER){

                                public void run() {
                                    for (IItemHandle handle : finalList) {
                                        if (handle instanceof IContributorHandle) {
                                            LinksSummaryPart.this.fWorkingCopy.getWorkItem().getSubscriptions().add((IContributorHandle)handle);
                                            continue;
                                        }
                                        if (!(handle instanceof ITeamArea)) continue;
                                        IContributorHandle[] iContributorHandleArray = ((ITeamArea)handle).getMembers();
                                        int n = iContributorHandleArray.length;
                                        int n2 = 0;
                                        while (n2 < n) {
                                            IContributorHandle subs = iContributorHandleArray[n2];
                                            LinksSummaryPart.this.fWorkingCopy.getWorkItem().getSubscriptions().add(subs);
                                            ++n2;
                                        }
                                    }
                                }
                            });
                        }
                        manager.add((IContributionItem)new Separator());
                        LinkHelper.addDropActions(manager, LinksSummaryPart.this.fWorkingCopy, finalList);
                    }
                });
                Menu menu = menuMgr.createContextMenu(control);
                Util.showAndDisposeOnHide(menu);
            }
        });
    }

    private void addApprovalDropTarget(final Control control, final IApprovalDescriptor desc) {
        DropTarget target = new DropTarget(control, 5);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new SubscriberUtil.SubscriberDropListener(){

            public void dragEnter(DropTargetEvent event) {
                super.dragEnter(event);
                if (control instanceof Hyperlink && event.detail != 0) {
                    ((Hyperlink)control).setUnderlined(true);
                }
            }

            public void drop(DropTargetEvent event) {
                ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection ss = (IStructuredSelection)selection;
                    for (IContributorHandle contributor : ss) {
                        LinksSummaryPart.this.fWorkingCopy.getWorkItem().getApprovals().add(LinksSummaryPart.this.fWorkingCopy.getWorkItem().getApprovals().createApproval(desc, contributor));
                        if (LinksSummaryPart.this.fWorkingCopy.getWorkItem().getCreator().sameItemId((IItemHandle)contributor) || LinksSummaryPart.this.fWorkingCopy.getWorkItem().getSubscriptions().contains(contributor)) continue;
                        LinksSummaryPart.this.fWorkingCopy.getWorkItem().getSubscriptions().add(contributor);
                    }
                }
            }

            public void dragLeave(DropTargetEvent event) {
                super.dragLeave(event);
                if (control instanceof Hyperlink) {
                    ((Hyperlink)control).setUnderlined(false);
                }
            }

            protected WorkItemWorkingCopy getWorkingCopy() {
                return LinksSummaryPart.this.fWorkingCopy;
            }
        });
    }

    void addInvalidDropTarget(Control control) {
        DropTarget target = new DropTarget(control, 5);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance()});
        target.addDropListener(new DropTargetListener(){

            public void dragEnter(DropTargetEvent event) {
                this.setNone(event);
            }

            private void setNone(DropTargetEvent event) {
                event.detail = 0;
            }

            public void dragLeave(DropTargetEvent event) {
                this.setNone(event);
            }

            public void dragOperationChanged(DropTargetEvent event) {
                this.setNone(event);
            }

            public void dragOver(DropTargetEvent event) {
                this.setNone(event);
            }

            public void drop(DropTargetEvent event) {
                this.setNone(event);
            }

            public void dropAccept(DropTargetEvent event) {
                this.setNone(event);
            }
        });
    }

    public boolean stretchVertically() {
        return true;
    }

    private void updateLinks() {
        Object[] types;
        Object[] objectArray = types = this.fLinkContentProvider.getElements(this.fWorkingCopy);
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o instanceof IEndPointDescriptor) {
                ItemizedQuickInformationEntry entry;
                IEndPointDescriptor desc = (IEndPointDescriptor)o;
                if (desc.getReferencedItemType() != null && desc.getReferencedItemType().equals(IWorkItem.ITEM_TYPE)) {
                    if (this.fItemizingEntries.get(desc) == null) {
                        entry = new WorkItemQuickInformationEntry(this, desc);
                        this.fItemizingEntries.put(desc, entry);
                        if (this.fWorkingCopy != null) {
                            ((WorkItemQuickInformationEntry)entry).initialize(this.fWorkingCopy);
                        }
                    }
                } else if (desc.getReferencedItemType() != null && desc.getReferencedItemType().equals(IAttachment.ITEM_TYPE)) {
                    if (this.fItemizingEntries.get(desc) == null) {
                        entry = new ArtifactQuickInformationEntry(this);
                        this.fItemizingEntries.put(desc, entry);
                        if (this.fWorkingCopy != null) {
                            ((ArtifactQuickInformationEntry)entry).initialize(this.fWorkingCopy);
                        }
                    }
                } else if (this.fItemizingEntries.get(desc) == null) {
                    entry = new ReferenceQuickInformationEntry(this, desc);
                    this.fItemizingEntries.put(desc, entry);
                    if (this.fWorkingCopy != null) {
                        ((ReferenceQuickInformationEntry)entry).initialize(this.fWorkingCopy);
                    }
                }
            }
            ++n2;
        }
    }

    private void updateApprovals() {
        if (this.fApprovalsJob == null) {
            this.fApprovalsJob = new ApprovalsJob(Messages.LinksSummaryPart_RESOLVING_SUBSCRIBERS);
        }
        this.fApprovalsJob.schedule();
    }

    public void setInput(Object input) {
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.fLinkContentProvider.inputChanged(null, null, this.fWorkingCopy);
            this.fApprovers = new HashMap();
            this.fContribEntry.initialize(this.fWorkingCopy);
            if (!this.fItemizingEntries.isEmpty()) {
                for (AbstractQuickInformationEntry abstractQuickInformationEntry : this.fItemizingEntries.values()) {
                    abstractQuickInformationEntry.initialize(this.fWorkingCopy);
                }
            }
            this.updateLinks();
            this.updateApprovals();
        } else {
            this.fLinkContentProvider.inputChanged(null, null, null);
            this.fWorkingCopy = null;
            this.fItemizingEntries.clear();
            this.fApprovers = new HashMap();
        }
    }

    IHyperlinkListener getLinksPageActivator() {
        return this.fLinksPageActivator;
    }

    private void activateLinksPage() {
        IEditorPart part = this.getSite().getWorkbenchPage().getActiveEditor();
        if (part instanceof WorkItemEditor) {
            WorkItemEditor editor = (WorkItemEditor)part;
            IFormPage links = null;
            for (Object page : editor.getPages()) {
                if (!(page instanceof LinksTab)) continue;
                links = (IFormPage)page;
                break;
            }
            if (links != null) {
                editor.setActivePage(links.getId());
            }
        }
    }

    private void activateApprovalPage() {
        IEditorPart part = this.getSite().getWorkbenchPage().getActiveEditor();
        if (part instanceof WorkItemEditor) {
            WorkItemEditor editor = (WorkItemEditor)part;
            IFormPage approvals = null;
            for (Object page : editor.getPages()) {
                if (!(page instanceof ApprovalsTab)) continue;
                approvals = (IFormPage)page;
                break;
            }
            if (approvals != null) {
                editor.setActivePage(approvals.getId());
            }
        }
    }

    public void init(ITeamFormPartSite site) {
        super.init(site);
        this.addListeners();
    }

    private void addListeners() {
        this.fUIListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class);
        if (this.fUIListener != null) {
            this.fUIListener.addListener((IWorkItemListener)this.fWorkItemListener, "references");
            this.fUIListener.addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.APPROVALS_PROPERTY);
            this.fUIListener.addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY);
        }
    }

    private void removeListeners() {
        if (this.fUIListener != null) {
            this.fUIListener.removeListener((IWorkItemListener)this.fWorkItemListener, "references");
            this.fUIListener.removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.APPROVALS_PROPERTY);
            this.fUIListener.removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY);
            this.fUIListener = null;
        }
    }

    public void dispose() {
        if (this.fLinkContentProvider != null) {
            this.fLinkContentProvider.dispose();
            this.fLinkContentProvider = null;
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        this.removeListeners();
        if (this.fContribEntry != null) {
            this.fContribEntry.dispose();
            this.fContribEntry = null;
        }
        for (AbstractQuickInformationEntry abstractQuickInformationEntry : this.fItemizingEntries.values()) {
            abstractQuickInformationEntry.dispose();
        }
        this.fItemizingEntries.clear();
        this.fWorkingCopy = null;
        super.dispose();
    }

    private class ApprovalToolTipSupport
    extends TooltipSupport {
        private IApprovalDescriptor fDesc;

        public ApprovalToolTipSupport(Control control, IApprovalDescriptor descriptor) {
            super(control, true, true);
            this.fDesc = descriptor;
        }

        protected Object mapElement(int x, int y) {
            return this.fDesc;
        }

        protected void openRequested(Object element) {
            LinksSummaryPart.this.activateApprovalPage();
        }

        protected String getMarkup(Object element, boolean isFocus) {
            StringBuffer result = new StringBuffer();
            IApprovals app = LinksSummaryPart.this.fWorkingCopy.getWorkItem().getApprovals();
            HashMap stateToApprovers = new HashMap();
            IApproval currentUser = null;
            for (IApproval a : app.getContents(this.fDesc)) {
                if (stateToApprovers.get(WorkItemApprovals.getState((String)a.getStateIdentifier())) == null) {
                    stateToApprovers.put(WorkItemApprovals.getState((String)a.getStateIdentifier()), new ArrayList());
                }
                ((List)stateToApprovers.get(WorkItemApprovals.getState((String)a.getStateIdentifier()))).add(a.getApprover());
                if (!a.getApprover().sameItemId((IItemHandle)LinksSummaryPart.this.fWorkingCopy.getTeamRepository().loggedInContributor())) continue;
                currentUser = a;
            }
            String stateName = WorkItemApprovals.getState((String)this.fDesc.getCumulativeStateIdentifier()).getDisplayName();
            result.append(NLS.bind((String)Messages.LinksSummaryPart_CUMULATIVE_STATE, (Object)this.fDesc.getName(), (Object[])new Object[]{stateName}));
            if (currentUser != null) {
                result.append(NLS.bind((String)Messages.LinksSummaryPart_YOUR_STATE, (Object)WorkItemApprovals.getState((String)currentUser.getStateIdentifier()).getDisplayName(), (Object[])new Object[0]));
            }
            if (isFocus && LinksSummaryPart.this.fWorkingCopy != null) {
                result.append("<ul>");
                for (IApprovalState state : WorkItemApprovals.getStates()) {
                    if (stateToApprovers.get(state) == null) {
                        stateToApprovers.put(state, new ArrayList());
                    }
                    result.append(String.valueOf(state.getDisplayName()) + ": " + ((List)stateToApprovers.get(state)).size());
                    result.append("<ul>");
                    for (IContributorHandle handle : (List)stateToApprovers.get(state)) {
                        String name = Messages.LinksSummaryPart_ERROR_RETRIEVING_NAME;
                        if (LinksSummaryPart.this.fApprovers.get(handle.getItemId()) == null) continue;
                        String uri = URIService.createAuditableURI((ITeamRepository)((ITeamRepository)LinksSummaryPart.this.fWorkingCopy.getWorkItem().getOrigin()), (IItemHandle)((IItemHandle)LinksSummaryPart.this.fApprovers.get(handle.getItemId()))).toString();
                        name = ((IContributor)LinksSummaryPart.this.fApprovers.get(handle.getItemId())).getName();
                        result.append(NLS.bind((String)"<li><a href=''{0}''>{1}</a></li>", (Object)uri, (Object[])new Object[]{name}));
                    }
                    result.append("</ul>");
                    result.append("<br />");
                }
                result.append("</ul>");
            } else {
                result.append("<ul>");
                for (IApprovalState state : WorkItemApprovals.getStates()) {
                    if (stateToApprovers.get(state) == null) {
                        stateToApprovers.put(state, new ArrayList());
                    }
                    result.append(NLS.bind((String)"<li>{0} {1}</li>", (Object)((List)stateToApprovers.get(state)).size(), (Object[])new Object[]{state.getDisplayName()}));
                }
                result.append("</ul>");
            }
            return result.toString();
        }
    }

    private class ApprovalsJob
    extends UIUpdaterJob {
        public ApprovalsJob(String name) {
            super(name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus runInBackground(IProgressMonitor monitor) {
            if (LinksSummaryPart.this.fWorkingCopy != null) {
                IAuditableClient auditableClient = (IAuditableClient)((ITeamRepository)LinksSummaryPart.this.fWorkingCopy.getWorkItem().getOrigin()).getClientLibrary(IAuditableClient.class);
                try {
                    ArrayList<IContributorHandle> toResolve = new ArrayList<IContributorHandle>();
                    for (IApproval a : LinksSummaryPart.this.fWorkingCopy.getWorkItem().getApprovals().getContents()) {
                        toResolve.add(a.getApprover());
                    }
                    List resolved = auditableClient.resolveAuditables(toResolve, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                    Object object = LinksSummaryPart.this.fALock;
                    synchronized (object) {
                        LinksSummaryPart.this.fApprovers = new HashMap();
                        for (IContributor contrib : resolved) {
                            if (contrib == null) continue;
                            LinksSummaryPart.this.fApprovers.put(contrib.getItemId(), contrib);
                        }
                    }
                }
                catch (TeamRepositoryException e) {
                    WorkItemIDEUIPlugin.getDefault().log(Messages.LinksSummaryPart_ERROR_RESOLVING_SUBSCRIBERS, e);
                }
            }
            return super.runInBackground(monitor);
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            LinksSummaryPart.this.updateItems();
            return super.runInUI(monitor);
        }
    }

    private class WorkItemListener
    implements IWorkItemListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (!event.affects((IWorkItemHandle)LinksSummaryPart.this.fWorkingCopy.getWorkItem())) {
                return;
            }
            if (event.affects("references")) {
                LinksSummaryPart.this.updateLinks();
            }
            if (event.affects(IWorkItem.APPROVALS_PROPERTY)) {
                LinksSummaryPart.this.updateApprovals();
            }
            if (event.affects(IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY)) {
                LinksSummaryPart.this.updateItems();
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

