/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.internal.util.Dates;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPart;
import com.ibm.team.foundation.rcp.core.text.ReferencePosition;
import com.ibm.team.foundation.rcp.core.text.TextConverter;
import com.ibm.team.foundation.rcp.ui.dnd.ViewerDragSupport;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.links.common.IItemReference;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.registry.IEndPointDescriptor;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.client.internal.util.ClientUtils;
import com.ibm.team.workitem.common.internal.model.WorkItemAttributes;
import com.ibm.team.workitem.common.internal.presentations.PresentationDescriptor;
import com.ibm.team.workitem.common.model.ReferencesChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemLinkTypes;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.LinkLabelProvider;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.LinkHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.links.LinkContentProvider;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.AbstractPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.IPresentationUpdater;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.presentationhandler.PresentationHandlerManager;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IInputSelectionProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class LinksPart
extends PresentationPart {
    private TreeViewer fViewer;
    private LinkLabelProvider fLinkLabelProvider;
    private WorkItemWorkingCopy fWorkingCopy;
    private ViewerPart fViewerPart;
    private IPresentationUpdater fPresentationUpdater = new AbstractPresentationUpdater(){

        public void attributeChanged(WorkItemChangeEvent event) {
            IEndPointDescriptor referenceType;
            IAdaptable details = event.getAttributeChangeDetails("references");
            if (details == null) {
                LinksPart.this.fViewer.refresh();
                return;
            }
            ReferencesChangeDetails change = (ReferencesChangeDetails)details.getAdapter(ReferencesChangeDetails.class);
            if (change == null) {
                LinksPart.this.fViewer.refresh();
                return;
            }
            for (IReference reference : change.getAdded()) {
                boolean isNewLinkType;
                referenceType = WorkItemLinkTypes.getEndPointDescriptor((IReference)reference);
                if (referenceType == null || LinkContentProvider.isFiltered(referenceType)) continue;
                boolean bl = isNewLinkType = !this.hasLinkType(LinksPart.this.fViewer, referenceType);
                if (isNewLinkType) {
                    LinksPart.this.fViewer.add((Object)LinksPart.this.fWorkingCopy, (Object)referenceType);
                }
                LinksPart.this.fViewer.add((Object)referenceType, (Object)reference);
                if (!isNewLinkType) continue;
                LinksPart.this.fViewer.expandToLevel((Object)referenceType, 1);
            }
            for (IReference reference : change.getRemoved()) {
                referenceType = WorkItemLinkTypes.getEndPointDescriptor((IReference)reference);
                if (referenceType == null || LinkContentProvider.isFiltered(referenceType)) continue;
                LinksPart.this.fViewer.remove((Object)reference);
                if (((ITreeContentProvider)LinksPart.this.fViewer.getContentProvider()).hasChildren((Object)referenceType)) continue;
                LinksPart.this.fViewer.remove((Object)referenceType);
            }
        }

        private boolean hasLinkType(TreeViewer viewer, IEndPointDescriptor linkType) {
            TreeItem[] typeItems = viewer.getTree().getItems();
            int i = 0;
            while (i < typeItems.length) {
                TreeItem item = typeItems[i];
                if (linkType.equals(item.getData())) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    };

    public void createContent(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        parent.setLayout((Layout)layout);
        toolkit.paintBordersFor(parent);
        this.fViewer = new TreeViewer(parent, 770);
        Control control = this.fViewer.getControl();
        this.initAccessible(control);
        toolkit.adapt(control, false, false);
        control.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 200;
        data.heightHint = this.fViewer.getTree().getItemHeight() * 2;
        control.setLayoutData((Object)data);
        this.fViewer.setContentProvider((IContentProvider)new LinkContentProvider());
        this.fLinkLabelProvider = new LinkLabelProvider();
        this.fViewer.setLabelProvider((IBaseLabelProvider)this.fLinkLabelProvider);
        this.fViewer.setComparator((ViewerComparator)new LinkComparator());
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                new LinkHelper.OpenLinkAction((IInputSelectionProvider)LinksPart.this.fViewer).run();
            }
        });
        this.createTooltipSupport(control);
        this.createDragSource();
        this.createDropTarget();
        this.getSite().registerSelectionProvider((ISelectionProvider)this.fViewer, control);
        this.createContextMenu((Viewer)this.fViewer, control);
        ViewerPane viewerPane = (ViewerPane)this.getSite().getAdapter(ViewerPane.class);
        if (viewerPane != null) {
            this.fViewerPart = new ViewerPart((Viewer)this.fViewer, "references");
            viewerPane.addViewerPart(this.fViewerPart);
        }
        Control toolBar = this.createToolPanel(parent, toolkit);
        toolBar.setLayoutData((Object)new GridData(4, 128, false, false));
    }

    private void createTooltipSupport(Control control) {
        new TooltipSupport(control, true, true){

            protected Object mapElement(int x, int y) {
                Object element = super.mapElement(x, y);
                if (element instanceof IReference && ((IReference)element).isItemReference()) {
                    return ((IItemReference)element).getReferencedItem();
                }
                return null;
            }
        };
    }

    private void createDragSource() {
        new ViewerDragSupport((Viewer)this.fViewer){

            protected void dragFinished(DragSourceEvent event) {
                if (event.doit && (event.detail & 2) != 0) {
                    WorkItemWorkingCopy input = (WorkItemWorkingCopy)LinksPart.this.fViewer.getInput();
                    Iterator iterator = LinksPart.getSelectionIterator();
                    if (input != null && iterator != null) {
                        while (iterator.hasNext()) {
                            Object element = iterator.next();
                            if (!(element instanceof IReference)) continue;
                            IReference reference = (IReference)element;
                            input.getReferences().remove(reference);
                        }
                    }
                }
            }

            protected boolean validateSelection(ISelection selection) {
                if (super.validateSelection(selection)) {
                    IStructuredSelection structured = (IStructuredSelection)selection;
                    Object[] objectArray = structured.toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (!(element instanceof IReference)) {
                            return false;
                        }
                        ++n2;
                    }
                    return true;
                }
                return false;
            }

            protected URIReference[] createReferences(Object[] elements) {
                Assert.isNotNull((Object)elements);
                return Util.createURIReferences(elements, ((WorkItemWorkingCopy)LinksPart.this.fViewer.getInput()).getTeamRepository());
            }
        };
    }

    private void createDropTarget() {
        DropTarget target = new DropTarget(this.fViewer.getControl(), 7);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getInstance(), HTMLTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new LinkDropTargetListener(){

            protected IEndPointDescriptor getEndPoint(DropTargetEvent event) {
                return LinksPart.this.findDropTargetType(event);
            }

            protected WorkItemWorkingCopy getWorkingCopy() {
                return (WorkItemWorkingCopy)LinksPart.this.fViewer.getInput();
            }

            protected Control getControl() {
                return LinksPart.this.fViewer.getControl();
            }
        });
    }

    private IEndPointDescriptor findDropTargetType(DropTargetEvent event) {
        if (event.item == null) {
            return null;
        }
        return this.findReferenceType(event.item.getData());
    }

    private static Iterator getSelectionIterator() {
        IStructuredSelection selection = LinksPart.getStructuredSelection();
        if (selection == null) {
            return null;
        }
        return selection.iterator();
    }

    private static IStructuredSelection getStructuredSelection() {
        ISelection selection = LocalSelectionTransfer.getInstance().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            return (IStructuredSelection)selection;
        }
        return null;
    }

    private Control createToolPanel(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        toolkit.paintBordersFor(composite);
        AddLinkDropDown addLink = new AddLinkDropDown(composite, toolkit);
        addLink.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        ActionButton openLink = new ActionButton(new LinkHelper.OpenLinkAction((IInputSelectionProvider)this.fViewer), composite, toolkit);
        openLink.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        ActionButton deleteLink = new ActionButton(new LinkHelper.DeleteLinkAction((IInputSelectionProvider)this.fViewer), composite, toolkit);
        deleteLink.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        return composite;
    }

    private void createContextMenu(Viewer viewer, Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LinkHelper.addSelectionActions(LinksPart.this.getSite().getWorkbenchPage(), manager, (IInputSelectionProvider)LinksPart.this.fViewer);
            }
        });
        this.getSite().registerContextMenu(this.getId(), menuMgr, (ISelectionProvider)new InternalConvertingSelectionProvider(viewer));
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void setFocus() {
        if (this.fViewer != null && !this.fViewer.getTree().isDisposed()) {
            this.fViewer.getTree().setFocus();
        }
    }

    private void addListeners() {
        PresentationHandlerManager mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class);
        if (mgr != null) {
            PresentationDescriptor desc = Util.cloneDescriptor(this.getDescriptor());
            desc.setAttributeId(WorkItemAttributes.getPropertyIdentifier((String)"references"));
            mgr.addPresentationUpdater(this.fPresentationUpdater, desc);
        }
    }

    public void setInput(Object input) {
        this.removeListeners();
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            WorkItemEditorInput workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            this.addListeners();
            this.fViewer.setInput((Object)this.fWorkingCopy);
            this.fViewer.expandAll();
        } else {
            this.fWorkingCopy = null;
            this.fViewer.setInput(null);
        }
    }

    private void removeListeners() {
        PresentationHandlerManager mgr;
        if (this.getSite() != null && (mgr = (PresentationHandlerManager)this.getSite().getAdapter(PresentationHandlerManager.class)) != null) {
            mgr.removePresentationUpdater(this.fPresentationUpdater);
        }
    }

    public void dispose() {
        if (this.fViewerPart != null) {
            ViewerPane viewerPane = (ViewerPane)this.getSite().getAdapter(ViewerPane.class);
            if (viewerPane != null) {
                viewerPane.removeViewerPart(this.fViewerPart);
            }
            this.fViewerPart = null;
        }
        this.removeListeners();
        this.fViewer = null;
        super.dispose();
    }

    private IEndPointDescriptor findReferenceType(Object element) {
        if (element instanceof IEndPointDescriptor) {
            return (IEndPointDescriptor)element;
        }
        if (element instanceof IReference) {
            return WorkItemLinkTypes.getEndPointDescriptor((IReference)((IReference)element));
        }
        return null;
    }

    private class ActionButton {
        private Action fAction;
        private Button fButton;

        public ActionButton(Action action, Composite parent, FormToolkit toolkit) {
            this.fAction = action;
            this.fButton = toolkit.createButton(parent, this.fAction.getText(), 0);
            this.fButton.setEnabled(this.fAction.isEnabled());
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ActionButton.this.fAction.isEnabled()) {
                        ActionButton.this.fAction.run();
                    }
                }
            });
            if (this.fAction instanceof IUpdate) {
                LinksPart.this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        ((IUpdate)ActionButton.this.fAction).update();
                        ActionButton.this.fButton.setEnabled(ActionButton.this.fAction.isEnabled());
                    }
                });
            }
        }

        public Control getControl() {
            return this.fButton;
        }
    }

    private class AddLinkDropDown {
        private Button fButton;

        public AddLinkDropDown(Composite parent, FormToolkit toolkit) {
            this.fButton = toolkit.createButton(parent, Messages.LinksPart_ADD, 0x4000000);
            this.fButton.setImage(WorkItemIDEUIPlugin.getImage(ImagePool.DROPDOWN));
            this.fButton.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    Menu menu = AddLinkDropDown.this.getMenu((Control)AddLinkDropDown.this.fButton);
                    Point location = AddLinkDropDown.this.fButton.getParent().toDisplay(AddLinkDropDown.this.fButton.getLocation());
                    location.y += ((AddLinkDropDown)AddLinkDropDown.this).fButton.getBounds().height;
                    menu.setLocation(location);
                    Util.showAndDisposeOnHide(menu);
                }
            });
        }

        public Control getControl() {
            return this.fButton;
        }

        private Menu getMenu(Control parent) {
            MenuManager manager = new MenuManager();
            WorkItemWorkingCopy workingCopy = (WorkItemWorkingCopy)LinksPart.this.fViewer.getInput();
            LinkHelper.addEmptySelectionActions(LinksPart.this.getSite().getWorkbenchPage(), (IMenuManager)manager, workingCopy);
            return manager.createContextMenu(parent);
        }
    }

    public static class InternalConvertingSelectionProvider
    extends ConvertingSelectionProvider {
        private Viewer fViewer;

        public InternalConvertingSelectionProvider(Viewer viewer) {
            super((ISelectionProvider)viewer);
            this.fViewer = viewer;
        }

        protected ISelection convertFrom(ISelection viewerSelection) {
            if (!(viewerSelection instanceof IStructuredSelection)) {
                return viewerSelection;
            }
            Object input = this.fViewer.getInput();
            if (!(input instanceof WorkItemWorkingCopy)) {
                return viewerSelection;
            }
            IStructuredSelection selection = (IStructuredSelection)viewerSelection;
            ArrayList<Object> result = new ArrayList<Object>(selection.size());
            for (Object element : selection) {
                IItemHandle adapter = null;
                if (element instanceof ArtifactLink) {
                    element = ((ArtifactLink)element).getReference();
                }
                if (element instanceof IReference) {
                    adapter = ClientUtils.findItemHandle((String)((WorkItemWorkingCopy)input).getTeamRepository().getRepositoryURI(), (IReference)((IReference)element));
                }
                if (adapter != null) {
                    result.add(adapter);
                    continue;
                }
                result.add(element);
            }
            return new StructuredSelection(result);
        }
    }

    private static class LinkComparator
    extends ViewerComparator {
        private LinkComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IReference && ((IReference)e1).getLink() != null && e2 instanceof IReference && ((IReference)e2).getLink() != null) {
                Date modified1 = ((IReference)e1).getLink().modified();
                Date modified2 = ((IReference)e2).getLink().modified();
                if (modified1 == null && modified2 == null) {
                    return super.compare(viewer, e1, e2);
                }
                if (modified1 == null) {
                    return 1;
                }
                if (modified2 == null) {
                    return -1;
                }
                return Dates.compareTo((Date)modified1, (Date)modified2);
            }
            return super.compare(viewer, e1, e2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class LinkDropTargetListener
    implements DropTargetListener {
        protected abstract WorkItemWorkingCopy getWorkingCopy();

        protected abstract IEndPointDescriptor getEndPoint(DropTargetEvent var1);

        protected Control getControl() {
            return null;
        }

        public void dragEnter(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dropAccept(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void drop(DropTargetEvent event) {
            this.performDrop(event);
        }

        public void dragOver(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dragLeave(DropTargetEvent event) {
        }

        private void validateDrop(DropTargetEvent event) {
            if (!this.canRun(event)) {
                event.detail = 0;
                return;
            }
            if (this.allLinks(event)) {
                this.selectOperation(event, new int[]{4, 2, 1});
            } else {
                this.selectOperation(event, new int[]{4});
            }
        }

        private void selectOperation(DropTargetEvent event, int[] operations) {
            int i = 0;
            while (i < operations.length) {
                if ((event.operations & operations[i]) != 0) {
                    event.detail = operations[i];
                    return;
                }
                ++i;
            }
            event.detail = 0;
        }

        /*
         * Unable to fully structure code
         */
        private boolean allLinks(DropTargetEvent event) {
            iter = LinksPart.access$2();
            if (iter != null) ** GOTO lbl7
            return false;
lbl-1000:
            // 1 sources

            {
                next = iter.next();
                if (next instanceof IReference) continue;
                return false;
lbl7:
                // 2 sources

                ** while (iter.hasNext())
            }
lbl8:
            // 1 sources

            return true;
        }

        private void performDrop(DropTargetEvent event) {
            List<IEndPointDescriptor> targetTypes;
            if (!this.canRun(event)) {
                event.detail = 0;
                return;
            }
            final ArrayList<Object> elements = new ArrayList<Object>();
            if (LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                IStructuredSelection selection = LinksPart.getStructuredSelection();
                elements.addAll(this.findItemHandles(selection));
            } else if (HTMLTransfer.getInstance().isSupportedType(event.currentDataType) && event.data instanceof String) {
                String html = (String)event.data;
                TextConverter.FeaturedText featuredText = TextConverter.fromHTML2FeaturedText((XMLString)XMLString.createFromXMLText((String)html));
                String text = featuredText.getText();
                ReferencePosition[] referencePositionArray = featuredText.getReferencePositions();
                int n = referencePositionArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ReferencePosition referencePosition = referencePositionArray[n2];
                    URI uri = referencePosition.getReference();
                    int offset = referencePosition.getOffset();
                    String label = text.substring(offset, offset + referencePosition.getLength()).trim();
                    if (label.length() == 0) {
                        label = uri.toString();
                    }
                    elements.add(new URIReference(label, "", uri));
                    ++n2;
                }
            }
            if (elements.isEmpty()) {
                event.detail = 0;
                return;
            }
            IEndPointDescriptor targetType = this.getEndPoint(event);
            if (targetType == null && (targetTypes = LinkHelper.getTargetTypes(elements, WorkItemLinkTypes.getUserWritableDescriptors(), this.getWorkingCopy())).size() == 1) {
                targetType = targetTypes.get(0);
            }
            if (targetType == null) {
                if (this.getControl() == null) {
                    event.detail = 0;
                    return;
                }
                MenuManager menuMgr = new MenuManager("#PopupMenu");
                menuMgr.setRemoveAllWhenShown(true);
                menuMgr.addMenuListener(new IMenuListener(){

                    public void menuAboutToShow(IMenuManager manager) {
                        LinkHelper.addDropActions(manager, LinkDropTargetListener.this.getWorkingCopy(), elements);
                    }
                });
                Menu menu = menuMgr.createContextMenu(this.getControl());
                Util.showAndDisposeOnHide(menu);
                return;
            }
            LinkHelper.AddLinkToEndPointAction action = new LinkHelper.AddLinkToEndPointAction(this.getWorkingCopy(), targetType, "", elements);
            if (action.isEnabled()) {
                action.run();
            }
        }

        private boolean canRun(DropTargetEvent event) {
            if (this.getWorkingCopy() == null) {
                return false;
            }
            IStructuredSelection selection = null;
            if (LocalSelectionTransfer.getInstance().isSupportedType(event.currentDataType)) {
                selection = LinksPart.getStructuredSelection();
            } else if (HTMLTransfer.getInstance().isSupportedType(event.currentDataType)) {
                return true;
            }
            if (selection == null) {
                return false;
            }
            ArrayList<IItemHandle> elements = new ArrayList<IItemHandle>();
            try {
                elements.addAll(this.findItemHandles(selection));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return false;
            }
            IEndPointDescriptor targetType = this.getEndPoint(event);
            if (targetType == null) {
                return !LinkHelper.getTargetTypes(elements, WorkItemLinkTypes.getUserWritableDescriptors(), this.getWorkingCopy()).isEmpty();
            }
            return !LinkHelper.getTargetTypes(elements, Collections.singletonList(targetType), this.getWorkingCopy()).isEmpty();
        }

        private List<IItemHandle> findItemHandles(IStructuredSelection selection) {
            ArrayList<IItemHandle> list = new ArrayList<IItemHandle>();
            Iterator iter = selection.iterator();
            while (iter.hasNext()) {
                IItemHandle handle = LinkHelper.findItemHandle(iter.next());
                if (handle == null || handle.sameItemId((IItemHandle)this.getWorkingCopy().getWorkItem()) || handle.getOrigin() != this.getWorkingCopy().getTeamRepository()) continue;
                list.add(handle);
            }
            return list;
        }
    }
}

