/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledTextViewerSupport;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.SourceViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPane;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.actions.ViewerPart;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.core.text.IStyledDocument;
import com.ibm.team.foundation.rcp.core.text.StyledDocument;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.Location;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.ui.editor.TeamFormPartSite;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.model.ChangeDetails;
import com.ibm.team.workitem.common.model.CommentsChangeDetails;
import com.ibm.team.workitem.common.model.IComment;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.CSashForm;
import com.ibm.team.workitem.ide.ui.internal.editor.CommentsDocument;
import com.ibm.team.workitem.ide.ui.internal.editor.DocumentModel;
import com.ibm.team.workitem.ide.ui.internal.editor.SourceViewerSupport;
import com.ibm.team.workitem.ide.ui.internal.editor.TextLineWrapper;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorToolkit;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemUIWorkingCopy;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.rcp.ui.ContributorColors;
import com.ibm.team.workitem.rcp.ui.IWorkItemUIWorkingCopy;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemContextProvider;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.projection.ProjectionAnnotation;
import org.eclipse.jface.text.source.projection.ProjectionAnnotationModel;
import org.eclipse.jface.text.source.projection.ProjectionViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.Section;

public class DiscussionPart
extends PresentationPart {
    public static final String AUTO_SUBSCRIBE = "com.ibm.team.workitem.ide.ui.editor.autosubscribe";
    private static final String SAVE_REMINDER_TEXT = Messages.DiscussionPart_PRESS_SAVE;
    private static final boolean USE_GLOBAL_CONTRIBUTOR_COLORS = true;
    private static final String NEW_COMMENT = "newComment";
    private static final int COMMENTS_HEIGHT_HINT = 140;
    private static final int COMMENTS_WIDTH_HINT = 100;
    private static final int COMMENTS_DRAG_MINIMUM = 64;
    private StyledTextViewerSupport fCommentsViewerSupport;
    private ProjectionViewer fProjectionViewer;
    private ViewerPart fCommentsViewerPart;
    private IOverviewRuler fOverviewRuler;
    private Map fConfiguredAnnotationTypes = new HashMap();
    private boolean fShowUserInOverviewRuler = true;
    private StyledTextViewerSupport fNewCommentViewerSupport;
    private ViewerPart fNewCommentViewerPart;
    private CSashForm fContainer;
    private boolean fIsNewCommentsFieldVisible = false;
    private DocumentModel fCommentsSupport;
    private int fFirstNew;
    private WorkItemWorkingCopy fWorkingCopy;
    private WorkItemListener fWorkItemListener = new WorkItemListener();
    private ContributorColors fContributorColors;
    private Composite fCommentsContainer;
    private boolean fRevealEnd = true;
    private static final String COMMENTS_LABEL_FONT = "com.ibm.team.workitem.ide.ui.internal.editor.commentsLabelFont";
    private static final String SHOW_NEW_COMMENT_TEXT = Messages.DiscussionPart_ADD_COMMENT;
    private static final String HIDE_NEW_COMMENT_TEXT = Messages.DiscussionPart_HIDE_COMMENT;
    private Section fSection;
    private Label fCommentsLabel;
    private Hyperlink fNewCommentLink;
    private ResourceManager fResourceManager;

    public void createContent(Composite parent) {
        ViewerPane viewerPane;
        WorkItemContextProvider contextProvider;
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.marginBottom = 5;
        parent.setLayout((Layout)layout);
        this.fContainer = new CSashForm(parent, 512){

            public void setBounds(int x, int y, int width, int height) {
                super.setBounds(x, y, width, height);
                if (SWT.getPlatform().equals("win32")) {
                    this.layout(false, true);
                }
            }
        };
        this.fContainer.setLayoutData(new GridData(4, 4, true, true));
        this.fContainer.setDragMinimum(64);
        if (Util.isInWorkItemEditor(this)) {
            ((GridData)this.fContainer.getLayoutData()).heightHint = 140;
            ((GridData)this.fContainer.getLayoutData()).widthHint = 100;
        }
        toolkit.adapt((Composite)this.fContainer);
        this.fCommentsContainer = toolkit.createComposite((Composite)this.fContainer);
        layout = new GridLayout(1, false);
        layout.marginWidth = 1;
        layout.marginHeight = 2;
        this.fCommentsContainer.setLayout((Layout)layout);
        toolkit.paintBordersFor(this.fCommentsContainer);
        ITeamFormPartSite commentsSite = this.getSite();
        if (this.getSite() instanceof TeamFormPartSite) {
            contextProvider = (ContextProvider)this.getSite().getAdapter(ContextProvider.class);
            final CommentsContextProvider commentsContextProvider = new CommentsContextProvider((ContextProvider)contextProvider);
            commentsSite = new TeamFormPartSite((TeamFormPartSite)this.getSite(), new IAdaptable(){

                public Object getAdapter(Class adapter) {
                    if (ContextProvider.class.equals((Object)adapter)) {
                        return commentsContextProvider;
                    }
                    return DiscussionPart.this.getSite().getAdapter(adapter);
                }
            });
        }
        contextProvider = new WorkItemContextProvider(){

            protected WorkItemWorkingCopy getWorkItemWorkingCopy() {
                return DiscussionPart.this.fWorkingCopy;
            }
        };
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        this.fCommentsViewerSupport = SourceViewerSupport.createStyledTextViewerSupport();
        this.fCommentsViewerSupport.getTextViewerDecorators().add(0, new TextLineWrapper());
        this.fCommentsViewerSupport.setUseOverviewRuler(true);
        this.fCommentsViewerSupport.setUseProjectionViewer(true);
        this.fCommentsViewerSupport.setStyle(66306);
        this.fCommentsViewerSupport.setMargin(new Point(1, 1));
        this.fCommentsViewerSupport.setEnableSpellChecking(false);
        this.fCommentsViewerSupport.setContentAssistContextProvider((ContentAssistContextProvider)contextProvider);
        this.fCommentsViewerSupport.init(commentsSite);
        this.fCommentsViewerSupport.createContent(this.fCommentsContainer);
        this.fProjectionViewer = (ProjectionViewer)this.fCommentsViewerSupport.getSourceViewer();
        this.initAccessible((Control)this.fCommentsViewerSupport.getSourceViewer().getTextWidget(), Messages.DiscussionPart_DISCUSSION);
        Caret c = this.fProjectionViewer.getTextWidget().getCaret();
        this.fProjectionViewer.setEditable(false);
        this.fProjectionViewer.getTextWidget().setCaret(c);
        ScrollBar bar = this.fProjectionViewer.getTextWidget().getVerticalBar();
        if (bar != null) {
            bar.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DiscussionPart.this.updateRevealEnd();
                }
            });
        }
        this.fOverviewRuler = this.fCommentsViewerSupport.getOverviewRuler();
        Control control = this.fProjectionViewer.getControl();
        control.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        toolkit.adapt(control, false, false);
        control.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        SourceViewerPane sourceViewerPane = (SourceViewerPane)this.getSite().getAdapter(SourceViewerPane.class);
        if (sourceViewerPane != null) {
            sourceViewerPane.addSourceViewer((ISourceViewer)this.fProjectionViewer);
        }
        if ((viewerPane = (ViewerPane)this.getSite().getAdapter(ViewerPane.class)) != null) {
            this.fCommentsViewerPart = new ViewerPart((Viewer)this.fProjectionViewer, IWorkItem.COMMENTS_PROPERTY);
            viewerPane.addViewerPart(this.fCommentsViewerPart);
        }
        this.fProjectionViewer.appendVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent event) {
                DiscussionPart.this.handleCommentTyped(event);
            }
        });
        this.fProjectionViewer.addTextPresentationListener((ITextPresentationListener)new InternalPresentationListener((TextViewer)this.fProjectionViewer, this.fResourceManager));
        Composite text = toolkit.createComposite((Composite)this.fContainer);
        toolkit.paintBordersFor(text);
        text.setLayout((Layout)new GridLayout());
        ((GridLayout)text.getLayout()).marginWidth = 0;
        ((GridLayout)text.getLayout()).marginHeight = 0;
        this.fContainer.setWeights(new int[]{70, 30});
        Composite borderContainer = toolkit.createComposite(text, 0);
        borderContainer.setLayoutData((Object)new GridData(4, 4, true, true));
        borderContainer.setLayout((Layout)new GridLayout());
        ((GridLayout)borderContainer.getLayout()).marginHeight = 2;
        ((GridLayout)borderContainer.getLayout()).marginWidth = 1;
        ((GridLayout)borderContainer.getLayout()).marginBottom = 2;
        ((GridLayout)borderContainer.getLayout()).verticalSpacing = 2;
        toolkit.paintBordersFor(borderContainer);
        Composite container = toolkit.createComposite(borderContainer);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginLeft = 2;
        layout.marginHeight = 2;
        container.setLayout((Layout)layout);
        this.fNewCommentViewerSupport = SourceViewerSupport.createStyledTextViewerSupport();
        this.fNewCommentViewerSupport.setMargin(new Point(1, 1));
        this.fNewCommentViewerSupport.init(this.getSite());
        this.fNewCommentViewerSupport.setContentAssistContextProvider((ContentAssistContextProvider)contextProvider);
        this.fNewCommentViewerSupport.createContent(container);
        control = this.fNewCommentViewerSupport.getSourceViewer().getControl();
        this.initAccessible(control, Messages.DiscussionPart_NEW_COMMENT);
        if (WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getBoolean(AUTO_SUBSCRIBE)) {
            this.fNewCommentViewerSupport.getSourceViewer().addTextListener(new ITextListener(){
                private boolean fRun = true;

                public void textChanged(TextEvent event) {
                    if (this.fRun && event.getText() != null && event.getText().length() > 0) {
                        this.fRun = false;
                        if (WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getBoolean(DiscussionPart.AUTO_SUBSCRIBE)) {
                            DiscussionPart.this.addCurrentUserAsSubscriber();
                        }
                    }
                }
            });
        }
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.adapt(control, false, false);
        control.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        Composite reminderContainer = toolkit.createComposite(borderContainer);
        reminderContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 2;
        reminderContainer.setLayout((Layout)layout);
        reminderContainer.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        if (!JFaceResources.getFontRegistry().hasValueFor(COMMENTS_LABEL_FONT)) {
            FontData[] datas = JFaceResources.getFontRegistry().defaultFont().getFontData();
            int i = 0;
            while (i < datas.length) {
                FontData data = datas[i];
                data.setHeight(data.getHeight() - 1);
                ++i;
            }
            JFaceResources.getFontRegistry().put(COMMENTS_LABEL_FONT, datas);
        }
        Label reminder = toolkit.createLabel(reminderContainer, SAVE_REMINDER_TEXT);
        reminder.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        reminder.setForeground(reminder.getDisplay().getSystemColor(16));
        reminder.setFont(JFaceResources.getFont((String)COMMENTS_LABEL_FONT));
        if (sourceViewerPane != null) {
            sourceViewerPane.addSourceViewer((ISourceViewer)this.fNewCommentViewerSupport.getSourceViewer());
        }
        if (viewerPane != null) {
            this.fNewCommentViewerPart = new ViewerPart((Viewer)this.fNewCommentViewerSupport.getSourceViewer(), NEW_COMMENT);
            viewerPane.addViewerPart(this.fNewCommentViewerPart);
        }
        this.createSectionHeader(parent, toolkit);
        this.makeNewCommentsFieldVisible(!this.sectionHeaderExists());
        this.addWorkItemListener();
    }

    private void updateRevealEnd() {
        StyledText text = this.fProjectionViewer.getTextWidget();
        ScrollBar bar = text.getVerticalBar();
        this.fRevealEnd = bar.getSelection() + bar.getThumb() >= bar.getMaximum();
    }

    private void handleCommentTyped(VerifyEvent event) {
        if (Character.getType(event.character) != 15) {
            this.setFocusNewComment();
            String value = this.fNewCommentViewerSupport.getSourceViewer().getDocument().get();
            value = String.valueOf(value) + String.valueOf(event.character);
            StyledText textWidget = this.fNewCommentViewerSupport.getSourceViewer().getTextWidget();
            this.fNewCommentViewerSupport.getSourceViewer().getDocument().set(value);
            textWidget.setCaretOffset(textWidget.getCharCount());
        }
    }

    private void addCurrentUserAsSubscriber() {
        IContributor currentUser = this.fWorkingCopy.getTeamRepository().loggedInContributor();
        if (currentUser == null) {
            return;
        }
        if (currentUser.sameItemId((IItemHandle)this.fWorkingCopy.getWorkItem().getOwner())) {
            return;
        }
        if (this.fWorkingCopy.getWorkItem().getSubscriptions().contains((IContributorHandle)currentUser)) {
            return;
        }
        this.fWorkingCopy.getWorkItem().getSubscriptions().add((IContributorHandle)currentUser);
    }

    public void setFocusNewComment() {
        this.makeNewCommentsFieldVisible(true);
        this.fNewCommentViewerSupport.getSourceViewer().getTextWidget().setFocus();
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void setInput(Object input) {
        WorkItemEditorInput workItemEditorInput;
        WorkItemWorkingCopy workingCopy = null;
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            workItemEditorInput = (WorkItemEditorInput)((Object)input);
            workingCopy = workItemEditorInput.getWorkingCopy();
        }
        if (workingCopy == this.fWorkingCopy) {
            return;
        }
        if (this.fWorkingCopy != null) {
            this.getCommentsDocument().removeCommentListener((IWorkItemListener)this.fWorkItemListener);
            this.getUIWorkingCopy().removeDocumentModel(this.getCommentsSupport());
            this.fWorkingCopy = null;
            this.fCommentsSupport = null;
        }
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            workItemEditorInput = (WorkItemEditorInput)((Object)input);
            this.fWorkingCopy = workItemEditorInput.getWorkingCopy();
            CommentsDocument document = new CommentsDocument(this.getUIWorkingCopy());
            this.fCommentsSupport = new DocumentModel((IStyledDocument)document);
            this.fProjectionViewer.setDocument((IDocument)this.getCommentsDocument(), this.getCommentsSupport().getAnnotationModel());
            this.fProjectionViewer.enableProjection();
            this.fCommentsViewerSupport.updateBaseURI();
            this.initializeComments();
            this.fNewCommentViewerSupport.getSourceViewer().setDocument((IDocument)this.getUIWorkingCopy().getNewComment(), this.getUIWorkingCopy().getNewCommentAnnotationModel());
            this.fNewCommentViewerSupport.updateBaseURI();
            this.getUIWorkingCopy().addDocumentModel(this.fCommentsSupport);
            this.getCommentsDocument().addCommentListener((IWorkItemListener)this.fWorkItemListener);
        } else {
            StyledDocument document = new StyledDocument();
            this.fProjectionViewer.setDocument((IDocument)document, null);
            this.fNewCommentViewerSupport.getSourceViewer().setDocument((IDocument)document, null);
        }
    }

    public void dispose() {
        ViewerPane viewerPane;
        SourceViewerPane sourceViewerPane;
        if (this.getSite() != null) {
            this.removeWorkItemListener();
        }
        if (this.fCommentsViewerSupport != null) {
            sourceViewerPane = (SourceViewerPane)this.getSite().getAdapter(SourceViewerPane.class);
            if (sourceViewerPane != null) {
                sourceViewerPane.removeSourceViewer((ISourceViewer)this.fCommentsViewerSupport.getSourceViewer());
            }
            this.fCommentsViewerSupport.dispose();
            this.fCommentsViewerSupport = null;
            this.fProjectionViewer = null;
        }
        if (this.fCommentsViewerPart != null) {
            viewerPane = (ViewerPane)this.getSite().getAdapter(ViewerPane.class);
            if (viewerPane != null) {
                viewerPane.removeViewerPart(this.fCommentsViewerPart);
            }
            this.fCommentsViewerPart = null;
        }
        if (this.fNewCommentViewerSupport != null) {
            sourceViewerPane = (SourceViewerPane)this.getSite().getAdapter(SourceViewerPane.class);
            if (sourceViewerPane != null) {
                sourceViewerPane.removeSourceViewer((ISourceViewer)this.fNewCommentViewerSupport.getSourceViewer());
            }
            this.fNewCommentViewerSupport.dispose();
            this.fNewCommentViewerSupport = null;
        }
        if (this.fNewCommentViewerPart != null) {
            viewerPane = (ViewerPane)this.getSite().getAdapter(ViewerPane.class);
            if (viewerPane != null) {
                viewerPane.removeViewerPart(this.fNewCommentViewerPart);
            }
            this.fNewCommentViewerPart = null;
        }
        if (this.fWorkingCopy != null) {
            this.getCommentsDocument().removeCommentListener((IWorkItemListener)this.fWorkItemListener);
            this.getUIWorkingCopy().removeDocumentModel(this.getCommentsSupport());
            this.fWorkingCopy = null;
        }
        if (this.fResourceManager != null) {
            this.fResourceManager.dispose();
            this.fResourceManager = null;
        }
        super.dispose();
    }

    private void addWorkItemListener() {
        UIWorkItemListener uiWorkItemListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class);
        if (uiWorkItemListener != null) {
            uiWorkItemListener.addListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.OWNER_PROPERTY);
        }
    }

    private void removeWorkItemListener() {
        UIWorkItemListener uiWorkItemListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class);
        if (uiWorkItemListener != null) {
            uiWorkItemListener.removeListener((IWorkItemListener)this.fWorkItemListener, IWorkItem.OWNER_PROPERTY);
        }
    }

    private void handleCommentsChanged(WorkItemChangeEvent event) {
        IAdaptable adaptable = event.getAttributeChangeDetails(IWorkItem.COMMENTS_PROPERTY);
        if (adaptable != null) {
            CommentsChangeDetails details = (CommentsChangeDetails)adaptable.getAdapter(CommentsChangeDetails.class);
            if (details != null && details.isAddition()) {
                this.handleCommentAdded(details.getComment(), details.getIndex(), event.getAttributeChangeType(IWorkItem.COMMENTS_PROPERTY) != 2);
            } else {
                this.initializeComments();
            }
        } else {
            this.initializeComments();
        }
    }

    private void handleCommentAdded(IComment comment, int commentIndex, boolean reveal) {
        this.updateSectionHeaderComments();
        Position commentRange = this.getCommentsDocument().getProjectionRanges()[commentIndex];
        int offset = this.getCommentsDocument().getLength();
        ProjectionAnnotationModel model = this.fProjectionViewer.getProjectionAnnotationModel();
        if (model != null) {
            URIReference reference = Hyperlinks.createHyperlink((Object)comment);
            model.addAnnotation((Annotation)new CommentProjectionAnnotation(reference), new Position(commentRange.getOffset(), commentRange.getLength()));
        }
        if ((model = this.fProjectionViewer.getAnnotationModel()) != null) {
            String type = this.getAnnotationType(comment.getCreator());
            this.configureAnnotationType(comment.getCreator());
            model.addAnnotation(new Annotation(type, false, this.getCommentCreatorAsURI(comment.getCreator())), new Position(commentRange.getOffset(), commentRange.getLength()));
            this.fOverviewRuler.update();
        }
        this.fProjectionViewer.invalidateTextPresentation(offset, this.getCommentsDocument().getLength() - offset);
        this.adjustCommentScrollPosition();
    }

    private void adjustCommentScrollPosition() {
        if (this.fWorkingCopy != null && this.fRevealEnd) {
            this.fProjectionViewer.revealRange(this.getCommentsDocument().getLength(), 0);
        }
    }

    private void initializeComments() {
        this.updateSectionHeaderComments();
        ProjectionAnnotationModel model = this.fProjectionViewer.getProjectionAnnotationModel();
        if (model != null) {
            model.removeAllAnnotations();
        }
        Position[] ranges = this.getCommentsDocument().getProjectionRanges();
        model = this.fProjectionViewer.getProjectionAnnotationModel();
        Position posToReveal = null;
        if (ranges.length > 0) {
            posToReveal = ranges[ranges.length - 1];
        }
        if (model != null) {
            HashMap<CommentProjectionAnnotation, Position> map = new HashMap<CommentProjectionAnnotation, Position>();
            URIReference[] commentReferences = this.createCommentReferences();
            int i = 0;
            while (i < ranges.length) {
                Position position = ranges[i];
                map.put(new CommentProjectionAnnotation(commentReferences[i]), new Position(position.getOffset(), position.getLength()));
                ++i;
            }
            model.replaceAnnotations(null, map);
        }
        IAnnotationModelExtension iAnnotationModelExtension = model = this.fProjectionViewer.getAnnotationModel() instanceof IAnnotationModelExtension ? (IAnnotationModelExtension)this.fProjectionViewer.getAnnotationModel() : null;
        if (model != null) {
            model.removeAllAnnotations();
            HashMap<Annotation, Position> authorMap = new HashMap<Annotation, Position>();
            String[] uris = this.getCommentCreatorsAsURIs();
            IComment[] comments = this.fWorkingCopy.getWorkItem().getComments().getContents();
            int i = 0;
            while (i < ranges.length) {
                Position position = ranges[i];
                if (this.fFirstNew - 1 == i) {
                    posToReveal = position;
                }
                this.configureAnnotationType(comments[i].getCreator());
                String type = this.getAnnotationType(comments[i].getCreator());
                authorMap.put(new Annotation(type, false, uris[i]), new Position(position.getOffset(), position.getLength()));
                ++i;
            }
            model.replaceAnnotations(null, authorMap);
            this.fOverviewRuler.update();
        }
        if (posToReveal != null) {
            final Position finalPosToReveal = posToReveal;
            this.fProjectionViewer.getTextWidget().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (DiscussionPart.this.fProjectionViewer != null && DiscussionPart.this.fProjectionViewer.getTextWidget() != null && !finalPosToReveal.isDeleted() && DiscussionPart.this.fRevealEnd) {
                        DiscussionPart.this.fProjectionViewer.revealRange(finalPosToReveal.getOffset(), finalPosToReveal.getLength());
                        DiscussionPart.this.updateRevealEnd();
                    }
                }
            });
        }
    }

    private String getCommentCreatorAsURI(IContributorHandle handle) {
        ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
        return Location.itemLocation((IItemHandle)handle, (String)teamRepository.getRepositoryURI()).toString();
    }

    private String[] getCommentCreatorsAsURIs() {
        IComment[] comments = this.fWorkingCopy.getWorkItem().getComments().getContents();
        ArrayList<String> uris = new ArrayList<String>();
        ITeamRepository teamRepository = this.fWorkingCopy.getTeamRepository();
        IComment[] iCommentArray = comments;
        int n = comments.length;
        int n2 = 0;
        while (n2 < n) {
            IComment c = iCommentArray[n2];
            uris.add(Location.itemLocation((IItemHandle)c.getCreator(), (String)teamRepository.getRepositoryURI()).toString());
            ++n2;
        }
        return uris.toArray(new String[uris.size()]);
    }

    private URIReference[] createCommentReferences() {
        IComment[] comments = this.fWorkingCopy.getWorkItem().getComments().getContents();
        URIReference[] commentReferences = new URIReference[comments.length];
        int i = 0;
        while (i < comments.length) {
            commentReferences[i] = Hyperlinks.createHyperlink((Object)comments[i]);
            ++i;
        }
        return commentReferences;
    }

    private void handleOwnerChanged(WorkItemChangeEvent event) {
        ChangeDetails change;
        IAdaptable details = event.getAttributeChangeDetails(IWorkItem.OWNER_PROPERTY);
        if (details != null && (change = (ChangeDetails)details.getAdapter(ChangeDetails.class)) != null) {
            if (change.getOldValue() != null) {
                this.resetAnnotationType((IContributorHandle)change.getOldValue());
            }
            if (change.getNewValue() != null) {
                this.configureAnnotationTypeColor((IContributorHandle)change.getNewValue());
            }
            this.fOverviewRuler.update();
        }
    }

    private String getAnnotationType(IContributorHandle contributor) {
        String id = contributor == null ? "unassigned" : contributor.getItemId().getUuidValue();
        return "com.ibm.magnolia.editor.author." + id;
    }

    private void configureAnnotationType(IContributorHandle contributorHandle) {
        String type = this.getAnnotationType(contributorHandle);
        if (!this.fConfiguredAnnotationTypes.containsKey(type)) {
            int i = this.fConfiguredAnnotationTypes.size();
            this.fConfiguredAnnotationTypes.put(type, new Integer(i));
            this.configureAnnotationTypeColor(contributorHandle);
            if (this.isShowUsersInOverviewRuler()) {
                this.fOverviewRuler.setAnnotationTypeLayer((Object)type, 0);
                this.fOverviewRuler.addAnnotationType((Object)type);
            }
        }
    }

    private void resetAnnotationType(IContributorHandle contributorHandle) {
        String type = this.getAnnotationType(contributorHandle);
        if (this.fConfiguredAnnotationTypes.containsKey(type)) {
            this.configureAnnotationTypeColor(contributorHandle);
        }
    }

    private void configureAnnotationTypeColor(IContributorHandle contributorHandle) {
        RGB rgb = contributorHandle.sameItemId((IItemHandle)this.fWorkingCopy.getWorkItem().getCreator()) ? this.getContributorColors().getRoleColor(ContributorColors.CREATOR) : (contributorHandle.sameItemId((IItemHandle)this.fWorkingCopy.getWorkItem().getOwner()) ? this.getContributorColors().getRoleColor(ContributorColors.OWNER) : this.getContributorColors().getContributorColor(contributorHandle));
        Color color = this.fResourceManager.createColor(rgb);
        this.fOverviewRuler.setAnnotationTypeColor((Object)this.getAnnotationType(contributorHandle), color);
    }

    private ContributorColors getContributorColors() {
        return WorkItemUI.getContributorColors();
    }

    private boolean isShowUsersInOverviewRuler() {
        return this.fShowUserInOverviewRuler;
    }

    private boolean isNewCommentsFieldVisible() {
        return this.fIsNewCommentsFieldVisible;
    }

    public void revealNewComment() {
        this.makeNewCommentsFieldVisible(true);
    }

    private void makeNewCommentsFieldVisible(boolean isVisible) {
        this.fIsNewCommentsFieldVisible = isVisible;
        this.fContainer.setMaximizedControl((Control)(isVisible ? null : this.fCommentsContainer));
        this.updateSectionHeaderExpansion();
        this.adjustCommentScrollPosition();
        WorkItemEditor.InternalRefreshJob refreshJob = (WorkItemEditor.InternalRefreshJob)((Object)this.getSite().getAdapter(WorkItemEditor.InternalRefreshJob.class));
        if (refreshJob != null) {
            refreshJob.setActive(isVisible);
        }
    }

    private CommentsDocument getCommentsDocument() {
        return (CommentsDocument)this.getCommentsSupport().getDocument();
    }

    private DocumentModel getCommentsSupport() {
        return this.fCommentsSupport;
    }

    private WorkItemUIWorkingCopy getUIWorkingCopy() {
        return (WorkItemUIWorkingCopy)this.fWorkingCopy.getAdapter(IWorkItemUIWorkingCopy.class);
    }

    private boolean sectionHeaderExists() {
        return this.fSection != null;
    }

    private void createSectionHeader(Composite parent, FormToolkit toolkit) {
        Composite current = parent;
        while (current != null && !(current instanceof Section)) {
            current = current.getParent();
        }
        this.fSection = (Section)current;
        if (!this.sectionHeaderExists()) {
            return;
        }
        Composite textClientContainer = new Composite((Composite)this.fSection, 0){

            public void setBounds(int x, int y, int width, int height) {
                ExpandableComposite parent = (ExpandableComposite)this.getParent();
                super.setBounds(x, y, parent.getSize().x - x - parent.marginWidth - parent.titleBarTextMarginWidth, height);
            }
        };
        textClientContainer.setBackground(null);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 10;
        textClientContainer.setLayout((Layout)layout);
        this.fCommentsLabel = new Label(textClientContainer, 0);
        this.fCommentsLabel.setBackground(null);
        this.fCommentsLabel.setForeground(this.fSection.getTitleBarForeground());
        this.fCommentsLabel.setText("");
        this.fCommentsLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.fCommentsLabel.setFont(JFaceResources.getFont((String)COMMENTS_LABEL_FONT));
        Label spacer = new Label(textClientContainer, 0);
        spacer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        HyperlinkGroup linkGroup = new HyperlinkGroup(toolkit.getColors().getDisplay());
        linkGroup.setBackground(null);
        this.fNewCommentLink = ((WorkItemEditorToolkit)toolkit).createCustomHyperlink(textClientContainer, this.getNewCommentText(), 0);
        this.fNewCommentLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.fNewCommentLink.setBackground(null);
        this.fNewCommentLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                boolean makeVisible = !DiscussionPart.this.isNewCommentsFieldVisible() || !DiscussionPart.this.fSection.isExpanded();
                DiscussionPart.this.makeNewCommentsFieldVisible(makeVisible);
                if (makeVisible) {
                    DiscussionPart.this.fNewCommentViewerSupport.getSourceViewer().getTextWidget().setFocus();
                }
            }
        });
        linkGroup.add(this.fNewCommentLink);
        this.fSection.setTextClient((Control)textClientContainer);
    }

    private void updateSectionHeaderExpansion() {
        if (!this.sectionHeaderExists()) {
            return;
        }
        boolean isVisible = this.isNewCommentsFieldVisible();
        if (isVisible) {
            this.expandSection();
        }
        this.updateSectionHeaderLink();
    }

    private void expandSection() {
        if (!this.fSection.isExpanded()) {
            this.fSection.setExpanded(true);
        }
    }

    public void updateSectionHeaderLink() {
        if (!this.sectionHeaderExists()) {
            return;
        }
        String text = this.getNewCommentText();
        if (text.equals(this.fNewCommentLink.getText())) {
            return;
        }
        this.fNewCommentLink.setText(text);
        this.fNewCommentLink.getParent().getParent().layout(new Control[]{this.fNewCommentLink});
    }

    private String getNewCommentText() {
        boolean isVisible = this.isNewCommentsFieldVisible() && this.sectionHeaderExists() && this.fSection.isExpanded();
        return isVisible ? HIDE_NEW_COMMENT_TEXT : SHOW_NEW_COMMENT_TEXT;
    }

    private void updateSectionHeaderComments() {
        String text;
        if (!this.sectionHeaderExists()) {
            return;
        }
        int numberOfComments = this.getUIWorkingCopy().getNumberOfComments();
        switch (numberOfComments) {
            case 0: {
                text = "";
                break;
            }
            case 1: {
                text = Messages.DiscussionPart_COMMENT;
                break;
            }
            default: {
                text = Messages.DiscussionPart_COMMENTS;
            }
        }
        if (numberOfComments > 0) {
            IComment[] comments;
            int newComments = 0;
            IComment[] iCommentArray = comments = this.getUIWorkingCopy().getVisibleComments();
            int n = comments.length;
            int n2 = 0;
            while (n2 < n) {
                IComment comment = iCommentArray[n2];
                if (this.getCommentsDocument().isUnreadComment(comment)) {
                    ++newComments;
                }
                ++n2;
            }
            if (newComments > 0) {
                text = Messages.DiscussionPart_COMMENTS_NEW;
            }
            this.fCommentsLabel.setText("(" + MessageFormat.format(text, new Integer(numberOfComments), new Integer(newComments)) + ")");
        } else {
            this.fCommentsLabel.setText("");
        }
        this.fSection.layout();
    }

    public void revealComment(URI commentURI) {
        ProjectionViewer projectionViewer = this.fProjectionViewer;
        ProjectionAnnotationModel model = projectionViewer.getProjectionAnnotationModel();
        CommentProjectionAnnotation commentAnnotation = this.getCommentAnnotation(model, commentURI);
        if (commentAnnotation != null) {
            this.expandSection();
            if (commentAnnotation.isCollapsed()) {
                model.expand((Annotation)commentAnnotation);
            }
            Position position = model.getPosition((Annotation)commentAnnotation);
            projectionViewer.revealRange(position.getOffset(), position.getLength());
            this.updateRevealEnd();
            try {
                IDocument document = projectionViewer.getDocument();
                if (document != null) {
                    IRegion line = document.getLineInformationOfOffset(position.getOffset());
                    projectionViewer.setSelectedRange(line.getOffset(), line.getLength());
                }
            }
            catch (BadLocationException x) {
                WorkItemIDEUIPlugin.getDefault().log(com.ibm.team.workitem.ide.ui.internal.editor.comments.Messages.WorkItemHyperlinkHandler_UNEXPECTED_EXCEPTION, x);
            }
            return;
        }
    }

    private CommentProjectionAnnotation getCommentAnnotation(ProjectionAnnotationModel model, URI commentURI) {
        if (model != null) {
            Iterator iter = model.getAnnotationIterator();
            while (iter.hasNext()) {
                String cPath;
                String rPath;
                URIReference reference;
                Annotation annotation = (Annotation)iter.next();
                if (!(annotation instanceof CommentProjectionAnnotation) || (reference = ((CommentProjectionAnnotation)annotation).getCommentReference()).getURI().getQuery().indexOf("path") < 0 || commentURI.getQuery().indexOf("path") < 0 || !(rPath = reference.getURI().getQuery().substring(reference.getURI().getQuery().indexOf("path"))).equals(cPath = commentURI.getQuery().substring(commentURI.getQuery().indexOf("path")))) continue;
                return (CommentProjectionAnnotation)annotation;
            }
        }
        return null;
    }

    public static class CommentProjectionAnnotation
    extends ProjectionAnnotation {
        private URIReference fCommentReference;

        public CommentProjectionAnnotation(URIReference commentReference) {
            this(false, commentReference);
        }

        public CommentProjectionAnnotation(boolean isCollapsed, URIReference commentReference) {
            super(isCollapsed);
            this.fCommentReference = commentReference;
        }

        public URIReference getCommentReference() {
            return this.fCommentReference;
        }
    }

    private class CommentsContextProvider
    extends ContextProvider {
        public CommentsContextProvider(ContextProvider enclosingProvider) {
            super(enclosingProvider);
        }

        public URIReference getContext() {
            ProjectionAnnotationModel model = DiscussionPart.this.fProjectionViewer.getProjectionAnnotationModel();
            if (model != null) {
                ITextSelection selection = (ITextSelection)DiscussionPart.this.fProjectionViewer.getSelection();
                Iterator iter = model.getAnnotationIterator();
                while (iter.hasNext()) {
                    Position position;
                    Annotation annotation = (Annotation)iter.next();
                    if (!(annotation instanceof CommentProjectionAnnotation) || !(position = model.getPosition(annotation)).overlapsWith(selection.getOffset(), selection.getLength())) continue;
                    return ((CommentProjectionAnnotation)annotation).getCommentReference();
                }
            }
            return null;
        }

        public Object getUIContext() {
            return DiscussionPart.this.getSite().getWorkbenchPage();
        }
    }

    private static class InternalPresentationListener
    implements ITextPresentationListener {
        private static final int GLOBAL_INDENT = 2;
        private TextViewer fTextViewer;
        private Color fHeaderBackground;

        public InternalPresentationListener(TextViewer textViewer, ResourceManager resourceManager) {
            this.fTextViewer = textViewer;
            StyledText text = this.fTextViewer.getTextWidget();
            Color color1 = text.getDisplay().getSystemColor(22);
            Color color2 = text.getDisplay().getSystemColor(25);
            RGB rgb = FormColors.blend((RGB)color1.getRGB(), (RGB)color2.getRGB(), (int)40);
            this.fHeaderBackground = resourceManager.createColor(rgb);
        }

        public void applyTextPresentation(TextPresentation textPresentation) {
            StyledText text = this.fTextViewer.getTextWidget();
            GC graphics = new GC((Drawable)text);
            graphics.setFont(text.getFont());
            try {
                Position[] ranges;
                IRegion modelRange = textPresentation.getExtent();
                Position[] positionArray = ranges = ((CommentsDocument)this.fTextViewer.getDocument()).getProjectionRanges();
                int n = ranges.length;
                int n2 = 0;
                while (n2 < n) {
                    IRegion widgetRange;
                    Position range = positionArray[n2];
                    if (range.overlapsWith(modelRange.getOffset(), modelRange.getLength()) && (widgetRange = this.fTextViewer.modelRange2WidgetRange((IRegion)new Region(range.getOffset(), range.getLength()))) != null) {
                        this.updateLineStyles(text, graphics, widgetRange);
                    }
                    ++n2;
                }
            }
            finally {
                graphics.dispose();
            }
        }

        private void updateLineStyles(StyledText text, GC graphics, IRegion widgetRange) {
            int beginLine = text.getLineAtOffset(widgetRange.getOffset());
            int endLine = text.getLineAtOffset(widgetRange.getOffset() + widgetRange.getLength());
            text.setLineBackground(beginLine, 1, this.fHeaderBackground);
            int headerBegin = text.getOffsetAtLine(beginLine);
            int headerEnd = text.getOffsetAtLine(beginLine + 1);
            String header = text.getText(headerBegin, headerEnd - 1);
            int i = header.indexOf(" ");
            int nOfLines = endLine - beginLine;
            if (i != -1 && nOfLines - 1 > 0) {
                String prefix = header.substring(0, i + 1);
                int indent = graphics.stringExtent((String)prefix).x + 2;
                text.setLineIndent(beginLine, 1, 2);
                text.setLineIndent(beginLine + 1, nOfLines - 1, indent);
            } else {
                text.setLineIndent(beginLine, nOfLines, 2);
            }
        }
    }

    private class WorkItemListener
    implements IWorkItemListener {
        private WorkItemListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (DiscussionPart.this.fWorkingCopy == null || !event.affects((IWorkItemHandle)DiscussionPart.this.fWorkingCopy.getWorkItem())) {
                return;
            }
            if (event.affects(IWorkItem.OWNER_PROPERTY)) {
                DiscussionPart.this.handleOwnerChanged(event);
            }
            if (event.affects(IWorkItem.COMMENTS_PROPERTY)) {
                DiscussionPart.this.handleCommentsChanged(event);
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }
    }
}

