/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItem;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.ValueSetProvider;
import com.ibm.team.workitem.common.internal.ValueSetProviderRegistry;
import com.ibm.team.workitem.common.model.AttributeTypes;
import com.ibm.team.workitem.common.model.IAttribute;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.IItemPicker;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.ItemPickerRegistry;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.history.CategorySelectionHistoryManager;
import com.ibm.team.workitem.ide.ui.internal.history.IntervalSelectionHistoryManager;
import com.ibm.team.workitem.ide.ui.internal.history.ItemSelectionHistory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Composite;

public class DecoratedHistoryCombo
extends DecoratedCombo {
    public static final String DIALOG_CANCELED = "DecoratedHistoryCombo.dialog_canceled";
    public static final String RETRIEVEENTRY = Messages.DecoratedHistoryCombo_RETRIEVING;
    private static final String MOREDIALOGENTRY = Messages.DecoratedHistoryCombo_MORE;
    private static final String ERROR = Messages.DecoratedHistoryCombo_ERROR_SETTING_VALUES;
    private Object fNullValue = null;
    private Object[] fFullValueSet = null;
    private Object fDefaultValue = null;
    private IWorkItem fWorkItem;
    private ItemSelectionHistory fHistory;
    private IAttribute fAttribute;
    private final ComboUpdaterJob fUpdaterJob;
    private ValueSetProvider fValueSetProvider;

    public DecoratedHistoryCombo(Composite parent, int style, int options, IAttribute attribute, String valueSetProviderId) {
        super(parent, style, options);
        this.fAttribute = attribute;
        this.fValueSetProvider = ValueSetProviderRegistry.getValueSetProvider((String)valueSetProviderId);
        if (this.fValueSetProvider == null) {
            this.fValueSetProvider = ValueSetProviderRegistry.getFallBackValueSetProvider();
        }
        this.fUpdaterJob = new ComboUpdaterJob(NLS.bind((String)Messages.DecoratedHistoryCombo_UPDATE_ATTRIBUTE_VALUES, (Object)this.fAttribute.getIdentifier(), (Object[])new Object[0]));
    }

    public void setWorkItem(IWorkItem workItem) {
        this.fWorkItem = workItem;
    }

    public Object[] getFullValueSet() {
        return this.fFullValueSet;
    }

    public void scheduleJob() {
        if (this.fUpdaterJob != null) {
            this.setValueSet(new Object[]{RETRIEVEENTRY});
            this.fUpdaterJob.schedule();
        }
    }

    public Object getCachedDefaultValue() {
        return this.fDefaultValue;
    }

    protected Object getDefaultValue(IProgressMonitor monitor) {
        return null;
    }

    public Object getValue() {
        Object value = super.getValue();
        if (value instanceof String) {
            if (((String)value).equals(MOREDIALOGENTRY)) {
                value = this.createDialog();
            } else if (((String)value).equals(ERROR)) {
                this.fUpdaterJob.schedule();
                value = null;
            }
        }
        return value;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object createDialog() {
        void var4_5;
        if (!"category".equals(this.fAttribute.getAttributeType()) && !"interval".equals(this.fAttribute.getAttributeType())) return DIALOG_CANCELED;
        IItemPicker picker = ItemPickerRegistry.getItemPicker(AttributeTypes.getItemType((String)this.fAttribute.getAttributeType()));
        if (picker == null) return DIALOG_CANCELED;
        Object defaultValue = this.getCachedDefaultValue();
        List list = Collections.emptyList();
        if (defaultValue instanceof IItemHandle) {
            List<IItemHandle> list2 = Collections.singletonList((IItemHandle)defaultValue);
        }
        IItemHandle result = picker.getItemResult(this.getCombo().getShell(), this.fWorkItem, (ITeamRepository)this.fWorkItem.getOrigin(), null, null, null, (List<? extends IItemHandle>)var4_5, false);
        if (!picker.getStatus().isOK()) {
            return DIALOG_CANCELED;
        }
        this.setValue(result);
        if (this.fHistory != null && result instanceof IItem) {
            this.fHistory.add((IItem)result);
        }
        this.setComboValues();
        return result;
    }

    private void setComboValues() {
        if (this.fHistory == null) {
            if (this.fFullValueSet != null) {
                this.setValueSet(this.fFullValueSet);
            } else {
                this.setValueSet(new Object[]{ERROR});
            }
            return;
        }
        if (this.fHistory.hasUnresolvedEntries()) {
            this.setValueSet(new Object[]{RETRIEVEENTRY});
            if (!this.fHistory.isResolving()) {
                this.fUpdaterJob.schedule();
            }
            return;
        }
        IItem[] hist = this.fHistory.getHistory();
        Object[] result = new Object[hist.length + 2];
        int i = 0;
        while (i < hist.length) {
            result[i] = hist[i];
            ++i;
        }
        result[hist.length] = this.fNullValue;
        result[hist.length + 1] = MOREDIALOGENTRY;
        this.setValueSet(result);
    }

    private final class ComboUpdaterJob
    extends UIUpdaterJob {
        public ComboUpdaterJob(String name) {
            super(name);
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            if (DecoratedHistoryCombo.this.fWorkItem == null) {
                return Status.CANCEL_STATUS;
            }
            try {
                if ("category".equals(DecoratedHistoryCombo.this.fAttribute.getAttributeType())) {
                    DecoratedHistoryCombo.this.fHistory = CategorySelectionHistoryManager.getHistory(DecoratedHistoryCombo.this.fWorkItem.getProjectArea());
                } else if ("interval".equals(DecoratedHistoryCombo.this.fAttribute.getAttributeType())) {
                    DecoratedHistoryCombo.this.fHistory = IntervalSelectionHistoryManager.getHistory(DecoratedHistoryCombo.this.fWorkItem.getProjectArea());
                }
                if (DecoratedHistoryCombo.this.fHistory != null) {
                    DecoratedHistoryCombo.this.fHistory.resolveHistory(DecoratedHistoryCombo.this.fWorkItem, monitor);
                    if (DecoratedHistoryCombo.this.fWorkItem == null) {
                        return Status.CANCEL_STATUS;
                    }
                }
                ITeamRepository teamRepository = (ITeamRepository)DecoratedHistoryCombo.this.fWorkItem.getOrigin();
                IWorkItemCommon workItemCommon = (IWorkItemCommon)teamRepository.getClientLibrary(IWorkItemCommon.class);
                DecoratedHistoryCombo.this.fNullValue = DecoratedHistoryCombo.this.fValueSetProvider.getNullValue(DecoratedHistoryCombo.this.fAttribute, DecoratedHistoryCombo.this.fWorkItem, workItemCommon, monitor);
                ArrayList<Object> valueSet = new ArrayList<Object>(DecoratedHistoryCombo.this.fValueSetProvider.getValueSet(DecoratedHistoryCombo.this.fAttribute, DecoratedHistoryCombo.this.fWorkItem, workItemCommon, monitor));
                if ("deliverable".equals(DecoratedHistoryCombo.this.fAttribute.getAttributeType()) && valueSet != null && !valueSet.contains(DecoratedHistoryCombo.this.fNullValue)) {
                    valueSet.add(0, DecoratedHistoryCombo.this.fNullValue);
                }
                DecoratedHistoryCombo.this.fFullValueSet = valueSet.toArray();
                DecoratedHistoryCombo.this.fDefaultValue = DecoratedHistoryCombo.this.getDefaultValue(monitor);
            }
            catch (TeamRepositoryException x) {
                return new Status(4, "com.ibm.team.workitem.ide.ui", 4, Messages.DecoratedHistoryCombo_EXCEPTION_UPDATING_VALUESET, (Throwable)x);
            }
            return Status.OK_STATUS;
        }

        public IStatus runInUI(IProgressMonitor monitor) {
            if (DecoratedHistoryCombo.this.getCombo().isDisposed()) {
                return Status.CANCEL_STATUS;
            }
            DecoratedHistoryCombo.this.setNullValue(DecoratedHistoryCombo.this.fNullValue);
            DecoratedHistoryCombo.this.setComboValues();
            return Status.OK_STATUS;
        }
    }
}

