/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.part;

import com.ibm.icu.text.Collator;
import com.ibm.icu.text.DateFormat;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.internal.favorites.Favorite;
import com.ibm.team.foundation.rcp.core.internal.favorites.FavoritesFolder;
import com.ibm.team.foundation.rcp.core.internal.favorites.URIFavorite;
import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.foundation.rcp.ui.dnd.URIReferenceTransfer;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.calendar.DatePicker;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.rcp.ui.TeamContributorSelectionDialog;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IContributorHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.ui.editor.TeamFormPage;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.IAuditableClient;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.IWorkItemListener;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.WorkItemChangeEvent;
import com.ibm.team.workitem.client.WorkItemWorkingCopy;
import com.ibm.team.workitem.common.internal.util.Daystamp;
import com.ibm.team.workitem.common.model.ApprovalChangeDetails;
import com.ibm.team.workitem.common.model.IApproval;
import com.ibm.team.workitem.common.model.IApprovalDescriptor;
import com.ibm.team.workitem.common.model.IApprovalState;
import com.ibm.team.workitem.common.model.IApprovalType;
import com.ibm.team.workitem.common.model.IApprovals;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.ListChangeDetails;
import com.ibm.team.workitem.common.model.WorkItemApprovals;
import com.ibm.team.workitem.ide.ui.internal.ImagePool;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedCombo;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditor;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemTeamFormPartContainer;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemTeamFormSectionPart;
import com.ibm.team.workitem.ide.ui.internal.editor.part.DiscussionPart;
import com.ibm.team.workitem.ide.ui.internal.editor.part.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.presentations.PresentationPart;
import com.ibm.team.workitem.rcp.ui.UIWorkItemListener;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.HyperlinkGroup;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.texteditor.IUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApprovalsPart
extends PresentationPart {
    private static final String STATE_PROPERTY = "state";
    private static final String APPROVER_PROPERTY = "approver";
    private static final String DUE_DATE_PROPERTY = "dueDate";
    private static final int DATE_FORMAT = 2;
    private static final int MAX_DATE_CHARS = 16;
    private TreeViewer fViewer;
    private ApprovalContentProvider fContentProvider;
    private AddCommentLink fAddCommentLink;
    private InternalDescriptorListener fDescriptorListener = new InternalDescriptorListener();
    private InternalApprovalListener fApprovalListener = new InternalApprovalListener();
    private WorkItemWorkingCopy fWorkingCopy;

    public void init(ITeamFormPartSite site) {
        super.init(site);
        UIWorkItemListener uiWorkItemListener = (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class);
        if (uiWorkItemListener != null) {
            uiWorkItemListener.addListener((IWorkItemListener)this.fDescriptorListener, IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY);
            uiWorkItemListener.addListener((IWorkItemListener)this.fApprovalListener, IWorkItem.APPROVALS_PROPERTY);
        }
    }

    public void createContent(Composite parent) {
        FormToolkit toolkit = this.getSite().getToolkit();
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 1;
        layout.marginWidth = 1;
        parent.setLayout((Layout)layout);
        toolkit.paintBordersFor(parent);
        this.fViewer = new TreeViewer(parent, 66306);
        Control control = this.fViewer.getControl();
        this.initAccessible(control);
        toolkit.adapt(control, false, false);
        control.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 200;
        data.heightHint = this.fViewer.getTree().getItemHeight() * 2;
        control.setLayoutData((Object)data);
        this.fContentProvider = new ApprovalContentProvider();
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.fViewer.setComparator((ViewerComparator)new ApprovalComparator());
        this.fViewer.setColumnProperties(new String[]{APPROVER_PROPERTY, STATE_PROPERTY, DUE_DATE_PROPERTY});
        this.fViewer.getTree().setHeaderVisible(true);
        this.fViewer.getTree().setLinesVisible(true);
        ApprovalLabelProvider labelProvider = new ApprovalLabelProvider();
        TreeViewerColumn viewerColumn = new TreeViewerColumn(this.fViewer, 16384);
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        TreeColumn column = viewerColumn.getColumn();
        column.setText(Messages.ApprovalsPart_APPROVER);
        column.setWidth(160);
        GC gc = new GC((Drawable)this.fViewer.getTree());
        gc.setFont(this.fViewer.getTree().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        viewerColumn = new TreeViewerColumn(this.fViewer, 16384);
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        column = viewerColumn.getColumn();
        column.setText(Messages.ApprovalsPart_STATE);
        column.setWidth(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)18));
        viewerColumn.setEditingSupport((EditingSupport)new ApprovalEditingSupport(this.fViewer));
        viewerColumn = new TreeViewerColumn(this.fViewer, 16384);
        viewerColumn.setLabelProvider((CellLabelProvider)labelProvider);
        column = viewerColumn.getColumn();
        column.setText(Messages.ApprovalsPart_DUE_LABEL);
        column.setWidth(Dialog.convertWidthInCharsToPixels((FontMetrics)fontMetrics, (int)16));
        this.createTooltipSupport(control);
        this.createDragSource();
        this.createDropTarget();
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                Object element;
                if (((IStructuredSelection)ApprovalsPart.this.fViewer.getSelection()).size() == 1 && (element = ((IStructuredSelection)ApprovalsPart.this.fViewer.getSelection()).getFirstElement()) instanceof IApprovalDescriptor) {
                    ApprovalsPart.this.editDescriptor((IApprovalDescriptor)element);
                }
            }
        });
        this.getSite().registerSelectionProvider((ISelectionProvider)this.fViewer, control);
        this.createContextMenu((ISelectionProvider)this.fViewer, control);
        if ("gtk".equals(SWT.getPlatform())) {
            Utils.updateColumnWidths((Tree)this.fViewer.getTree(), (int[])new int[]{5, 3, 2});
        } else {
            Utils.updateColumnWidths((Tree)this.fViewer.getTree(), (int[])new int[]{1, -1, -1});
        }
        Control toolBar = this.createToolPanel(parent, toolkit);
        toolBar.setLayoutData((Object)new GridData(4, 128, false, false));
    }

    private void editDescriptor(IApprovalDescriptor descriptor) {
        NewApprovalDescriptorDialog dialog = new NewApprovalDescriptorDialog(Display.getCurrent().getActiveShell(), null, true);
        dialog.setType(WorkItemApprovals.getType((String)descriptor.getTypeIdentifier()));
        dialog.setName(descriptor.getName());
        dialog.setDueDate(descriptor.getDueDate());
        if (dialog.open() != 0) {
            return;
        }
        descriptor.setTypeIdentifier(dialog.getType().getIdentifier());
        descriptor.setName(dialog.getName());
        descriptor.setDueDate(dialog.getDueDate());
        if (dialog.isAddApprover()) {
            this.addApprovals(descriptor);
        }
    }

    private void createTooltipSupport(Control control) {
        new TooltipSupport(control, true, true){

            protected Object mapElement(int x, int y) {
                Object element = super.mapElement(x, y);
                if (element instanceof IApproval) {
                    return ((IApproval)element).getApprover();
                }
                return element;
            }
        };
    }

    private void createDragSource() {
        new DragSupport((Control)this.fViewer.getTree(), 4){
            private ISelectionProvider fSelectionProvider;
            {
                this.fSelectionProvider = new InternalConvertingSelectionProvider((ISelectionProvider)ApprovalsPart.this.fViewer);
            }

            public ISelection getSelection() {
                return this.fSelectionProvider.getSelection();
            }
        };
    }

    private void createDropTarget() {
        DropTarget target = new DropTarget((Control)this.fViewer.getTree(), 4);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer(), URIReferenceTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new InternalDropTargetListener());
    }

    private Control createToolPanel(Composite parent, FormToolkit toolkit) {
        Composite composite = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        toolkit.paintBordersFor(composite);
        ActionButton addApproval = new ActionButton(new AddApprovalDescriptorAction(), composite, toolkit);
        addApproval.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        ActionButton editDescriptor = new ActionButton(new EditDescriptorAction(false), composite, toolkit);
        editDescriptor.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        ActionButton addApprover = new ActionButton(new AddApprovalAction(false), composite, toolkit);
        addApprover.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        ActionButton editState = new ActionButton(new EditStateAction(false), composite, toolkit);
        editState.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        ActionButton remove = new ActionButton(new RemoveApprovalAction(), composite, toolkit);
        remove.getControl().setLayoutData((Object)new GridData(4, 128, false, false));
        this.fAddCommentLink = new AddCommentLink(composite, toolkit);
        this.fAddCommentLink.getLayoutControl().setLayoutData((Object)new GridData(0x1000000, 0x1000000, false, false));
        return composite;
    }

    private void createContextMenu(ISelectionProvider selectionProvider, Control control) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                RemoveApprovalAction removeAction;
                EditStateAction editStateAction;
                AddApprovalAction addAction;
                EditDescriptorAction editDescriptorAction = new EditDescriptorAction(true);
                if (editDescriptorAction.isEnabled()) {
                    manager.add((IAction)editDescriptorAction);
                }
                if ((addAction = new AddApprovalAction(true)).isEnabled()) {
                    manager.add((IAction)addAction);
                }
                if ((editStateAction = new EditStateAction(true)).isEnabled()) {
                    manager.add((IAction)editStateAction);
                }
                if ((removeAction = new RemoveApprovalAction()).isEnabled()) {
                    manager.add((IAction)removeAction);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.getSite().registerContextMenu(this.getId(), menuMgr, (ISelectionProvider)new InternalConvertingSelectionProvider(selectionProvider));
        Menu menu = menuMgr.createContextMenu(control);
        control.setMenu(menu);
    }

    public void setApprovalSelection(Object approval) {
        if (approval != null && approval instanceof IApproval || approval instanceof IApprovalDescriptor) {
            this.fViewer.setSelection((ISelection)new StructuredSelection(approval), true);
            if (approval instanceof IApproval && !this.fWorkingCopy.getWorkItem().getApprovals().isClosed((IApproval)approval) && ((IApproval)approval).getApprover().sameItemId((IItemHandle)this.fWorkingCopy.getTeamRepository().loggedInContributor())) {
                this.fViewer.editElement(approval, 1);
            }
        } else {
            this.fViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        }
    }

    public void setFocus() {
        this.fViewer.getTree().setFocus();
    }

    @Override
    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void setInput(Object input) {
        if (input instanceof WorkItemEditorInput && ((WorkItemEditorInput)((Object)input)).isResolved()) {
            this.fWorkingCopy = ((WorkItemEditorInput)((Object)input)).getWorkingCopy();
            this.fViewer.setInput((Object)this.fWorkingCopy);
            IApprovals approvals = this.fWorkingCopy.getWorkItem().getApprovals();
            List descriptors = approvals.getDescriptors();
            for (IApprovalDescriptor descriptor : descriptors) {
                if (approvals.isClosed(descriptor)) continue;
                this.fViewer.expandToLevel((Object)descriptor, 1);
            }
            this.selectFirstOwnedApproval();
        } else {
            this.fWorkingCopy = null;
            this.fViewer.setInput(null);
        }
    }

    private void selectFirstOwnedApproval() {
        if (this.fWorkingCopy == null) {
            return;
        }
        IContributor user = this.fWorkingCopy.getTeamRepository().loggedInContributor();
        if (user == null) {
            return;
        }
        IApprovals approvals = this.fWorkingCopy.getWorkItem().getApprovals();
        List contents = approvals.getContents();
        Collections.sort(contents, new Comparator<IApproval>(){

            @Override
            public int compare(IApproval o1, IApproval o2) {
                return ApprovalsPart.this.fViewer.getComparator().compare((Viewer)ApprovalsPart.this.fViewer, (Object)o1, (Object)o2);
            }
        });
        IApproval selection = null;
        for (final IApproval approval : contents) {
            if (!approval.getApprover().sameItemId((IItemHandle)user) || approvals.isClosed(approval)) continue;
            selection = approval;
            break;
        }
        if (selection != null) {
            if ("gtk".equals(SWT.getPlatform())) {
                IApproval approval;
                approval = selection;
                this.fViewer.getControl().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!ApprovalsPart.this.fViewer.getControl().isDisposed()) {
                            ApprovalsPart.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)approval), true);
                            ApprovalsPart.this.fViewer.editElement((Object)approval, 1);
                        }
                    }
                });
            } else {
                this.fViewer.setSelection((ISelection)new StructuredSelection(selection), true);
                this.fViewer.editElement((Object)selection, 1);
            }
        }
    }

    private IApprovalDescriptor getSelectedDescriptor(boolean exact) {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        if (exact) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof IApprovalDescriptor) {
                return (IApprovalDescriptor)selection.getFirstElement();
            }
            return null;
        }
        IApprovalDescriptor descriptor = null;
        for (Object element : selection.toList()) {
            IApprovalDescriptor tmp = null;
            if (element instanceof IApprovalDescriptor) {
                tmp = (IApprovalDescriptor)element;
            } else if (element instanceof IApproval) {
                tmp = ((IApproval)element).getDescriptor();
            }
            if (descriptor == tmp) continue;
            if (descriptor != null) {
                return null;
            }
            descriptor = tmp;
        }
        return descriptor;
    }

    private IApprovalDescriptor createApprovalDescriptor(String defaultName) {
        NewApprovalDescriptorDialog dialog = new NewApprovalDescriptorDialog(Display.getCurrent().getActiveShell(), defaultName, false);
        if (dialog.open() != 0) {
            return null;
        }
        IApprovalDescriptor descriptor = this.fWorkingCopy.getWorkItem().getApprovals().createDescriptor(dialog.getType().getIdentifier(), dialog.getName());
        descriptor.setDueDate(dialog.getDueDate());
        this.fWorkingCopy.getWorkItem().getApprovals().add(descriptor);
        if (dialog.isAddApprover()) {
            this.addApprovals(descriptor);
        }
        return descriptor;
    }

    private void addApprovals(IApprovalDescriptor descriptor) {
        ITeamRepository teamRepository = (ITeamRepository)this.fWorkingCopy.getWorkItem().getOrigin();
        ArrayList<IContributorHandle> approvers = new ArrayList<IContributorHandle>();
        List contents = this.fWorkingCopy.getWorkItem().getApprovals().getContents(descriptor);
        for (IApproval approval : contents) {
            approvers.add(approval.getApprover());
        }
        TeamContributorSelectionDialog dialog = new TeamContributorSelectionDialog(Display.getCurrent().getActiveShell(), teamRepository, approvers, true);
        dialog.setTitle(Messages.ApprovalsPart_ADD_APPROVERS);
        dialog.setShellTitle(Messages.ApprovalsPart_ADD_APPROVERS);
        dialog.setMessage(Messages.ApprovalsPart_SELECT_APPROVERS_MESSAGE);
        if (dialog.open() == 0) {
            ArrayList<IContributorHandle> handles = new ArrayList<IContributorHandle>();
            Object[] objectArray = dialog.getResult();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object result = objectArray[n2];
                if (result instanceof IContributorHandle) {
                    handles.add((IContributorHandle)result);
                }
                ++n2;
            }
            this.resolveAndAdd(descriptor, handles);
        }
    }

    private void resolveAndAdd(final IApprovalDescriptor descriptor, final List<IContributorHandle> handles) {
        UIUpdaterJob job = new UIUpdaterJob(Messages.ApprovalsPart_RESOLVING_APPROVERS){
            private IApproval fLastAdded;

            public IStatus runInBackground(IProgressMonitor monitor) {
                ITeamRepository teamRepository = ApprovalsPart.this.fWorkingCopy.getTeamRepository();
                IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                IWorkItem workItem = ApprovalsPart.this.fWorkingCopy.getWorkItem();
                try {
                    workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                    IApprovals approvals = workItem.getApprovals();
                    List contributors = auditableClient.resolveAuditables(handles, ItemProfile.CONTRIBUTOR_DEFAULT, monitor);
                    for (IContributor contributor : contributors) {
                        if (contributor == null) continue;
                        this.fLastAdded = approvals.createApproval(descriptor, (IContributorHandle)contributor);
                        approvals.add(this.fLastAdded);
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (TeamRepositoryException e) {
                    Status status = new Status(4, "com.ibm.team.workitem.ide.ui", 4, Messages.ApprovalsPart_EXCEPTION_RESOLVING_APPROVERS, (Throwable)e);
                    return status;
                }
                finally {
                    workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)workItem);
                }
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (this.fLastAdded != null) {
                    ApprovalsPart.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)this.fLastAdded), true);
                }
                return super.runInUI(monitor);
            }
        };
        job.schedule();
    }

    public void dispose() {
        UIWorkItemListener uiWorkItemListener;
        UIWorkItemListener uIWorkItemListener = uiWorkItemListener = this.getSite() != null ? (UIWorkItemListener)this.getSite().getAdapter(UIWorkItemListener.class) : null;
        if (uiWorkItemListener != null) {
            if (this.fDescriptorListener != null) {
                uiWorkItemListener.removeListener((IWorkItemListener)this.fDescriptorListener, IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY);
                this.fDescriptorListener = null;
            }
            if (this.fApprovalListener != null) {
                uiWorkItemListener.removeListener((IWorkItemListener)this.fApprovalListener, IWorkItem.APPROVALS_PROPERTY);
                this.fApprovalListener = null;
            }
        }
        this.fViewer = null;
        super.dispose();
    }

    private class ActionButton {
        private Action fAction;
        private Button fButton;

        public ActionButton(Action action, Composite parent, FormToolkit toolkit) {
            this.fAction = action;
            this.fButton = toolkit.createButton(parent, this.fAction.getText(), 0);
            this.fButton.setEnabled(this.fAction.isEnabled());
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ActionButton.this.fAction.isEnabled()) {
                        ActionButton.this.fAction.run();
                    }
                }
            });
            if (this.fAction instanceof IUpdate) {
                ApprovalsPart.this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        ((IUpdate)ActionButton.this.fAction).update();
                        ActionButton.this.fButton.setEnabled(ActionButton.this.fAction.isEnabled());
                    }
                });
            }
        }

        public Control getControl() {
            return this.fButton;
        }
    }

    private class AddApprovalAction
    extends Action
    implements IUpdate {
        private boolean fContextMenu;

        public AddApprovalAction(boolean contextMenu) {
            this.fContextMenu = contextMenu;
            this.setText(Messages.ApprovalsPart_ADD_APPROVER);
            this.update();
        }

        public void update() {
            this.setEnabled(this.getDescriptor() != null);
        }

        public void run() {
            IApprovalDescriptor descriptor = this.getDescriptor();
            if (descriptor == null) {
                return;
            }
            ApprovalsPart.this.addApprovals(descriptor);
        }

        private IApprovalDescriptor getDescriptor() {
            return ApprovalsPart.this.getSelectedDescriptor(this.fContextMenu);
        }
    }

    private class AddApprovalDescriptorAction
    extends Action {
        public AddApprovalDescriptorAction() {
            this.setText(Messages.ApprovalsPart_NEW_APPROVAL);
            this.setEnabled(true);
        }

        public void run() {
            ApprovalsPart.this.createApprovalDescriptor(null);
        }
    }

    private class AddCommentLink {
        private HyperlinkGroup fHyperlinkGroup = new HyperlinkGroup(Display.getCurrent());
        private Hyperlink fLink;

        public AddCommentLink(Composite composite, FormToolkit toolkit) {
            this.fHyperlinkGroup.setBackground(toolkit.getColors().getBackground());
            this.fLink = new Hyperlink(composite, 0);
            this.fLink.setText(Messages.ApprovalsPart_ADD_COMMENT);
            this.fLink.setToolTipText(Messages.ApprovalsPart_ADD_COMMENT_TOOLTIP);
            this.fLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    IEditorPart editorPart;
                    String linkTarget = (String)ApprovalsPart.this.getDescriptor().getProperties().get("toBeLinkedPartId");
                    if (linkTarget == null) {
                        linkTarget = "com.ibm.team.workitem.presentation.discussion";
                    }
                    if ((editorPart = ApprovalsPart.this.getSite().getWorkbenchPage().getActiveEditor()) instanceof WorkItemEditor) {
                        WorkItemEditor editor = (WorkItemEditor)editorPart;
                        String partId = linkTarget;
                        editor.activatePart(partId);
                        if (editor.getActiveEditor() instanceof TeamFormPage) {
                            IFormPart[] iFormPartArray = ((TeamFormPage)editor.getActiveEditor()).getManagedForm().getParts();
                            int n = iFormPartArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                TeamFormPart part;
                                IFormPart section = iFormPartArray[n2];
                                if (section instanceof WorkItemTeamFormSectionPart) {
                                    part = ((WorkItemTeamFormSectionPart)section).getPart(partId);
                                    if (part != null && part instanceof DiscussionPart) {
                                        ((DiscussionPart)part).setFocusNewComment();
                                        return;
                                    }
                                } else if (section instanceof WorkItemTeamFormPartContainer && (part = ((WorkItemTeamFormPartContainer)section).getPart(partId)) != null && part instanceof DiscussionPart) {
                                    ((DiscussionPart)part).setFocusNewComment();
                                    return;
                                }
                                ++n2;
                            }
                        }
                    }
                }
            });
            toolkit.adapt((Control)this.fLink, true, true);
            this.fHyperlinkGroup.add(this.fLink);
        }

        public Control getLayoutControl() {
            return this.fLink;
        }
    }

    private class ApprovalComparator
    extends ViewerComparator {
        private ApprovalComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            if (e1 instanceof IApprovalDescriptor && e2 instanceof IApprovalDescriptor) {
                List descriptors = ApprovalsPart.this.fWorkingCopy.getWorkItem().getApprovals().getDescriptors();
                return descriptors.indexOf(e1) - descriptors.indexOf(e2);
            }
            if (e1 instanceof IApproval && e2 instanceof IApproval) {
                IApprovalDescriptor descriptor2;
                IApprovals approvals = ApprovalsPart.this.fWorkingCopy.getWorkItem().getApprovals();
                IApprovalDescriptor descriptor1 = ((IApproval)e1).getDescriptor();
                if (!descriptor1.equals(descriptor2 = ((IApproval)e2).getDescriptor())) {
                    List descriptors = ApprovalsPart.this.fWorkingCopy.getWorkItem().getApprovals().getDescriptors();
                    return descriptors.indexOf(descriptor1) - descriptors.indexOf(descriptor2);
                }
                ITeamRepository teamRepository = ApprovalsPart.this.fWorkingCopy.getTeamRepository();
                IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                ItemProfile profile = ItemProfile.createProfile((IItemType)IContributor.ITEM_TYPE, (String[])new String[]{IContributor.NAME_PROPERTY});
                IContributor a1 = (IContributor)auditableClient.findCachedAuditable((IAuditableHandle)((IApproval)e1).getApprover(), profile);
                IContributor a2 = (IContributor)auditableClient.findCachedAuditable((IAuditableHandle)((IApproval)e2).getApprover(), profile);
                if (a1 != null && a2 != null) {
                    return Collator.getInstance().compare(a1.getName(), a2.getName());
                }
                List contents = approvals.getContents(descriptor1);
                return contents.indexOf(e1) - contents.indexOf(e2);
            }
            return super.compare(viewer, e1, e2);
        }
    }

    private static class ApprovalContentProvider
    implements ITreeContentProvider {
        private TreeViewer fViewer = null;
        private WorkItemWorkingCopy fWorkingCopy = null;

        private ApprovalContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return this.fWorkingCopy.getWorkItem().getApprovals().getDescriptors().toArray();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IApprovalDescriptor) {
                return this.fWorkingCopy.getWorkItem().getApprovals().getContents((IApprovalDescriptor)parentElement).toArray();
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IApproval) {
                return ((IApproval)element).getDescriptor();
            }
            return null;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.fViewer = (TreeViewer)viewer;
            this.fWorkingCopy = newInput instanceof WorkItemWorkingCopy ? (WorkItemWorkingCopy)newInput : null;
        }

        public void add(IApprovalDescriptor descriptor) {
            this.fViewer.add((Object)this.fWorkingCopy, (Object)descriptor);
        }

        public void remove(IApprovalDescriptor descriptor) {
            this.fViewer.remove((Object)descriptor);
        }

        public void add(IApproval approval) {
            this.add(approval.getDescriptor());
            this.fViewer.add((Object)approval.getDescriptor(), (Object)approval);
        }

        public void remove(IApproval approval) {
            this.fViewer.remove((Object)approval);
        }

        public void dispose() {
            this.fWorkingCopy = null;
        }
    }

    private class ApprovalEditingSupport
    extends EditingSupport {
        private CellEditor fCellEditor;

        private ApprovalEditingSupport(TreeViewer viewer) {
            super((ColumnViewer)viewer);
        }

        protected boolean canEdit(Object element) {
            IContributor user = ApprovalsPart.this.fWorkingCopy.getTeamRepository().loggedInContributor();
            return element instanceof IApproval && ((IApproval)element).getApprover().sameItemId((IItemHandle)user);
        }

        protected CellEditor getCellEditor(final Object element) {
            if (this.fCellEditor != null) {
                this.fCellEditor.dispose();
                this.fCellEditor = null;
            }
            ArrayList<String> items = new ArrayList<String>();
            for (IApprovalState state : WorkItemApprovals.getStates()) {
                items.add(state.getDisplayName());
            }
            this.fCellEditor = new ComboBoxCellEditor((Composite)this.getTreeViewer().getTree(), items.toArray(new String[items.size()]), 8){

                protected Control createControl(Composite parent) {
                    Composite container = new Composite(parent, 0);
                    container.setLayout((Layout)new FillLayout());
                    super.createControl(container);
                    return container;
                }
            };
            ((CCombo)((Composite)this.fCellEditor.getControl()).getChildren()[0]).addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ApprovalEditingSupport.this.setValue(element, ((CCombo)e.widget).getSelectionIndex());
                }
            });
            return this.fCellEditor;
        }

        protected Object getValue(Object element) {
            IApprovalState state = WorkItemApprovals.getState((String)((IApproval)element).getStateIdentifier());
            return WorkItemApprovals.getStates().indexOf(state);
        }

        protected void setValue(Object element, Object value) {
            IApprovalState state = (IApprovalState)WorkItemApprovals.getStates().get((Integer)value);
            if (!((IApproval)element).getStateIdentifier().equals(state.getIdentifier())) {
                ((IApproval)element).setStateIdentifier(state.getIdentifier());
            }
        }

        private TreeViewer getTreeViewer() {
            return (TreeViewer)this.getViewer();
        }
    }

    private class ApprovalLabelProvider
    extends CellLabelProvider {
        private ResourceManager fResourceManager = new LocalResourceManager(JFaceResources.getResources());
        private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());

        public ApprovalLabelProvider() {
            this.fStandardLabelProvider.addListener(new ILabelProviderListener(){

                public void labelProviderChanged(LabelProviderChangedEvent event) {
                    Object[] elements = event.getElements();
                    if (elements != null) {
                        HashSet<Object> mappedElements = new HashSet<Object>();
                        Object[] objectArray = elements;
                        int n = elements.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object element = objectArray[n2];
                            mappedElements.addAll(this.findMappedElements(element));
                            ++n2;
                        }
                        if (!mappedElements.isEmpty()) {
                            ApprovalLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ApprovalLabelProvider.this, mappedElements.toArray()));
                        }
                    } else {
                        ApprovalLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ApprovalLabelProvider.this));
                    }
                }

                private List<Object> findMappedElements(Object element) {
                    ArrayList<Object> mappedElements = new ArrayList<Object>();
                    if (element instanceof IApprovalDescriptor || element instanceof IApproval) {
                        mappedElements.add(element);
                    } else {
                        if (!(element instanceof IContributorHandle)) {
                            return Collections.emptyList();
                        }
                        IContributorHandle contributor = (IContributorHandle)element;
                        List approvals = ApprovalsPart.this.fWorkingCopy.getWorkItem().getApprovals().getContents();
                        for (IApproval approval : approvals) {
                            if (!approval.getApprover().sameItemId((IItemHandle)contributor)) continue;
                            mappedElements.add(approval);
                        }
                    }
                    return mappedElements;
                }
            });
        }

        public void update(ViewerCell cell) {
            if (cell.getElement() instanceof IApprovalDescriptor) {
                IApprovalDescriptor descriptor = (IApprovalDescriptor)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    cell.setText(descriptor.getName());
                    IApprovalType type = WorkItemApprovals.getType((String)descriptor.getTypeIdentifier());
                    cell.setImage(this.fResourceManager.createImage(ImageDescriptor.createFromURL((URL)type.getIconURL())));
                } else if (cell.getColumnIndex() == 1) {
                    if (ApprovalsPart.this.fContentProvider.getChildren(descriptor).length > 0) {
                        IApprovalState state = WorkItemApprovals.getState((String)descriptor.getCumulativeStateIdentifier());
                        cell.setText(state.getDisplayName());
                        cell.setForeground(Display.getCurrent().getSystemColor(16));
                        cell.setImage(this.fResourceManager.createImage(ImageDescriptor.createFromURL((URL)state.getIconURL())));
                    } else {
                        cell.setText(null);
                        cell.setImage(null);
                    }
                } else if (cell.getColumnIndex() == 2) {
                    if (descriptor.getDueDate() != null) {
                        cell.setText(DateFormat.getDateInstance((int)2).format((Date)descriptor.getDueDate()));
                    } else {
                        cell.setText(null);
                    }
                }
            } else if (cell.getElement() instanceof IApproval) {
                IApproval approval = (IApproval)cell.getElement();
                if (cell.getColumnIndex() == 0) {
                    IContributorHandle handle = approval.getApprover();
                    ITeamRepository teamRepository = (ITeamRepository)handle.getOrigin();
                    IAuditableClient auditableClient = (IAuditableClient)teamRepository.getClientLibrary(IAuditableClient.class);
                    IContributor approver = (IContributor)auditableClient.findCachedAuditable((IAuditableHandle)handle, ItemProfile.CONTRIBUTOR_DEFAULT);
                    ViewerLabel viewerLabel = new ViewerLabel(null, null);
                    this.fStandardLabelProvider.updateLabel(viewerLabel, approver != null ? approver : handle);
                    cell.setText(viewerLabel.getText());
                    cell.setFont(viewerLabel.getFont());
                    cell.setImage(viewerLabel.getImage());
                    cell.setForeground(viewerLabel.getForeground());
                    cell.setBackground(viewerLabel.getBackground());
                } else if (cell.getColumnIndex() == 1) {
                    IApprovalState state = WorkItemApprovals.getState((String)approval.getStateIdentifier());
                    cell.setText(state.getDisplayName());
                    cell.setImage(this.fResourceManager.createImage(ImageDescriptor.createFromURL((URL)state.getIconURL())));
                }
            }
        }

        public void dispose() {
            if (this.fResourceManager != null) {
                this.fResourceManager.dispose();
                this.fResourceManager = null;
            }
            if (this.fStandardLabelProvider != null) {
                this.fStandardLabelProvider.dispose();
                this.fStandardLabelProvider = null;
            }
            super.dispose();
        }
    }

    private class EditDescriptorAction
    extends Action
    implements IUpdate {
        private boolean fContextMenu;

        public EditDescriptorAction(boolean contextMenu) {
            this.fContextMenu = contextMenu;
            this.setText(Messages.ApprovalsPart_EDIT_APPROVAL);
            this.update();
        }

        public void update() {
            this.setEnabled(this.getDescriptor() != null);
        }

        private IApprovalDescriptor getDescriptor() {
            return ApprovalsPart.this.getSelectedDescriptor(this.fContextMenu);
        }

        public void run() {
            IApprovalDescriptor descriptor = this.getDescriptor();
            if (descriptor == null) {
                return;
            }
            ApprovalsPart.this.editDescriptor(descriptor);
        }
    }

    private class EditStateAction
    extends Action
    implements IUpdate {
        private boolean fContextMenu;

        public EditStateAction(boolean contextMenu) {
            this.fContextMenu = contextMenu;
            this.setText(Messages.ApprovalsPart_EDIT_STATE);
            this.update();
        }

        public void update() {
            this.setEnabled(this.getApproval() != null);
        }

        private IApproval getApproval() {
            if (ApprovalsPart.this.fWorkingCopy == null) {
                return null;
            }
            IContributor user = ApprovalsPart.this.fWorkingCopy.getTeamRepository().loggedInContributor();
            IStructuredSelection selection = (IStructuredSelection)ApprovalsPart.this.fViewer.getSelection();
            if (this.fContextMenu) {
                if (selection.size() == 1 && selection.getFirstElement() instanceof IApproval && ((IApproval)selection.getFirstElement()).getApprover().sameItemId((IItemHandle)user)) {
                    return (IApproval)selection.getFirstElement();
                }
                return null;
            }
            IApprovalDescriptor descriptor = ApprovalsPart.this.getSelectedDescriptor(this.fContextMenu);
            if (descriptor == null) {
                return null;
            }
            List contents = ApprovalsPart.this.fWorkingCopy.getWorkItem().getApprovals().getContents(descriptor);
            for (IApproval approval : contents) {
                if (!approval.getApprover().sameItemId((IItemHandle)user)) continue;
                return approval;
            }
            return null;
        }

        public void run() {
            IApproval approval = this.getApproval();
            if (approval == null) {
                return;
            }
            ApprovalsPart.this.fViewer.editElement((Object)approval, 1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalApprovalListener
    implements IWorkItemListener {
        private InternalApprovalListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (ApprovalsPart.this.fWorkingCopy == null) {
                return;
            }
            if (!event.affects((IWorkItemHandle)ApprovalsPart.this.fWorkingCopy.getWorkItem())) {
                return;
            }
            if (event.affects(IWorkItem.APPROVALS_PROPERTY)) {
                this.handleApprovalsChanged(ApprovalsPart.this.fWorkingCopy, event);
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }

        private void handleApprovalsChanged(WorkItemWorkingCopy input, WorkItemChangeEvent event) {
            IAdaptable details = event.getAttributeChangeDetails(IWorkItem.APPROVALS_PROPERTY);
            if (details == null) {
                ApprovalsPart.this.fViewer.refresh();
                return;
            }
            ListChangeDetails listChange = (ListChangeDetails)details.getAdapter(ListChangeDetails.class);
            if (listChange != null) {
                this.handleApprovalListChange(input, (ListChangeDetails<IApproval>)listChange);
                return;
            }
            ApprovalChangeDetails stateChange = (ApprovalChangeDetails)details.getAdapter(ApprovalChangeDetails.class);
            if (stateChange != null) {
                this.handleApprovalStateChange(stateChange);
                return;
            }
            ApprovalsPart.this.fViewer.refresh();
        }

        private void handleApprovalListChange(WorkItemWorkingCopy input, ListChangeDetails<IApproval> change) {
            for (IApproval approval : change.getAdded()) {
                ApprovalsPart.this.fContentProvider.add(approval);
                ApprovalsPart.this.fViewer.expandToLevel((Object)approval.getDescriptor(), 1);
            }
            for (IApproval approval : change.getRemoved()) {
                ApprovalsPart.this.fContentProvider.remove(approval);
            }
        }

        private void handleApprovalStateChange(ApprovalChangeDetails stateChange) {
            ApprovalsPart.this.fViewer.update((Object)stateChange.getApproval(), new String[]{ApprovalsPart.STATE_PROPERTY});
        }
    }

    private static class InternalConvertingSelectionProvider
    extends ConvertingSelectionProvider {
        public InternalConvertingSelectionProvider(ISelectionProvider provider) {
            super(provider);
        }

        protected ISelection convertFrom(ISelection viewerSelection) {
            ArrayList<IContributorHandle> elements = new ArrayList<IContributorHandle>();
            for (Object element : ((IStructuredSelection)viewerSelection).toList()) {
                if (!(element instanceof IApproval)) continue;
                elements.add(((IApproval)element).getApprover());
            }
            return new StructuredSelection(elements);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalDescriptorListener
    implements IWorkItemListener {
        private InternalDescriptorListener() {
        }

        public void workItemAttributeChanged(WorkItemChangeEvent event) {
            if (ApprovalsPart.this.fWorkingCopy == null) {
                return;
            }
            if (!event.affects((IWorkItemHandle)ApprovalsPart.this.fWorkingCopy.getWorkItem())) {
                return;
            }
            if (event.affects(IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY)) {
                this.handleApprovalDescriptorsChanged(ApprovalsPart.this.fWorkingCopy, event);
            }
        }

        public void workItemAttributeDependencyChanged(WorkItemChangeEvent event) {
        }

        private void handleApprovalDescriptorsChanged(WorkItemWorkingCopy input, WorkItemChangeEvent event) {
            IAdaptable details = event.getAttributeChangeDetails(IWorkItem.APPROVAL_DESCRIPTORS_PROPERTY);
            if (details == null) {
                ApprovalsPart.this.fViewer.refresh();
                return;
            }
            ListChangeDetails listChange = (ListChangeDetails)details.getAdapter(ListChangeDetails.class);
            if (listChange != null) {
                this.handleDescriptorListChange(input, (ListChangeDetails<IApprovalDescriptor>)listChange);
                return;
            }
            ApprovalChangeDetails stateChange = (ApprovalChangeDetails)details.getAdapter(ApprovalChangeDetails.class);
            if (stateChange != null) {
                this.handleDescriptorStateChange(stateChange);
                return;
            }
            ApprovalsPart.this.fViewer.refresh();
        }

        private void handleDescriptorListChange(WorkItemWorkingCopy input, ListChangeDetails<IApprovalDescriptor> change) {
            for (IApprovalDescriptor descriptor : change.getAdded()) {
                ApprovalsPart.this.fContentProvider.add(descriptor);
            }
            for (IApprovalDescriptor descriptor : change.getRemoved()) {
                ApprovalsPart.this.fContentProvider.remove(descriptor);
            }
            if (!change.getAdded().isEmpty()) {
                ApprovalsPart.this.fViewer.setSelection((ISelection)new StructuredSelection(change.getAdded().get(change.getAdded().size() - 1)), true);
            }
        }

        private void handleDescriptorStateChange(ApprovalChangeDetails stateChange) {
            if (IApprovalDescriptor.TYPE_IDENTIFIER_PROPERTY.equals(stateChange.getProperty()) || IApprovalDescriptor.NAME_PROPERTY.equals(stateChange.getProperty())) {
                ApprovalsPart.this.fViewer.update((Object)stateChange.getDescriptor(), new String[]{ApprovalsPart.APPROVER_PROPERTY});
            } else if (IApprovalDescriptor.CUMULATIVE_STATE_IDENTIFIER_PROPERTY.equals(stateChange.getProperty())) {
                ApprovalsPart.this.fViewer.update((Object)stateChange.getDescriptor(), new String[]{ApprovalsPart.STATE_PROPERTY});
            } else if (IApprovalDescriptor.DUE_DATE_PROPERTY.equals(stateChange.getProperty())) {
                ApprovalsPart.this.fViewer.update((Object)stateChange.getDescriptor(), new String[]{ApprovalsPart.DUE_DATE_PROPERTY});
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class InternalDropTargetListener
    implements DropTargetListener {
        private InternalDropTargetListener() {
        }

        public void dragEnter(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dragOperationChanged(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dropAccept(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void drop(DropTargetEvent event) {
            this.performDrop(event);
        }

        public void dragOver(DropTargetEvent event) {
            this.validateDrop(event);
        }

        public void dragLeave(DropTargetEvent event) {
        }

        private void validateDrop(DropTargetEvent event) {
            event.detail = this.canRun(event) ? event.operations & 4 : 0;
        }

        private void performDrop(DropTargetEvent event) {
            if (!this.canRun(event)) {
                event.detail = 0;
                return;
            }
            List<Object> elements = this.getTransferElements(event);
            List<IContributorHandle> handles = this.expand(elements);
            if (handles.isEmpty()) {
                event.detail = 0;
                return;
            }
            IApprovalDescriptor descriptor = this.getDescriptor(event);
            if (descriptor == null) {
                descriptor = ApprovalsPart.this.createApprovalDescriptor(this.findDefaultName(elements));
            }
            if (descriptor == null) {
                event.detail = 0;
                return;
            }
            ApprovalsPart.this.resolveAndAdd(descriptor, handles);
        }

        private boolean canRun(DropTargetEvent event) {
            if (ApprovalsPart.this.fWorkingCopy == null) {
                return false;
            }
            if (URIReferenceTransfer.getInstance().isSupportedType(event.currentDataType)) {
                return true;
            }
            List<Object> elements = this.getTransferElements(event);
            IApprovalDescriptor descriptor = this.getDescriptor(event);
            IApprovals approvals = ApprovalsPart.this.fWorkingCopy.getWorkItem().getApprovals();
            for (IContributorHandle handle : this.expand(elements)) {
                if (descriptor == null) {
                    return true;
                }
                if (approvals.contains(descriptor, handle)) continue;
                return true;
            }
            return false;
        }

        private List<Object> getTransferElements(DropTargetEvent event) {
            ArrayList<Object> elements = new ArrayList<Object>();
            if (URIReferenceTransfer.getInstance().isSupportedType(event.currentDataType) && event.data instanceof URIReference[]) {
                elements.addAll(Arrays.asList((URIReference[])event.data));
            }
            if (LocalSelectionTransfer.getTransfer().isSupportedType(event.currentDataType) && LocalSelectionTransfer.getTransfer().getSelection() instanceof IStructuredSelection) {
                elements.addAll(((IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection()).toList());
            }
            return elements;
        }

        private List<IContributorHandle> expand(List<Object> list) {
            ArrayList<IContributorHandle> result = new ArrayList<IContributorHandle>();
            for (Object element : list) {
                if (element instanceof FavoritesFolder) {
                    result.addAll(this.expand(((FavoritesFolder)element).getChildren()));
                    continue;
                }
                if (element instanceof Favorite) {
                    result.addAll(this.expand(Collections.singletonList(((Favorite)element).getItem())));
                    continue;
                }
                if (element instanceof URIFavorite) {
                    try {
                        URI uri = new URI(((URIFavorite)element).getUri());
                        result.addAll(this.expand(Collections.singletonList(this.findItemHandle(uri))));
                    }
                    catch (URISyntaxException uRISyntaxException) {}
                    continue;
                }
                if (element instanceof URIReference) {
                    result.addAll(this.expand(Collections.singletonList(this.findItemHandle(((URIReference)element).getURI()))));
                    continue;
                }
                if (!(element instanceof IContributorHandle)) continue;
                result.add((IContributorHandle)element);
            }
            return result;
        }

        private IItemHandle findItemHandle(URI uri) {
            try {
                return URIService.resolveItemHandle((URI)uri);
            }
            catch (TeamRepositoryException teamRepositoryException) {
                return null;
            }
        }

        private String findDefaultName(List<Object> elements) {
            for (Object element : elements) {
                if (!(element instanceof FavoritesFolder)) continue;
                return ((FavoritesFolder)element).getText();
            }
            return null;
        }

        private IApprovalDescriptor getDescriptor(DropTargetEvent event) {
            if (event.item == null) {
                return null;
            }
            Object data = event.item.getData();
            if (data instanceof IApprovalDescriptor) {
                return (IApprovalDescriptor)data;
            }
            if (data instanceof IApproval) {
                return ((IApproval)data).getDescriptor();
            }
            return null;
        }
    }

    public static class NewApprovalDescriptorDialog
    extends Dialog {
        private static final String DIALOG_SETTINGS_KEY = "newApprovalDescriptor";
        private static final String TYPE_KEY = "descriptorType";
        private static final String NAME_HISTORY_KEY = "descriptorNameHistory";
        private static final int MAX_NAME_HISTORY = 5;
        private IDialogSettings fDialogSettings;
        private IApprovalType fType = (IApprovalType)WorkItemApprovals.getTypes().get(0);
        private String fName = "";
        private List<String> fNameHistory = new ArrayList<String>();
        private Daystamp fDue = new Daystamp(2);
        private ParseException fDueException = null;
        private boolean fAddApprover = false;
        private String fInitialName;
        private DecoratedCombo fTypeCombo;
        private DecoratedCombo fNameText;
        private DecoratedText fDueText;
        private ResourceManager fResourceManager;
        private String fDefaultName;
        private boolean fEdit;
        private Hyperlink fLink;

        public NewApprovalDescriptorDialog(Shell parentShell, String defaultName, boolean edit) {
            super(parentShell);
            this.fDefaultName = defaultName;
            this.fEdit = edit;
            this.loadSettings();
        }

        public IApprovalType getType() {
            return this.fType;
        }

        public void setType(IApprovalType type) {
            this.fType = type;
        }

        public String getName() {
            return this.fName;
        }

        public void setName(String name) {
            Assert.isNotNull((Object)name);
            this.fName = name;
        }

        public Timestamp getDueDate() {
            return this.fDue.getTimestamp();
        }

        public void setDueDate(Timestamp dueDate) {
            this.fDue.setStoredTimestamp(dueDate);
        }

        public boolean isAddApprover() {
            return this.fAddApprover;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(this.fEdit ? Messages.ApprovalsPart_EDIT_APPROVAL_SHELL_TITLE : Messages.ApprovalsPart_NEW_APPROVAL_SHELL_TITLE);
        }

        protected Control createDialogArea(Composite parent) {
            Composite container = (Composite)super.createDialogArea(parent);
            Composite composite = new Composite(container, 0);
            GridData data = new GridData(4, 4, true, true);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            composite.setLayoutData((Object)data);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.horizontalSpacing = 9;
            composite.setLayout((Layout)layout);
            this.fResourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
            Label label = new Label(composite, 0);
            label.setText(Messages.ApprovalsPart_TYPE);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fTypeCombo = new DecoratedCombo(composite, 8, 1);
            this.fTypeCombo.getLayoutControl().setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            this.fTypeCombo.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    if (element instanceof IApprovalType) {
                        return ((IApprovalType)element).getDisplayName();
                    }
                    return super.getText(element);
                }

                public Image getImage(Object element) {
                    if (element instanceof IApprovalType) {
                        URL iconURL = ((IApprovalType)element).getIconURL();
                        return NewApprovalDescriptorDialog.this.fResourceManager.createImageWithDefault(iconURL != null ? ImageDescriptor.createFromURL((URL)iconURL) : null);
                    }
                    return super.getImage(element);
                }
            });
            this.fTypeCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    NewApprovalDescriptorDialog.this.fType = (IApprovalType)NewApprovalDescriptorDialog.this.fTypeCombo.getValue();
                    if (NewApprovalDescriptorDialog.this.fNameText != null && NewApprovalDescriptorDialog.this.fNameText.getCombo().getText().equals(NewApprovalDescriptorDialog.this.fInitialName)) {
                        NewApprovalDescriptorDialog.this.setInitialName();
                    }
                }
            });
            this.fTypeCombo.setValueSet(WorkItemApprovals.getTypes().toArray());
            this.fTypeCombo.setValue((Object)this.fType);
            label = new Label(composite, 0);
            label.setText(Messages.ApprovalsPart_SUBJECT);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            this.fNameText = new DecoratedCombo(composite, 0);
            data = new GridData(4, 0x1000000, true, false);
            data.horizontalIndent = 16;
            this.fNameText.getLayoutControl().setLayoutData((Object)data);
            this.fNameText.getCombo().setFocus();
            this.fNameText.getCombo().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewApprovalDescriptorDialog.this.fName = NewApprovalDescriptorDialog.this.fNameText.getCombo().getText();
                    NewApprovalDescriptorDialog.this.validateInput();
                }
            });
            label = new Label(composite, 0);
            label.setText(Messages.ApprovalsPart_DUE);
            label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
            Composite dueContainer = new Composite(composite, 0);
            dueContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            dueContainer.setLayout((Layout)layout);
            this.fDueText = new DecoratedText(dueContainer, 2052);
            data = new GridData(4, 0x1000000, true, false);
            data.horizontalIndent = 23;
            this.fDueText.getLayoutControl().setLayoutData((Object)data);
            this.fDueText.getText().addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    NewApprovalDescriptorDialog.this.fDueException = NewApprovalDescriptorDialog.this.fDue.setText((String)NewApprovalDescriptorDialog.this.fDueText.getValue());
                    NewApprovalDescriptorDialog.this.validateInput();
                }
            });
            final ToolBar toolBar = new ToolBar(dueContainer, 0x800000);
            toolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
            final ToolItem calendarButton = new ToolItem(toolBar, 8);
            calendarButton.setToolTipText(Messages.ApprovalsPart_PICK_DATE);
            LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)toolBar);
            Image image = JazzResources.getImageWithDefault((ResourceManager)resourceManager, (ImageDescriptor)ImagePool.DATE);
            calendarButton.setImage(image);
            calendarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    calendarButton.setEnabled(false);
                    Rectangle rect = calendarButton.getBounds();
                    Point pt = toolBar.toDisplay(new Point(rect.x, rect.y + rect.height));
                    DatePicker picker = new DatePicker(NewApprovalDescriptorDialog.this.getShell(), 2);
                    picker.setLocation(pt.x, pt.y);
                    try {
                        picker.setDate(DateFormat.getDateInstance((int)2).parse(NewApprovalDescriptorDialog.this.fDueText.getText().getText()));
                    }
                    catch (ParseException parseException) {}
                    picker.open();
                    Date date = picker.getDateObject();
                    if (date != null) {
                        NewApprovalDescriptorDialog.this.fDueText.getText().setText(DateFormat.getDateInstance((int)2).format(date));
                        NewApprovalDescriptorDialog.this.fDueText.getText().setFocus();
                    }
                    calendarButton.setEnabled(true);
                }
            });
            this.fLink = new Hyperlink(composite, 0);
            this.fLink.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 2, 1));
            this.fLink.setText(Messages.ApprovalsPart_ADD_APPROVER);
            this.fLink.setToolTipText(Messages.ApprovalsPart_ADD_APPROVER);
            this.fLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    NewApprovalDescriptorDialog.this.fAddApprover = true;
                    NewApprovalDescriptorDialog.this.okPressed();
                }
            });
            HyperlinkGroup hyperlinkGroup = new HyperlinkGroup(Display.getCurrent());
            hyperlinkGroup.add(this.fLink);
            if ("".equals(this.fName)) {
                this.setInitialName();
            } else {
                this.fNameText.getCombo().setText(this.fName);
                this.fNameText.getCombo().setSelection(new Point(0, this.fName.length()));
            }
            for (String name : this.fNameHistory) {
                this.fNameText.getCombo().add(name);
            }
            if (this.fNameHistory.isEmpty()) {
                this.fNameText.getCombo().add(this.fNameText.getCombo().getText());
            }
            this.fDueText.setValue(this.fDue.getText());
            NewApprovalDescriptorDialog.applyDialogFont((Control)container);
            return container;
        }

        private void validateInput() {
            IStatus nameStatus = this.getNameStatus();
            this.fNameText.setStatus(nameStatus);
            IStatus dueStatus = this.getDueStatus();
            this.fDueText.setStatus(dueStatus);
            boolean enabled = nameStatus.getSeverity() != 4 && nameStatus.getSeverity() != 8;
            enabled &= dueStatus.getSeverity() != 4 && dueStatus.getSeverity() != 8;
            Button okButton = this.getButton(0);
            if (okButton != null) {
                okButton.setEnabled(enabled);
            }
            if (this.fLink != null) {
                this.fLink.setEnabled(enabled);
            }
        }

        private void setInitialName() {
            this.fInitialName = this.defaultInitialValue((IApprovalType)this.fTypeCombo.getValue());
            this.fNameText.getCombo().setText(this.fInitialName);
            this.fNameText.getCombo().setSelection(new Point(0, this.fInitialName.length()));
        }

        private IStatus getNameStatus() {
            if (this.fNameText.getCombo().getText().length() == 0) {
                return new Status(4, "com.ibm.team.workitem.ide.ui", Messages.ApprovalsPart_EMPTY_APPROVAL_NAME);
            }
            return Status.OK_STATUS;
        }

        private String defaultInitialValue(IApprovalType type) {
            if (this.fDefaultName != null) {
                return this.fDefaultName;
            }
            if (!this.fNameHistory.isEmpty()) {
                return this.fNameHistory.get(0);
            }
            return type.getDisplayName();
        }

        private IStatus getDueStatus() {
            if (this.fDueException != null) {
                return new Status(4, "com.ibm.team.workitem.ide.ui", this.fDueException.getLocalizedMessage());
            }
            return Status.OK_STATUS;
        }

        protected void okPressed() {
            super.okPressed();
            this.storeSettings();
        }

        private void loadSettings() {
            IApprovalType type;
            this.fDialogSettings = WorkItemIDEUIPlugin.getDefault().getDialogSettings().getSection(DIALOG_SETTINGS_KEY);
            if (this.fDialogSettings != null && this.fDialogSettings.get(TYPE_KEY) != null && (type = WorkItemApprovals.getType((String)this.fDialogSettings.get(TYPE_KEY))) != null) {
                this.fType = type;
            }
            if (this.fDialogSettings != null && this.fDialogSettings.getArray(NAME_HISTORY_KEY) != null) {
                this.fNameHistory.addAll(Arrays.asList(this.fDialogSettings.getArray(NAME_HISTORY_KEY)));
            }
        }

        private void storeSettings() {
            if (this.fDialogSettings == null) {
                this.fDialogSettings = WorkItemIDEUIPlugin.getDefault().getDialogSettings().addNewSection(DIALOG_SETTINGS_KEY);
            }
            this.fDialogSettings.put(TYPE_KEY, this.fType.getIdentifier());
            while (this.fNameHistory.remove(this.fName)) {
            }
            this.fNameHistory.add(0, this.fName);
            if (this.fNameHistory.size() > 5) {
                this.fNameHistory = new ArrayList<String>(this.fNameHistory.subList(0, 5));
            }
            this.fDialogSettings.put(NAME_HISTORY_KEY, this.fNameHistory.toArray(new String[this.fNameHistory.size()]));
        }
    }

    private class RemoveApprovalAction
    extends Action
    implements IUpdate {
        public RemoveApprovalAction() {
            this.setText(Messages.ApprovalsPart_REMOVE);
            this.update();
        }

        public void update() {
            this.setEnabled(this.canRun());
        }

        private boolean canRun() {
            if (ApprovalsPart.this.fWorkingCopy == null) {
                return false;
            }
            return !ApprovalsPart.this.fViewer.getSelection().isEmpty();
        }

        public void run() {
            if (!this.canRun()) {
                return;
            }
            ITeamRepository teamRepository = ApprovalsPart.this.fWorkingCopy.getTeamRepository();
            IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
            IWorkItem workItem = ApprovalsPart.this.fWorkingCopy.getWorkItem();
            try {
                workItemClient.getWorkItemWorkingCopyManager().beginCompoundWorkItemChange((IWorkItemHandle)workItem);
                List selection = ((IStructuredSelection)ApprovalsPart.this.fViewer.getSelection()).toList();
                IApprovals approvals = workItem.getApprovals();
                for (Object object : selection) {
                    if (object instanceof IApprovalDescriptor) {
                        IApprovalDescriptor descriptor = (IApprovalDescriptor)object;
                        approvals.remove(descriptor);
                        continue;
                    }
                    if (!(object instanceof IApproval)) continue;
                    approvals.remove((IApproval)object);
                }
            }
            finally {
                workItemClient.getWorkItemWorkingCopyManager().endCompoundWorkItemChange((IWorkItemHandle)workItem);
            }
        }
    }
}

