/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.itempicker;

import com.ibm.team.process.common.IIteration;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.process.internal.common.ProcessPackage;
import com.ibm.team.repository.common.IContributor;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.common.model.ICategory;
import com.ibm.team.workitem.common.model.IWorkItem;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.CategoryItemPicker;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.ContributorItemPicker;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.IItemPicker;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.IterationItemPicker;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.ProcessAreaItemPicker;
import com.ibm.team.workitem.ide.ui.internal.editor.itempicker.WorkItemItemPicker;
import java.util.HashMap;

public class ItemPickerRegistry {
    private static HashMap<IItemType, Class<? extends IItemPicker>> REGISTRY = new HashMap();

    static {
        REGISTRY.put(IContributor.ITEM_TYPE, ContributorItemPicker.class);
        REGISTRY.put(IItemType.IRegistry.INSTANCE.getItemType(ProcessPackage.eINSTANCE.getProcessArea().getName(), "com.ibm.team.process"), ProcessAreaItemPicker.class);
        REGISTRY.put(IProjectArea.ITEM_TYPE, ProcessAreaItemPicker.class);
        REGISTRY.put(ITeamArea.ITEM_TYPE, ProcessAreaItemPicker.class);
        REGISTRY.put(IWorkItem.ITEM_TYPE, WorkItemItemPicker.class);
        REGISTRY.put(ICategory.ITEM_TYPE, CategoryItemPicker.class);
        REGISTRY.put(IIteration.ITEM_TYPE, IterationItemPicker.class);
    }

    public static IItemPicker getItemPicker(IItemType itemType) {
        if (itemType == null) {
            return null;
        }
        Class<? extends IItemPicker> clazz = REGISTRY.get(itemType);
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            WorkItemIDEUIPlugin.getDefault().log(NLS.bind((String)Messages.ItemPickerRegistry_EXCEPTION_CREATING_ITEMPICKER, (Object)itemType, (Object[])new Object[0]), e);
            return null;
        }
    }
}

