/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.deliverable;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.foundation.client.util.FoundationJob;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.internal.util.ExceptionDescription;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.foundation.rcp.ui.internal.util.ExceptionDescriptionUI;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.labelProviders.ElementRemovedNotifierImpl;
import com.ibm.team.jface.labelProviders.IElementRemovedNotifier;
import com.ibm.team.jface.labelProviders.StandardLabelProvider;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.repository.client.IItemManager;
import com.ibm.team.repository.client.ISharedItemChangeEvent;
import com.ibm.team.repository.client.ISharedItemChangeListener;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IAuditable;
import com.ibm.team.repository.common.IAuditableHandle;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.ui.editor.TeamFormPart;
import com.ibm.team.workitem.client.IWorkItemClient;
import com.ibm.team.workitem.client.internal.WorkItemClient;
import com.ibm.team.workitem.client.internal.util.AuditableBatchResolver;
import com.ibm.team.workitem.common.IWorkItemCommon;
import com.ibm.team.workitem.common.internal.DeliverableWorkingCopy;
import com.ibm.team.workitem.common.internal.model.Deliverable;
import com.ibm.team.workitem.common.internal.util.ItemHandleAwareHashSet;
import com.ibm.team.workitem.common.model.IDeliverable;
import com.ibm.team.workitem.common.model.ItemProfile;
import com.ibm.team.workitem.common.model.MultiStaleDataException;
import com.ibm.team.workitem.ide.ui.WorkItemIDEUI;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.WorkItemProjectAreaEditorInput;
import com.ibm.team.workitem.ide.ui.internal.editor.deliverable.DeliverableDialog;
import com.ibm.team.workitem.ide.ui.internal.editor.deliverable.DeliverablePage;
import com.ibm.team.workitem.ide.ui.internal.editor.deliverable.Messages;
import com.ibm.team.workitem.rcp.ui.internal.ConstrainedTableViewer;
import com.ibm.team.workitem.rcp.ui.internal.util.Utils;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.texteditor.IUpdate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliverablePart
extends TeamFormPart {
    private static final String NAME_LABEL = Messages.DeliverablePart_NAME_LABEL;
    private static final String CREATION_DATE_LABEL = Messages.DeliverablePart_CREATION_DATE_LABEL;
    private static final String VISIBILITY_LABEL = Messages.DeliverablePart_VISIBILITY_LABEL;
    private static final String ARTIFACT_LABEL = Messages.DeliverablePart_ARTIFACT_LABEL;
    private static final int NAME_INDEX = 0;
    private static final int CREATION_DATE_INDEX = 1;
    private static final int VISIBILITY_INDEX = 2;
    private static final int ARTIFACT_INDEX = 3;
    private IProjectArea fProjectArea;
    private DeliverableWorkingCopy fWorkingCopy;
    private Runnable fWorkingCopyListener = new Runnable(){

        public void run() {
            FoundationUIJob job = new FoundationUIJob(Messages.DeliverablePart_UPDATE_DIRTY_STATE){

                protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                    DeliverablePart.this.fPage.firePropertyChange(257);
                    return null;
                }
            };
            job.schedule();
        }
    };
    private AuditableBatchResolver fArtifacts;
    private Object fInput;
    private DeliverablePage fPage;
    private TableViewer fViewer;
    private boolean fShowArchived = false;
    private ISharedItemChangeListener fSharedItemListener = new InternalSharedItemListener();

    private List<IDeliverable> getSortedDeliverables() {
        ArrayList<IDeliverable> deliverables = new ArrayList<IDeliverable>(this.fWorkingCopy.getDeliverables());
        Collections.sort(deliverables, new Comparator<IDeliverable>(){

            @Override
            public int compare(IDeliverable o1, IDeliverable o2) {
                return DeliverableWorkingCopy.compare((IDeliverable)o1, (IDeliverable)o2);
            }
        });
        return deliverables;
    }

    private List<IDeliverable> getSortedSelection(final List<IDeliverable> order) {
        ArrayList<IDeliverable> selection = new ArrayList<IDeliverable>();
        for (Object element : ((IStructuredSelection)this.fViewer.getSelection()).toList()) {
            if (!(element instanceof IDeliverable)) continue;
            selection.add((IDeliverable)element);
        }
        Collections.sort(selection, new Comparator<IDeliverable>(){

            @Override
            public int compare(IDeliverable o1, IDeliverable o2) {
                return order.indexOf(o1) - order.indexOf(o2);
            }
        });
        return selection;
    }

    private void moveUp(List<IDeliverable> deliverables, List<IDeliverable> selection) {
        for (IDeliverable deliverable : selection) {
            int index = deliverables.indexOf(deliverable) - 1;
            if (!this.fShowArchived) {
                while (index >= 0 && deliverables.get(index).isArchived()) {
                    --index;
                }
            }
            if (index < 0 || selection.contains(deliverables.get(index))) continue;
            deliverables.remove(deliverable);
            deliverables.add(index, deliverable);
        }
    }

    private void updateSequenceValue(List<IDeliverable> deliverables) {
        int i = 0;
        int n = deliverables.size();
        while (i < n) {
            Deliverable deliverable = (Deliverable)deliverables.get(n - i - 1);
            if (deliverable.getSequenceValue() != i) {
                deliverable.setSequenceValue(i);
            }
            ++i;
        }
    }

    private List<Integer> getIndices(IStructuredSelection selection) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Object element : selection.toList()) {
            indices.add(this.indexOf(element));
        }
        Collections.sort(indices);
        return indices;
    }

    private int indexOf(Object element) {
        int index = -1;
        int i = 0;
        int n = this.fViewer.getTable().getItemCount();
        while (i < n) {
            Object current = this.fViewer.getElementAt(i);
            if (current == element) {
                index = i;
                break;
            }
            ++i;
        }
        return index;
    }

    public DeliverablePart(DeliverablePage page) {
        this.fPage = page;
    }

    public boolean stretchHorizontally() {
        return true;
    }

    public boolean stretchVertically() {
        return true;
    }

    public void createContent(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        Composite composite = new Composite(parent, 0){

            public Point computeSize(int hint, int hint2, boolean changed) {
                Point size = super.computeSize(hint, hint2, changed);
                size.x = 100;
                return size;
            }
        };
        composite.setLayout((Layout)new FillLayout());
        composite.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        Label label = new Label(composite, 64);
        label.setText(Messages.DeliverablePart_DEFINE_RELEASES);
        Table table = ConstrainedTableViewer.createTable((Composite)parent, (FormToolkit)this.getSite().getToolkit(), (int)68354, (boolean)false);
        TableColumn column = new TableColumn(table, 16384);
        column.setText(NAME_LABEL);
        column.setResizable(true);
        column.setWidth(100);
        column = new TableColumn(table, 16384);
        column.setText(CREATION_DATE_LABEL);
        column.setResizable(true);
        column.setWidth(100);
        column = new TableColumn(table, 16384);
        column.setText(VISIBILITY_LABEL);
        column.setResizable(true);
        column.setWidth(100);
        column = new TableColumn(table, 16384);
        column.setText(ARTIFACT_LABEL);
        column.setResizable(true);
        column.setWidth(100);
        this.fViewer = new TableViewer(table);
        this.fViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.fViewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.fViewer.getTable().setHeaderVisible(true);
        this.fViewer.getTable().setLinesVisible(true);
        this.fViewer.setColumnProperties(new String[]{NAME_LABEL, CREATION_DATE_LABEL, VISIBILITY_LABEL, ARTIFACT_LABEL});
        this.fViewer.setContentProvider((IContentProvider)new DeliverableContentProvider());
        this.fViewer.setLabelProvider((IBaseLabelProvider)new DeliverableLabelProvider());
        this.fViewer.setSorter((ViewerSorter)new DeliverableSorter());
        this.fViewer.setFilters(new ViewerFilter[]{new DeliverableFilter()});
        this.fViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                EditAction editAction = new EditAction();
                if (editAction.isEnabled()) {
                    editAction.run();
                }
            }
        });
        this.addContextMenu();
        Composite moveButtons = new Composite(parent, 0);
        moveButtons.setLayoutData((Object)new GridData(4, 4, false, false));
        this.createMoveButtons(this.fViewer, moveButtons);
        Composite editButtons = new Composite(parent, 0);
        editButtons.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.createEditButtons(this.fViewer, editButtons);
        Utils.updateColumnWidths((Table)this.fViewer.getTable(), (int[])new int[0]);
        this.getSite().registerSelectionProvider((ISelectionProvider)this.fViewer, this.fViewer.getControl());
    }

    private void addContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                OpenArtifactAction openArtifact;
                UnarchiveAction unarchive;
                ArchiveAction archive;
                EditAction edit;
                AddAction add = new AddAction();
                if (add.isEnabled()) {
                    manager.add((IAction)add);
                }
                if ((edit = new EditAction()).isEnabled()) {
                    manager.add((IAction)edit);
                }
                if ((archive = new ArchiveAction()).isEnabled()) {
                    manager.add((IAction)archive);
                }
                if ((unarchive = new UnarchiveAction()).isEnabled()) {
                    manager.add((IAction)unarchive);
                }
                if ((openArtifact = new OpenArtifactAction()).isEnabled()) {
                    manager.add((IAction)openArtifact);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(this.fViewer.getControl());
        this.fViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(String.valueOf(this.getSite().getId((TeamFormPart)this)) + ".deliverableViewer", menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void createMoveButtons(TableViewer viewer, Composite parent) {
        GridLayout gd = new GridLayout();
        gd.marginWidth = 0;
        gd.marginHeight = 0;
        parent.setLayout((Layout)gd);
        Button up = this.getSite().getToolkit().createButton(parent, "", 0);
        up.setLayoutData((Object)new GridData(4, 4, false, false));
        new ActionButton((StructuredViewer)viewer, (IAction)new MoveUpAction(), up);
        Button down = this.getSite().getToolkit().createButton(parent, "", 0);
        down.setLayoutData((Object)new GridData(4, 4, false, false));
        new ActionButton((StructuredViewer)viewer, (IAction)new MoveDownAction(), down);
    }

    private void createEditButtons(TableViewer viewer, Composite parent) {
        GridLayout gd = new GridLayout(5, false);
        gd.marginWidth = 0;
        gd.marginHeight = 0;
        parent.setLayout((Layout)gd);
        Button add = this.getSite().getToolkit().createButton(parent, "", 0);
        add.setLayoutData((Object)new GridData(16384, 4, false, false));
        new ActionButton((StructuredViewer)viewer, (IAction)new AddAction(), add);
        Button edit = this.getSite().getToolkit().createButton(parent, "", 0);
        edit.setLayoutData((Object)new GridData(16384, 4, false, false));
        new ActionButton((StructuredViewer)viewer, (IAction)new EditAction(), edit);
        Button archive = this.getSite().getToolkit().createButton(parent, "", 0);
        archive.setLayoutData((Object)new GridData(16384, 4, false, false));
        new ActionButton((StructuredViewer)viewer, (IAction)new ArchiveAction(), archive);
        Button openArtifact = this.getSite().getToolkit().createButton(parent, "", 0);
        openArtifact.setLayoutData((Object)new GridData(16384, 4, false, false));
        new ActionButton((StructuredViewer)viewer, (IAction)new OpenArtifactAction(), openArtifact);
        final Button showArchived = new Button(parent, 0x800020);
        showArchived.setText(Messages.DeliverablePart_SHOW_ARCHIVED);
        showArchived.setLayoutData((Object)new GridData(131072, 4, true, false));
        showArchived.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeliverablePart.this.fShowArchived = showArchived.getSelection();
                DeliverablePart.this.fViewer.refresh();
                DeliverablePart.this.fViewer.setSelection(DeliverablePart.this.fViewer.getSelection());
            }
        });
    }

    public boolean isDirty() {
        return this.fWorkingCopy != null && this.fWorkingCopy.isDirty();
    }

    private void resolveInput() {
        UIUpdaterJob job = new UIUpdaterJob(Messages.DeliverablePart_RESOLVING_RELEASES){

            public IStatus runInBackground(IProgressMonitor monitor) {
                if (DeliverablePart.this.fProjectArea == null) {
                    return Status.CANCEL_STATUS;
                }
                if (!DeliverablePart.this.fProjectArea.isInitialized()) {
                    DeliverablePart.this.fInput = Messages.DeliverablePart_PROJECT_AREA_NOT_INITIALIZED;
                    return Status.OK_STATUS;
                }
                try {
                    ITeamRepository teamRepository = (ITeamRepository)DeliverablePart.this.fProjectArea.getOrigin();
                    IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    DeliverablePart.this.fWorkingCopy = ((WorkItemClient)workItemClient).resolveDeliverableWorkingCopy(DeliverablePart.this.fProjectArea, monitor);
                    DeliverablePart.this.fWorkingCopy.setDirtyListener(DeliverablePart.this.fWorkingCopyListener);
                    AuditableBatchResolver resolver = new AuditableBatchResolver((IWorkItemCommon)workItemClient);
                    for (IDeliverable deliverable : DeliverablePart.this.fWorkingCopy.getDeliverables()) {
                        if (!(deliverable.getArtifact() instanceof IAuditableHandle)) continue;
                        resolver.add(ItemProfile.createFullProfile((IItemType)deliverable.getArtifact().getItemType()), (IAuditableHandle)deliverable.getArtifact());
                    }
                    resolver.resolve(monitor);
                    DeliverablePart.this.fArtifacts = resolver;
                    DeliverablePart.this.fInput = DeliverablePart.this.fWorkingCopy;
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException x) {
                    return new Status(4, "com.ibm.team.workitem.ide.ui", x.getMessage(), (Throwable)x);
                }
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (DeliverablePart.this.fViewer != null && !DeliverablePart.this.fViewer.getControl().isDisposed()) {
                    DeliverablePart.this.fViewer.setInput(DeliverablePart.this.fInput);
                    DeliverablePart.this.fViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void setInput(Object input) {
        if (input instanceof WorkItemProjectAreaEditorInput) {
            this.fProjectArea = ((WorkItemProjectAreaEditorInput)input).getProjectArea();
            IItemManager itemManager = ((ITeamRepository)this.fProjectArea.getOrigin()).itemManager();
            itemManager.addItemChangeListener(IDeliverable.ITEM_TYPE, this.fSharedItemListener);
            this.resolveInput();
        }
    }

    public void save(IProgressMonitor monitor) {
        if (this.fWorkingCopy != null && this.fWorkingCopy.isDirty()) {
            try {
                this.getSite().getWorkbenchPage().getWorkbenchWindow().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        try {
                            DeliverablePart.this.fWorkingCopy.save(monitor);
                        }
                        catch (TeamRepositoryException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                });
                this.fViewer.refresh();
            }
            catch (InvocationTargetException x) {
                Throwable cause = x.getCause();
                if (cause instanceof MultiStaleDataException) {
                    this.handleStale((MultiStaleDataException)cause);
                    monitor.setCanceled(true);
                    return;
                }
                ExceptionDescriptionUI.handleDescription((IWorkbenchWindow)this.getSite().getWorkbenchPage().getWorkbenchWindow(), (ExceptionDescription)ExceptionDescription.findDescription((String)Messages.DeliverablePart_SAVING_RELEASES, (Throwable)cause));
                WorkItemIDEUIPlugin.getDefault().log("Error while saving releases", x);
                monitor.setCanceled(true);
                return;
            }
            catch (InterruptedException interruptedException) {
                monitor.setCanceled(true);
                return;
            }
        }
    }

    private Shell getShell() {
        return this.getSite().getWorkbenchPage().getWorkbenchWindow().getShell();
    }

    private void handleStale(MultiStaleDataException x) {
        FoundationUIJob staleJob = new FoundationUIJob(Messages.DeliverablePart_HANDLING_STALE_DATA){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                if (DeliverablePart.this.fProjectArea == null) {
                    return Status.CANCEL_STATUS;
                }
                if (MessageDialog.openQuestion((Shell)DeliverablePart.this.getShell(), (String)Messages.DeliverablePart_SAVE_CONFLICT, (String)Messages.DeliverablePart_SAVE_CONFLICT_DISCARD)) {
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                monitor.beginTask(Messages.DeliverablePart_REFRESHING_ITEMS, 4);
                                ITeamRepository repo = (ITeamRepository)DeliverablePart.this.fProjectArea.getOrigin();
                                try {
                                    DeliverablePart.this.fProjectArea = (IProjectArea)repo.itemManager().fetchCompleteItem(DeliverablePart.this.fProjectArea.getItemHandle(), 1, monitor);
                                }
                                catch (TeamRepositoryException x) {
                                    throw new InvocationTargetException(x, Messages.DeliverablePart_ERROR_REFRESHING_PROJECT_AREA);
                                }
                                monitor.worked(1);
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                try {
                                    List cachedDeliverables = repo.itemManager().getKnownSharedItems(IDeliverable.ITEM_TYPE);
                                    repo.itemManager().refreshSharedItems(cachedDeliverables, monitor);
                                }
                                catch (TeamRepositoryException x) {
                                    throw new InvocationTargetException(x, Messages.DeliverablePart_ERROR_REFRESHING_RELEASES);
                                }
                                monitor.worked(2);
                                if (monitor.isCanceled()) {
                                    throw new InterruptedException();
                                }
                                DeliverablePart.this.fWorkingCopy = null;
                            }
                        });
                        DeliverablePart.this.setInput(new WorkItemProjectAreaEditorInput(DeliverablePart.this.fProjectArea));
                    }
                    catch (InvocationTargetException x) {
                        MessageDialog.openError((Shell)DeliverablePart.this.getShell(), (String)Messages.DeliverablePart_ERROR_HANDLING_SAVE_CONFLICT, (String)x.getMessage());
                        WorkItemIDEUIPlugin.getDefault().log(x.getMessage(), x);
                    }
                    catch (InterruptedException interruptedException) {
                        return Status.CANCEL_STATUS;
                    }
                }
                return Status.OK_STATUS;
            }
        };
        staleJob.setSystem(true);
        staleJob.schedule();
    }

    public void dispose() {
        if (this.fSharedItemListener != null && this.fProjectArea != null) {
            IItemManager itemManager = ((ITeamRepository)this.fProjectArea.getOrigin()).itemManager();
            itemManager.removeItemChangeListener(IDeliverable.ITEM_TYPE, this.fSharedItemListener);
            this.fSharedItemListener = null;
        }
        super.dispose();
    }

    private static class ActionButton {
        private StructuredViewer fViewer;
        private IAction fAction;
        private Button fButton;

        public ActionButton(StructuredViewer viewer, IAction action, Button button) {
            this.fViewer = viewer;
            this.fAction = action;
            this.fButton = button;
            this.fButton.setText(this.fAction.getText());
            this.fButton.setEnabled(this.fAction.isEnabled());
            this.fButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (ActionButton.this.fAction.isEnabled()) {
                        ActionButton.this.fAction.run();
                    }
                }
            });
            if (this.fAction instanceof IUpdate) {
                this.fViewer.addPostSelectionChangedListener(new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent event) {
                        ((IUpdate)ActionButton.this.fAction).update();
                        ActionButton.this.fButton.setEnabled(ActionButton.this.fAction.isEnabled());
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AddAction
    extends Action
    implements IUpdate {
        public AddAction() {
            super(Messages.DeliverablePart_ADD);
            this.update();
        }

        public void run() {
            DeliverableDialog dialog = new DeliverableDialog(DeliverablePart.this.fViewer.getControl().getShell(), DeliverableDialog.ADD_DELIVERABLE_TITLE);
            dialog.setUnavailable(this.getExistingNames());
            if (dialog.open() != 0) {
                return;
            }
            IDeliverable deliverable = DeliverablePart.this.fWorkingCopy.createDeliverable(dialog.getName());
            int max = -1;
            Set deliverables = DeliverablePart.this.fWorkingCopy.getDeliverables();
            for (IDeliverable current : deliverables) {
                int seq = ((Deliverable)current).getSequenceValue();
                if (seq <= max) continue;
                max = seq;
            }
            ((Deliverable)deliverable).setSequenceValue(max + 1);
            deliverable.setCreationDate(dialog.getCreationDate());
            deliverable.setHTMLDescription(dialog.getDescription());
            deliverable.setFiltered(dialog.isFiltered());
            DeliverablePart.this.fViewer.add((Object)deliverable);
            DeliverablePart.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)deliverable));
            DeliverablePart.this.fViewer.reveal((Object)deliverable);
        }

        private List<String> getExistingNames() {
            ArrayList<String> names = new ArrayList<String>();
            for (IDeliverable deliverable : DeliverablePart.this.fWorkingCopy.getDeliverables()) {
                names.add(deliverable.getName());
            }
            return names;
        }

        public void update() {
            this.setEnabled(DeliverablePart.this.fWorkingCopy != null);
        }
    }

    private class ArchiveAction
    extends Action
    implements IUpdate {
        public ArchiveAction() {
            super(Messages.DeliverablePart_ARCHIVE);
            this.update();
        }

        public void run() {
            ArrayList<IDeliverable> deliverables = new ArrayList<IDeliverable>();
            for (Object o : ((IStructuredSelection)DeliverablePart.this.fViewer.getSelection()).toList()) {
                IDeliverable deliverable;
                if (!(o instanceof IDeliverable) || (deliverable = (IDeliverable)o).isArchived()) continue;
                deliverables.add(deliverable);
            }
            if (deliverables.isEmpty()) {
                return;
            }
            String message = deliverables.size() == 1 ? NLS.bind((String)Messages.DeliverablePart_ARCHIVE_RELEASE, (Object)((IDeliverable)deliverables.get(0)).getName(), (Object[])new Object[0]) : NLS.bind((String)Messages.DeliverablePart_ARCHIVE_RELEASES, (Object)deliverables.size(), (Object[])new Object[0]);
            boolean confirmed = MessageDialog.openQuestion((Shell)DeliverablePart.this.getShell(), (String)Messages.DeliverablePart_CONFIRM_ARCHIVE, (String)message);
            if (!confirmed) {
                return;
            }
            for (IDeliverable deliverable : deliverables) {
                deliverable.setArchived(true);
            }
            DeliverablePart.this.fViewer.refresh();
            DeliverablePart.this.fViewer.setSelection(DeliverablePart.this.fViewer.getSelection());
        }

        public void update() {
            this.setEnabled(DeliverablePart.this.fWorkingCopy != null && this.hasUnarchived((IStructuredSelection)DeliverablePart.this.fViewer.getSelection()));
        }

        private boolean hasUnarchived(IStructuredSelection selection) {
            for (Object element : selection.toList()) {
                if (!(element instanceof IDeliverable) || ((IDeliverable)element).isArchived()) continue;
                return true;
            }
            return false;
        }
    }

    private static class DeliverableContentProvider
    implements IStructuredContentProvider {
        private DeliverableContentProvider() {
        }

        public Object[] getElements(Object input) {
            if (input instanceof DeliverableWorkingCopy) {
                return ((DeliverableWorkingCopy)input).getDeliverables().toArray();
            }
            if (input instanceof String) {
                return new Object[]{input};
            }
            return new Object[]{new PendingUpdateAdapter()};
        }

        public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
        }

        public void dispose() {
        }
    }

    private class DeliverableFilter
    extends ViewerFilter {
        private DeliverableFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IDeliverable) {
                return DeliverablePart.this.fShowArchived || !((IDeliverable)element).isArchived();
            }
            return true;
        }
    }

    private class DeliverableLabelProvider
    extends CellLabelProvider {
        private StandardLabelProvider fStandardLabelProvider = new StandardLabelProvider((IElementRemovedNotifier)new ElementRemovedNotifierImpl());
        private ILabelProviderListener fLabelProviderListener = new ILabelProviderListener(){

            public void labelProviderChanged(LabelProviderChangedEvent event) {
                DeliverableWorkingCopy workingCopy = DeliverablePart.this.fWorkingCopy;
                if (workingCopy == null) {
                    return;
                }
                Object[] elements = event.getElements();
                if (elements != null) {
                    ItemHandleAwareHashSet mapped = new ItemHandleAwareHashSet();
                    Set deliverables = workingCopy.getDeliverables();
                    Object[] objectArray = elements;
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        if (element instanceof IItemHandle) {
                            for (IDeliverable deliverable : deliverables) {
                                if (!((IItemHandle)element).sameItemId(deliverable.getArtifact())) continue;
                                mapped.add(deliverable);
                            }
                        }
                        ++n2;
                    }
                    if (!mapped.isEmpty()) {
                        DeliverableLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)DeliverableLabelProvider.this, mapped.toArray()));
                    }
                } else {
                    DeliverableLabelProvider.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)DeliverableLabelProvider.this, null));
                }
            }
        };
        private DateFormat fDateFormatter = DateFormat.getDateInstance((int)2);

        public DeliverableLabelProvider() {
            this.fStandardLabelProvider.addListener(this.fLabelProviderListener);
        }

        public void update(ViewerCell cell) {
            Object element = cell.getElement();
            if (element instanceof IDeliverable) {
                IDeliverable deliverable = (IDeliverable)element;
                switch (cell.getColumnIndex()) {
                    case 0: {
                        cell.setText(deliverable.getName());
                        cell.setForeground(Display.getDefault().getSystemColor(deliverable.isArchived() ? 18 : 24));
                        break;
                    }
                    case 1: {
                        Timestamp creationDate = deliverable.getCreationDate();
                        cell.setText(creationDate != null ? this.fDateFormatter.format((Date)creationDate) : "");
                        cell.setForeground(Display.getDefault().getSystemColor(deliverable.isArchived() ? 18 : 24));
                        break;
                    }
                    case 3: {
                        IAuditable artifact = null;
                        if (deliverable.getArtifact() instanceof IAuditableHandle) {
                            artifact = DeliverablePart.this.fArtifacts.get((IAuditableHandle)deliverable.getArtifact());
                        }
                        String text = null;
                        if (artifact != null) {
                            ViewerLabel label = new ViewerLabel(null, null);
                            this.fStandardLabelProvider.updateLabel(label, (Object)artifact);
                            text = label.getText();
                        }
                        if (text == null) {
                            text = "";
                        }
                        cell.setText(text);
                        cell.setForeground(Display.getDefault().getSystemColor(deliverable.isArchived() ? 18 : 24));
                        break;
                    }
                    case 2: {
                        cell.setText(deliverable.isFiltered() ? Messages.DeliverablePart_PROJECT_INTERNAL_LABEL : Messages.DeliverablePart_PUBLIC_LABEL);
                        cell.setForeground(Display.getDefault().getSystemColor(deliverable.isArchived() ? 18 : 24));
                    }
                }
            } else if (element instanceof String && cell.getColumnIndex() == 0) {
                cell.setText((String)element);
            } else if (element instanceof PendingUpdateAdapter && cell.getColumnIndex() == 0) {
                cell.setText(((PendingUpdateAdapter)element).getLabel(element));
            }
        }

        public void dispose() {
            if (this.fStandardLabelProvider != null) {
                if (this.fLabelProviderListener != null) {
                    this.fStandardLabelProvider.removeListener(this.fLabelProviderListener);
                }
                this.fStandardLabelProvider.dispose();
                this.fStandardLabelProvider = null;
            }
            super.dispose();
        }
    }

    private static class DeliverableSorter
    extends ViewerSorter {
        private DeliverableSorter() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return DeliverableWorkingCopy.compare((IDeliverable)((IDeliverable)e1), (IDeliverable)((IDeliverable)e2));
        }
    }

    private class EditAction
    extends Action
    implements IUpdate {
        public EditAction() {
            super(Messages.DeliverablePart_EDIT);
            this.update();
        }

        public void run() {
            IStructuredSelection structuredSelection = (IStructuredSelection)DeliverablePart.this.fViewer.getSelection();
            if (structuredSelection.size() != 1) {
                return;
            }
            IDeliverable deliverable = (IDeliverable)structuredSelection.getFirstElement();
            ArrayList<IDeliverable> deliverables = new ArrayList<IDeliverable>(DeliverablePart.this.fWorkingCopy.getDeliverables());
            boolean result = WorkItemIDEUI.openEditDeliverableDialog(DeliverablePart.this.getShell(), DeliverableDialog.EDIT_DELIVERABLE_TITLE, deliverable, deliverables);
            if (result) {
                DeliverablePart.this.fViewer.refresh((Object)deliverable, true);
            }
        }

        public void update() {
            this.setEnabled(DeliverablePart.this.fWorkingCopy != null && ((IStructuredSelection)DeliverablePart.this.fViewer.getSelection()).size() == 1);
        }
    }

    private class InternalSharedItemListener
    implements ISharedItemChangeListener {
        private UIUpdaterJob fUpdaterJob = new UIUpdaterJob(Messages.DeliverablePart_UPDATING_DELIVERABLES){

            public IStatus runInBackground(IProgressMonitor monitor) {
                try {
                    IProjectArea projectArea = DeliverablePart.this.fProjectArea;
                    DeliverableWorkingCopy workingCopy = DeliverablePart.this.fWorkingCopy;
                    if (projectArea == null || workingCopy == null) {
                        return Status.CANCEL_STATUS;
                    }
                    workingCopy.update(monitor);
                    ITeamRepository teamRepository = (ITeamRepository)projectArea.getOrigin();
                    IWorkItemClient workItemClient = (IWorkItemClient)teamRepository.getClientLibrary(IWorkItemClient.class);
                    AuditableBatchResolver resolver = new AuditableBatchResolver((IWorkItemCommon)workItemClient);
                    for (IDeliverable deliverable : workingCopy.getDeliverables()) {
                        if (!(deliverable.getArtifact() instanceof IAuditableHandle)) continue;
                        resolver.add(ItemProfile.createFullProfile((IItemType)deliverable.getArtifact().getItemType()), (IAuditableHandle)deliverable.getArtifact());
                    }
                    resolver.resolve(monitor);
                    DeliverablePart.this.fArtifacts = resolver;
                    return Status.OK_STATUS;
                }
                catch (TeamRepositoryException x) {
                    return new Status(4, "com.ibm.team.workitem.ide.ui", x.getMessage(), (Throwable)x);
                }
            }

            public IStatus runInUI(IProgressMonitor monitor) {
                if (DeliverablePart.this.fViewer != null && !DeliverablePart.this.fViewer.getControl().isDisposed()) {
                    DeliverablePart.this.fViewer.refresh();
                }
                return super.runInUI(monitor);
            }
        };

        private InternalSharedItemListener() {
        }

        public void itemsChanged(List events) {
            IProjectArea projectArea = DeliverablePart.this.fProjectArea;
            DeliverableWorkingCopy workingCopy = DeliverablePart.this.fWorkingCopy;
            if (projectArea == null || workingCopy == null) {
                return;
            }
            boolean update = false;
            for (ISharedItemChangeEvent event : events) {
                if (!(event.getSharedItem() instanceof IDeliverable) || !((IDeliverable)event.getSharedItem()).getProjectArea().sameItemId((IItemHandle)projectArea)) continue;
                IDeliverable deliverable = (IDeliverable)event.getSharedItem();
                if (workingCopy.getDeliverables().contains(deliverable)) continue;
                update = true;
                break;
            }
            if (update) {
                this.fUpdaterJob.schedule();
            }
        }
    }

    private class MoveDownAction
    extends Action
    implements IUpdate {
        public MoveDownAction() {
            super(Messages.DeliverablePart_DOWN);
            this.update();
        }

        public void run() {
            if (DeliverablePart.this.fWorkingCopy == null) {
                return;
            }
            List deliverables = DeliverablePart.this.getSortedDeliverables();
            Collections.reverse(deliverables);
            List selection = DeliverablePart.this.getSortedSelection(deliverables);
            DeliverablePart.this.moveUp(deliverables, selection);
            Collections.reverse(deliverables);
            DeliverablePart.this.updateSequenceValue(deliverables);
            DeliverablePart.this.fViewer.refresh();
            DeliverablePart.this.fViewer.setSelection(DeliverablePart.this.fViewer.getSelection());
        }

        public void update() {
            this.setEnabled(this.shouldEnable());
        }

        private boolean shouldEnable() {
            if (DeliverablePart.this.fWorkingCopy == null) {
                return false;
            }
            return this.canMoveDown((IStructuredSelection)DeliverablePart.this.fViewer.getSelection());
        }

        private boolean canMoveDown(IStructuredSelection selection) {
            List indices = DeliverablePart.this.getIndices(selection);
            Collections.reverse(indices);
            boolean foundGap = false;
            int last = DeliverablePart.this.fViewer.getTable().getItemCount();
            for (Integer index : indices) {
                if (index < last - 1) {
                    foundGap = true;
                    break;
                }
                last = index;
            }
            return foundGap;
        }
    }

    private class MoveUpAction
    extends Action
    implements IUpdate {
        public MoveUpAction() {
            super(Messages.DeliverablePart_UP);
            this.update();
        }

        public void run() {
            if (DeliverablePart.this.fWorkingCopy == null) {
                return;
            }
            List deliverables = DeliverablePart.this.getSortedDeliverables();
            List selection = DeliverablePart.this.getSortedSelection(deliverables);
            DeliverablePart.this.moveUp(deliverables, selection);
            DeliverablePart.this.updateSequenceValue(deliverables);
            DeliverablePart.this.fViewer.refresh();
            DeliverablePart.this.fViewer.setSelection(DeliverablePart.this.fViewer.getSelection());
        }

        public void update() {
            this.setEnabled(this.shouldEnable());
        }

        private boolean shouldEnable() {
            if (DeliverablePart.this.fWorkingCopy == null) {
                return false;
            }
            return this.canMoveUp((IStructuredSelection)DeliverablePart.this.fViewer.getSelection());
        }

        private boolean canMoveUp(IStructuredSelection selection) {
            List indices = DeliverablePart.this.getIndices(selection);
            boolean foundGap = false;
            int last = -1;
            for (Integer index : indices) {
                if (index > last + 1) {
                    foundGap = true;
                    break;
                }
                last = index;
            }
            return foundGap;
        }
    }

    private class OpenArtifactAction
    extends Action
    implements IUpdate {
        public OpenArtifactAction() {
            super(Messages.DeliverablePart_OPEN_ARTIFACT);
            this.update();
        }

        public void run() {
            final IStructuredSelection selection = (IStructuredSelection)DeliverablePart.this.fViewer.getSelection();
            FoundationJob job = new FoundationJob(Messages.DeliverablePart_OPEN_ARTIFACT){

                protected IStatus runProtected(IProgressMonitor monitor) {
                    for (Object element : selection.toList()) {
                        URIReference reference;
                        IItemHandle artifact;
                        if (!(element instanceof IDeliverable) || (artifact = ((IDeliverable)element).getArtifact()) == null || (reference = Hyperlinks.create((Object)artifact, (IProgressMonitor)monitor)) == null) continue;
                        Hyperlinks.open((URI)reference.getURI(), null, (IProgressMonitor)monitor);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setUser(true);
            job.schedule();
        }

        public void update() {
            this.setEnabled(DeliverablePart.this.fWorkingCopy != null && this.hasArtifact((IStructuredSelection)DeliverablePart.this.fViewer.getSelection()));
        }

        private boolean hasArtifact(IStructuredSelection selection) {
            for (Object element : selection.toList()) {
                if (!(element instanceof IDeliverable) || ((IDeliverable)element).getArtifact() == null) continue;
                return true;
            }
            return false;
        }
    }

    private class UnarchiveAction
    extends Action
    implements IUpdate {
        public UnarchiveAction() {
            super(Messages.DeliverablePart_UNARCHIVE);
            this.update();
        }

        public void run() {
            boolean changed = false;
            for (Object o : ((IStructuredSelection)DeliverablePart.this.fViewer.getSelection()).toList()) {
                IDeliverable deliverable;
                if (!(o instanceof IDeliverable) || !(deliverable = (IDeliverable)o).isArchived()) continue;
                deliverable.setArchived(false);
                changed = true;
            }
            if (changed) {
                DeliverablePart.this.fViewer.refresh();
                DeliverablePart.this.fViewer.setSelection(DeliverablePart.this.fViewer.getSelection());
            }
        }

        public void update() {
            this.setEnabled(DeliverablePart.this.fWorkingCopy != null && this.hasArchived((IStructuredSelection)DeliverablePart.this.fViewer.getSelection()));
        }

        private boolean hasArchived(IStructuredSelection selection) {
            for (Object element : selection.toList()) {
                if (!(element instanceof IDeliverable) || !((IDeliverable)element).isArchived()) continue;
                return true;
            }
            return false;
        }
    }
}

