/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.deliverable;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.collaboration.ui.text.CollaborationPresenceTextDecorator;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.StyledTextViewerSupport;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.calendar.DatePicker;
import com.ibm.team.ui.editor.ITeamFormPartSite;
import com.ibm.team.ui.editor.TeamFormPartSite;
import com.ibm.team.workitem.ide.ui.internal.editor.DecoratedText;
import com.ibm.team.workitem.ide.ui.internal.editor.DocumentModel;
import com.ibm.team.workitem.ide.ui.internal.editor.deliverable.Messages;
import com.ibm.team.workitem.rcp.ui.internal.ImagePool;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeliverableDialog
extends Dialog {
    public static final String ADD_DELIVERABLE_TITLE = Messages.DeliverableDialog_ADD_RELEASE;
    public static final String EDIT_DELIVERABLE_TITLE = Messages.DeliverableDialog_EDIT_RELEASE;
    private static final int DATE_FORMAT = 2;
    private static final String NONE = Messages.DeliverableDialog_NONE;
    private String fTitle;
    private String fName = "";
    private DocumentModel fDescriptionModel = new DocumentModel();
    private String fCreationDate = "";
    private boolean fFiltered = false;
    private DecoratedText fNameText;
    private StyledTextViewerSupport fDescriptionSupport;
    private DecoratedText fCreationDateText;
    private List<String> fUnavailable = Collections.emptyList();

    public DeliverableDialog(Shell parentShell, String title) {
        super(parentShell);
        this.fTitle = title;
    }

    public String getName() {
        return this.fName;
    }

    public void setName(String name) {
        this.fName = name;
    }

    public Timestamp getCreationDate() {
        try {
            return this.internalGetCreationDate();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public void setCreationDate(Timestamp creationDate) {
        this.fCreationDate = creationDate != null ? DateFormat.getDateInstance((int)2).format((Date)creationDate) : "";
    }

    public XMLString getDescription() {
        return this.fDescriptionModel.getDocument().getHTML();
    }

    public void setDescription(XMLString description) {
        this.fDescriptionModel.getDocument().setHTML(description);
    }

    public boolean isFiltered() {
        return this.fFiltered;
    }

    public void setFiltered(boolean filtered) {
        this.fFiltered = filtered;
    }

    public void setUnavailable(List<String> unavailable) {
        this.fUnavailable = unavailable;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.fTitle);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = this.convertHorizontalDLUsToPixels(300);
        composite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 9;
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setText(Messages.DeliverableDialog_NAME);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fNameText = new DecoratedText(composite, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.fNameText.getLayoutControl().setLayoutData((Object)data);
        this.fNameText.getText().setFocus();
        this.fNameText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeliverableDialog.this.fName = ((String)DeliverableDialog.this.fNameText.getValue()).trim();
                DeliverableDialog.this.validateInput();
            }
        });
        this.fNameText.setValue(this.fName);
        this.fNameText.setSelection((ISelection)new TextSelection(0, this.fName.length()));
        label = new Label(composite, 0);
        label.setText(Messages.DeliverableDialog_DESCRIPTION);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.fDescriptionSupport = new StyledTextViewerSupport();
        this.fDescriptionSupport.getTextViewerDecorators().add(0, new CollaborationPresenceTextDecorator());
        this.fDescriptionSupport.setMargin(new Point(1, 1));
        this.fDescriptionSupport.init((ITeamFormPartSite)new TeamFormPartSite(null));
        this.fDescriptionSupport.setStyle(68162);
        this.fDescriptionSupport.createContent(composite);
        SourceViewer sourceViewer = this.fDescriptionSupport.getSourceViewer();
        Control control = sourceViewer.getControl();
        data = new GridData(4, 4, true, true);
        data.widthHint = 64;
        data.heightHint = this.fDescriptionSupport.getSourceViewer().getTextWidget().getLineHeight() * 5;
        control.setLayoutData((Object)data);
        this.fDescriptionSupport.getSourceViewer().setDocument((IDocument)this.fDescriptionModel.getDocument(), this.fDescriptionModel.getAnnotationModel());
        this.fDescriptionSupport.updateBaseURI();
        label = new Label(composite, 0);
        label.setText(Messages.DeliverableDialog_CREATION_DATE);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Composite creationContainer = new Composite(composite, 0);
        creationContainer.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        creationContainer.setLayout((Layout)layout);
        this.fCreationDateText = new DecoratedText(creationContainer, 2052);
        data = new GridData(4, 0x1000000, true, false);
        this.fCreationDateText.getLayoutControl().setLayoutData((Object)data);
        this.fCreationDateText.getText().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeliverableDialog.this.fCreationDate = (String)DeliverableDialog.this.fCreationDateText.getValue();
                DeliverableDialog.this.validateInput();
            }
        });
        this.fCreationDateText.setValue(this.fCreationDate);
        final ToolBar toolBar = new ToolBar(creationContainer, 0x800000);
        toolBar.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        final ToolItem calendarButton = new ToolItem(toolBar, 8);
        calendarButton.setToolTipText(Messages.DeliverableDialog_PICK_DATE);
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)toolBar);
        Image image = JazzResources.getImageWithDefault((ResourceManager)resourceManager, (ImageDescriptor)ImagePool.DATE);
        calendarButton.setImage(image);
        calendarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                calendarButton.setEnabled(false);
                Rectangle rect = calendarButton.getBounds();
                Point pt = toolBar.toDisplay(new Point(rect.x, rect.y + rect.height));
                DatePicker picker = new DatePicker(DeliverableDialog.this.getShell(), 2);
                picker.setLocation(pt.x, pt.y);
                try {
                    picker.setDate(DateFormat.getDateInstance((int)2).parse(DeliverableDialog.this.fCreationDateText.getText().getText()));
                }
                catch (ParseException parseException) {}
                picker.open();
                Date date = picker.getDateObject();
                if (date != null) {
                    DeliverableDialog.this.fCreationDateText.getText().setText(DateFormat.getDateInstance((int)2).format(date));
                    DeliverableDialog.this.fCreationDateText.getText().setFocus();
                }
                calendarButton.setEnabled(true);
            }
        });
        final Button filtered = new Button(composite, 0x800020);
        filtered.setText(Messages.DeliverableDialog_ONLY_SHOW_TO_MEMBERS);
        filtered.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 2, 1));
        filtered.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DeliverableDialog.this.fFiltered = filtered.getSelection();
            }
        });
        filtered.setSelection(this.fFiltered);
        DeliverableDialog.applyDialogFont((Control)container);
        return container;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.validateInput();
    }

    private void validateInput() {
        Button okButton = this.getButton(0);
        if (okButton == null) {
            return;
        }
        IStatus nameStatus = this.getNameStatus();
        if (this.getButtonBar() != null) {
            this.fNameText.setStatus(nameStatus);
        }
        IStatus creationDateStatus = this.getCreationDateStatus();
        if (this.getButtonBar() != null) {
            this.fCreationDateText.setStatus(creationDateStatus);
        }
        boolean enabled = nameStatus.getSeverity() != 4 && nameStatus.getSeverity() != 8;
        okButton.setEnabled(enabled &= creationDateStatus.getSeverity() != 4 && creationDateStatus.getSeverity() != 8);
    }

    private IStatus getNameStatus() {
        if (this.fName.length() == 0) {
            return new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.DeliverableDialog_EMPTY_NAME);
        }
        if (this.fUnavailable.contains(this.fName)) {
            return new Status(4, "com.ibm.team.workitem.rcp.ui", Messages.DeliverableDialog_NAME_EXISTS);
        }
        return Status.OK_STATUS;
    }

    private IStatus getCreationDateStatus() {
        try {
            this.internalGetCreationDate();
            return Status.OK_STATUS;
        }
        catch (ParseException x) {
            return new Status(4, "com.ibm.team.workitem.rcp.ui", x.getLocalizedMessage());
        }
    }

    private Timestamp internalGetCreationDate() throws ParseException {
        String text = this.fCreationDate.trim();
        if (text.length() == 0 || NONE.equals(text)) {
            return null;
        }
        DateFormat dateFormat = DateFormat.getDateInstance((int)2);
        return new Timestamp(dateFormat.parse(text).getTime());
    }

    public boolean close() {
        boolean close = super.close();
        if (close && this.fDescriptionSupport != null) {
            this.fDescriptionSupport.dispose();
            this.fDescriptionSupport = null;
        }
        return close;
    }
}

