/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.comments;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;

public final class FileHyperlinkHandler
extends HyperlinkHandler {
    public static final String FILE_SCHEME = "file";

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        Object file;
        IPath location;
        Object element = object;
        if (element instanceof IFile && (location = (file = (IFile)element).getLocation()) != null) {
            element = new File(location.toOSString());
        }
        if (element instanceof File) {
            file = (File)element;
            String name = ((File)file).getName();
            try {
                File parent = ((File)file).getParentFile();
                String location2 = parent != null ? parent.getCanonicalPath() : "/";
                String description = MessageFormat.format(Messages.FileHyperlinkHandler_LOCATION_PATTERN, location2);
                return new URIReference(name, description, "java.io.File", ((File)file).toURI());
            }
            catch (IOException iOException) {}
        }
        return super.createHyperlink(object, monitor);
    }

    public boolean handles(URI uri) {
        return false;
    }

    public boolean links(Object object) {
        return object instanceof File || object instanceof IFile;
    }

    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        try {
            return new File(uri);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public boolean resolves(URI uri) {
        Assert.isNotNull((Object)uri);
        String scheme = uri.getScheme();
        return FILE_SCHEME.equals(scheme);
    }
}

