/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.comments;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.FileHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.Util;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.Messages;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.WorkItemHyperlinkHandler;
import com.ibm.team.workitem.rcp.ui.internal.WorkItemRCPUIPlugin;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.ide.IDE;

public final class DefaultHyperlinkHandler
extends HyperlinkHandler {
    public static String SHOW_EXTERNAL_OPEN_WARNING_DIALOG = "com.ibm.team.workitem.ide.ui.internal.editor.comments.DefaultHyperlinkHandler.SHOW_EXTERNAL_OPEN_WARNING_DIALOG";

    public boolean handles(URI uri) {
        return true;
    }

    public void open(final URI uri, final ContextProvider context, IProgressMonitor monitor) {
        WorkItemRCPUIPlugin.runInUI((String)MessageFormat.format(Messages.DefaultHyperlinkHandler_OPENING, uri), (IRunnableWithProgress)new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                DefaultHyperlinkHandler.this.handleOpen(uri, context, monitor);
            }
        }, (IProgressMonitor)monitor);
    }

    private void handleOpen(URI uri, ContextProvider context, IProgressMonitor monitor) {
        boolean success;
        String scheme = uri.getScheme();
        if ("ftp".equals(scheme) || "http".equals(scheme) || "https".equals(scheme) || "mailto".equals(scheme)) {
            if ("mailto".equals(scheme)) {
                if (!Program.launch((String)uri.toString())) {
                    WorkItemRCPUIPlugin.openInBrowser((URI)uri);
                }
            } else {
                WorkItemRCPUIPlugin.openInBrowser((URI)uri);
            }
            return;
        }
        try {
            IFileStore file = EFS.getStore((URI)uri);
            IWorkbenchPage page = null;
            Shell shell = null;
            if (context != null) {
                Object uiContext = context.findUIContext();
                if (uiContext instanceof IWorkbenchPage) {
                    page = (IWorkbenchPage)uiContext;
                } else if (uiContext instanceof Shell) {
                    shell = (Shell)uiContext;
                } else if (uiContext instanceof IWorkbenchWindow) {
                    shell = ((IWorkbenchWindow)uiContext).getShell();
                }
            }
            if (page == null) {
                page = Util.getWorkbenchPage(shell);
            }
            if ("file".equals(scheme)) {
                try {
                    FileHelper.open(page, new File(uri));
                    return;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (CoreException coreException) {}
            }
            try {
                IDE.openEditorOnFileStore((IWorkbenchPage)page, (IFileStore)file);
                return;
            }
            catch (PartInitException x) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.DefaultHyperlinkHandler_EXCEPTION_OPENING_EDITOR, x);
            }
        }
        catch (CoreException coreException) {}
        Shell parent = WorkItemHyperlinkHandler.findShell(context);
        boolean doit = true;
        if (WorkItemIDEUIPlugin.getDefault().getPreferenceStore().getBoolean(SHOW_EXTERNAL_OPEN_WARNING_DIALOG)) {
            String msg = NLS.bind((String)Messages.DefaultHyperlinkHandler_EXTERNAL_OPEN_WARNING, (Object)uri, (Object[])new Object[0]);
            MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)parent, (String)Messages.DefaultHyperlinkHandler_OPENING_LINK, (String)msg, (String)Messages.DefaultHyperlinkHandler_DO_NOT_SHOW_WARNING, (boolean)false, null, null);
            int result = dialog.getReturnCode();
            doit = result == 2;
            boolean toggle = dialog.getToggleState();
            if (toggle && (result == 2 || result == 3)) {
                WorkItemIDEUIPlugin.getDefault().getPreferenceStore().setValue(SHOW_EXTERNAL_OPEN_WARNING_DIALOG, !toggle);
            }
        }
        if (doit && !(success = Program.launch((String)uri.toString()))) {
            MessageDialog.openError((Shell)parent, (String)Messages.DefaultHyperlinkHandler_COULD_NOT_OPEN_LOCATION, (String)NLS.bind((String)Messages.DefaultHyperlinkHandler_COULD_NOT_OPEN_URI, (Object)uri, (Object[])new Object[0]));
        }
    }

    public URIReference createHyperlink(Object object) {
        if (object instanceof URIReference) {
            return (URIReference)object;
        }
        return super.createHyperlink(object);
    }

    public boolean links(Object object) {
        if (object instanceof URIReference) {
            return true;
        }
        return super.links(object);
    }
}

