/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor.comments;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.links.common.IReference;
import com.ibm.team.links.common.IURIReference;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.workitem.client.URIService;
import com.ibm.team.workitem.client.internal.ArtifactLink;
import com.ibm.team.workitem.common.model.IAttachment;
import com.ibm.team.workitem.common.model.IAttachmentHandle;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.FileHelper;
import com.ibm.team.workitem.ide.ui.internal.editor.comments.Messages;
import com.ibm.team.workitem.rcp.ui.WorkItemUI;
import java.net.URI;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class AttachmentHyperlinkHandler
extends HyperlinkHandler {
    public boolean handles(URI uri) {
        return IAttachment.ITEM_TYPE.equals(URIService.findItemType((URI)uri));
    }

    public boolean resolves(URI uri) {
        return IAttachment.ITEM_TYPE.equals(URIService.findItemType((URI)uri));
    }

    public Object resolve(URI uri, ContextProvider provider) throws TeamRepositoryException {
        return URIService.resolveObject((URI)uri);
    }

    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        try {
            return URIService.resolveObject((URI)uri, (IProgressMonitor)monitor);
        }
        catch (TeamRepositoryException x) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.workitem.ide.ui", x.getMessage(), (Throwable)x));
        }
    }

    public void open(URI uri, ContextProvider context, IProgressMonitor monitor) {
        try {
            URIService.getLoggedInTeamRepository((URI)uri, (IProgressMonitor)monitor);
            Object object = URIService.resolveObject((URI)uri, (IProgressMonitor)monitor);
            if (object instanceof IAttachment) {
                IAttachment attachment = (IAttachment)object;
                FileHelper.open(attachment, monitor);
                return;
            }
        }
        catch (PermissionDeniedException permissionDeniedException) {
            WorkItemUI.openPermissionDeniedDialog((String)Messages.AttachmentHyperlinkHandler_ATTACHMENT);
        }
        catch (ItemNotFoundException itemNotFoundException) {
            WorkItemUI.openItemNotFoundDialog((String)Messages.AttachmentHyperlinkHandler_ATTACHMENT);
        }
        catch (TeamRepositoryException x) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.AttachmentHyperlinkHandler_EXCEPTION_RESOLVING_ATTACHMENT, x);
        }
        catch (CoreException x) {
            WorkItemIDEUIPlugin.getDefault().log(Messages.AttachmentHyperlinkHandler_EXCEPTION_OPENING_ATTACHMENT, x);
        }
    }

    public URIReference createHyperlink(Object object) {
        ArtifactLink link;
        IReference reference;
        if (object instanceof IAttachmentHandle) {
            IAttachmentHandle handle = (IAttachmentHandle)object;
            ITeamRepository repository = (ITeamRepository)handle.getOrigin();
            ArrayList<String> properties = new ArrayList<String>(2);
            properties.add(IAttachment.NAME_PROPERTY);
            properties.add(IAttachment.DESCRIPTION_PROPERTY);
            try {
                IAttachment attachment = (IAttachment)repository.itemManager().fetchPartialItem((IItemHandle)handle, 0, properties, null);
                if (attachment != null) {
                    return new URIReference(attachment.getName(), NLS.bind((String)Messages.AttachmentHyperlinkHandler_NAME_DESCRIPTION, (Object)attachment.getName(), (Object[])new Object[]{attachment.getDescription()}), IAttachment.class.getName(), URIService.createAuditableURI((ITeamRepository)((ITeamRepository)handle.getOrigin()), (IItemHandle)handle));
                }
            }
            catch (TeamRepositoryException e) {
                WorkItemIDEUIPlugin.getDefault().log(Messages.AttachmentHyperlinkHandler_EXCEPTION_RESOLVING_ATTACHMENT, e);
            }
        } else if (object instanceof ArtifactLink && (reference = (link = (ArtifactLink)object).getReference()).isURIReference()) {
            IURIReference uriReference = (IURIReference)reference;
            return new URIReference(uriReference.getComment(), NLS.bind((String)Messages.AttachmentHyperlinkHandler_NAME_DESCRIPTION, (Object)uriReference.getComment(), (Object[])new Object[]{uriReference.getComment()}), IAttachment.class.getName(), uriReference.getURI());
        }
        return super.createHyperlink(object);
    }

    public boolean links(Object object) {
        if (object instanceof IAttachmentHandle || object instanceof ArtifactLink) {
            return true;
        }
        return super.links(object);
    }
}

