/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.workitem.ide.ui.internal.editor;

import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.AdditionalInformationInput;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.CompletionProposal;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContentAssistContextProvider;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ContextProviderContentAssistContext;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.IContentAssistProposalsComputer;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.ReferenceInsertionStrategy;
import com.ibm.team.foundation.ide.ui.internal.styledtextviewer.contentassist.TeamContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.workitem.common.model.IWorkItemHandle;
import com.ibm.team.workitem.ide.ui.internal.WorkItemIDEUIPlugin;
import com.ibm.team.workitem.ide.ui.internal.editor.Messages;
import com.ibm.team.workitem.rcp.ui.workitempicker.WorkItemSelectionDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WorkItemPickerProposalComputer
implements IContentAssistProposalsComputer {
    private final ReferenceInsertionStrategy fInsertionStrategy;

    public WorkItemPickerProposalComputer(ReferenceInsertionStrategy insertionStrategy) {
        this.fInsertionStrategy = insertionStrategy;
    }

    public List<ICompletionProposal> computeCompletionProposals(ContentAssistContext context) {
        ContentAssistContextProvider contextProvider;
        ITeamRepository teamRepository = null;
        if (context instanceof ContextProviderContentAssistContext && (contextProvider = ((ContextProviderContentAssistContext)context).getContextProvider()) instanceof TeamContextProvider) {
            teamRepository = ((TeamContextProvider)contextProvider).getTeamRepository();
        }
        ArrayList<ICompletionProposal> result = new ArrayList<ICompletionProposal>();
        result.add((ICompletionProposal)new WorkItemPickerProposal(context.getOffset(), this.fInsertionStrategy, teamRepository));
        return result;
    }

    public String getErrorMessage() {
        return null;
    }

    public void sessionEnded() {
    }

    public void sessionStarted() {
    }

    private static final class WorkItemPickerProposal
    extends CompletionProposal {
        private final ReferenceInsertionStrategy fInsertionStrategy;
        private int fNewOffset;
        private final ITeamRepository fTeamRepository;

        public WorkItemPickerProposal(int startOffset, ReferenceInsertionStrategy insertionStrategy, ITeamRepository teamRepository) {
            super(Messages.WorkItemPickerProposalComputer_PROPOSAL_LABEL, null);
            this.fInsertionStrategy = insertionStrategy;
            this.fTeamRepository = teamRepository;
        }

        public void apply(IDocument document, char trigger, int offset) {
            String prefix = "";
            try {
                prefix = WorkItemPickerProposal.getPrefix(document, offset);
            }
            catch (BadLocationException e) {
                WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
            }
            WorkItemSelectionDialog dialog = this.fTeamRepository != null ? new WorkItemSelectionDialog(this.getShell(), this.fTeamRepository, false) : new WorkItemSelectionDialog(this.getShell(), false);
            dialog.setInitialPattern(prefix, WorkItemSelectionDialog.CaretPosition.END);
            IWorkItemHandle item = dialog.getSingleWorkItem();
            if (item == null) {
                return;
            }
            URIReference reference = Hyperlinks.create((Object)item, (IProgressMonitor)new NullProgressMonitor());
            try {
                this.fNewOffset = this.fInsertionStrategy.insert(reference, (Object)item, document, offset, prefix);
            }
            catch (CoreException e) {
                WorkItemIDEUIPlugin.getDefault().log(e.getMessage(), e);
            }
        }

        protected AdditionalInformationInput getAdditionaInformationInput(IProgressMonitor monitor) {
            String text = Messages.WorkItemPickerProposalComputer_PROPOSAL_DESCRIPTION;
            return new AdditionalInformationInput(text, text);
        }

        public Point getSelection(IDocument document) {
            return new Point(this.fNewOffset, 0);
        }

        public boolean isValidFor(IDocument document, int offset) {
            return true;
        }

        private static String getPrefix(IDocument doc, int offset) throws BadLocationException {
            if (doc == null || offset > doc.getLength()) {
                return null;
            }
            int length = 0;
            while (--offset >= 0 && !Character.isWhitespace(doc.getChar(offset))) {
                ++length;
            }
            return doc.get(offset + 1, length);
        }

        private Shell getShell() {
            return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
    }
}

